/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/js/background.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/@aws-amplify/auth/lib/Auth.js":
/*!****************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/Auth.js ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), \"throw\": verb(1), \"return\": verb(2) }, typeof Symbol === \"function\" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError(\"Generator is already executing.\");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y[\"return\"] : op[0] ? y[\"throw\"] || ((t = y[\"return\"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar types_1 = __webpack_require__(/*! ./types */ \"./node_modules/@aws-amplify/auth/lib/types/index.js\");\nvar core_1 = __webpack_require__(/*! @aws-amplify/core */ \"./node_modules/@aws-amplify/core/lib/index.js\");\nvar amazon_cognito_identity_js_1 = __webpack_require__(/*! amazon-cognito-identity-js */ \"./node_modules/amazon-cognito-identity-js/es/index.js\");\nvar url_1 = __webpack_require__(/*! url */ \"./node_modules/url/url.js\");\nvar OAuth_1 = __webpack_require__(/*! ./OAuth/OAuth */ \"./node_modules/@aws-amplify/auth/lib/OAuth/OAuth.js\");\nvar urlListener_1 = __webpack_require__(/*! ./urlListener */ \"./node_modules/@aws-amplify/auth/lib/urlListener.js\");\nvar logger = new core_1.ConsoleLogger('AuthClass');\nvar USER_ADMIN_SCOPE = 'aws.cognito.signin.user.admin';\nvar AMPLIFY_SYMBOL = ((typeof Symbol !== 'undefined' && typeof Symbol.for === 'function') ?\n    Symbol.for('amplify_default') : '@@amplify_default');\nvar dispatchAuthEvent = function (event, data, message) {\n    core_1.Hub.dispatch('auth', { event: event, data: data, message: message }, 'Auth', AMPLIFY_SYMBOL);\n};\nvar CognitoHostedUIIdentityProvider;\n(function (CognitoHostedUIIdentityProvider) {\n    CognitoHostedUIIdentityProvider[\"Cognito\"] = \"COGNITO\";\n    CognitoHostedUIIdentityProvider[\"Google\"] = \"Google\";\n    CognitoHostedUIIdentityProvider[\"Facebook\"] = \"Facebook\";\n    CognitoHostedUIIdentityProvider[\"Amazon\"] = \"LoginWithAmazon\";\n})(CognitoHostedUIIdentityProvider = exports.CognitoHostedUIIdentityProvider || (exports.CognitoHostedUIIdentityProvider = {}));\n/**\n* Provide authentication steps\n*/\nvar AuthClass = /** @class */ (function () {\n    /**\n     * Initialize Auth with AWS configurations\n     * @param {Object} config - Configuration of the Auth\n     */\n    function AuthClass(config) {\n        var _this = this;\n        this.userPool = null;\n        this.user = null;\n        this.configure(config);\n        this.currentUserCredentials = this.currentUserCredentials.bind(this);\n        if (core_1.AWS.config) {\n            core_1.AWS.config.update({ customUserAgent: core_1.Constants.userAgent });\n        }\n        else {\n            logger.warn('No AWS.config');\n        }\n        core_1.Hub.listen('auth', function (_a) {\n            var payload = _a.payload;\n            var event = payload.event;\n            switch (event) {\n                case 'signIn':\n                    _this._storage.setItem('amplify-signin-with-hostedUI', 'false');\n                    break;\n                case 'signOut':\n                    _this._storage.removeItem('amplify-signin-with-hostedUI');\n                    break;\n                case 'cognitoHostedUI':\n                    _this._storage.setItem('amplify-signin-with-hostedUI', 'true');\n                    break;\n            }\n        });\n    }\n    AuthClass.prototype.getModuleName = function () {\n        return 'Auth';\n    };\n    AuthClass.prototype.configure = function (config) {\n        var _this = this;\n        if (!config)\n            return this._config || {};\n        logger.debug('configure Auth');\n        var conf = Object.assign({}, this._config, core_1.Parser.parseMobilehubConfig(config).Auth, config);\n        this._config = conf;\n        var _a = this._config, userPoolId = _a.userPoolId, userPoolWebClientId = _a.userPoolWebClientId, cookieStorage = _a.cookieStorage, oauth = _a.oauth, region = _a.region, identityPoolId = _a.identityPoolId, mandatorySignIn = _a.mandatorySignIn, refreshHandlers = _a.refreshHandlers, identityPoolRegion = _a.identityPoolRegion;\n        if (!this._config.storage) {\n            // backward compatbility\n            if (cookieStorage)\n                this._storage = new amazon_cognito_identity_js_1.CookieStorage(cookieStorage);\n            else {\n                this._storage = new core_1.StorageHelper().getStorage();\n            }\n        }\n        else {\n            this._storage = this._config.storage;\n        }\n        this._storageSync = Promise.resolve();\n        if (typeof this._storage['sync'] === 'function') {\n            this._storageSync = this._storage['sync']();\n        }\n        if (userPoolId) {\n            var userPoolData = {\n                UserPoolId: userPoolId,\n                ClientId: userPoolWebClientId,\n            };\n            userPoolData.Storage = this._storage;\n            this.userPool = new amazon_cognito_identity_js_1.CognitoUserPool(userPoolData);\n        }\n        core_1.Credentials.configure({\n            mandatorySignIn: mandatorySignIn,\n            region: identityPoolRegion || region,\n            userPoolId: userPoolId,\n            identityPoolId: identityPoolId,\n            refreshHandlers: refreshHandlers,\n            storage: this._storage\n        });\n        // initiailize cognitoauth client if hosted ui options provided\n        // to keep backward compatibility:\n        var cognitoHostedUIConfig = oauth ? (types_1.isCognitoHostedOpts(this._config.oauth)\n            ? oauth : oauth.awsCognito)\n            : undefined;\n        if (cognitoHostedUIConfig) {\n            var cognitoAuthParams = Object.assign({\n                cognitoClientId: userPoolWebClientId,\n                UserPoolId: userPoolId,\n                domain: cognitoHostedUIConfig['domain'],\n                scopes: cognitoHostedUIConfig['scope'],\n                redirectSignIn: cognitoHostedUIConfig['redirectSignIn'],\n                redirectSignOut: cognitoHostedUIConfig['redirectSignOut'],\n                responseType: cognitoHostedUIConfig['responseType'],\n                Storage: this._storage,\n                urlOpener: cognitoHostedUIConfig['urlOpener']\n            }, cognitoHostedUIConfig['options']);\n            this._oAuthHandler = new OAuth_1.default({\n                scopes: cognitoAuthParams.scopes,\n                config: cognitoAuthParams,\n                cognitoClientId: cognitoAuthParams.cognitoClientId\n            });\n            // **NOTE** - Remove this in a future major release as it is a breaking change\n            urlListener_1.default(function (_a) {\n                var url = _a.url;\n                _this._handleAuthResponse(url);\n            });\n        }\n        dispatchAuthEvent('configured', null, \"The Auth category has been configured successfully\");\n        return this._config;\n    };\n    /**\n     * Sign up with username, password and other attrbutes like phone, email\n     * @param {String | object} params - The user attirbutes used for signin\n     * @param {String[]} restOfAttrs - for the backward compatability\n     * @return - A promise resolves callback data if success\n     */\n    AuthClass.prototype.signUp = function (params) {\n        var _this = this;\n        var restOfAttrs = [];\n        for (var _i = 1; _i < arguments.length; _i++) {\n            restOfAttrs[_i - 1] = arguments[_i];\n        }\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        var username = null;\n        var password = null;\n        var attributes = [];\n        var validationData = null;\n        if (params && typeof params === 'string') {\n            username = params;\n            password = restOfAttrs ? restOfAttrs[0] : null;\n            var email = restOfAttrs ? restOfAttrs[1] : null;\n            var phone_number = restOfAttrs ? restOfAttrs[2] : null;\n            if (email)\n                attributes.push({ Name: 'email', Value: email });\n            if (phone_number)\n                attributes.push({ Name: 'phone_number', Value: phone_number });\n        }\n        else if (params && typeof params === 'object') {\n            username = params['username'];\n            password = params['password'];\n            var attrs_1 = params['attributes'];\n            if (attrs_1) {\n                Object.keys(attrs_1).map(function (key) {\n                    var ele = { Name: key, Value: attrs_1[key] };\n                    attributes.push(ele);\n                });\n            }\n            validationData = params['validationData'] || null;\n        }\n        else {\n            return Promise.reject('The first parameter should either be non-null string or object');\n        }\n        if (!username) {\n            return Promise.reject('Username cannot be empty');\n        }\n        if (!password) {\n            return Promise.reject('Password cannot be empty');\n        }\n        logger.debug('signUp attrs:', attributes);\n        logger.debug('signUp validation data:', validationData);\n        return new Promise(function (resolve, reject) {\n            _this.userPool.signUp(username, password, attributes, validationData, function (err, data) {\n                if (err) {\n                    dispatchAuthEvent('signUp_failure', err, username + \" failed to signup\");\n                    reject(err);\n                }\n                else {\n                    dispatchAuthEvent('signUp', data, username + \" has signed up successfully\");\n                    resolve(data);\n                }\n            });\n        });\n    };\n    /**\n     * Send the verfication code to confirm sign up\n     * @param {String} username - The username to be confirmed\n     * @param {String} code - The verification code\n     * @param {ConfirmSignUpOptions} options - other options for confirm signup\n     * @return - A promise resolves callback data if success\n     */\n    AuthClass.prototype.confirmSignUp = function (username, code, options) {\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        if (!username) {\n            return Promise.reject('Username cannot be empty');\n        }\n        if (!code) {\n            return Promise.reject('Code cannot be empty');\n        }\n        var user = this.createCognitoUser(username);\n        var forceAliasCreation = options && typeof options.forceAliasCreation === 'boolean'\n            ? options.forceAliasCreation : true;\n        return new Promise(function (resolve, reject) {\n            user.confirmRegistration(code, forceAliasCreation, function (err, data) {\n                if (err) {\n                    reject(err);\n                }\n                else {\n                    resolve(data);\n                }\n            });\n        });\n    };\n    /**\n     * Resend the verification code\n     * @param {String} username - The username to be confirmed\n     * @return - A promise resolves data if success\n     */\n    AuthClass.prototype.resendSignUp = function (username) {\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        if (!username) {\n            return Promise.reject('Username cannot be empty');\n        }\n        var user = this.createCognitoUser(username);\n        return new Promise(function (resolve, reject) {\n            user.resendConfirmationCode(function (err, data) {\n                if (err) {\n                    reject(err);\n                }\n                else {\n                    resolve(data);\n                }\n            });\n        });\n    };\n    /**\n     * Sign in\n     * @param {String | SignInOpts} usernameOrSignInOpts - The username to be signed in or the sign in options\n     * @param {String} password - The password of the username\n     * @return - A promise resolves the CognitoUser\n     */\n    AuthClass.prototype.signIn = function (usernameOrSignInOpts, pw) {\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        var username = null;\n        var password = null;\n        var validationData = {};\n        // for backward compatibility\n        if (typeof usernameOrSignInOpts === 'string') {\n            username = usernameOrSignInOpts;\n            password = pw;\n        }\n        else if (types_1.isUsernamePasswordOpts(usernameOrSignInOpts)) {\n            if (typeof pw !== 'undefined') {\n                logger.warn('The password should be defined under the first parameter object!');\n            }\n            username = usernameOrSignInOpts.username;\n            password = usernameOrSignInOpts.password;\n            validationData = usernameOrSignInOpts.validationData;\n        }\n        else {\n            return Promise.reject(new Error('The username should either be a string or one of the sign in types'));\n        }\n        if (!username) {\n            return Promise.reject('Username cannot be empty');\n        }\n        var authDetails = new amazon_cognito_identity_js_1.AuthenticationDetails({\n            Username: username,\n            Password: password,\n            ValidationData: validationData\n        });\n        if (password) {\n            return this.signInWithPassword(authDetails);\n        }\n        else {\n            return this.signInWithoutPassword(authDetails);\n        }\n    };\n    /**\n     * Return an object with the authentication callbacks\n     * @param {CognitoUser} user - the cognito user object\n     * @param {} resolve - function called when resolving the current step\n     * @param {} reject - function called when rejecting the current step\n     * @return - an object with the callback methods for user authentication\n     */\n    AuthClass.prototype.authCallbacks = function (user, resolve, reject) {\n        var _this = this;\n        var that = this;\n        return {\n            onSuccess: function (session) { return __awaiter(_this, void 0, void 0, function () {\n                var cred, e_1, currentUser, e_2;\n                return __generator(this, function (_a) {\n                    switch (_a.label) {\n                        case 0:\n                            logger.debug(session);\n                            delete (user['challengeName']);\n                            delete (user['challengeParam']);\n                            _a.label = 1;\n                        case 1:\n                            _a.trys.push([1, 4, 5, 9]);\n                            return [4 /*yield*/, core_1.Credentials.clear()];\n                        case 2:\n                            _a.sent();\n                            return [4 /*yield*/, core_1.Credentials.set(session, 'session')];\n                        case 3:\n                            cred = _a.sent();\n                            logger.debug('succeed to get cognito credentials', cred);\n                            return [3 /*break*/, 9];\n                        case 4:\n                            e_1 = _a.sent();\n                            logger.debug('cannot get cognito credentials', e_1);\n                            return [3 /*break*/, 9];\n                        case 5:\n                            _a.trys.push([5, 7, , 8]);\n                            return [4 /*yield*/, this.currentUserPoolUser()];\n                        case 6:\n                            currentUser = _a.sent();\n                            that.user = currentUser;\n                            dispatchAuthEvent('signIn', currentUser, \"A user \" + user.getUsername() + \" has been signed in\");\n                            resolve(currentUser);\n                            return [3 /*break*/, 8];\n                        case 7:\n                            e_2 = _a.sent();\n                            logger.error('Failed to get the signed in user', e_2);\n                            reject(e_2);\n                            return [3 /*break*/, 8];\n                        case 8: return [7 /*endfinally*/];\n                        case 9: return [2 /*return*/];\n                    }\n                });\n            }); },\n            onFailure: function (err) {\n                logger.debug('signIn failure', err);\n                dispatchAuthEvent('signIn_failure', err, user.getUsername() + \" failed to signin\");\n                reject(err);\n            },\n            customChallenge: function (challengeParam) {\n                logger.debug('signIn custom challenge answer required');\n                user['challengeName'] = 'CUSTOM_CHALLENGE';\n                user['challengeParam'] = challengeParam;\n                resolve(user);\n            },\n            mfaRequired: function (challengeName, challengeParam) {\n                logger.debug('signIn MFA required');\n                user['challengeName'] = challengeName;\n                user['challengeParam'] = challengeParam;\n                resolve(user);\n            },\n            mfaSetup: function (challengeName, challengeParam) {\n                logger.debug('signIn mfa setup', challengeName);\n                user['challengeName'] = challengeName;\n                user['challengeParam'] = challengeParam;\n                resolve(user);\n            },\n            newPasswordRequired: function (userAttributes, requiredAttributes) {\n                logger.debug('signIn new password');\n                user['challengeName'] = 'NEW_PASSWORD_REQUIRED';\n                user['challengeParam'] = {\n                    userAttributes: userAttributes,\n                    requiredAttributes: requiredAttributes\n                };\n                resolve(user);\n            },\n            totpRequired: function (challengeName, challengeParam) {\n                logger.debug('signIn totpRequired');\n                user['challengeName'] = challengeName;\n                user['challengeParam'] = challengeParam;\n                resolve(user);\n            },\n            selectMFAType: function (challengeName, challengeParam) {\n                logger.debug('signIn selectMFAType', challengeName);\n                user['challengeName'] = challengeName;\n                user['challengeParam'] = challengeParam;\n                resolve(user);\n            }\n        };\n    };\n    /**\n     * Sign in with a password\n     * @private\n     * @param {AuthenticationDetails} authDetails - the user sign in data\n     * @return - A promise resolves the CognitoUser object if success or mfa required\n     */\n    AuthClass.prototype.signInWithPassword = function (authDetails) {\n        var _this = this;\n        var user = this.createCognitoUser(authDetails.getUsername());\n        return new Promise(function (resolve, reject) {\n            user.authenticateUser(authDetails, _this.authCallbacks(user, resolve, reject));\n        });\n    };\n    /**\n     * Sign in without a password\n     * @private\n     * @param {AuthenticationDetails} authDetails - the user sign in data\n     * @return - A promise resolves the CognitoUser object if success or mfa required\n     */\n    AuthClass.prototype.signInWithoutPassword = function (authDetails) {\n        var _this = this;\n        var user = this.createCognitoUser(authDetails.getUsername());\n        user.setAuthenticationFlowType('CUSTOM_AUTH');\n        return new Promise(function (resolve, reject) {\n            user.initiateAuth(authDetails, _this.authCallbacks(user, resolve, reject));\n        });\n    };\n    /**\n     * get user current preferred mfa option\n     * this method doesn't work with totp, we need to deprecate it.\n     * @deprecated\n     * @param {CognitoUser} user - the current user\n     * @return - A promise resolves the current preferred mfa option if success\n     */\n    AuthClass.prototype.getMFAOptions = function (user) {\n        return new Promise(function (res, rej) {\n            user.getMFAOptions(function (err, mfaOptions) {\n                if (err) {\n                    logger.debug('get MFA Options failed', err);\n                    rej(err);\n                    return;\n                }\n                logger.debug('get MFA options success', mfaOptions);\n                res(mfaOptions);\n                return;\n            });\n        });\n    };\n    /**\n     * get preferred mfa method\n     * @param {CognitoUser} user - the current cognito user\n     */\n    AuthClass.prototype.getPreferredMFA = function (user) {\n        var that = this;\n        return new Promise(function (res, rej) {\n            user.getUserData(function (err, data) {\n                if (err) {\n                    logger.debug('getting preferred mfa failed', err);\n                    rej(err);\n                    return;\n                }\n                var mfaType = that._getMfaTypeFromUserData(data);\n                if (!mfaType) {\n                    rej('invalid MFA Type');\n                    return;\n                }\n                else {\n                    res(mfaType);\n                    return;\n                }\n            });\n        });\n    };\n    AuthClass.prototype._getMfaTypeFromUserData = function (data) {\n        var ret = null;\n        var preferredMFA = data.PreferredMfaSetting;\n        // if the user has used Auth.setPreferredMFA() to setup the mfa type\n        // then the \"PreferredMfaSetting\" would exist in the response\n        if (preferredMFA) {\n            ret = preferredMFA;\n        }\n        else {\n            // if mfaList exists but empty, then its noMFA\n            var mfaList = data.UserMFASettingList;\n            if (!mfaList) {\n                // if SMS was enabled by using Auth.enableSMS(),\n                // the response would contain MFAOptions\n                // as for now Cognito only supports for SMS, so we will say it is 'SMS_MFA'\n                // if it does not exist, then it should be NOMFA\n                var MFAOptions = data.MFAOptions;\n                if (MFAOptions) {\n                    ret = 'SMS_MFA';\n                }\n                else {\n                    ret = 'NOMFA';\n                }\n            }\n            else if (mfaList.length === 0) {\n                ret = 'NOMFA';\n            }\n            else {\n                logger.debug('invalid case for getPreferredMFA', data);\n            }\n        }\n        return ret;\n    };\n    AuthClass.prototype._getUserData = function (user) {\n        return new Promise(function (res, rej) {\n            user.getUserData(function (err, data) {\n                if (err) {\n                    logger.debug('getting user data failed', err);\n                    rej(err);\n                    return;\n                }\n                else {\n                    res(data);\n                    return;\n                }\n            });\n        });\n    };\n    /**\n     * set preferred MFA method\n     * @param {CognitoUser} user - the current Cognito user\n     * @param {string} mfaMethod - preferred mfa method\n     * @return - A promise resolve if success\n     */\n    AuthClass.prototype.setPreferredMFA = function (user, mfaMethod) {\n        return __awaiter(this, void 0, void 0, function () {\n            var userData, smsMfaSettings, totpMfaSettings, _a, mfaList, currentMFAType, that;\n            return __generator(this, function (_b) {\n                switch (_b.label) {\n                    case 0: return [4 /*yield*/, this._getUserData(user)];\n                    case 1:\n                        userData = _b.sent();\n                        smsMfaSettings = null;\n                        totpMfaSettings = null;\n                        _a = mfaMethod;\n                        switch (_a) {\n                            case 'TOTP' || false: return [3 /*break*/, 2];\n                            case 'SMS' || false: return [3 /*break*/, 3];\n                            case 'NOMFA': return [3 /*break*/, 4];\n                        }\n                        return [3 /*break*/, 6];\n                    case 2:\n                        totpMfaSettings = {\n                            PreferredMfa: true,\n                            Enabled: true\n                        };\n                        return [3 /*break*/, 7];\n                    case 3:\n                        smsMfaSettings = {\n                            PreferredMfa: true,\n                            Enabled: true\n                        };\n                        return [3 /*break*/, 7];\n                    case 4:\n                        mfaList = userData['UserMFASettingList'];\n                        return [4 /*yield*/, this._getMfaTypeFromUserData(userData)];\n                    case 5:\n                        currentMFAType = _b.sent();\n                        if (currentMFAType === 'NOMFA') {\n                            return [2 /*return*/, Promise.resolve('No change for mfa type')];\n                        }\n                        else if (currentMFAType === 'SMS_MFA') {\n                            smsMfaSettings = {\n                                PreferredMfa: false,\n                                Enabled: false\n                            };\n                        }\n                        else if (currentMFAType === 'SOFTWARE_TOKEN_MFA') {\n                            totpMfaSettings = {\n                                PreferredMfa: false,\n                                Enabled: false\n                            };\n                        }\n                        else {\n                            return [2 /*return*/, Promise.reject('invalid MFA type')];\n                        }\n                        // if there is a UserMFASettingList in the response\n                        // we need to disable every mfa type in that list\n                        if (mfaList && mfaList.length !== 0) {\n                            // to disable SMS or TOTP if exists in that list\n                            mfaList.forEach(function (mfaType) {\n                                if (mfaType === 'SMS_MFA') {\n                                    smsMfaSettings = {\n                                        PreferredMfa: false,\n                                        Enabled: false\n                                    };\n                                }\n                                else if (mfaType === 'SOFTWARE_TOKEN_MFA') {\n                                    totpMfaSettings = {\n                                        PreferredMfa: false,\n                                        Enabled: false\n                                    };\n                                }\n                            });\n                        }\n                        return [3 /*break*/, 7];\n                    case 6:\n                        logger.debug('no validmfa method provided');\n                        return [2 /*return*/, Promise.reject('no validmfa method provided')];\n                    case 7:\n                        that = this;\n                        return [2 /*return*/, new Promise(function (res, rej) {\n                                user.setUserMfaPreference(smsMfaSettings, totpMfaSettings, function (err, result) {\n                                    if (err) {\n                                        logger.debug('Set user mfa preference error', err);\n                                        return rej(err);\n                                    }\n                                    logger.debug('Set user mfa success', result);\n                                    return res(result);\n                                });\n                            })];\n                }\n            });\n        });\n    };\n    /**\n     * diable SMS\n     * @deprecated\n     * @param {CognitoUser} user - the current user\n     * @return - A promise resolves is success\n     */\n    AuthClass.prototype.disableSMS = function (user) {\n        return new Promise(function (res, rej) {\n            user.disableMFA(function (err, data) {\n                if (err) {\n                    logger.debug('disable mfa failed', err);\n                    rej(err);\n                    return;\n                }\n                logger.debug('disable mfa succeed', data);\n                res(data);\n                return;\n            });\n        });\n    };\n    /**\n     * enable SMS\n     * @deprecated\n     * @param {CognitoUser} user - the current user\n     * @return - A promise resolves is success\n     */\n    AuthClass.prototype.enableSMS = function (user) {\n        return new Promise(function (res, rej) {\n            user.enableMFA(function (err, data) {\n                if (err) {\n                    logger.debug('enable mfa failed', err);\n                    rej(err);\n                    return;\n                }\n                logger.debug('enable mfa succeed', data);\n                res(data);\n                return;\n            });\n        });\n    };\n    /**\n     * Setup TOTP\n     * @param {CognitoUser} user - the current user\n     * @return - A promise resolves with the secret code if success\n     */\n    AuthClass.prototype.setupTOTP = function (user) {\n        return new Promise(function (res, rej) {\n            user.associateSoftwareToken({\n                onFailure: function (err) {\n                    logger.debug('associateSoftwareToken failed', err);\n                    rej(err);\n                    return;\n                },\n                associateSecretCode: function (secretCode) {\n                    logger.debug('associateSoftwareToken sucess', secretCode);\n                    res(secretCode);\n                    return;\n                }\n            });\n        });\n    };\n    /**\n     * verify TOTP setup\n     * @param {CognitoUser} user - the current user\n     * @param {string} challengeAnswer - challenge answer\n     * @return - A promise resolves is success\n     */\n    AuthClass.prototype.verifyTotpToken = function (user, challengeAnswer) {\n        logger.debug('verfication totp token', user, challengeAnswer);\n        return new Promise(function (res, rej) {\n            user.verifySoftwareToken(challengeAnswer, 'My TOTP device', {\n                onFailure: function (err) {\n                    logger.debug('verifyTotpToken failed', err);\n                    rej(err);\n                    return;\n                },\n                onSuccess: function (data) {\n                    logger.debug('verifyTotpToken success', data);\n                    res(data);\n                    return;\n                }\n            });\n        });\n    };\n    /**\n     * Send MFA code to confirm sign in\n     * @param {Object} user - The CognitoUser object\n     * @param {String} code - The confirmation code\n     */\n    AuthClass.prototype.confirmSignIn = function (user, code, mfaType) {\n        var _this = this;\n        if (!code) {\n            return Promise.reject('Code cannot be empty');\n        }\n        var that = this;\n        return new Promise(function (resolve, reject) {\n            user.sendMFACode(code, {\n                onSuccess: function (session) { return __awaiter(_this, void 0, void 0, function () {\n                    var cred, e_3;\n                    return __generator(this, function (_a) {\n                        switch (_a.label) {\n                            case 0:\n                                logger.debug(session);\n                                _a.label = 1;\n                            case 1:\n                                _a.trys.push([1, 4, 5, 6]);\n                                return [4 /*yield*/, core_1.Credentials.clear()];\n                            case 2:\n                                _a.sent();\n                                return [4 /*yield*/, core_1.Credentials.set(session, 'session')];\n                            case 3:\n                                cred = _a.sent();\n                                logger.debug('succeed to get cognito credentials', cred);\n                                return [3 /*break*/, 6];\n                            case 4:\n                                e_3 = _a.sent();\n                                logger.debug('cannot get cognito credentials', e_3);\n                                return [3 /*break*/, 6];\n                            case 5:\n                                that.user = user;\n                                dispatchAuthEvent('signIn', user, user + \" has signed in\");\n                                resolve(user);\n                                return [7 /*endfinally*/];\n                            case 6: return [2 /*return*/];\n                        }\n                    });\n                }); },\n                onFailure: function (err) {\n                    logger.debug('confirm signIn failure', err);\n                    reject(err);\n                }\n            }, mfaType);\n        });\n    };\n    AuthClass.prototype.completeNewPassword = function (user, password, requiredAttributes) {\n        var _this = this;\n        if (!password) {\n            return Promise.reject('Password cannot be empty');\n        }\n        var that = this;\n        return new Promise(function (resolve, reject) {\n            user.completeNewPasswordChallenge(password, requiredAttributes, {\n                onSuccess: function (session) { return __awaiter(_this, void 0, void 0, function () {\n                    var cred, e_4;\n                    return __generator(this, function (_a) {\n                        switch (_a.label) {\n                            case 0:\n                                logger.debug(session);\n                                _a.label = 1;\n                            case 1:\n                                _a.trys.push([1, 4, 5, 6]);\n                                return [4 /*yield*/, core_1.Credentials.clear()];\n                            case 2:\n                                _a.sent();\n                                return [4 /*yield*/, core_1.Credentials.set(session, 'session')];\n                            case 3:\n                                cred = _a.sent();\n                                logger.debug('succeed to get cognito credentials', cred);\n                                return [3 /*break*/, 6];\n                            case 4:\n                                e_4 = _a.sent();\n                                logger.debug('cannot get cognito credentials', e_4);\n                                return [3 /*break*/, 6];\n                            case 5:\n                                that.user = user;\n                                dispatchAuthEvent('signIn', user, user + \" has signed in\");\n                                resolve(user);\n                                return [7 /*endfinally*/];\n                            case 6: return [2 /*return*/];\n                        }\n                    });\n                }); },\n                onFailure: function (err) {\n                    logger.debug('completeNewPassword failure', err);\n                    dispatchAuthEvent('completeNewPassword_failure', err, _this.user + \" failed to complete the new password flow\");\n                    reject(err);\n                },\n                mfaRequired: function (challengeName, challengeParam) {\n                    logger.debug('signIn MFA required');\n                    user['challengeName'] = challengeName;\n                    user['challengeParam'] = challengeParam;\n                    resolve(user);\n                },\n                mfaSetup: function (challengeName, challengeParam) {\n                    logger.debug('signIn mfa setup', challengeName);\n                    user['challengeName'] = challengeName;\n                    user['challengeParam'] = challengeParam;\n                    resolve(user);\n                }\n            });\n        });\n    };\n    /**\n     * Send the answer to a custom challenge\n     * @param {CognitoUser} user - The CognitoUser object\n     * @param {String} challengeResponses - The confirmation code\n     */\n    AuthClass.prototype.sendCustomChallengeAnswer = function (user, challengeResponses) {\n        var _this = this;\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        if (!challengeResponses) {\n            return Promise.reject('Challenge response cannot be empty');\n        }\n        var that = this;\n        return new Promise(function (resolve, reject) {\n            user.sendCustomChallengeAnswer(challengeResponses, _this.authCallbacks(user, resolve, reject));\n        });\n    };\n    /**\n     * Update an authenticated users' attributes\n     * @param {CognitoUser} - The currently logged in user object\n     * @return {Promise}\n     **/\n    AuthClass.prototype.updateUserAttributes = function (user, attributes) {\n        var attributeList = [];\n        var that = this;\n        return new Promise(function (resolve, reject) {\n            that.userSession(user).then(function (session) {\n                for (var key in attributes) {\n                    if (key !== 'sub' &&\n                        key.indexOf('_verified') < 0) {\n                        var attr = {\n                            'Name': key,\n                            'Value': attributes[key]\n                        };\n                        attributeList.push(attr);\n                    }\n                }\n                user.updateAttributes(attributeList, function (err, result) {\n                    if (err) {\n                        return reject(err);\n                    }\n                    else {\n                        return resolve(result);\n                    }\n                });\n            });\n        });\n    };\n    /**\n     * Return user attributes\n     * @param {Object} user - The CognitoUser object\n     * @return - A promise resolves to user attributes if success\n     */\n    AuthClass.prototype.userAttributes = function (user) {\n        var _this = this;\n        return new Promise(function (resolve, reject) {\n            _this.userSession(user).then(function (session) {\n                user.getUserAttributes(function (err, attributes) {\n                    if (err) {\n                        reject(err);\n                    }\n                    else {\n                        resolve(attributes);\n                    }\n                });\n            });\n        });\n    };\n    AuthClass.prototype.verifiedContact = function (user) {\n        var that = this;\n        return this.userAttributes(user)\n            .then(function (attributes) {\n            var attrs = that.attributesToObject(attributes);\n            var unverified = {};\n            var verified = {};\n            if (attrs['email']) {\n                if (attrs['email_verified']) {\n                    verified['email'] = attrs['email'];\n                }\n                else {\n                    unverified['email'] = attrs['email'];\n                }\n            }\n            if (attrs['phone_number']) {\n                if (attrs['phone_number_verified']) {\n                    verified['phone_number'] = attrs['phone_number'];\n                }\n                else {\n                    unverified['phone_number'] = attrs['phone_number'];\n                }\n            }\n            return {\n                verified: verified,\n                unverified: unverified\n            };\n        });\n    };\n    /**\n     * Get current authenticated user\n     * @return - A promise resolves to current authenticated CognitoUser if success\n     */\n    AuthClass.prototype.currentUserPoolUser = function (params) {\n        var _this = this;\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        var that = this;\n        return new Promise(function (res, rej) {\n            _this._storageSync.then(function () {\n                var user = that.userPool.getCurrentUser();\n                if (!user) {\n                    logger.debug('Failed to get user from user pool');\n                    rej('No current user');\n                    return;\n                }\n                // refresh the session if the session expired.\n                user.getSession(function (err, session) {\n                    if (err) {\n                        logger.debug('Failed to get the user session', err);\n                        rej(err);\n                        return;\n                    }\n                    // get user data from Cognito\n                    var bypassCache = params ? params.bypassCache : false;\n                    // validate the token's scope fisrt before calling this function\n                    var _a = session.getAccessToken().decodePayload().scope, scope = _a === void 0 ? '' : _a;\n                    if (scope.split(' ').includes(USER_ADMIN_SCOPE)) {\n                        user.getUserData(function (err, data) {\n                            if (err) {\n                                logger.debug('getting user data failed', err);\n                                // Make sure the user is still valid\n                                if (err.message === 'User is disabled' || err.message === 'User does not exist.') {\n                                    rej(err);\n                                }\n                                else {\n                                    // the error may also be thrown when lack of permissions to get user info etc\n                                    // in that case we just bypass the error\n                                    res(user);\n                                }\n                                return;\n                            }\n                            var preferredMFA = data.PreferredMfaSetting || 'NOMFA';\n                            var attributeList = [];\n                            for (var i = 0; i < data.UserAttributes.length; i++) {\n                                var attribute = {\n                                    Name: data.UserAttributes[i].Name,\n                                    Value: data.UserAttributes[i].Value,\n                                };\n                                var userAttribute = new amazon_cognito_identity_js_1.CognitoUserAttribute(attribute);\n                                attributeList.push(userAttribute);\n                            }\n                            var attributes = that.attributesToObject(attributeList);\n                            Object.assign(user, { attributes: attributes, preferredMFA: preferredMFA });\n                            return res(user);\n                        }, { bypassCache: bypassCache });\n                    }\n                    else {\n                        logger.debug(\"Unable to get the user data because the \" + USER_ADMIN_SCOPE + \" \" +\n                            \"is not in the scopes of the access token\");\n                        return res(user);\n                    }\n                });\n            }).catch(function (e) {\n                logger.debug('Failed to sync cache info into memory', e);\n                return rej(e);\n            });\n        });\n    };\n    /**\n     * Get current authenticated user\n     * @param {CurrentUserOpts} - options for getting the current user\n     * @return - A promise resolves to current authenticated CognitoUser if success\n     */\n    AuthClass.prototype.currentAuthenticatedUser = function (params) {\n        return __awaiter(this, void 0, void 0, function () {\n            var federatedUser, e_5, user, e_6;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        logger.debug('getting current authenticted user');\n                        federatedUser = null;\n                        _a.label = 1;\n                    case 1:\n                        _a.trys.push([1, 3, , 4]);\n                        return [4 /*yield*/, this._storageSync];\n                    case 2:\n                        _a.sent();\n                        return [3 /*break*/, 4];\n                    case 3:\n                        e_5 = _a.sent();\n                        logger.debug('Failed to sync cache info into memory', e_5);\n                        throw e_5;\n                    case 4:\n                        try {\n                            federatedUser = JSON.parse(this._storage.getItem('aws-amplify-federatedInfo')).user;\n                        }\n                        catch (e) {\n                            logger.debug('cannot load federated user from auth storage');\n                        }\n                        if (!federatedUser) return [3 /*break*/, 5];\n                        this.user = federatedUser;\n                        logger.debug('get current authenticated federated user', this.user);\n                        return [2 /*return*/, this.user];\n                    case 5:\n                        logger.debug('get current authenticated userpool user');\n                        user = null;\n                        _a.label = 6;\n                    case 6:\n                        _a.trys.push([6, 8, , 9]);\n                        return [4 /*yield*/, this.currentUserPoolUser(params)];\n                    case 7:\n                        user = _a.sent();\n                        return [3 /*break*/, 9];\n                    case 8:\n                        e_6 = _a.sent();\n                        if (e_6 === 'No userPool') {\n                            logger.error('Cannot get the current user because the user pool is missing. ' +\n                                'Please make sure the Auth module is configured with a valid Cognito User Pool ID');\n                        }\n                        logger.debug('The user is not authenticated by the error', e_6);\n                        throw ('not authenticated');\n                    case 9:\n                        this.user = user;\n                        return [2 /*return*/, this.user];\n                }\n            });\n        });\n    };\n    /**\n     * Get current user's session\n     * @return - A promise resolves to session object if success\n     */\n    AuthClass.prototype.currentSession = function () {\n        var that = this;\n        logger.debug('Getting current session');\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        return new Promise(function (res, rej) {\n            that.currentUserPoolUser().then(function (user) {\n                that.userSession(user).then(function (session) {\n                    res(session);\n                    return;\n                }).catch(function (e) {\n                    logger.debug('Failed to get the current session', e);\n                    rej(e);\n                    return;\n                });\n            }).catch(function (e) {\n                logger.debug('Failed to get the current user', e);\n                rej(e);\n                return;\n            });\n        });\n    };\n    /**\n     * Get the corresponding user session\n     * @param {Object} user - The CognitoUser object\n     * @return - A promise resolves to the session\n     */\n    AuthClass.prototype.userSession = function (user) {\n        if (!user) {\n            logger.debug('the user is null');\n            return Promise.reject('Failed to get the session because the user is empty');\n        }\n        return new Promise(function (resolve, reject) {\n            logger.debug('Getting the session from this user:', user);\n            user.getSession(function (err, session) {\n                if (err) {\n                    logger.debug('Failed to get the session from user', user);\n                    reject(err);\n                    return;\n                }\n                else {\n                    logger.debug('Succeed to get the user session', session);\n                    resolve(session);\n                    return;\n                }\n            });\n        });\n    };\n    /**\n     * Get  authenticated credentials of current user.\n     * @return - A promise resolves to be current user's credentials\n     */\n    AuthClass.prototype.currentUserCredentials = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            var that, e_7, federatedInfo;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        that = this;\n                        logger.debug('Getting current user credentials');\n                        _a.label = 1;\n                    case 1:\n                        _a.trys.push([1, 3, , 4]);\n                        return [4 /*yield*/, this._storageSync];\n                    case 2:\n                        _a.sent();\n                        return [3 /*break*/, 4];\n                    case 3:\n                        e_7 = _a.sent();\n                        logger.debug('Failed to sync cache info into memory', e_7);\n                        throw e_7;\n                    case 4:\n                        federatedInfo = null;\n                        try {\n                            federatedInfo = JSON.parse(this._storage.getItem('aws-amplify-federatedInfo'));\n                        }\n                        catch (e) {\n                            logger.debug('failed to get or parse item aws-amplify-federatedInfo', e);\n                        }\n                        if (federatedInfo) {\n                            // refresh the jwt token here if necessary\n                            return [2 /*return*/, core_1.Credentials.refreshFederatedToken(federatedInfo)];\n                        }\n                        else {\n                            return [2 /*return*/, this.currentSession()\n                                    .then(function (session) {\n                                    logger.debug('getting session success', session);\n                                    return core_1.Credentials.set(session, 'session');\n                                }).catch(function (error) {\n                                    logger.debug('getting session failed', error);\n                                    return core_1.Credentials.set(null, 'guest');\n                                })];\n                        }\n                        return [2 /*return*/];\n                }\n            });\n        });\n    };\n    AuthClass.prototype.currentCredentials = function () {\n        logger.debug('getting current credntials');\n        return core_1.Credentials.get();\n    };\n    /**\n     * Initiate an attribute confirmation request\n     * @param {Object} user - The CognitoUser\n     * @param {Object} attr - The attributes to be verified\n     * @return - A promise resolves to callback data if success\n     */\n    AuthClass.prototype.verifyUserAttribute = function (user, attr) {\n        return new Promise(function (resolve, reject) {\n            user.getAttributeVerificationCode(attr, {\n                onSuccess: function () { return resolve(); },\n                onFailure: function (err) { return reject(err); }\n            });\n        });\n    };\n    /**\n     * Confirm an attribute using a confirmation code\n     * @param {Object} user - The CognitoUser\n     * @param {Object} attr - The attribute to be verified\n     * @param {String} code - The confirmation code\n     * @return - A promise resolves to callback data if success\n     */\n    AuthClass.prototype.verifyUserAttributeSubmit = function (user, attr, code) {\n        if (!code) {\n            return Promise.reject('Code cannot be empty');\n        }\n        return new Promise(function (resolve, reject) {\n            user.verifyAttribute(attr, code, {\n                onSuccess: function (data) {\n                    resolve(data);\n                    return;\n                },\n                onFailure: function (err) {\n                    reject(err);\n                    return;\n                }\n            });\n        });\n    };\n    AuthClass.prototype.verifyCurrentUserAttribute = function (attr) {\n        var that = this;\n        return that.currentUserPoolUser()\n            .then(function (user) { return that.verifyUserAttribute(user, attr); });\n    };\n    /**\n     * Confirm current user's attribute using a confirmation code\n     * @param {Object} attr - The attribute to be verified\n     * @param {String} code - The confirmation code\n     * @return - A promise resolves to callback data if success\n     */\n    AuthClass.prototype.verifyCurrentUserAttributeSubmit = function (attr, code) {\n        var that = this;\n        return that.currentUserPoolUser()\n            .then(function (user) { return that.verifyUserAttributeSubmit(user, attr, code); });\n    };\n    AuthClass.prototype.cognitoIdentitySignOut = function (opts, user) {\n        return __awaiter(this, void 0, void 0, function () {\n            var e_8, isSignedInHostedUI;\n            var _this = this;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        _a.trys.push([0, 2, , 3]);\n                        return [4 /*yield*/, this._storageSync];\n                    case 1:\n                        _a.sent();\n                        return [3 /*break*/, 3];\n                    case 2:\n                        e_8 = _a.sent();\n                        logger.debug('Failed to sync cache info into memory', e_8);\n                        throw e_8;\n                    case 3:\n                        isSignedInHostedUI = this._oAuthHandler\n                            && this._storage.getItem('amplify-signin-with-hostedUI') === 'true';\n                        return [2 /*return*/, new Promise(function (res, rej) {\n                                if (opts && opts.global) {\n                                    logger.debug('user global sign out', user);\n                                    // in order to use global signout\n                                    // we must validate the user as an authenticated user by using getSession\n                                    user.getSession(function (err, result) {\n                                        if (err) {\n                                            logger.debug('failed to get the user session', err);\n                                            return rej(err);\n                                        }\n                                        user.globalSignOut({\n                                            onSuccess: function (data) {\n                                                logger.debug('global sign out success');\n                                                if (isSignedInHostedUI) {\n                                                    _this._oAuthHandler.signOut();\n                                                }\n                                                return res();\n                                            },\n                                            onFailure: function (err) {\n                                                logger.debug('global sign out failed', err);\n                                                return rej(err);\n                                            }\n                                        });\n                                    });\n                                }\n                                else {\n                                    logger.debug('user sign out', user);\n                                    user.signOut();\n                                    if (isSignedInHostedUI) {\n                                        _this._oAuthHandler.signOut();\n                                    }\n                                    return res();\n                                }\n                            })];\n                }\n            });\n        });\n    };\n    /**\n     * Sign out method\n     * @\n     * @return - A promise resolved if success\n     */\n    AuthClass.prototype.signOut = function (opts) {\n        return __awaiter(this, void 0, void 0, function () {\n            var e_9, user;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        _a.trys.push([0, 2, , 3]);\n                        return [4 /*yield*/, this.cleanCachedItems()];\n                    case 1:\n                        _a.sent();\n                        return [3 /*break*/, 3];\n                    case 2:\n                        e_9 = _a.sent();\n                        logger.debug('failed to clear cached items');\n                        return [3 /*break*/, 3];\n                    case 3:\n                        if (!this.userPool) return [3 /*break*/, 7];\n                        user = this.userPool.getCurrentUser();\n                        if (!user) return [3 /*break*/, 5];\n                        return [4 /*yield*/, this.cognitoIdentitySignOut(opts, user)];\n                    case 4:\n                        _a.sent();\n                        return [3 /*break*/, 6];\n                    case 5:\n                        logger.debug('no current Cognito user');\n                        _a.label = 6;\n                    case 6: return [3 /*break*/, 8];\n                    case 7:\n                        logger.debug('no Congito User pool');\n                        _a.label = 8;\n                    case 8:\n                        /**\n                         * Note for future refactor - no reliable way to get username with\n                         * Cognito User Pools vs Identity when federating with Social Providers\n                         * This is why we need a well structured session object that can be inspected\n                         * and information passed back in the message below for Hub dispatch\n                        */\n                        dispatchAuthEvent('signOut', this.user, \"A user has been signed out\");\n                        this.user = null;\n                        return [2 /*return*/];\n                }\n            });\n        });\n    };\n    AuthClass.prototype.cleanCachedItems = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0: \n                    // clear cognito cached item\n                    return [4 /*yield*/, core_1.Credentials.clear()];\n                    case 1:\n                        // clear cognito cached item\n                        _a.sent();\n                        return [2 /*return*/];\n                }\n            });\n        });\n    };\n    /**\n     * Change a password for an authenticated user\n     * @param {Object} user - The CognitoUser object\n     * @param {String} oldPassword - the current password\n     * @param {String} newPassword - the requested new password\n     * @return - A promise resolves if success\n     */\n    AuthClass.prototype.changePassword = function (user, oldPassword, newPassword) {\n        var _this = this;\n        return new Promise(function (resolve, reject) {\n            _this.userSession(user).then(function (session) {\n                user.changePassword(oldPassword, newPassword, function (err, data) {\n                    if (err) {\n                        logger.debug('change password failure', err);\n                        return reject(err);\n                    }\n                    else {\n                        return resolve(data);\n                    }\n                });\n            });\n        });\n    };\n    /**\n     * Initiate a forgot password request\n     * @param {String} username - the username to change password\n     * @return - A promise resolves if success\n     */\n    AuthClass.prototype.forgotPassword = function (username) {\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        if (!username) {\n            return Promise.reject('Username cannot be empty');\n        }\n        var user = this.createCognitoUser(username);\n        return new Promise(function (resolve, reject) {\n            user.forgotPassword({\n                onSuccess: function () {\n                    resolve();\n                    return;\n                },\n                onFailure: function (err) {\n                    logger.debug('forgot password failure', err);\n                    reject(err);\n                    return;\n                },\n                inputVerificationCode: function (data) {\n                    resolve(data);\n                    return;\n                }\n            });\n        });\n    };\n    /**\n     * Confirm a new password using a confirmation Code\n     * @param {String} username - The username\n     * @param {String} code - The confirmation code\n     * @param {String} password - The new password\n     * @return - A promise that resolves if success\n     */\n    AuthClass.prototype.forgotPasswordSubmit = function (username, code, password) {\n        if (!this.userPool) {\n            return Promise.reject('No userPool');\n        }\n        if (!username) {\n            return Promise.reject('Username cannot be empty');\n        }\n        if (!code) {\n            return Promise.reject('Code cannot be empty');\n        }\n        if (!password) {\n            return Promise.reject('Password cannot be empty');\n        }\n        var user = this.createCognitoUser(username);\n        return new Promise(function (resolve, reject) {\n            user.confirmPassword(code, password, {\n                onSuccess: function () {\n                    resolve();\n                    return;\n                },\n                onFailure: function (err) {\n                    reject(err);\n                    return;\n                }\n            });\n        });\n    };\n    /**\n     * Get user information\n     * @async\n     * @return {Object }- current User's information\n     */\n    AuthClass.prototype.currentUserInfo = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            var source, user, attributes, userAttrs, credentials, e_10, info, err_1, user;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        source = core_1.Credentials.getCredSource();\n                        if (!(!source || source === 'aws' || source === 'userPool')) return [3 /*break*/, 9];\n                        return [4 /*yield*/, this.currentUserPoolUser()\n                                .catch(function (err) { return logger.debug(err); })];\n                    case 1:\n                        user = _a.sent();\n                        if (!user) {\n                            return [2 /*return*/, null];\n                        }\n                        _a.label = 2;\n                    case 2:\n                        _a.trys.push([2, 8, , 9]);\n                        return [4 /*yield*/, this.userAttributes(user)];\n                    case 3:\n                        attributes = _a.sent();\n                        userAttrs = this.attributesToObject(attributes);\n                        credentials = null;\n                        _a.label = 4;\n                    case 4:\n                        _a.trys.push([4, 6, , 7]);\n                        return [4 /*yield*/, this.currentCredentials()];\n                    case 5:\n                        credentials = _a.sent();\n                        return [3 /*break*/, 7];\n                    case 6:\n                        e_10 = _a.sent();\n                        logger.debug('Failed to retrieve credentials while getting current user info', e_10);\n                        return [3 /*break*/, 7];\n                    case 7:\n                        info = {\n                            'id': credentials ? credentials.identityId : undefined,\n                            'username': user.getUsername(),\n                            'attributes': userAttrs\n                        };\n                        return [2 /*return*/, info];\n                    case 8:\n                        err_1 = _a.sent();\n                        logger.debug('currentUserInfo error', err_1);\n                        return [2 /*return*/, {}];\n                    case 9:\n                        if (source === 'federated') {\n                            user = this.user;\n                            return [2 /*return*/, user ? user : {}];\n                        }\n                        return [2 /*return*/];\n                }\n            });\n        });\n    };\n    AuthClass.prototype.federatedSignIn = function (providerOrOptions, response, user) {\n        return __awaiter(this, void 0, void 0, function () {\n            var options, provider, client_id, redirect_uri, provider, loggedInUser, e_11, token, identity_id, expires_at, credentials, currentUser;\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        if (!this._config.identityPoolId && !this._config.userPoolId) {\n                            throw new Error(\"Federation requires either a User Pool or Identity Pool in config\");\n                        }\n                        // Ensure backwards compatability\n                        if (typeof providerOrOptions === 'undefined') {\n                            if (this._config.identityPoolId && !this._config.userPoolId) {\n                                throw new Error(\"Federation with Identity Pools requires tokens passed as arguments\");\n                            }\n                        }\n                        if (!(types_1.isFederatedSignInOptions(providerOrOptions)\n                            || types_1.isFederatedSignInOptionsCustom(providerOrOptions)\n                            || typeof providerOrOptions === 'undefined')) return [3 /*break*/, 1];\n                        options = providerOrOptions || { provider: CognitoHostedUIIdentityProvider.Cognito };\n                        provider = types_1.isFederatedSignInOptions(options)\n                            ? options.provider\n                            : options.customProvider;\n                        if (this._config.userPoolId) {\n                            client_id = types_1.isCognitoHostedOpts(this._config.oauth)\n                                ? this._config.userPoolWebClientId\n                                : this._config.oauth.clientID;\n                            redirect_uri = types_1.isCognitoHostedOpts(this._config.oauth)\n                                ? this._config.oauth.redirectSignIn\n                                : this._config.oauth.redirectUri;\n                            this._oAuthHandler.oauthSignIn(this._config.oauth.responseType, this._config.oauth.domain, redirect_uri, client_id, provider);\n                        }\n                        return [3 /*break*/, 8];\n                    case 1:\n                        provider = providerOrOptions;\n                        _a.label = 2;\n                    case 2:\n                        _a.trys.push([2, 4, , 5]);\n                        return [4 /*yield*/, this.currentAuthenticatedUser()];\n                    case 3:\n                        loggedInUser = _a.sent();\n                        logger.warn(\"There is already a signed in user: \" + loggedInUser + \" in your app.\\n                You should not call Auth.federatedSignIn method again as it may cause unexpected behavior.\");\n                        return [3 /*break*/, 5];\n                    case 4:\n                        e_11 = _a.sent();\n                        return [3 /*break*/, 5];\n                    case 5:\n                        token = response.token, identity_id = response.identity_id, expires_at = response.expires_at;\n                        return [4 /*yield*/, core_1.Credentials.set({ provider: provider, token: token, identity_id: identity_id, user: user, expires_at: expires_at }, 'federation')];\n                    case 6:\n                        credentials = _a.sent();\n                        return [4 /*yield*/, this.currentAuthenticatedUser()];\n                    case 7:\n                        currentUser = _a.sent();\n                        dispatchAuthEvent('signIn', currentUser, \"A user \" + currentUser.username + \" has been signed in\");\n                        logger.debug('federated sign in credentials', credentials);\n                        return [2 /*return*/, credentials];\n                    case 8: return [2 /*return*/];\n                }\n            });\n        });\n    };\n    /**\n     * Used to complete the OAuth flow with or without the Cognito Hosted UI\n     * @param {String} URL - optional parameter for customers to pass in the response URL\n     */\n    AuthClass.prototype._handleAuthResponse = function (URL) {\n        return __awaiter(this, void 0, void 0, function () {\n            var currentUrl, hasCodeOrError, hasTokenOrError, _a, accessToken, idToken, refreshToken, session, credentials, currentUser, err_2;\n            return __generator(this, function (_b) {\n                switch (_b.label) {\n                    case 0:\n                        if (!this._config.userPoolId) {\n                            throw new Error(\"OAuth responses require a User Pool defined in config\");\n                        }\n                        currentUrl = URL || window.location.href;\n                        hasCodeOrError = !!(url_1.parse(currentUrl).query || '')\n                            .split('&')\n                            .map(function (entry) { return entry.split('='); })\n                            .find(function (_a) {\n                            var k = _a[0];\n                            return k === 'code' || k === 'error';\n                        });\n                        hasTokenOrError = !!(url_1.parse(currentUrl).hash || '#')\n                            .substr(1)\n                            .split('&')\n                            .map(function (entry) { return entry.split('='); })\n                            .find(function (_a) {\n                            var k = _a[0];\n                            return k === 'access_token' || k === 'error';\n                        });\n                        if (!(hasCodeOrError || hasTokenOrError)) return [3 /*break*/, 6];\n                        _b.label = 1;\n                    case 1:\n                        _b.trys.push([1, 5, , 6]);\n                        return [4 /*yield*/, this._oAuthHandler.handleAuthResponse(currentUrl)];\n                    case 2:\n                        _a = _b.sent(), accessToken = _a.accessToken, idToken = _a.idToken, refreshToken = _a.refreshToken;\n                        session = new amazon_cognito_identity_js_1.CognitoUserSession({\n                            IdToken: new amazon_cognito_identity_js_1.CognitoIdToken({ IdToken: idToken }),\n                            RefreshToken: new amazon_cognito_identity_js_1.CognitoRefreshToken({ RefreshToken: refreshToken }),\n                            AccessToken: new amazon_cognito_identity_js_1.CognitoAccessToken({ AccessToken: accessToken })\n                        });\n                        credentials = void 0;\n                        if (!this._config.identityPoolId) return [3 /*break*/, 4];\n                        return [4 /*yield*/, core_1.Credentials.set(session, 'session')];\n                    case 3:\n                        credentials = _b.sent();\n                        logger.debug('AWS credentials', credentials);\n                        _b.label = 4;\n                    case 4:\n                        currentUser = this.createCognitoUser(session.getIdToken().decodePayload()['cognito:username']);\n                        dispatchAuthEvent('signIn', currentUser, \"A user \" + currentUser.getUsername() + \" has been signed in\");\n                        dispatchAuthEvent('cognitoHostedUI', currentUser, \"A user \" + currentUser.getUsername() + \" has been signed in via Cognito Hosted UI\");\n                        // This calls cacheTokens() in Cognito SDK\n                        currentUser.setSignInUserSession(session);\n                        //#endregion\n                        if (window && typeof window.history !== 'undefined') {\n                            window.history.replaceState({}, null, this._config.oauth.redirectSignIn);\n                        }\n                        return [2 /*return*/, credentials];\n                    case 5:\n                        err_2 = _b.sent();\n                        logger.debug(\"Error in cognito hosted auth response\", err_2);\n                        dispatchAuthEvent('signIn_failure', err_2, \"The OAuth response flow failed\");\n                        dispatchAuthEvent('cognitoHostedUI_failure', err_2, \"A failure occurred when returning to the Cognito Hosted UI\");\n                        throw err_2;\n                    case 6: return [2 /*return*/];\n                }\n            });\n        });\n    };\n    /**\n     * Compact version of credentials\n     * @param {Object} credentials\n     * @return {Object} - Credentials\n     */\n    AuthClass.prototype.essentialCredentials = function (credentials) {\n        return {\n            accessKeyId: credentials.accessKeyId,\n            sessionToken: credentials.sessionToken,\n            secretAccessKey: credentials.secretAccessKey,\n            identityId: credentials.identityId,\n            authenticated: credentials.authenticated\n        };\n    };\n    AuthClass.prototype.attributesToObject = function (attributes) {\n        var obj = {};\n        if (attributes) {\n            attributes.map(function (attribute) {\n                if (attribute.Value === 'true') {\n                    obj[attribute.Name] = true;\n                }\n                else if (attribute.Value === 'false') {\n                    obj[attribute.Name] = false;\n                }\n                else {\n                    obj[attribute.Name] = attribute.Value;\n                }\n            });\n        }\n        return obj;\n    };\n    AuthClass.prototype.createCognitoUser = function (username) {\n        var userData = {\n            Username: username,\n            Pool: this.userPool,\n        };\n        userData.Storage = this._storage;\n        var authenticationFlowType = this._config.authenticationFlowType;\n        var user = new amazon_cognito_identity_js_1.CognitoUser(userData);\n        if (authenticationFlowType) {\n            user.setAuthenticationFlowType(authenticationFlowType);\n        }\n        return user;\n    };\n    return AuthClass;\n}());\nexports.default = AuthClass;\n//# sourceMappingURL=Auth.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2F1dGgvbGliL0F1dGguanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2F1dGgvbGliL0F1dGguanM/NWE3MCJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbi8qXG4gKiBDb3B5cmlnaHQgMjAxNy0yMDE5IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoXG4gKiB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgaHR0cDovL2F3cy5hbWF6b24uY29tL2FwYWNoZTIuMC9cbiAqXG4gKiBvciBpbiB0aGUgXCJsaWNlbnNlXCIgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVMgT1JcbiAqIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG52YXIgX19hd2FpdGVyID0gKHRoaXMgJiYgdGhpcy5fX2F3YWl0ZXIpIHx8IGZ1bmN0aW9uICh0aGlzQXJnLCBfYXJndW1lbnRzLCBQLCBnZW5lcmF0b3IpIHtcbiAgICByZXR1cm4gbmV3IChQIHx8IChQID0gUHJvbWlzZSkpKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgZnVuY3Rpb24gZnVsZmlsbGVkKHZhbHVlKSB7IHRyeSB7IHN0ZXAoZ2VuZXJhdG9yLm5leHQodmFsdWUpKTsgfSBjYXRjaCAoZSkgeyByZWplY3QoZSk7IH0gfVxuICAgICAgICBmdW5jdGlvbiByZWplY3RlZCh2YWx1ZSkgeyB0cnkgeyBzdGVwKGdlbmVyYXRvcltcInRocm93XCJdKHZhbHVlKSk7IH0gY2F0Y2ggKGUpIHsgcmVqZWN0KGUpOyB9IH1cbiAgICAgICAgZnVuY3Rpb24gc3RlcChyZXN1bHQpIHsgcmVzdWx0LmRvbmUgPyByZXNvbHZlKHJlc3VsdC52YWx1ZSkgOiBuZXcgUChmdW5jdGlvbiAocmVzb2x2ZSkgeyByZXNvbHZlKHJlc3VsdC52YWx1ZSk7IH0pLnRoZW4oZnVsZmlsbGVkLCByZWplY3RlZCk7IH1cbiAgICAgICAgc3RlcCgoZ2VuZXJhdG9yID0gZ2VuZXJhdG9yLmFwcGx5KHRoaXNBcmcsIF9hcmd1bWVudHMgfHwgW10pKS5uZXh0KCkpO1xuICAgIH0pO1xufTtcbnZhciBfX2dlbmVyYXRvciA9ICh0aGlzICYmIHRoaXMuX19nZW5lcmF0b3IpIHx8IGZ1bmN0aW9uICh0aGlzQXJnLCBib2R5KSB7XG4gICAgdmFyIF8gPSB7IGxhYmVsOiAwLCBzZW50OiBmdW5jdGlvbigpIHsgaWYgKHRbMF0gJiAxKSB0aHJvdyB0WzFdOyByZXR1cm4gdFsxXTsgfSwgdHJ5czogW10sIG9wczogW10gfSwgZiwgeSwgdCwgZztcbiAgICByZXR1cm4gZyA9IHsgbmV4dDogdmVyYigwKSwgXCJ0aHJvd1wiOiB2ZXJiKDEpLCBcInJldHVyblwiOiB2ZXJiKDIpIH0sIHR5cGVvZiBTeW1ib2wgPT09IFwiZnVuY3Rpb25cIiAmJiAoZ1tTeW1ib2wuaXRlcmF0b3JdID0gZnVuY3Rpb24oKSB7IHJldHVybiB0aGlzOyB9KSwgZztcbiAgICBmdW5jdGlvbiB2ZXJiKG4pIHsgcmV0dXJuIGZ1bmN0aW9uICh2KSB7IHJldHVybiBzdGVwKFtuLCB2XSk7IH07IH1cbiAgICBmdW5jdGlvbiBzdGVwKG9wKSB7XG4gICAgICAgIGlmIChmKSB0aHJvdyBuZXcgVHlwZUVycm9yKFwiR2VuZXJhdG9yIGlzIGFscmVhZHkgZXhlY3V0aW5nLlwiKTtcbiAgICAgICAgd2hpbGUgKF8pIHRyeSB7XG4gICAgICAgICAgICBpZiAoZiA9IDEsIHkgJiYgKHQgPSBvcFswXSAmIDIgPyB5W1wicmV0dXJuXCJdIDogb3BbMF0gPyB5W1widGhyb3dcIl0gfHwgKCh0ID0geVtcInJldHVyblwiXSkgJiYgdC5jYWxsKHkpLCAwKSA6IHkubmV4dCkgJiYgISh0ID0gdC5jYWxsKHksIG9wWzFdKSkuZG9uZSkgcmV0dXJuIHQ7XG4gICAgICAgICAgICBpZiAoeSA9IDAsIHQpIG9wID0gW29wWzBdICYgMiwgdC52YWx1ZV07XG4gICAgICAgICAgICBzd2l0Y2ggKG9wWzBdKSB7XG4gICAgICAgICAgICAgICAgY2FzZSAwOiBjYXNlIDE6IHQgPSBvcDsgYnJlYWs7XG4gICAgICAgICAgICAgICAgY2FzZSA0OiBfLmxhYmVsKys7IHJldHVybiB7IHZhbHVlOiBvcFsxXSwgZG9uZTogZmFsc2UgfTtcbiAgICAgICAgICAgICAgICBjYXNlIDU6IF8ubGFiZWwrKzsgeSA9IG9wWzFdOyBvcCA9IFswXTsgY29udGludWU7XG4gICAgICAgICAgICAgICAgY2FzZSA3OiBvcCA9IF8ub3BzLnBvcCgpOyBfLnRyeXMucG9wKCk7IGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIGRlZmF1bHQ6XG4gICAgICAgICAgICAgICAgICAgIGlmICghKHQgPSBfLnRyeXMsIHQgPSB0Lmxlbmd0aCA+IDAgJiYgdFt0Lmxlbmd0aCAtIDFdKSAmJiAob3BbMF0gPT09IDYgfHwgb3BbMF0gPT09IDIpKSB7IF8gPSAwOyBjb250aW51ZTsgfVxuICAgICAgICAgICAgICAgICAgICBpZiAob3BbMF0gPT09IDMgJiYgKCF0IHx8IChvcFsxXSA+IHRbMF0gJiYgb3BbMV0gPCB0WzNdKSkpIHsgXy5sYWJlbCA9IG9wWzFdOyBicmVhazsgfVxuICAgICAgICAgICAgICAgICAgICBpZiAob3BbMF0gPT09IDYgJiYgXy5sYWJlbCA8IHRbMV0pIHsgXy5sYWJlbCA9IHRbMV07IHQgPSBvcDsgYnJlYWs7IH1cbiAgICAgICAgICAgICAgICAgICAgaWYgKHQgJiYgXy5sYWJlbCA8IHRbMl0pIHsgXy5sYWJlbCA9IHRbMl07IF8ub3BzLnB1c2gob3ApOyBicmVhazsgfVxuICAgICAgICAgICAgICAgICAgICBpZiAodFsyXSkgXy5vcHMucG9wKCk7XG4gICAgICAgICAgICAgICAgICAgIF8udHJ5cy5wb3AoKTsgY29udGludWU7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBvcCA9IGJvZHkuY2FsbCh0aGlzQXJnLCBfKTtcbiAgICAgICAgfSBjYXRjaCAoZSkgeyBvcCA9IFs2LCBlXTsgeSA9IDA7IH0gZmluYWxseSB7IGYgPSB0ID0gMDsgfVxuICAgICAgICBpZiAob3BbMF0gJiA1KSB0aHJvdyBvcFsxXTsgcmV0dXJuIHsgdmFsdWU6IG9wWzBdID8gb3BbMV0gOiB2b2lkIDAsIGRvbmU6IHRydWUgfTtcbiAgICB9XG59O1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xudmFyIHR5cGVzXzEgPSByZXF1aXJlKFwiLi90eXBlc1wiKTtcbnZhciBjb3JlXzEgPSByZXF1aXJlKFwiQGF3cy1hbXBsaWZ5L2NvcmVcIik7XG52YXIgYW1hem9uX2NvZ25pdG9faWRlbnRpdHlfanNfMSA9IHJlcXVpcmUoXCJhbWF6b24tY29nbml0by1pZGVudGl0eS1qc1wiKTtcbnZhciB1cmxfMSA9IHJlcXVpcmUoXCJ1cmxcIik7XG52YXIgT0F1dGhfMSA9IHJlcXVpcmUoXCIuL09BdXRoL09BdXRoXCIpO1xudmFyIHVybExpc3RlbmVyXzEgPSByZXF1aXJlKFwiLi91cmxMaXN0ZW5lclwiKTtcbnZhciBsb2dnZXIgPSBuZXcgY29yZV8xLkNvbnNvbGVMb2dnZXIoJ0F1dGhDbGFzcycpO1xudmFyIFVTRVJfQURNSU5fU0NPUEUgPSAnYXdzLmNvZ25pdG8uc2lnbmluLnVzZXIuYWRtaW4nO1xudmFyIEFNUExJRllfU1lNQk9MID0gKCh0eXBlb2YgU3ltYm9sICE9PSAndW5kZWZpbmVkJyAmJiB0eXBlb2YgU3ltYm9sLmZvciA9PT0gJ2Z1bmN0aW9uJykgP1xuICAgIFN5bWJvbC5mb3IoJ2FtcGxpZnlfZGVmYXVsdCcpIDogJ0BAYW1wbGlmeV9kZWZhdWx0Jyk7XG52YXIgZGlzcGF0Y2hBdXRoRXZlbnQgPSBmdW5jdGlvbiAoZXZlbnQsIGRhdGEsIG1lc3NhZ2UpIHtcbiAgICBjb3JlXzEuSHViLmRpc3BhdGNoKCdhdXRoJywgeyBldmVudDogZXZlbnQsIGRhdGE6IGRhdGEsIG1lc3NhZ2U6IG1lc3NhZ2UgfSwgJ0F1dGgnLCBBTVBMSUZZX1NZTUJPTCk7XG59O1xudmFyIENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXI7XG4oZnVuY3Rpb24gKENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXIpIHtcbiAgICBDb2duaXRvSG9zdGVkVUlJZGVudGl0eVByb3ZpZGVyW1wiQ29nbml0b1wiXSA9IFwiQ09HTklUT1wiO1xuICAgIENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXJbXCJHb29nbGVcIl0gPSBcIkdvb2dsZVwiO1xuICAgIENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXJbXCJGYWNlYm9va1wiXSA9IFwiRmFjZWJvb2tcIjtcbiAgICBDb2duaXRvSG9zdGVkVUlJZGVudGl0eVByb3ZpZGVyW1wiQW1hem9uXCJdID0gXCJMb2dpbldpdGhBbWF6b25cIjtcbn0pKENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXIgPSBleHBvcnRzLkNvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXIgfHwgKGV4cG9ydHMuQ29nbml0b0hvc3RlZFVJSWRlbnRpdHlQcm92aWRlciA9IHt9KSk7XG4vKipcbiogUHJvdmlkZSBhdXRoZW50aWNhdGlvbiBzdGVwc1xuKi9cbnZhciBBdXRoQ2xhc3MgPSAvKiogQGNsYXNzICovIChmdW5jdGlvbiAoKSB7XG4gICAgLyoqXG4gICAgICogSW5pdGlhbGl6ZSBBdXRoIHdpdGggQVdTIGNvbmZpZ3VyYXRpb25zXG4gICAgICogQHBhcmFtIHtPYmplY3R9IGNvbmZpZyAtIENvbmZpZ3VyYXRpb24gb2YgdGhlIEF1dGhcbiAgICAgKi9cbiAgICBmdW5jdGlvbiBBdXRoQ2xhc3MoY29uZmlnKSB7XG4gICAgICAgIHZhciBfdGhpcyA9IHRoaXM7XG4gICAgICAgIHRoaXMudXNlclBvb2wgPSBudWxsO1xuICAgICAgICB0aGlzLnVzZXIgPSBudWxsO1xuICAgICAgICB0aGlzLmNvbmZpZ3VyZShjb25maWcpO1xuICAgICAgICB0aGlzLmN1cnJlbnRVc2VyQ3JlZGVudGlhbHMgPSB0aGlzLmN1cnJlbnRVc2VyQ3JlZGVudGlhbHMuYmluZCh0aGlzKTtcbiAgICAgICAgaWYgKGNvcmVfMS5BV1MuY29uZmlnKSB7XG4gICAgICAgICAgICBjb3JlXzEuQVdTLmNvbmZpZy51cGRhdGUoeyBjdXN0b21Vc2VyQWdlbnQ6IGNvcmVfMS5Db25zdGFudHMudXNlckFnZW50IH0pO1xuICAgICAgICB9XG4gICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgbG9nZ2VyLndhcm4oJ05vIEFXUy5jb25maWcnKTtcbiAgICAgICAgfVxuICAgICAgICBjb3JlXzEuSHViLmxpc3RlbignYXV0aCcsIGZ1bmN0aW9uIChfYSkge1xuICAgICAgICAgICAgdmFyIHBheWxvYWQgPSBfYS5wYXlsb2FkO1xuICAgICAgICAgICAgdmFyIGV2ZW50ID0gcGF5bG9hZC5ldmVudDtcbiAgICAgICAgICAgIHN3aXRjaCAoZXZlbnQpIHtcbiAgICAgICAgICAgICAgICBjYXNlICdzaWduSW4nOlxuICAgICAgICAgICAgICAgICAgICBfdGhpcy5fc3RvcmFnZS5zZXRJdGVtKCdhbXBsaWZ5LXNpZ25pbi13aXRoLWhvc3RlZFVJJywgJ2ZhbHNlJyk7XG4gICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgIGNhc2UgJ3NpZ25PdXQnOlxuICAgICAgICAgICAgICAgICAgICBfdGhpcy5fc3RvcmFnZS5yZW1vdmVJdGVtKCdhbXBsaWZ5LXNpZ25pbi13aXRoLWhvc3RlZFVJJyk7XG4gICAgICAgICAgICAgICAgICAgIGJyZWFrO1xuICAgICAgICAgICAgICAgIGNhc2UgJ2NvZ25pdG9Ib3N0ZWRVSSc6XG4gICAgICAgICAgICAgICAgICAgIF90aGlzLl9zdG9yYWdlLnNldEl0ZW0oJ2FtcGxpZnktc2lnbmluLXdpdGgtaG9zdGVkVUknLCAndHJ1ZScpO1xuICAgICAgICAgICAgICAgICAgICBicmVhaztcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSk7XG4gICAgfVxuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuZ2V0TW9kdWxlTmFtZSA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgcmV0dXJuICdBdXRoJztcbiAgICB9O1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuY29uZmlndXJlID0gZnVuY3Rpb24gKGNvbmZpZykge1xuICAgICAgICB2YXIgX3RoaXMgPSB0aGlzO1xuICAgICAgICBpZiAoIWNvbmZpZylcbiAgICAgICAgICAgIHJldHVybiB0aGlzLl9jb25maWcgfHwge307XG4gICAgICAgIGxvZ2dlci5kZWJ1ZygnY29uZmlndXJlIEF1dGgnKTtcbiAgICAgICAgdmFyIGNvbmYgPSBPYmplY3QuYXNzaWduKHt9LCB0aGlzLl9jb25maWcsIGNvcmVfMS5QYXJzZXIucGFyc2VNb2JpbGVodWJDb25maWcoY29uZmlnKS5BdXRoLCBjb25maWcpO1xuICAgICAgICB0aGlzLl9jb25maWcgPSBjb25mO1xuICAgICAgICB2YXIgX2EgPSB0aGlzLl9jb25maWcsIHVzZXJQb29sSWQgPSBfYS51c2VyUG9vbElkLCB1c2VyUG9vbFdlYkNsaWVudElkID0gX2EudXNlclBvb2xXZWJDbGllbnRJZCwgY29va2llU3RvcmFnZSA9IF9hLmNvb2tpZVN0b3JhZ2UsIG9hdXRoID0gX2Eub2F1dGgsIHJlZ2lvbiA9IF9hLnJlZ2lvbiwgaWRlbnRpdHlQb29sSWQgPSBfYS5pZGVudGl0eVBvb2xJZCwgbWFuZGF0b3J5U2lnbkluID0gX2EubWFuZGF0b3J5U2lnbkluLCByZWZyZXNoSGFuZGxlcnMgPSBfYS5yZWZyZXNoSGFuZGxlcnMsIGlkZW50aXR5UG9vbFJlZ2lvbiA9IF9hLmlkZW50aXR5UG9vbFJlZ2lvbjtcbiAgICAgICAgaWYgKCF0aGlzLl9jb25maWcuc3RvcmFnZSkge1xuICAgICAgICAgICAgLy8gYmFja3dhcmQgY29tcGF0YmlsaXR5XG4gICAgICAgICAgICBpZiAoY29va2llU3RvcmFnZSlcbiAgICAgICAgICAgICAgICB0aGlzLl9zdG9yYWdlID0gbmV3IGFtYXpvbl9jb2duaXRvX2lkZW50aXR5X2pzXzEuQ29va2llU3RvcmFnZShjb29raWVTdG9yYWdlKTtcbiAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgIHRoaXMuX3N0b3JhZ2UgPSBuZXcgY29yZV8xLlN0b3JhZ2VIZWxwZXIoKS5nZXRTdG9yYWdlKCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICB0aGlzLl9zdG9yYWdlID0gdGhpcy5fY29uZmlnLnN0b3JhZ2U7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5fc3RvcmFnZVN5bmMgPSBQcm9taXNlLnJlc29sdmUoKTtcbiAgICAgICAgaWYgKHR5cGVvZiB0aGlzLl9zdG9yYWdlWydzeW5jJ10gPT09ICdmdW5jdGlvbicpIHtcbiAgICAgICAgICAgIHRoaXMuX3N0b3JhZ2VTeW5jID0gdGhpcy5fc3RvcmFnZVsnc3luYyddKCk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKHVzZXJQb29sSWQpIHtcbiAgICAgICAgICAgIHZhciB1c2VyUG9vbERhdGEgPSB7XG4gICAgICAgICAgICAgICAgVXNlclBvb2xJZDogdXNlclBvb2xJZCxcbiAgICAgICAgICAgICAgICBDbGllbnRJZDogdXNlclBvb2xXZWJDbGllbnRJZCxcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICB1c2VyUG9vbERhdGEuU3RvcmFnZSA9IHRoaXMuX3N0b3JhZ2U7XG4gICAgICAgICAgICB0aGlzLnVzZXJQb29sID0gbmV3IGFtYXpvbl9jb2duaXRvX2lkZW50aXR5X2pzXzEuQ29nbml0b1VzZXJQb29sKHVzZXJQb29sRGF0YSk7XG4gICAgICAgIH1cbiAgICAgICAgY29yZV8xLkNyZWRlbnRpYWxzLmNvbmZpZ3VyZSh7XG4gICAgICAgICAgICBtYW5kYXRvcnlTaWduSW46IG1hbmRhdG9yeVNpZ25JbixcbiAgICAgICAgICAgIHJlZ2lvbjogaWRlbnRpdHlQb29sUmVnaW9uIHx8IHJlZ2lvbixcbiAgICAgICAgICAgIHVzZXJQb29sSWQ6IHVzZXJQb29sSWQsXG4gICAgICAgICAgICBpZGVudGl0eVBvb2xJZDogaWRlbnRpdHlQb29sSWQsXG4gICAgICAgICAgICByZWZyZXNoSGFuZGxlcnM6IHJlZnJlc2hIYW5kbGVycyxcbiAgICAgICAgICAgIHN0b3JhZ2U6IHRoaXMuX3N0b3JhZ2VcbiAgICAgICAgfSk7XG4gICAgICAgIC8vIGluaXRpYWlsaXplIGNvZ25pdG9hdXRoIGNsaWVudCBpZiBob3N0ZWQgdWkgb3B0aW9ucyBwcm92aWRlZFxuICAgICAgICAvLyB0byBrZWVwIGJhY2t3YXJkIGNvbXBhdGliaWxpdHk6XG4gICAgICAgIHZhciBjb2duaXRvSG9zdGVkVUlDb25maWcgPSBvYXV0aCA/ICh0eXBlc18xLmlzQ29nbml0b0hvc3RlZE9wdHModGhpcy5fY29uZmlnLm9hdXRoKVxuICAgICAgICAgICAgPyBvYXV0aCA6IG9hdXRoLmF3c0NvZ25pdG8pXG4gICAgICAgICAgICA6IHVuZGVmaW5lZDtcbiAgICAgICAgaWYgKGNvZ25pdG9Ib3N0ZWRVSUNvbmZpZykge1xuICAgICAgICAgICAgdmFyIGNvZ25pdG9BdXRoUGFyYW1zID0gT2JqZWN0LmFzc2lnbih7XG4gICAgICAgICAgICAgICAgY29nbml0b0NsaWVudElkOiB1c2VyUG9vbFdlYkNsaWVudElkLFxuICAgICAgICAgICAgICAgIFVzZXJQb29sSWQ6IHVzZXJQb29sSWQsXG4gICAgICAgICAgICAgICAgZG9tYWluOiBjb2duaXRvSG9zdGVkVUlDb25maWdbJ2RvbWFpbiddLFxuICAgICAgICAgICAgICAgIHNjb3BlczogY29nbml0b0hvc3RlZFVJQ29uZmlnWydzY29wZSddLFxuICAgICAgICAgICAgICAgIHJlZGlyZWN0U2lnbkluOiBjb2duaXRvSG9zdGVkVUlDb25maWdbJ3JlZGlyZWN0U2lnbkluJ10sXG4gICAgICAgICAgICAgICAgcmVkaXJlY3RTaWduT3V0OiBjb2duaXRvSG9zdGVkVUlDb25maWdbJ3JlZGlyZWN0U2lnbk91dCddLFxuICAgICAgICAgICAgICAgIHJlc3BvbnNlVHlwZTogY29nbml0b0hvc3RlZFVJQ29uZmlnWydyZXNwb25zZVR5cGUnXSxcbiAgICAgICAgICAgICAgICBTdG9yYWdlOiB0aGlzLl9zdG9yYWdlLFxuICAgICAgICAgICAgICAgIHVybE9wZW5lcjogY29nbml0b0hvc3RlZFVJQ29uZmlnWyd1cmxPcGVuZXInXVxuICAgICAgICAgICAgfSwgY29nbml0b0hvc3RlZFVJQ29uZmlnWydvcHRpb25zJ10pO1xuICAgICAgICAgICAgdGhpcy5fb0F1dGhIYW5kbGVyID0gbmV3IE9BdXRoXzEuZGVmYXVsdCh7XG4gICAgICAgICAgICAgICAgc2NvcGVzOiBjb2duaXRvQXV0aFBhcmFtcy5zY29wZXMsXG4gICAgICAgICAgICAgICAgY29uZmlnOiBjb2duaXRvQXV0aFBhcmFtcyxcbiAgICAgICAgICAgICAgICBjb2duaXRvQ2xpZW50SWQ6IGNvZ25pdG9BdXRoUGFyYW1zLmNvZ25pdG9DbGllbnRJZFxuICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAvLyAqKk5PVEUqKiAtIFJlbW92ZSB0aGlzIGluIGEgZnV0dXJlIG1ham9yIHJlbGVhc2UgYXMgaXQgaXMgYSBicmVha2luZyBjaGFuZ2VcbiAgICAgICAgICAgIHVybExpc3RlbmVyXzEuZGVmYXVsdChmdW5jdGlvbiAoX2EpIHtcbiAgICAgICAgICAgICAgICB2YXIgdXJsID0gX2EudXJsO1xuICAgICAgICAgICAgICAgIF90aGlzLl9oYW5kbGVBdXRoUmVzcG9uc2UodXJsKTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9XG4gICAgICAgIGRpc3BhdGNoQXV0aEV2ZW50KCdjb25maWd1cmVkJywgbnVsbCwgXCJUaGUgQXV0aCBjYXRlZ29yeSBoYXMgYmVlbiBjb25maWd1cmVkIHN1Y2Nlc3NmdWxseVwiKTtcbiAgICAgICAgcmV0dXJuIHRoaXMuX2NvbmZpZztcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIFNpZ24gdXAgd2l0aCB1c2VybmFtZSwgcGFzc3dvcmQgYW5kIG90aGVyIGF0dHJidXRlcyBsaWtlIHBob25lLCBlbWFpbFxuICAgICAqIEBwYXJhbSB7U3RyaW5nIHwgb2JqZWN0fSBwYXJhbXMgLSBUaGUgdXNlciBhdHRpcmJ1dGVzIHVzZWQgZm9yIHNpZ25pblxuICAgICAqIEBwYXJhbSB7U3RyaW5nW119IHJlc3RPZkF0dHJzIC0gZm9yIHRoZSBiYWNrd2FyZCBjb21wYXRhYmlsaXR5XG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyBjYWxsYmFjayBkYXRhIGlmIHN1Y2Nlc3NcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLnNpZ25VcCA9IGZ1bmN0aW9uIChwYXJhbXMpIHtcbiAgICAgICAgdmFyIF90aGlzID0gdGhpcztcbiAgICAgICAgdmFyIHJlc3RPZkF0dHJzID0gW107XG4gICAgICAgIGZvciAodmFyIF9pID0gMTsgX2kgPCBhcmd1bWVudHMubGVuZ3RoOyBfaSsrKSB7XG4gICAgICAgICAgICByZXN0T2ZBdHRyc1tfaSAtIDFdID0gYXJndW1lbnRzW19pXTtcbiAgICAgICAgfVxuICAgICAgICBpZiAoIXRoaXMudXNlclBvb2wpIHtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnTm8gdXNlclBvb2wnKTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgdXNlcm5hbWUgPSBudWxsO1xuICAgICAgICB2YXIgcGFzc3dvcmQgPSBudWxsO1xuICAgICAgICB2YXIgYXR0cmlidXRlcyA9IFtdO1xuICAgICAgICB2YXIgdmFsaWRhdGlvbkRhdGEgPSBudWxsO1xuICAgICAgICBpZiAocGFyYW1zICYmIHR5cGVvZiBwYXJhbXMgPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgICB1c2VybmFtZSA9IHBhcmFtcztcbiAgICAgICAgICAgIHBhc3N3b3JkID0gcmVzdE9mQXR0cnMgPyByZXN0T2ZBdHRyc1swXSA6IG51bGw7XG4gICAgICAgICAgICB2YXIgZW1haWwgPSByZXN0T2ZBdHRycyA/IHJlc3RPZkF0dHJzWzFdIDogbnVsbDtcbiAgICAgICAgICAgIHZhciBwaG9uZV9udW1iZXIgPSByZXN0T2ZBdHRycyA/IHJlc3RPZkF0dHJzWzJdIDogbnVsbDtcbiAgICAgICAgICAgIGlmIChlbWFpbClcbiAgICAgICAgICAgICAgICBhdHRyaWJ1dGVzLnB1c2goeyBOYW1lOiAnZW1haWwnLCBWYWx1ZTogZW1haWwgfSk7XG4gICAgICAgICAgICBpZiAocGhvbmVfbnVtYmVyKVxuICAgICAgICAgICAgICAgIGF0dHJpYnV0ZXMucHVzaCh7IE5hbWU6ICdwaG9uZV9udW1iZXInLCBWYWx1ZTogcGhvbmVfbnVtYmVyIH0pO1xuICAgICAgICB9XG4gICAgICAgIGVsc2UgaWYgKHBhcmFtcyAmJiB0eXBlb2YgcGFyYW1zID09PSAnb2JqZWN0Jykge1xuICAgICAgICAgICAgdXNlcm5hbWUgPSBwYXJhbXNbJ3VzZXJuYW1lJ107XG4gICAgICAgICAgICBwYXNzd29yZCA9IHBhcmFtc1sncGFzc3dvcmQnXTtcbiAgICAgICAgICAgIHZhciBhdHRyc18xID0gcGFyYW1zWydhdHRyaWJ1dGVzJ107XG4gICAgICAgICAgICBpZiAoYXR0cnNfMSkge1xuICAgICAgICAgICAgICAgIE9iamVjdC5rZXlzKGF0dHJzXzEpLm1hcChmdW5jdGlvbiAoa2V5KSB7XG4gICAgICAgICAgICAgICAgICAgIHZhciBlbGUgPSB7IE5hbWU6IGtleSwgVmFsdWU6IGF0dHJzXzFba2V5XSB9O1xuICAgICAgICAgICAgICAgICAgICBhdHRyaWJ1dGVzLnB1c2goZWxlKTtcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHZhbGlkYXRpb25EYXRhID0gcGFyYW1zWyd2YWxpZGF0aW9uRGF0YSddIHx8IG51bGw7XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ1RoZSBmaXJzdCBwYXJhbWV0ZXIgc2hvdWxkIGVpdGhlciBiZSBub24tbnVsbCBzdHJpbmcgb3Igb2JqZWN0Jyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCF1c2VybmFtZSkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdVc2VybmFtZSBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAoIXBhc3N3b3JkKSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ1Bhc3N3b3JkIGNhbm5vdCBiZSBlbXB0eScpO1xuICAgICAgICB9XG4gICAgICAgIGxvZ2dlci5kZWJ1Zygnc2lnblVwIGF0dHJzOicsIGF0dHJpYnV0ZXMpO1xuICAgICAgICBsb2dnZXIuZGVidWcoJ3NpZ25VcCB2YWxpZGF0aW9uIGRhdGE6JywgdmFsaWRhdGlvbkRhdGEpO1xuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlc29sdmUsIHJlamVjdCkge1xuICAgICAgICAgICAgX3RoaXMudXNlclBvb2wuc2lnblVwKHVzZXJuYW1lLCBwYXNzd29yZCwgYXR0cmlidXRlcywgdmFsaWRhdGlvbkRhdGEsIGZ1bmN0aW9uIChlcnIsIGRhdGEpIHtcbiAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgIGRpc3BhdGNoQXV0aEV2ZW50KCdzaWduVXBfZmFpbHVyZScsIGVyciwgdXNlcm5hbWUgKyBcIiBmYWlsZWQgdG8gc2lnbnVwXCIpO1xuICAgICAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIGRpc3BhdGNoQXV0aEV2ZW50KCdzaWduVXAnLCBkYXRhLCB1c2VybmFtZSArIFwiIGhhcyBzaWduZWQgdXAgc3VjY2Vzc2Z1bGx5XCIpO1xuICAgICAgICAgICAgICAgICAgICByZXNvbHZlKGRhdGEpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIFNlbmQgdGhlIHZlcmZpY2F0aW9uIGNvZGUgdG8gY29uZmlybSBzaWduIHVwXG4gICAgICogQHBhcmFtIHtTdHJpbmd9IHVzZXJuYW1lIC0gVGhlIHVzZXJuYW1lIHRvIGJlIGNvbmZpcm1lZFxuICAgICAqIEBwYXJhbSB7U3RyaW5nfSBjb2RlIC0gVGhlIHZlcmlmaWNhdGlvbiBjb2RlXG4gICAgICogQHBhcmFtIHtDb25maXJtU2lnblVwT3B0aW9uc30gb3B0aW9ucyAtIG90aGVyIG9wdGlvbnMgZm9yIGNvbmZpcm0gc2lnbnVwXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyBjYWxsYmFjayBkYXRhIGlmIHN1Y2Nlc3NcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmNvbmZpcm1TaWduVXAgPSBmdW5jdGlvbiAodXNlcm5hbWUsIGNvZGUsIG9wdGlvbnMpIHtcbiAgICAgICAgaWYgKCF0aGlzLnVzZXJQb29sKSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ05vIHVzZXJQb29sJyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCF1c2VybmFtZSkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdVc2VybmFtZSBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAoIWNvZGUpIHtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnQ29kZSBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgdXNlciA9IHRoaXMuY3JlYXRlQ29nbml0b1VzZXIodXNlcm5hbWUpO1xuICAgICAgICB2YXIgZm9yY2VBbGlhc0NyZWF0aW9uID0gb3B0aW9ucyAmJiB0eXBlb2Ygb3B0aW9ucy5mb3JjZUFsaWFzQ3JlYXRpb24gPT09ICdib29sZWFuJ1xuICAgICAgICAgICAgPyBvcHRpb25zLmZvcmNlQWxpYXNDcmVhdGlvbiA6IHRydWU7XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiAocmVzb2x2ZSwgcmVqZWN0KSB7XG4gICAgICAgICAgICB1c2VyLmNvbmZpcm1SZWdpc3RyYXRpb24oY29kZSwgZm9yY2VBbGlhc0NyZWF0aW9uLCBmdW5jdGlvbiAoZXJyLCBkYXRhKSB7XG4gICAgICAgICAgICAgICAgaWYgKGVycikge1xuICAgICAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUoZGF0YSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogUmVzZW5kIHRoZSB2ZXJpZmljYXRpb24gY29kZVxuICAgICAqIEBwYXJhbSB7U3RyaW5nfSB1c2VybmFtZSAtIFRoZSB1c2VybmFtZSB0byBiZSBjb25maXJtZWRcbiAgICAgKiBAcmV0dXJuIC0gQSBwcm9taXNlIHJlc29sdmVzIGRhdGEgaWYgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUucmVzZW5kU2lnblVwID0gZnVuY3Rpb24gKHVzZXJuYW1lKSB7XG4gICAgICAgIGlmICghdGhpcy51c2VyUG9vbCkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdObyB1c2VyUG9vbCcpO1xuICAgICAgICB9XG4gICAgICAgIGlmICghdXNlcm5hbWUpIHtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnVXNlcm5hbWUgY2Fubm90IGJlIGVtcHR5Jyk7XG4gICAgICAgIH1cbiAgICAgICAgdmFyIHVzZXIgPSB0aGlzLmNyZWF0ZUNvZ25pdG9Vc2VyKHVzZXJuYW1lKTtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIHVzZXIucmVzZW5kQ29uZmlybWF0aW9uQ29kZShmdW5jdGlvbiAoZXJyLCBkYXRhKSB7XG4gICAgICAgICAgICAgICAgaWYgKGVycikge1xuICAgICAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUoZGF0YSk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogU2lnbiBpblxuICAgICAqIEBwYXJhbSB7U3RyaW5nIHwgU2lnbkluT3B0c30gdXNlcm5hbWVPclNpZ25Jbk9wdHMgLSBUaGUgdXNlcm5hbWUgdG8gYmUgc2lnbmVkIGluIG9yIHRoZSBzaWduIGluIG9wdGlvbnNcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gcGFzc3dvcmQgLSBUaGUgcGFzc3dvcmQgb2YgdGhlIHVzZXJuYW1lXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyB0aGUgQ29nbml0b1VzZXJcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLnNpZ25JbiA9IGZ1bmN0aW9uICh1c2VybmFtZU9yU2lnbkluT3B0cywgcHcpIHtcbiAgICAgICAgaWYgKCF0aGlzLnVzZXJQb29sKSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ05vIHVzZXJQb29sJyk7XG4gICAgICAgIH1cbiAgICAgICAgdmFyIHVzZXJuYW1lID0gbnVsbDtcbiAgICAgICAgdmFyIHBhc3N3b3JkID0gbnVsbDtcbiAgICAgICAgdmFyIHZhbGlkYXRpb25EYXRhID0ge307XG4gICAgICAgIC8vIGZvciBiYWNrd2FyZCBjb21wYXRpYmlsaXR5XG4gICAgICAgIGlmICh0eXBlb2YgdXNlcm5hbWVPclNpZ25Jbk9wdHMgPT09ICdzdHJpbmcnKSB7XG4gICAgICAgICAgICB1c2VybmFtZSA9IHVzZXJuYW1lT3JTaWduSW5PcHRzO1xuICAgICAgICAgICAgcGFzc3dvcmQgPSBwdztcbiAgICAgICAgfVxuICAgICAgICBlbHNlIGlmICh0eXBlc18xLmlzVXNlcm5hbWVQYXNzd29yZE9wdHModXNlcm5hbWVPclNpZ25Jbk9wdHMpKSB7XG4gICAgICAgICAgICBpZiAodHlwZW9mIHB3ICE9PSAndW5kZWZpbmVkJykge1xuICAgICAgICAgICAgICAgIGxvZ2dlci53YXJuKCdUaGUgcGFzc3dvcmQgc2hvdWxkIGJlIGRlZmluZWQgdW5kZXIgdGhlIGZpcnN0IHBhcmFtZXRlciBvYmplY3QhJyk7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICB1c2VybmFtZSA9IHVzZXJuYW1lT3JTaWduSW5PcHRzLnVzZXJuYW1lO1xuICAgICAgICAgICAgcGFzc3dvcmQgPSB1c2VybmFtZU9yU2lnbkluT3B0cy5wYXNzd29yZDtcbiAgICAgICAgICAgIHZhbGlkYXRpb25EYXRhID0gdXNlcm5hbWVPclNpZ25Jbk9wdHMudmFsaWRhdGlvbkRhdGE7XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QobmV3IEVycm9yKCdUaGUgdXNlcm5hbWUgc2hvdWxkIGVpdGhlciBiZSBhIHN0cmluZyBvciBvbmUgb2YgdGhlIHNpZ24gaW4gdHlwZXMnKSk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCF1c2VybmFtZSkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdVc2VybmFtZSBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgYXV0aERldGFpbHMgPSBuZXcgYW1hem9uX2NvZ25pdG9faWRlbnRpdHlfanNfMS5BdXRoZW50aWNhdGlvbkRldGFpbHMoe1xuICAgICAgICAgICAgVXNlcm5hbWU6IHVzZXJuYW1lLFxuICAgICAgICAgICAgUGFzc3dvcmQ6IHBhc3N3b3JkLFxuICAgICAgICAgICAgVmFsaWRhdGlvbkRhdGE6IHZhbGlkYXRpb25EYXRhXG4gICAgICAgIH0pO1xuICAgICAgICBpZiAocGFzc3dvcmQpIHtcbiAgICAgICAgICAgIHJldHVybiB0aGlzLnNpZ25JbldpdGhQYXNzd29yZChhdXRoRGV0YWlscyk7XG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5zaWduSW5XaXRob3V0UGFzc3dvcmQoYXV0aERldGFpbHMpO1xuICAgICAgICB9XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBSZXR1cm4gYW4gb2JqZWN0IHdpdGggdGhlIGF1dGhlbnRpY2F0aW9uIGNhbGxiYWNrc1xuICAgICAqIEBwYXJhbSB7Q29nbml0b1VzZXJ9IHVzZXIgLSB0aGUgY29nbml0byB1c2VyIG9iamVjdFxuICAgICAqIEBwYXJhbSB7fSByZXNvbHZlIC0gZnVuY3Rpb24gY2FsbGVkIHdoZW4gcmVzb2x2aW5nIHRoZSBjdXJyZW50IHN0ZXBcbiAgICAgKiBAcGFyYW0ge30gcmVqZWN0IC0gZnVuY3Rpb24gY2FsbGVkIHdoZW4gcmVqZWN0aW5nIHRoZSBjdXJyZW50IHN0ZXBcbiAgICAgKiBAcmV0dXJuIC0gYW4gb2JqZWN0IHdpdGggdGhlIGNhbGxiYWNrIG1ldGhvZHMgZm9yIHVzZXIgYXV0aGVudGljYXRpb25cbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmF1dGhDYWxsYmFja3MgPSBmdW5jdGlvbiAodXNlciwgcmVzb2x2ZSwgcmVqZWN0KSB7XG4gICAgICAgIHZhciBfdGhpcyA9IHRoaXM7XG4gICAgICAgIHZhciB0aGF0ID0gdGhpcztcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG9uU3VjY2VzczogZnVuY3Rpb24gKHNlc3Npb24pIHsgcmV0dXJuIF9fYXdhaXRlcihfdGhpcywgdm9pZCAwLCB2b2lkIDAsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICB2YXIgY3JlZCwgZV8xLCBjdXJyZW50VXNlciwgZV8yO1xuICAgICAgICAgICAgICAgIHJldHVybiBfX2dlbmVyYXRvcih0aGlzLCBmdW5jdGlvbiAoX2EpIHtcbiAgICAgICAgICAgICAgICAgICAgc3dpdGNoIChfYS5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAwOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZyhzZXNzaW9uKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBkZWxldGUgKHVzZXJbJ2NoYWxsZW5nZU5hbWUnXSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZGVsZXRlICh1c2VyWydjaGFsbGVuZ2VQYXJhbSddKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBfYS5sYWJlbCA9IDE7XG4gICAgICAgICAgICAgICAgICAgICAgICBjYXNlIDE6XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgX2EudHJ5cy5wdXNoKFsxLCA0LCA1LCA5XSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgY29yZV8xLkNyZWRlbnRpYWxzLmNsZWFyKCldO1xuICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAyOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzQgLyp5aWVsZCovLCBjb3JlXzEuQ3JlZGVudGlhbHMuc2V0KHNlc3Npb24sICdzZXNzaW9uJyldO1xuICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAzOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNyZWQgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdzdWNjZWVkIHRvIGdldCBjb2duaXRvIGNyZWRlbnRpYWxzJywgY3JlZCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgOV07XG4gICAgICAgICAgICAgICAgICAgICAgICBjYXNlIDQ6XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZV8xID0gX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnY2Fubm90IGdldCBjb2duaXRvIGNyZWRlbnRpYWxzJywgZV8xKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzMgLypicmVhayovLCA5XTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNTpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBfYS50cnlzLnB1c2goWzUsIDcsICwgOF0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuY3VycmVudFVzZXJQb29sVXNlcigpXTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNjpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjdXJyZW50VXNlciA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGF0LnVzZXIgPSBjdXJyZW50VXNlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBkaXNwYXRjaEF1dGhFdmVudCgnc2lnbkluJywgY3VycmVudFVzZXIsIFwiQSB1c2VyIFwiICsgdXNlci5nZXRVc2VybmFtZSgpICsgXCIgaGFzIGJlZW4gc2lnbmVkIGluXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlc29sdmUoY3VycmVudFVzZXIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDhdO1xuICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSA3OlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVfMiA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZXJyb3IoJ0ZhaWxlZCB0byBnZXQgdGhlIHNpZ25lZCBpbiB1c2VyJywgZV8yKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZWplY3QoZV8yKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzMgLypicmVhayovLCA4XTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgODogcmV0dXJuIFs3IC8qZW5kZmluYWxseSovXTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgOTogcmV0dXJuIFsyIC8qcmV0dXJuKi9dO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9KTsgfSxcbiAgICAgICAgICAgIG9uRmFpbHVyZTogZnVuY3Rpb24gKGVycikge1xuICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnc2lnbkluIGZhaWx1cmUnLCBlcnIpO1xuICAgICAgICAgICAgICAgIGRpc3BhdGNoQXV0aEV2ZW50KCdzaWduSW5fZmFpbHVyZScsIGVyciwgdXNlci5nZXRVc2VybmFtZSgpICsgXCIgZmFpbGVkIHRvIHNpZ25pblwiKTtcbiAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBjdXN0b21DaGFsbGVuZ2U6IGZ1bmN0aW9uIChjaGFsbGVuZ2VQYXJhbSkge1xuICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnc2lnbkluIGN1c3RvbSBjaGFsbGVuZ2UgYW5zd2VyIHJlcXVpcmVkJyk7XG4gICAgICAgICAgICAgICAgdXNlclsnY2hhbGxlbmdlTmFtZSddID0gJ0NVU1RPTV9DSEFMTEVOR0UnO1xuICAgICAgICAgICAgICAgIHVzZXJbJ2NoYWxsZW5nZVBhcmFtJ10gPSBjaGFsbGVuZ2VQYXJhbTtcbiAgICAgICAgICAgICAgICByZXNvbHZlKHVzZXIpO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIG1mYVJlcXVpcmVkOiBmdW5jdGlvbiAoY2hhbGxlbmdlTmFtZSwgY2hhbGxlbmdlUGFyYW0pIHtcbiAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ3NpZ25JbiBNRkEgcmVxdWlyZWQnKTtcbiAgICAgICAgICAgICAgICB1c2VyWydjaGFsbGVuZ2VOYW1lJ10gPSBjaGFsbGVuZ2VOYW1lO1xuICAgICAgICAgICAgICAgIHVzZXJbJ2NoYWxsZW5nZVBhcmFtJ10gPSBjaGFsbGVuZ2VQYXJhbTtcbiAgICAgICAgICAgICAgICByZXNvbHZlKHVzZXIpO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIG1mYVNldHVwOiBmdW5jdGlvbiAoY2hhbGxlbmdlTmFtZSwgY2hhbGxlbmdlUGFyYW0pIHtcbiAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ3NpZ25JbiBtZmEgc2V0dXAnLCBjaGFsbGVuZ2VOYW1lKTtcbiAgICAgICAgICAgICAgICB1c2VyWydjaGFsbGVuZ2VOYW1lJ10gPSBjaGFsbGVuZ2VOYW1lO1xuICAgICAgICAgICAgICAgIHVzZXJbJ2NoYWxsZW5nZVBhcmFtJ10gPSBjaGFsbGVuZ2VQYXJhbTtcbiAgICAgICAgICAgICAgICByZXNvbHZlKHVzZXIpO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIG5ld1Bhc3N3b3JkUmVxdWlyZWQ6IGZ1bmN0aW9uICh1c2VyQXR0cmlidXRlcywgcmVxdWlyZWRBdHRyaWJ1dGVzKSB7XG4gICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdzaWduSW4gbmV3IHBhc3N3b3JkJyk7XG4gICAgICAgICAgICAgICAgdXNlclsnY2hhbGxlbmdlTmFtZSddID0gJ05FV19QQVNTV09SRF9SRVFVSVJFRCc7XG4gICAgICAgICAgICAgICAgdXNlclsnY2hhbGxlbmdlUGFyYW0nXSA9IHtcbiAgICAgICAgICAgICAgICAgICAgdXNlckF0dHJpYnV0ZXM6IHVzZXJBdHRyaWJ1dGVzLFxuICAgICAgICAgICAgICAgICAgICByZXF1aXJlZEF0dHJpYnV0ZXM6IHJlcXVpcmVkQXR0cmlidXRlc1xuICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICAgICAgcmVzb2x2ZSh1c2VyKTtcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICB0b3RwUmVxdWlyZWQ6IGZ1bmN0aW9uIChjaGFsbGVuZ2VOYW1lLCBjaGFsbGVuZ2VQYXJhbSkge1xuICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnc2lnbkluIHRvdHBSZXF1aXJlZCcpO1xuICAgICAgICAgICAgICAgIHVzZXJbJ2NoYWxsZW5nZU5hbWUnXSA9IGNoYWxsZW5nZU5hbWU7XG4gICAgICAgICAgICAgICAgdXNlclsnY2hhbGxlbmdlUGFyYW0nXSA9IGNoYWxsZW5nZVBhcmFtO1xuICAgICAgICAgICAgICAgIHJlc29sdmUodXNlcik7XG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgc2VsZWN0TUZBVHlwZTogZnVuY3Rpb24gKGNoYWxsZW5nZU5hbWUsIGNoYWxsZW5nZVBhcmFtKSB7XG4gICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdzaWduSW4gc2VsZWN0TUZBVHlwZScsIGNoYWxsZW5nZU5hbWUpO1xuICAgICAgICAgICAgICAgIHVzZXJbJ2NoYWxsZW5nZU5hbWUnXSA9IGNoYWxsZW5nZU5hbWU7XG4gICAgICAgICAgICAgICAgdXNlclsnY2hhbGxlbmdlUGFyYW0nXSA9IGNoYWxsZW5nZVBhcmFtO1xuICAgICAgICAgICAgICAgIHJlc29sdmUodXNlcik7XG4gICAgICAgICAgICB9XG4gICAgICAgIH07XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBTaWduIGluIHdpdGggYSBwYXNzd29yZFxuICAgICAqIEBwcml2YXRlXG4gICAgICogQHBhcmFtIHtBdXRoZW50aWNhdGlvbkRldGFpbHN9IGF1dGhEZXRhaWxzIC0gdGhlIHVzZXIgc2lnbiBpbiBkYXRhXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyB0aGUgQ29nbml0b1VzZXIgb2JqZWN0IGlmIHN1Y2Nlc3Mgb3IgbWZhIHJlcXVpcmVkXG4gICAgICovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5zaWduSW5XaXRoUGFzc3dvcmQgPSBmdW5jdGlvbiAoYXV0aERldGFpbHMpIHtcbiAgICAgICAgdmFyIF90aGlzID0gdGhpcztcbiAgICAgICAgdmFyIHVzZXIgPSB0aGlzLmNyZWF0ZUNvZ25pdG9Vc2VyKGF1dGhEZXRhaWxzLmdldFVzZXJuYW1lKCkpO1xuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlc29sdmUsIHJlamVjdCkge1xuICAgICAgICAgICAgdXNlci5hdXRoZW50aWNhdGVVc2VyKGF1dGhEZXRhaWxzLCBfdGhpcy5hdXRoQ2FsbGJhY2tzKHVzZXIsIHJlc29sdmUsIHJlamVjdCkpO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIFNpZ24gaW4gd2l0aG91dCBhIHBhc3N3b3JkXG4gICAgICogQHByaXZhdGVcbiAgICAgKiBAcGFyYW0ge0F1dGhlbnRpY2F0aW9uRGV0YWlsc30gYXV0aERldGFpbHMgLSB0aGUgdXNlciBzaWduIGluIGRhdGFcbiAgICAgKiBAcmV0dXJuIC0gQSBwcm9taXNlIHJlc29sdmVzIHRoZSBDb2duaXRvVXNlciBvYmplY3QgaWYgc3VjY2VzcyBvciBtZmEgcmVxdWlyZWRcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLnNpZ25JbldpdGhvdXRQYXNzd29yZCA9IGZ1bmN0aW9uIChhdXRoRGV0YWlscykge1xuICAgICAgICB2YXIgX3RoaXMgPSB0aGlzO1xuICAgICAgICB2YXIgdXNlciA9IHRoaXMuY3JlYXRlQ29nbml0b1VzZXIoYXV0aERldGFpbHMuZ2V0VXNlcm5hbWUoKSk7XG4gICAgICAgIHVzZXIuc2V0QXV0aGVudGljYXRpb25GbG93VHlwZSgnQ1VTVE9NX0FVVEgnKTtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIHVzZXIuaW5pdGlhdGVBdXRoKGF1dGhEZXRhaWxzLCBfdGhpcy5hdXRoQ2FsbGJhY2tzKHVzZXIsIHJlc29sdmUsIHJlamVjdCkpO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIGdldCB1c2VyIGN1cnJlbnQgcHJlZmVycmVkIG1mYSBvcHRpb25cbiAgICAgKiB0aGlzIG1ldGhvZCBkb2Vzbid0IHdvcmsgd2l0aCB0b3RwLCB3ZSBuZWVkIHRvIGRlcHJlY2F0ZSBpdC5cbiAgICAgKiBAZGVwcmVjYXRlZFxuICAgICAqIEBwYXJhbSB7Q29nbml0b1VzZXJ9IHVzZXIgLSB0aGUgY3VycmVudCB1c2VyXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyB0aGUgY3VycmVudCBwcmVmZXJyZWQgbWZhIG9wdGlvbiBpZiBzdWNjZXNzXG4gICAgICovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5nZXRNRkFPcHRpb25zID0gZnVuY3Rpb24gKHVzZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXMsIHJlaikge1xuICAgICAgICAgICAgdXNlci5nZXRNRkFPcHRpb25zKGZ1bmN0aW9uIChlcnIsIG1mYU9wdGlvbnMpIHtcbiAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZ2V0IE1GQSBPcHRpb25zIGZhaWxlZCcsIGVycik7XG4gICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZ2V0IE1GQSBvcHRpb25zIHN1Y2Nlc3MnLCBtZmFPcHRpb25zKTtcbiAgICAgICAgICAgICAgICByZXMobWZhT3B0aW9ucyk7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogZ2V0IHByZWZlcnJlZCBtZmEgbWV0aG9kXG4gICAgICogQHBhcmFtIHtDb2duaXRvVXNlcn0gdXNlciAtIHRoZSBjdXJyZW50IGNvZ25pdG8gdXNlclxuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuZ2V0UHJlZmVycmVkTUZBID0gZnVuY3Rpb24gKHVzZXIpIHtcbiAgICAgICAgdmFyIHRoYXQgPSB0aGlzO1xuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlcywgcmVqKSB7XG4gICAgICAgICAgICB1c2VyLmdldFVzZXJEYXRhKGZ1bmN0aW9uIChlcnIsIGRhdGEpIHtcbiAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZ2V0dGluZyBwcmVmZXJyZWQgbWZhIGZhaWxlZCcsIGVycik7XG4gICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIHZhciBtZmFUeXBlID0gdGhhdC5fZ2V0TWZhVHlwZUZyb21Vc2VyRGF0YShkYXRhKTtcbiAgICAgICAgICAgICAgICBpZiAoIW1mYVR5cGUpIHtcbiAgICAgICAgICAgICAgICAgICAgcmVqKCdpbnZhbGlkIE1GQSBUeXBlJyk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgIHJlcyhtZmFUeXBlKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuX2dldE1mYVR5cGVGcm9tVXNlckRhdGEgPSBmdW5jdGlvbiAoZGF0YSkge1xuICAgICAgICB2YXIgcmV0ID0gbnVsbDtcbiAgICAgICAgdmFyIHByZWZlcnJlZE1GQSA9IGRhdGEuUHJlZmVycmVkTWZhU2V0dGluZztcbiAgICAgICAgLy8gaWYgdGhlIHVzZXIgaGFzIHVzZWQgQXV0aC5zZXRQcmVmZXJyZWRNRkEoKSB0byBzZXR1cCB0aGUgbWZhIHR5cGVcbiAgICAgICAgLy8gdGhlbiB0aGUgXCJQcmVmZXJyZWRNZmFTZXR0aW5nXCIgd291bGQgZXhpc3QgaW4gdGhlIHJlc3BvbnNlXG4gICAgICAgIGlmIChwcmVmZXJyZWRNRkEpIHtcbiAgICAgICAgICAgIHJldCA9IHByZWZlcnJlZE1GQTtcbiAgICAgICAgfVxuICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgIC8vIGlmIG1mYUxpc3QgZXhpc3RzIGJ1dCBlbXB0eSwgdGhlbiBpdHMgbm9NRkFcbiAgICAgICAgICAgIHZhciBtZmFMaXN0ID0gZGF0YS5Vc2VyTUZBU2V0dGluZ0xpc3Q7XG4gICAgICAgICAgICBpZiAoIW1mYUxpc3QpIHtcbiAgICAgICAgICAgICAgICAvLyBpZiBTTVMgd2FzIGVuYWJsZWQgYnkgdXNpbmcgQXV0aC5lbmFibGVTTVMoKSxcbiAgICAgICAgICAgICAgICAvLyB0aGUgcmVzcG9uc2Ugd291bGQgY29udGFpbiBNRkFPcHRpb25zXG4gICAgICAgICAgICAgICAgLy8gYXMgZm9yIG5vdyBDb2duaXRvIG9ubHkgc3VwcG9ydHMgZm9yIFNNUywgc28gd2Ugd2lsbCBzYXkgaXQgaXMgJ1NNU19NRkEnXG4gICAgICAgICAgICAgICAgLy8gaWYgaXQgZG9lcyBub3QgZXhpc3QsIHRoZW4gaXQgc2hvdWxkIGJlIE5PTUZBXG4gICAgICAgICAgICAgICAgdmFyIE1GQU9wdGlvbnMgPSBkYXRhLk1GQU9wdGlvbnM7XG4gICAgICAgICAgICAgICAgaWYgKE1GQU9wdGlvbnMpIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0ID0gJ1NNU19NRkEnO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0ID0gJ05PTUZBJztcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIGlmIChtZmFMaXN0Lmxlbmd0aCA9PT0gMCkge1xuICAgICAgICAgICAgICAgIHJldCA9ICdOT01GQSc7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2ludmFsaWQgY2FzZSBmb3IgZ2V0UHJlZmVycmVkTUZBJywgZGF0YSk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9O1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuX2dldFVzZXJEYXRhID0gZnVuY3Rpb24gKHVzZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXMsIHJlaikge1xuICAgICAgICAgICAgdXNlci5nZXRVc2VyRGF0YShmdW5jdGlvbiAoZXJyLCBkYXRhKSB7XG4gICAgICAgICAgICAgICAgaWYgKGVycikge1xuICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2dldHRpbmcgdXNlciBkYXRhIGZhaWxlZCcsIGVycik7XG4gICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICByZXMoZGF0YSk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBzZXQgcHJlZmVycmVkIE1GQSBtZXRob2RcbiAgICAgKiBAcGFyYW0ge0NvZ25pdG9Vc2VyfSB1c2VyIC0gdGhlIGN1cnJlbnQgQ29nbml0byB1c2VyXG4gICAgICogQHBhcmFtIHtzdHJpbmd9IG1mYU1ldGhvZCAtIHByZWZlcnJlZCBtZmEgbWV0aG9kXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlIGlmIHN1Y2Nlc3NcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLnNldFByZWZlcnJlZE1GQSA9IGZ1bmN0aW9uICh1c2VyLCBtZmFNZXRob2QpIHtcbiAgICAgICAgcmV0dXJuIF9fYXdhaXRlcih0aGlzLCB2b2lkIDAsIHZvaWQgMCwgZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgdmFyIHVzZXJEYXRhLCBzbXNNZmFTZXR0aW5ncywgdG90cE1mYVNldHRpbmdzLCBfYSwgbWZhTGlzdCwgY3VycmVudE1GQVR5cGUsIHRoYXQ7XG4gICAgICAgICAgICByZXR1cm4gX19nZW5lcmF0b3IodGhpcywgZnVuY3Rpb24gKF9iKSB7XG4gICAgICAgICAgICAgICAgc3dpdGNoIChfYi5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDA6IHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuX2dldFVzZXJEYXRhKHVzZXIpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgdXNlckRhdGEgPSBfYi5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBzbXNNZmFTZXR0aW5ncyA9IG51bGw7XG4gICAgICAgICAgICAgICAgICAgICAgICB0b3RwTWZhU2V0dGluZ3MgPSBudWxsO1xuICAgICAgICAgICAgICAgICAgICAgICAgX2EgPSBtZmFNZXRob2Q7XG4gICAgICAgICAgICAgICAgICAgICAgICBzd2l0Y2ggKF9hKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAnVE9UUCcgfHwgJ1NPRlRXQVJFX1RPS0VOX01GQSc6IHJldHVybiBbMyAvKmJyZWFrKi8sIDJdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgJ1NNUycgfHwgJ1NNU19NRkEnOiByZXR1cm4gWzMgLypicmVhayovLCAzXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBjYXNlICdOT01GQSc6IHJldHVybiBbMyAvKmJyZWFrKi8sIDRdO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgNl07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMjpcbiAgICAgICAgICAgICAgICAgICAgICAgIHRvdHBNZmFTZXR0aW5ncyA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBQcmVmZXJyZWRNZmE6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgRW5hYmxlZDogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDddO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDM6XG4gICAgICAgICAgICAgICAgICAgICAgICBzbXNNZmFTZXR0aW5ncyA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBQcmVmZXJyZWRNZmE6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgRW5hYmxlZDogdHJ1ZVxuICAgICAgICAgICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDddO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDQ6XG4gICAgICAgICAgICAgICAgICAgICAgICBtZmFMaXN0ID0gdXNlckRhdGFbJ1VzZXJNRkFTZXR0aW5nTGlzdCddO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgdGhpcy5fZ2V0TWZhVHlwZUZyb21Vc2VyRGF0YSh1c2VyRGF0YSldO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDU6XG4gICAgICAgICAgICAgICAgICAgICAgICBjdXJyZW50TUZBVHlwZSA9IF9iLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmIChjdXJyZW50TUZBVHlwZSA9PT0gJ05PTUZBJykge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMiAvKnJldHVybiovLCBQcm9taXNlLnJlc29sdmUoJ05vIGNoYW5nZSBmb3IgbWZhIHR5cGUnKV07XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICBlbHNlIGlmIChjdXJyZW50TUZBVHlwZSA9PT0gJ1NNU19NRkEnKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgc21zTWZhU2V0dGluZ3MgPSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFByZWZlcnJlZE1mYTogZmFsc2UsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEVuYWJsZWQ6IGZhbHNlXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIGVsc2UgaWYgKGN1cnJlbnRNRkFUeXBlID09PSAnU09GVFdBUkVfVE9LRU5fTUZBJykge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRvdHBNZmFTZXR0aW5ncyA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUHJlZmVycmVkTWZhOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgRW5hYmxlZDogZmFsc2VcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi8sIFByb21pc2UucmVqZWN0KCdpbnZhbGlkIE1GQSB0eXBlJyldO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgLy8gaWYgdGhlcmUgaXMgYSBVc2VyTUZBU2V0dGluZ0xpc3QgaW4gdGhlIHJlc3BvbnNlXG4gICAgICAgICAgICAgICAgICAgICAgICAvLyB3ZSBuZWVkIHRvIGRpc2FibGUgZXZlcnkgbWZhIHR5cGUgaW4gdGhhdCBsaXN0XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAobWZhTGlzdCAmJiBtZmFMaXN0Lmxlbmd0aCAhPT0gMCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIC8vIHRvIGRpc2FibGUgU01TIG9yIFRPVFAgaWYgZXhpc3RzIGluIHRoYXQgbGlzdFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIG1mYUxpc3QuZm9yRWFjaChmdW5jdGlvbiAobWZhVHlwZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAobWZhVHlwZSA9PT0gJ1NNU19NRkEnKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBzbXNNZmFTZXR0aW5ncyA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBQcmVmZXJyZWRNZmE6IGZhbHNlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEVuYWJsZWQ6IGZhbHNlXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVsc2UgaWYgKG1mYVR5cGUgPT09ICdTT0ZUV0FSRV9UT0tFTl9NRkEnKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0b3RwTWZhU2V0dGluZ3MgPSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgUHJlZmVycmVkTWZhOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBFbmFibGVkOiBmYWxzZVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgN107XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNjpcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnbm8gdmFsaWRtZmEgbWV0aG9kIHByb3ZpZGVkJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzIgLypyZXR1cm4qLywgUHJvbWlzZS5yZWplY3QoJ25vIHZhbGlkbWZhIG1ldGhvZCBwcm92aWRlZCcpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA3OlxuICAgICAgICAgICAgICAgICAgICAgICAgdGhhdCA9IHRoaXM7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzIgLypyZXR1cm4qLywgbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlcywgcmVqKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHVzZXIuc2V0VXNlck1mYVByZWZlcmVuY2Uoc21zTWZhU2V0dGluZ3MsIHRvdHBNZmFTZXR0aW5ncywgZnVuY3Rpb24gKGVyciwgcmVzdWx0KSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdTZXQgdXNlciBtZmEgcHJlZmVyZW5jZSBlcnJvcicsIGVycik7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdTZXQgdXNlciBtZmEgc3VjY2VzcycsIHJlc3VsdCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gcmVzKHJlc3VsdCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pXTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBkaWFibGUgU01TXG4gICAgICogQGRlcHJlY2F0ZWRcbiAgICAgKiBAcGFyYW0ge0NvZ25pdG9Vc2VyfSB1c2VyIC0gdGhlIGN1cnJlbnQgdXNlclxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgaXMgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuZGlzYWJsZVNNUyA9IGZ1bmN0aW9uICh1c2VyKSB7XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiAocmVzLCByZWopIHtcbiAgICAgICAgICAgIHVzZXIuZGlzYWJsZU1GQShmdW5jdGlvbiAoZXJyLCBkYXRhKSB7XG4gICAgICAgICAgICAgICAgaWYgKGVycikge1xuICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2Rpc2FibGUgbWZhIGZhaWxlZCcsIGVycik7XG4gICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZGlzYWJsZSBtZmEgc3VjY2VlZCcsIGRhdGEpO1xuICAgICAgICAgICAgICAgIHJlcyhkYXRhKTtcbiAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBlbmFibGUgU01TXG4gICAgICogQGRlcHJlY2F0ZWRcbiAgICAgKiBAcGFyYW0ge0NvZ25pdG9Vc2VyfSB1c2VyIC0gdGhlIGN1cnJlbnQgdXNlclxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgaXMgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuZW5hYmxlU01TID0gZnVuY3Rpb24gKHVzZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXMsIHJlaikge1xuICAgICAgICAgICAgdXNlci5lbmFibGVNRkEoZnVuY3Rpb24gKGVyciwgZGF0YSkge1xuICAgICAgICAgICAgICAgIGlmIChlcnIpIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdlbmFibGUgbWZhIGZhaWxlZCcsIGVycik7XG4gICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZW5hYmxlIG1mYSBzdWNjZWVkJywgZGF0YSk7XG4gICAgICAgICAgICAgICAgcmVzKGRhdGEpO1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIFNldHVwIFRPVFBcbiAgICAgKiBAcGFyYW0ge0NvZ25pdG9Vc2VyfSB1c2VyIC0gdGhlIGN1cnJlbnQgdXNlclxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgd2l0aCB0aGUgc2VjcmV0IGNvZGUgaWYgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuc2V0dXBUT1RQID0gZnVuY3Rpb24gKHVzZXIpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXMsIHJlaikge1xuICAgICAgICAgICAgdXNlci5hc3NvY2lhdGVTb2Z0d2FyZVRva2VuKHtcbiAgICAgICAgICAgICAgICBvbkZhaWx1cmU6IGZ1bmN0aW9uIChlcnIpIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdhc3NvY2lhdGVTb2Z0d2FyZVRva2VuIGZhaWxlZCcsIGVycik7XG4gICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBhc3NvY2lhdGVTZWNyZXRDb2RlOiBmdW5jdGlvbiAoc2VjcmV0Q29kZSkge1xuICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2Fzc29jaWF0ZVNvZnR3YXJlVG9rZW4gc3VjZXNzJywgc2VjcmV0Q29kZSk7XG4gICAgICAgICAgICAgICAgICAgIHJlcyhzZWNyZXRDb2RlKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIHZlcmlmeSBUT1RQIHNldHVwXG4gICAgICogQHBhcmFtIHtDb2duaXRvVXNlcn0gdXNlciAtIHRoZSBjdXJyZW50IHVzZXJcbiAgICAgKiBAcGFyYW0ge3N0cmluZ30gY2hhbGxlbmdlQW5zd2VyIC0gY2hhbGxlbmdlIGFuc3dlclxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgaXMgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUudmVyaWZ5VG90cFRva2VuID0gZnVuY3Rpb24gKHVzZXIsIGNoYWxsZW5nZUFuc3dlcikge1xuICAgICAgICBsb2dnZXIuZGVidWcoJ3ZlcmZpY2F0aW9uIHRvdHAgdG9rZW4nLCB1c2VyLCBjaGFsbGVuZ2VBbnN3ZXIpO1xuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlcywgcmVqKSB7XG4gICAgICAgICAgICB1c2VyLnZlcmlmeVNvZnR3YXJlVG9rZW4oY2hhbGxlbmdlQW5zd2VyLCAnTXkgVE9UUCBkZXZpY2UnLCB7XG4gICAgICAgICAgICAgICAgb25GYWlsdXJlOiBmdW5jdGlvbiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygndmVyaWZ5VG90cFRva2VuIGZhaWxlZCcsIGVycik7XG4gICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBvblN1Y2Nlc3M6IGZ1bmN0aW9uIChkYXRhKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygndmVyaWZ5VG90cFRva2VuIHN1Y2Nlc3MnLCBkYXRhKTtcbiAgICAgICAgICAgICAgICAgICAgcmVzKGRhdGEpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogU2VuZCBNRkEgY29kZSB0byBjb25maXJtIHNpZ24gaW5cbiAgICAgKiBAcGFyYW0ge09iamVjdH0gdXNlciAtIFRoZSBDb2duaXRvVXNlciBvYmplY3RcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gY29kZSAtIFRoZSBjb25maXJtYXRpb24gY29kZVxuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuY29uZmlybVNpZ25JbiA9IGZ1bmN0aW9uICh1c2VyLCBjb2RlLCBtZmFUeXBlKSB7XG4gICAgICAgIHZhciBfdGhpcyA9IHRoaXM7XG4gICAgICAgIGlmICghY29kZSkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdDb2RlIGNhbm5vdCBiZSBlbXB0eScpO1xuICAgICAgICB9XG4gICAgICAgIHZhciB0aGF0ID0gdGhpcztcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIHVzZXIuc2VuZE1GQUNvZGUoY29kZSwge1xuICAgICAgICAgICAgICAgIG9uU3VjY2VzczogZnVuY3Rpb24gKHNlc3Npb24pIHsgcmV0dXJuIF9fYXdhaXRlcihfdGhpcywgdm9pZCAwLCB2b2lkIDAsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICAgICAgdmFyIGNyZWQsIGVfMztcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIF9fZ2VuZXJhdG9yKHRoaXMsIGZ1bmN0aW9uIChfYSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgc3dpdGNoIChfYS5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMDpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKHNlc3Npb24pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBfYS5sYWJlbCA9IDE7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBfYS50cnlzLnB1c2goWzEsIDQsIDUsIDZdKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgY29yZV8xLkNyZWRlbnRpYWxzLmNsZWFyKCldO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMjpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzQgLyp5aWVsZCovLCBjb3JlXzEuQ3JlZGVudGlhbHMuc2V0KHNlc3Npb24sICdzZXNzaW9uJyldO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMzpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY3JlZCA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdzdWNjZWVkIHRvIGdldCBjb2duaXRvIGNyZWRlbnRpYWxzJywgY3JlZCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDZdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNDpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZV8zID0gX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2Nhbm5vdCBnZXQgY29nbml0byBjcmVkZW50aWFscycsIGVfMyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDZdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNTpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhhdC51c2VyID0gdXNlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZGlzcGF0Y2hBdXRoRXZlbnQoJ3NpZ25JbicsIHVzZXIsIHVzZXIgKyBcIiBoYXMgc2lnbmVkIGluXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXNvbHZlKHVzZXIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzcgLyplbmRmaW5hbGx5Ki9dO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNjogcmV0dXJuIFsyIC8qcmV0dXJuKi9dO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICB9KTsgfSxcbiAgICAgICAgICAgICAgICBvbkZhaWx1cmU6IGZ1bmN0aW9uIChlcnIpIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdjb25maXJtIHNpZ25JbiBmYWlsdXJlJywgZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgcmVqZWN0KGVycik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSwgbWZhVHlwZSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5jb21wbGV0ZU5ld1Bhc3N3b3JkID0gZnVuY3Rpb24gKHVzZXIsIHBhc3N3b3JkLCByZXF1aXJlZEF0dHJpYnV0ZXMpIHtcbiAgICAgICAgdmFyIF90aGlzID0gdGhpcztcbiAgICAgICAgaWYgKCFwYXNzd29yZCkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdQYXNzd29yZCBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgdGhhdCA9IHRoaXM7XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiAocmVzb2x2ZSwgcmVqZWN0KSB7XG4gICAgICAgICAgICB1c2VyLmNvbXBsZXRlTmV3UGFzc3dvcmRDaGFsbGVuZ2UocGFzc3dvcmQsIHJlcXVpcmVkQXR0cmlidXRlcywge1xuICAgICAgICAgICAgICAgIG9uU3VjY2VzczogZnVuY3Rpb24gKHNlc3Npb24pIHsgcmV0dXJuIF9fYXdhaXRlcihfdGhpcywgdm9pZCAwLCB2b2lkIDAsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICAgICAgdmFyIGNyZWQsIGVfNDtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIF9fZ2VuZXJhdG9yKHRoaXMsIGZ1bmN0aW9uIChfYSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgc3dpdGNoIChfYS5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMDpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKHNlc3Npb24pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBfYS5sYWJlbCA9IDE7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBfYS50cnlzLnB1c2goWzEsIDQsIDUsIDZdKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgY29yZV8xLkNyZWRlbnRpYWxzLmNsZWFyKCldO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMjpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzQgLyp5aWVsZCovLCBjb3JlXzEuQ3JlZGVudGlhbHMuc2V0KHNlc3Npb24sICdzZXNzaW9uJyldO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgMzpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY3JlZCA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdzdWNjZWVkIHRvIGdldCBjb2duaXRvIGNyZWRlbnRpYWxzJywgY3JlZCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDZdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNDpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZV80ID0gX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2Nhbm5vdCBnZXQgY29nbml0byBjcmVkZW50aWFscycsIGVfNCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDZdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNTpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhhdC51c2VyID0gdXNlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZGlzcGF0Y2hBdXRoRXZlbnQoJ3NpZ25JbicsIHVzZXIsIHVzZXIgKyBcIiBoYXMgc2lnbmVkIGluXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXNvbHZlKHVzZXIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzcgLyplbmRmaW5hbGx5Ki9dO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNhc2UgNjogcmV0dXJuIFsyIC8qcmV0dXJuKi9dO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgICAgICB9KTsgfSxcbiAgICAgICAgICAgICAgICBvbkZhaWx1cmU6IGZ1bmN0aW9uIChlcnIpIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdjb21wbGV0ZU5ld1Bhc3N3b3JkIGZhaWx1cmUnLCBlcnIpO1xuICAgICAgICAgICAgICAgICAgICBkaXNwYXRjaEF1dGhFdmVudCgnY29tcGxldGVOZXdQYXNzd29yZF9mYWlsdXJlJywgZXJyLCBfdGhpcy51c2VyICsgXCIgZmFpbGVkIHRvIGNvbXBsZXRlIHRoZSBuZXcgcGFzc3dvcmQgZmxvd1wiKTtcbiAgICAgICAgICAgICAgICAgICAgcmVqZWN0KGVycik7XG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBtZmFSZXF1aXJlZDogZnVuY3Rpb24gKGNoYWxsZW5nZU5hbWUsIGNoYWxsZW5nZVBhcmFtKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnc2lnbkluIE1GQSByZXF1aXJlZCcpO1xuICAgICAgICAgICAgICAgICAgICB1c2VyWydjaGFsbGVuZ2VOYW1lJ10gPSBjaGFsbGVuZ2VOYW1lO1xuICAgICAgICAgICAgICAgICAgICB1c2VyWydjaGFsbGVuZ2VQYXJhbSddID0gY2hhbGxlbmdlUGFyYW07XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUodXNlcik7XG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICBtZmFTZXR1cDogZnVuY3Rpb24gKGNoYWxsZW5nZU5hbWUsIGNoYWxsZW5nZVBhcmFtKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnc2lnbkluIG1mYSBzZXR1cCcsIGNoYWxsZW5nZU5hbWUpO1xuICAgICAgICAgICAgICAgICAgICB1c2VyWydjaGFsbGVuZ2VOYW1lJ10gPSBjaGFsbGVuZ2VOYW1lO1xuICAgICAgICAgICAgICAgICAgICB1c2VyWydjaGFsbGVuZ2VQYXJhbSddID0gY2hhbGxlbmdlUGFyYW07XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUodXNlcik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogU2VuZCB0aGUgYW5zd2VyIHRvIGEgY3VzdG9tIGNoYWxsZW5nZVxuICAgICAqIEBwYXJhbSB7Q29nbml0b1VzZXJ9IHVzZXIgLSBUaGUgQ29nbml0b1VzZXIgb2JqZWN0XG4gICAgICogQHBhcmFtIHtTdHJpbmd9IGNoYWxsZW5nZVJlc3BvbnNlcyAtIFRoZSBjb25maXJtYXRpb24gY29kZVxuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuc2VuZEN1c3RvbUNoYWxsZW5nZUFuc3dlciA9IGZ1bmN0aW9uICh1c2VyLCBjaGFsbGVuZ2VSZXNwb25zZXMpIHtcbiAgICAgICAgdmFyIF90aGlzID0gdGhpcztcbiAgICAgICAgaWYgKCF0aGlzLnVzZXJQb29sKSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ05vIHVzZXJQb29sJyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCFjaGFsbGVuZ2VSZXNwb25zZXMpIHtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnQ2hhbGxlbmdlIHJlc3BvbnNlIGNhbm5vdCBiZSBlbXB0eScpO1xuICAgICAgICB9XG4gICAgICAgIHZhciB0aGF0ID0gdGhpcztcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIHVzZXIuc2VuZEN1c3RvbUNoYWxsZW5nZUFuc3dlcihjaGFsbGVuZ2VSZXNwb25zZXMsIF90aGlzLmF1dGhDYWxsYmFja3ModXNlciwgcmVzb2x2ZSwgcmVqZWN0KSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogVXBkYXRlIGFuIGF1dGhlbnRpY2F0ZWQgdXNlcnMnIGF0dHJpYnV0ZXNcbiAgICAgKiBAcGFyYW0ge0NvZ25pdG9Vc2VyfSAtIFRoZSBjdXJyZW50bHkgbG9nZ2VkIGluIHVzZXIgb2JqZWN0XG4gICAgICogQHJldHVybiB7UHJvbWlzZX1cbiAgICAgKiovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS51cGRhdGVVc2VyQXR0cmlidXRlcyA9IGZ1bmN0aW9uICh1c2VyLCBhdHRyaWJ1dGVzKSB7XG4gICAgICAgIHZhciBhdHRyaWJ1dGVMaXN0ID0gW107XG4gICAgICAgIHZhciB0aGF0ID0gdGhpcztcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIHRoYXQudXNlclNlc3Npb24odXNlcikudGhlbihmdW5jdGlvbiAoc2Vzc2lvbikge1xuICAgICAgICAgICAgICAgIGZvciAodmFyIGtleSBpbiBhdHRyaWJ1dGVzKSB7XG4gICAgICAgICAgICAgICAgICAgIGlmIChrZXkgIT09ICdzdWInICYmXG4gICAgICAgICAgICAgICAgICAgICAgICBrZXkuaW5kZXhPZignX3ZlcmlmaWVkJykgPCAwKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB2YXIgYXR0ciA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAnTmFtZSc6IGtleSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAnVmFsdWUnOiBhdHRyaWJ1dGVzW2tleV1cbiAgICAgICAgICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICAgICAgICAgICAgICBhdHRyaWJ1dGVMaXN0LnB1c2goYXR0cik7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgdXNlci51cGRhdGVBdHRyaWJ1dGVzKGF0dHJpYnV0ZUxpc3QsIGZ1bmN0aW9uIChlcnIsIHJlc3VsdCkge1xuICAgICAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gcmVqZWN0KGVycik7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gcmVzb2x2ZShyZXN1bHQpO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBSZXR1cm4gdXNlciBhdHRyaWJ1dGVzXG4gICAgICogQHBhcmFtIHtPYmplY3R9IHVzZXIgLSBUaGUgQ29nbml0b1VzZXIgb2JqZWN0XG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyB0byB1c2VyIGF0dHJpYnV0ZXMgaWYgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUudXNlckF0dHJpYnV0ZXMgPSBmdW5jdGlvbiAodXNlcikge1xuICAgICAgICB2YXIgX3RoaXMgPSB0aGlzO1xuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlc29sdmUsIHJlamVjdCkge1xuICAgICAgICAgICAgX3RoaXMudXNlclNlc3Npb24odXNlcikudGhlbihmdW5jdGlvbiAoc2Vzc2lvbikge1xuICAgICAgICAgICAgICAgIHVzZXIuZ2V0VXNlckF0dHJpYnV0ZXMoZnVuY3Rpb24gKGVyciwgYXR0cmlidXRlcykge1xuICAgICAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJlc29sdmUoYXR0cmlidXRlcyk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUudmVyaWZpZWRDb250YWN0ID0gZnVuY3Rpb24gKHVzZXIpIHtcbiAgICAgICAgdmFyIHRoYXQgPSB0aGlzO1xuICAgICAgICByZXR1cm4gdGhpcy51c2VyQXR0cmlidXRlcyh1c2VyKVxuICAgICAgICAgICAgLnRoZW4oZnVuY3Rpb24gKGF0dHJpYnV0ZXMpIHtcbiAgICAgICAgICAgIHZhciBhdHRycyA9IHRoYXQuYXR0cmlidXRlc1RvT2JqZWN0KGF0dHJpYnV0ZXMpO1xuICAgICAgICAgICAgdmFyIHVudmVyaWZpZWQgPSB7fTtcbiAgICAgICAgICAgIHZhciB2ZXJpZmllZCA9IHt9O1xuICAgICAgICAgICAgaWYgKGF0dHJzWydlbWFpbCddKSB7XG4gICAgICAgICAgICAgICAgaWYgKGF0dHJzWydlbWFpbF92ZXJpZmllZCddKSB7XG4gICAgICAgICAgICAgICAgICAgIHZlcmlmaWVkWydlbWFpbCddID0gYXR0cnNbJ2VtYWlsJ107XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICB1bnZlcmlmaWVkWydlbWFpbCddID0gYXR0cnNbJ2VtYWlsJ107XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKGF0dHJzWydwaG9uZV9udW1iZXInXSkge1xuICAgICAgICAgICAgICAgIGlmIChhdHRyc1sncGhvbmVfbnVtYmVyX3ZlcmlmaWVkJ10pIHtcbiAgICAgICAgICAgICAgICAgICAgdmVyaWZpZWRbJ3Bob25lX251bWJlciddID0gYXR0cnNbJ3Bob25lX251bWJlciddO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgdW52ZXJpZmllZFsncGhvbmVfbnVtYmVyJ10gPSBhdHRyc1sncGhvbmVfbnVtYmVyJ107XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgICAgICB2ZXJpZmllZDogdmVyaWZpZWQsXG4gICAgICAgICAgICAgICAgdW52ZXJpZmllZDogdW52ZXJpZmllZFxuICAgICAgICAgICAgfTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBHZXQgY3VycmVudCBhdXRoZW50aWNhdGVkIHVzZXJcbiAgICAgKiBAcmV0dXJuIC0gQSBwcm9taXNlIHJlc29sdmVzIHRvIGN1cnJlbnQgYXV0aGVudGljYXRlZCBDb2duaXRvVXNlciBpZiBzdWNjZXNzXG4gICAgICovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5jdXJyZW50VXNlclBvb2xVc2VyID0gZnVuY3Rpb24gKHBhcmFtcykge1xuICAgICAgICB2YXIgX3RoaXMgPSB0aGlzO1xuICAgICAgICBpZiAoIXRoaXMudXNlclBvb2wpIHtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnTm8gdXNlclBvb2wnKTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgdGhhdCA9IHRoaXM7XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiAocmVzLCByZWopIHtcbiAgICAgICAgICAgIF90aGlzLl9zdG9yYWdlU3luYy50aGVuKGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICAgICB2YXIgdXNlciA9IHRoYXQudXNlclBvb2wuZ2V0Q3VycmVudFVzZXIoKTtcbiAgICAgICAgICAgICAgICBpZiAoIXVzZXIpIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdGYWlsZWQgdG8gZ2V0IHVzZXIgZnJvbSB1c2VyIHBvb2wnKTtcbiAgICAgICAgICAgICAgICAgICAgcmVqKCdObyBjdXJyZW50IHVzZXInKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAvLyByZWZyZXNoIHRoZSBzZXNzaW9uIGlmIHRoZSBzZXNzaW9uIGV4cGlyZWQuXG4gICAgICAgICAgICAgICAgdXNlci5nZXRTZXNzaW9uKGZ1bmN0aW9uIChlcnIsIHNlc3Npb24pIHtcbiAgICAgICAgICAgICAgICAgICAgaWYgKGVycikge1xuICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdGYWlsZWQgdG8gZ2V0IHRoZSB1c2VyIHNlc3Npb24nLCBlcnIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmVqKGVycik7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgLy8gZ2V0IHVzZXIgZGF0YSBmcm9tIENvZ25pdG9cbiAgICAgICAgICAgICAgICAgICAgdmFyIGJ5cGFzc0NhY2hlID0gcGFyYW1zID8gcGFyYW1zLmJ5cGFzc0NhY2hlIDogZmFsc2U7XG4gICAgICAgICAgICAgICAgICAgIC8vIHZhbGlkYXRlIHRoZSB0b2tlbidzIHNjb3BlIGZpc3J0IGJlZm9yZSBjYWxsaW5nIHRoaXMgZnVuY3Rpb25cbiAgICAgICAgICAgICAgICAgICAgdmFyIF9hID0gc2Vzc2lvbi5nZXRBY2Nlc3NUb2tlbigpLmRlY29kZVBheWxvYWQoKS5zY29wZSwgc2NvcGUgPSBfYSA9PT0gdm9pZCAwID8gJycgOiBfYTtcbiAgICAgICAgICAgICAgICAgICAgaWYgKHNjb3BlLnNwbGl0KCcgJykuaW5jbHVkZXMoVVNFUl9BRE1JTl9TQ09QRSkpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHVzZXIuZ2V0VXNlckRhdGEoZnVuY3Rpb24gKGVyciwgZGF0YSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmIChlcnIpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdnZXR0aW5nIHVzZXIgZGF0YSBmYWlsZWQnLCBlcnIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAvLyBNYWtlIHN1cmUgdGhlIHVzZXIgaXMgc3RpbGwgdmFsaWRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKGVyci5tZXNzYWdlID09PSAnVXNlciBpcyBkaXNhYmxlZCcgfHwgZXJyLm1lc3NhZ2UgPT09ICdVc2VyIGRvZXMgbm90IGV4aXN0LicpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gdGhlIGVycm9yIG1heSBhbHNvIGJlIHRocm93biB3aGVuIGxhY2sgb2YgcGVybWlzc2lvbnMgdG8gZ2V0IHVzZXIgaW5mbyBldGNcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC8vIGluIHRoYXQgY2FzZSB3ZSBqdXN0IGJ5cGFzcyB0aGUgZXJyb3JcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJlcyh1c2VyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciBwcmVmZXJyZWRNRkEgPSBkYXRhLlByZWZlcnJlZE1mYVNldHRpbmcgfHwgJ05PTUZBJztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgYXR0cmlidXRlTGlzdCA9IFtdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwgZGF0YS5Vc2VyQXR0cmlidXRlcy5sZW5ndGg7IGkrKykge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgYXR0cmlidXRlID0ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgTmFtZTogZGF0YS5Vc2VyQXR0cmlidXRlc1tpXS5OYW1lLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgVmFsdWU6IGRhdGEuVXNlckF0dHJpYnV0ZXNbaV0uVmFsdWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHZhciB1c2VyQXR0cmlidXRlID0gbmV3IGFtYXpvbl9jb2duaXRvX2lkZW50aXR5X2pzXzEuQ29nbml0b1VzZXJBdHRyaWJ1dGUoYXR0cmlidXRlKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgYXR0cmlidXRlTGlzdC5wdXNoKHVzZXJBdHRyaWJ1dGUpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgYXR0cmlidXRlcyA9IHRoYXQuYXR0cmlidXRlc1RvT2JqZWN0KGF0dHJpYnV0ZUxpc3QpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIE9iamVjdC5hc3NpZ24odXNlciwgeyBhdHRyaWJ1dGVzOiBhdHRyaWJ1dGVzLCBwcmVmZXJyZWRNRkE6IHByZWZlcnJlZE1GQSB9KTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gcmVzKHVzZXIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfSwgeyBieXBhc3NDYWNoZTogYnlwYXNzQ2FjaGUgfSk7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoXCJVbmFibGUgdG8gZ2V0IHRoZSB1c2VyIGRhdGEgYmVjYXVzZSB0aGUgXCIgKyBVU0VSX0FETUlOX1NDT1BFICsgXCIgXCIgK1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIFwiaXMgbm90IGluIHRoZSBzY29wZXMgb2YgdGhlIGFjY2VzcyB0b2tlblwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiByZXModXNlcik7XG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH0pLmNhdGNoKGZ1bmN0aW9uIChlKSB7XG4gICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdGYWlsZWQgdG8gc3luYyBjYWNoZSBpbmZvIGludG8gbWVtb3J5JywgZSk7XG4gICAgICAgICAgICAgICAgcmV0dXJuIHJlaihlKTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIEdldCBjdXJyZW50IGF1dGhlbnRpY2F0ZWQgdXNlclxuICAgICAqIEBwYXJhbSB7Q3VycmVudFVzZXJPcHRzfSAtIG9wdGlvbnMgZm9yIGdldHRpbmcgdGhlIGN1cnJlbnQgdXNlclxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgdG8gY3VycmVudCBhdXRoZW50aWNhdGVkIENvZ25pdG9Vc2VyIGlmIHN1Y2Nlc3NcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmN1cnJlbnRBdXRoZW50aWNhdGVkVXNlciA9IGZ1bmN0aW9uIChwYXJhbXMpIHtcbiAgICAgICAgcmV0dXJuIF9fYXdhaXRlcih0aGlzLCB2b2lkIDAsIHZvaWQgMCwgZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgdmFyIGZlZGVyYXRlZFVzZXIsIGVfNSwgdXNlciwgZV82O1xuICAgICAgICAgICAgcmV0dXJuIF9fZ2VuZXJhdG9yKHRoaXMsIGZ1bmN0aW9uIChfYSkge1xuICAgICAgICAgICAgICAgIHN3aXRjaCAoX2EubGFiZWwpIHtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAwOlxuICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdnZXR0aW5nIGN1cnJlbnQgYXV0aGVudGljdGVkIHVzZXInKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGZlZGVyYXRlZFVzZXIgPSBudWxsO1xuICAgICAgICAgICAgICAgICAgICAgICAgX2EubGFiZWwgPSAxO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDE6XG4gICAgICAgICAgICAgICAgICAgICAgICBfYS50cnlzLnB1c2goWzEsIDMsICwgNF0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgdGhpcy5fc3RvcmFnZVN5bmNdO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDI6XG4gICAgICAgICAgICAgICAgICAgICAgICBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzMgLypicmVhayovLCA0XTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAzOlxuICAgICAgICAgICAgICAgICAgICAgICAgZV81ID0gX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdGYWlsZWQgdG8gc3luYyBjYWNoZSBpbmZvIGludG8gbWVtb3J5JywgZV81KTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRocm93IGVfNTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA0OlxuICAgICAgICAgICAgICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmZWRlcmF0ZWRVc2VyID0gSlNPTi5wYXJzZSh0aGlzLl9zdG9yYWdlLmdldEl0ZW0oJ2F3cy1hbXBsaWZ5LWZlZGVyYXRlZEluZm8nKSkudXNlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIGNhdGNoIChlKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdjYW5ub3QgbG9hZCBmZWRlcmF0ZWQgdXNlciBmcm9tIGF1dGggc3RvcmFnZScpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCFmZWRlcmF0ZWRVc2VyKSByZXR1cm4gWzMgLypicmVhayovLCA1XTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMudXNlciA9IGZlZGVyYXRlZFVzZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2dldCBjdXJyZW50IGF1dGhlbnRpY2F0ZWQgZmVkZXJhdGVkIHVzZXInLCB0aGlzLnVzZXIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi8sIHRoaXMudXNlcl07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNTpcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZ2V0IGN1cnJlbnQgYXV0aGVudGljYXRlZCB1c2VycG9vbCB1c2VyJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICB1c2VyID0gbnVsbDtcbiAgICAgICAgICAgICAgICAgICAgICAgIF9hLmxhYmVsID0gNjtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA2OlxuICAgICAgICAgICAgICAgICAgICAgICAgX2EudHJ5cy5wdXNoKFs2LCA4LCAsIDldKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuY3VycmVudFVzZXJQb29sVXNlcihwYXJhbXMpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA3OlxuICAgICAgICAgICAgICAgICAgICAgICAgdXNlciA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDldO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDg6XG4gICAgICAgICAgICAgICAgICAgICAgICBlXzYgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoZV82ID09PSAnTm8gdXNlclBvb2wnKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmVycm9yKCdDYW5ub3QgZ2V0IHRoZSBjdXJyZW50IHVzZXIgYmVjYXVzZSB0aGUgdXNlciBwb29sIGlzIG1pc3NpbmcuICcgK1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAnUGxlYXNlIG1ha2Ugc3VyZSB0aGUgQXV0aCBtb2R1bGUgaXMgY29uZmlndXJlZCB3aXRoIGEgdmFsaWQgQ29nbml0byBVc2VyIFBvb2wgSUQnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnVGhlIHVzZXIgaXMgbm90IGF1dGhlbnRpY2F0ZWQgYnkgdGhlIGVycm9yJywgZV82KTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRocm93ICgnbm90IGF1dGhlbnRpY2F0ZWQnKTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA5OlxuICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy51c2VyID0gdXNlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMiAvKnJldHVybiovLCB0aGlzLnVzZXJdO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIEdldCBjdXJyZW50IHVzZXIncyBzZXNzaW9uXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyB0byBzZXNzaW9uIG9iamVjdCBpZiBzdWNjZXNzXG4gICAgICovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5jdXJyZW50U2Vzc2lvbiA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgdmFyIHRoYXQgPSB0aGlzO1xuICAgICAgICBsb2dnZXIuZGVidWcoJ0dldHRpbmcgY3VycmVudCBzZXNzaW9uJyk7XG4gICAgICAgIGlmICghdGhpcy51c2VyUG9vbCkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdObyB1c2VyUG9vbCcpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiAocmVzLCByZWopIHtcbiAgICAgICAgICAgIHRoYXQuY3VycmVudFVzZXJQb29sVXNlcigpLnRoZW4oZnVuY3Rpb24gKHVzZXIpIHtcbiAgICAgICAgICAgICAgICB0aGF0LnVzZXJTZXNzaW9uKHVzZXIpLnRoZW4oZnVuY3Rpb24gKHNlc3Npb24pIHtcbiAgICAgICAgICAgICAgICAgICAgcmVzKHNlc3Npb24pO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfSkuY2F0Y2goZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdGYWlsZWQgdG8gZ2V0IHRoZSBjdXJyZW50IHNlc3Npb24nLCBlKTtcbiAgICAgICAgICAgICAgICAgICAgcmVqKGUpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9KS5jYXRjaChmdW5jdGlvbiAoZSkge1xuICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnRmFpbGVkIHRvIGdldCB0aGUgY3VycmVudCB1c2VyJywgZSk7XG4gICAgICAgICAgICAgICAgcmVqKGUpO1xuICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIEdldCB0aGUgY29ycmVzcG9uZGluZyB1c2VyIHNlc3Npb25cbiAgICAgKiBAcGFyYW0ge09iamVjdH0gdXNlciAtIFRoZSBDb2duaXRvVXNlciBvYmplY3RcbiAgICAgKiBAcmV0dXJuIC0gQSBwcm9taXNlIHJlc29sdmVzIHRvIHRoZSBzZXNzaW9uXG4gICAgICovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS51c2VyU2Vzc2lvbiA9IGZ1bmN0aW9uICh1c2VyKSB7XG4gICAgICAgIGlmICghdXNlcikge1xuICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCd0aGUgdXNlciBpcyBudWxsJyk7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ0ZhaWxlZCB0byBnZXQgdGhlIHNlc3Npb24gYmVjYXVzZSB0aGUgdXNlciBpcyBlbXB0eScpO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiAocmVzb2x2ZSwgcmVqZWN0KSB7XG4gICAgICAgICAgICBsb2dnZXIuZGVidWcoJ0dldHRpbmcgdGhlIHNlc3Npb24gZnJvbSB0aGlzIHVzZXI6JywgdXNlcik7XG4gICAgICAgICAgICB1c2VyLmdldFNlc3Npb24oZnVuY3Rpb24gKGVyciwgc2Vzc2lvbikge1xuICAgICAgICAgICAgICAgIGlmIChlcnIpIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdGYWlsZWQgdG8gZ2V0IHRoZSBzZXNzaW9uIGZyb20gdXNlcicsIHVzZXIpO1xuICAgICAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdTdWNjZWVkIHRvIGdldCB0aGUgdXNlciBzZXNzaW9uJywgc2Vzc2lvbik7XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUoc2Vzc2lvbik7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBHZXQgIGF1dGhlbnRpY2F0ZWQgY3JlZGVudGlhbHMgb2YgY3VycmVudCB1c2VyLlxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgdG8gYmUgY3VycmVudCB1c2VyJ3MgY3JlZGVudGlhbHNcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmN1cnJlbnRVc2VyQ3JlZGVudGlhbHMgPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgIHJldHVybiBfX2F3YWl0ZXIodGhpcywgdm9pZCAwLCB2b2lkIDAsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgIHZhciB0aGF0LCBlXzcsIGZlZGVyYXRlZEluZm87XG4gICAgICAgICAgICByZXR1cm4gX19nZW5lcmF0b3IodGhpcywgZnVuY3Rpb24gKF9hKSB7XG4gICAgICAgICAgICAgICAgc3dpdGNoIChfYS5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDA6XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGF0ID0gdGhpcztcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnR2V0dGluZyBjdXJyZW50IHVzZXIgY3JlZGVudGlhbHMnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIF9hLmxhYmVsID0gMTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2EudHJ5cy5wdXNoKFsxLCAzLCAsIDRdKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuX3N0b3JhZ2VTeW5jXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAyOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgNF07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMzpcbiAgICAgICAgICAgICAgICAgICAgICAgIGVfNyA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnRmFpbGVkIHRvIHN5bmMgY2FjaGUgaW5mbyBpbnRvIG1lbW9yeScsIGVfNyk7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aHJvdyBlXzc7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNDpcbiAgICAgICAgICAgICAgICAgICAgICAgIGZlZGVyYXRlZEluZm8gPSBudWxsO1xuICAgICAgICAgICAgICAgICAgICAgICAgdHJ5IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBmZWRlcmF0ZWRJbmZvID0gSlNPTi5wYXJzZSh0aGlzLl9zdG9yYWdlLmdldEl0ZW0oJ2F3cy1hbXBsaWZ5LWZlZGVyYXRlZEluZm8nKSk7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICBjYXRjaCAoZSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZmFpbGVkIHRvIGdldCBvciBwYXJzZSBpdGVtIGF3cy1hbXBsaWZ5LWZlZGVyYXRlZEluZm8nLCBlKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIGlmIChmZWRlcmF0ZWRJbmZvKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLy8gcmVmcmVzaCB0aGUgand0IHRva2VuIGhlcmUgaWYgbmVjZXNzYXJ5XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi8sIGNvcmVfMS5DcmVkZW50aWFscy5yZWZyZXNoRmVkZXJhdGVkVG9rZW4oZmVkZXJhdGVkSW5mbyldO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi8sIHRoaXMuY3VycmVudFNlc3Npb24oKVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLnRoZW4oZnVuY3Rpb24gKHNlc3Npb24pIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZ2V0dGluZyBzZXNzaW9uIHN1Y2Nlc3MnLCBzZXNzaW9uKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBjb3JlXzEuQ3JlZGVudGlhbHMuc2V0KHNlc3Npb24sICdzZXNzaW9uJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pLmNhdGNoKGZ1bmN0aW9uIChlcnJvcikge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdnZXR0aW5nIHNlc3Npb24gZmFpbGVkJywgZXJyb3IpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGNvcmVfMS5DcmVkZW50aWFscy5zZXQobnVsbCwgJ2d1ZXN0Jyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pXTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMiAvKnJldHVybiovXTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmN1cnJlbnRDcmVkZW50aWFscyA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgbG9nZ2VyLmRlYnVnKCdnZXR0aW5nIGN1cnJlbnQgY3JlZG50aWFscycpO1xuICAgICAgICByZXR1cm4gY29yZV8xLkNyZWRlbnRpYWxzLmdldCgpO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogSW5pdGlhdGUgYW4gYXR0cmlidXRlIGNvbmZpcm1hdGlvbiByZXF1ZXN0XG4gICAgICogQHBhcmFtIHtPYmplY3R9IHVzZXIgLSBUaGUgQ29nbml0b1VzZXJcbiAgICAgKiBAcGFyYW0ge09iamVjdH0gYXR0ciAtIFRoZSBhdHRyaWJ1dGVzIHRvIGJlIHZlcmlmaWVkXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyB0byBjYWxsYmFjayBkYXRhIGlmIHN1Y2Nlc3NcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLnZlcmlmeVVzZXJBdHRyaWJ1dGUgPSBmdW5jdGlvbiAodXNlciwgYXR0cikge1xuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlc29sdmUsIHJlamVjdCkge1xuICAgICAgICAgICAgdXNlci5nZXRBdHRyaWJ1dGVWZXJpZmljYXRpb25Db2RlKGF0dHIsIHtcbiAgICAgICAgICAgICAgICBvblN1Y2Nlc3M6IGZ1bmN0aW9uICgpIHsgcmV0dXJuIHJlc29sdmUoKTsgfSxcbiAgICAgICAgICAgICAgICBvbkZhaWx1cmU6IGZ1bmN0aW9uIChlcnIpIHsgcmV0dXJuIHJlamVjdChlcnIpOyB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBDb25maXJtIGFuIGF0dHJpYnV0ZSB1c2luZyBhIGNvbmZpcm1hdGlvbiBjb2RlXG4gICAgICogQHBhcmFtIHtPYmplY3R9IHVzZXIgLSBUaGUgQ29nbml0b1VzZXJcbiAgICAgKiBAcGFyYW0ge09iamVjdH0gYXR0ciAtIFRoZSBhdHRyaWJ1dGUgdG8gYmUgdmVyaWZpZWRcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gY29kZSAtIFRoZSBjb25maXJtYXRpb24gY29kZVxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgdG8gY2FsbGJhY2sgZGF0YSBpZiBzdWNjZXNzXG4gICAgICovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS52ZXJpZnlVc2VyQXR0cmlidXRlU3VibWl0ID0gZnVuY3Rpb24gKHVzZXIsIGF0dHIsIGNvZGUpIHtcbiAgICAgICAgaWYgKCFjb2RlKSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ0NvZGUgY2Fubm90IGJlIGVtcHR5Jyk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIHVzZXIudmVyaWZ5QXR0cmlidXRlKGF0dHIsIGNvZGUsIHtcbiAgICAgICAgICAgICAgICBvblN1Y2Nlc3M6IGZ1bmN0aW9uIChkYXRhKSB7XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUoZGF0YSk7XG4gICAgICAgICAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgIG9uRmFpbHVyZTogZnVuY3Rpb24gKGVycikge1xuICAgICAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUudmVyaWZ5Q3VycmVudFVzZXJBdHRyaWJ1dGUgPSBmdW5jdGlvbiAoYXR0cikge1xuICAgICAgICB2YXIgdGhhdCA9IHRoaXM7XG4gICAgICAgIHJldHVybiB0aGF0LmN1cnJlbnRVc2VyUG9vbFVzZXIoKVxuICAgICAgICAgICAgLnRoZW4oZnVuY3Rpb24gKHVzZXIpIHsgcmV0dXJuIHRoYXQudmVyaWZ5VXNlckF0dHJpYnV0ZSh1c2VyLCBhdHRyKTsgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBDb25maXJtIGN1cnJlbnQgdXNlcidzIGF0dHJpYnV0ZSB1c2luZyBhIGNvbmZpcm1hdGlvbiBjb2RlXG4gICAgICogQHBhcmFtIHtPYmplY3R9IGF0dHIgLSBUaGUgYXR0cmlidXRlIHRvIGJlIHZlcmlmaWVkXG4gICAgICogQHBhcmFtIHtTdHJpbmd9IGNvZGUgLSBUaGUgY29uZmlybWF0aW9uIGNvZGVcbiAgICAgKiBAcmV0dXJuIC0gQSBwcm9taXNlIHJlc29sdmVzIHRvIGNhbGxiYWNrIGRhdGEgaWYgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUudmVyaWZ5Q3VycmVudFVzZXJBdHRyaWJ1dGVTdWJtaXQgPSBmdW5jdGlvbiAoYXR0ciwgY29kZSkge1xuICAgICAgICB2YXIgdGhhdCA9IHRoaXM7XG4gICAgICAgIHJldHVybiB0aGF0LmN1cnJlbnRVc2VyUG9vbFVzZXIoKVxuICAgICAgICAgICAgLnRoZW4oZnVuY3Rpb24gKHVzZXIpIHsgcmV0dXJuIHRoYXQudmVyaWZ5VXNlckF0dHJpYnV0ZVN1Ym1pdCh1c2VyLCBhdHRyLCBjb2RlKTsgfSk7XG4gICAgfTtcbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmNvZ25pdG9JZGVudGl0eVNpZ25PdXQgPSBmdW5jdGlvbiAob3B0cywgdXNlcikge1xuICAgICAgICByZXR1cm4gX19hd2FpdGVyKHRoaXMsIHZvaWQgMCwgdm9pZCAwLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICB2YXIgZV84LCBpc1NpZ25lZEluSG9zdGVkVUk7XG4gICAgICAgICAgICB2YXIgX3RoaXMgPSB0aGlzO1xuICAgICAgICAgICAgcmV0dXJuIF9fZ2VuZXJhdG9yKHRoaXMsIGZ1bmN0aW9uIChfYSkge1xuICAgICAgICAgICAgICAgIHN3aXRjaCAoX2EubGFiZWwpIHtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAwOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2EudHJ5cy5wdXNoKFswLCAyLCAsIDNdKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuX3N0b3JhZ2VTeW5jXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgM107XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMjpcbiAgICAgICAgICAgICAgICAgICAgICAgIGVfOCA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnRmFpbGVkIHRvIHN5bmMgY2FjaGUgaW5mbyBpbnRvIG1lbW9yeScsIGVfOCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aHJvdyBlXzg7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMzpcbiAgICAgICAgICAgICAgICAgICAgICAgIGlzU2lnbmVkSW5Ib3N0ZWRVSSA9IHRoaXMuX29BdXRoSGFuZGxlclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICYmIHRoaXMuX3N0b3JhZ2UuZ2V0SXRlbSgnYW1wbGlmeS1zaWduaW4td2l0aC1ob3N0ZWRVSScpID09PSAndHJ1ZSc7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzIgLypyZXR1cm4qLywgbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlcywgcmVqKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmIChvcHRzICYmIG9wdHMuZ2xvYmFsKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ3VzZXIgZ2xvYmFsIHNpZ24gb3V0JywgdXNlcik7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAvLyBpbiBvcmRlciB0byB1c2UgZ2xvYmFsIHNpZ25vdXRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC8vIHdlIG11c3QgdmFsaWRhdGUgdGhlIHVzZXIgYXMgYW4gYXV0aGVudGljYXRlZCB1c2VyIGJ5IHVzaW5nIGdldFNlc3Npb25cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHVzZXIuZ2V0U2Vzc2lvbihmdW5jdGlvbiAoZXJyLCByZXN1bHQpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZmFpbGVkIHRvIGdldCB0aGUgdXNlciBzZXNzaW9uJywgZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHJlaihlcnIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB1c2VyLmdsb2JhbFNpZ25PdXQoe1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBvblN1Y2Nlc3M6IGZ1bmN0aW9uIChkYXRhKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2dsb2JhbCBzaWduIG91dCBzdWNjZXNzJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAoaXNTaWduZWRJbkhvc3RlZFVJKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgX3RoaXMuX29BdXRoSGFuZGxlci5zaWduT3V0KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gcmVzKCk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG9uRmFpbHVyZTogZnVuY3Rpb24gKGVycikge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdnbG9iYWwgc2lnbiBvdXQgZmFpbGVkJywgZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiByZWooZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ3VzZXIgc2lnbiBvdXQnLCB1c2VyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHVzZXIuc2lnbk91dCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgaWYgKGlzU2lnbmVkSW5Ib3N0ZWRVSSkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIF90aGlzLl9vQXV0aEhhbmRsZXIuc2lnbk91dCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIHJlcygpO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfSldO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIFNpZ24gb3V0IG1ldGhvZFxuICAgICAqIEBcbiAgICAgKiBAcmV0dXJuIC0gQSBwcm9taXNlIHJlc29sdmVkIGlmIHN1Y2Nlc3NcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLnNpZ25PdXQgPSBmdW5jdGlvbiAob3B0cykge1xuICAgICAgICByZXR1cm4gX19hd2FpdGVyKHRoaXMsIHZvaWQgMCwgdm9pZCAwLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICB2YXIgZV85LCB1c2VyO1xuICAgICAgICAgICAgcmV0dXJuIF9fZ2VuZXJhdG9yKHRoaXMsIGZ1bmN0aW9uIChfYSkge1xuICAgICAgICAgICAgICAgIHN3aXRjaCAoX2EubGFiZWwpIHtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAwOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2EudHJ5cy5wdXNoKFswLCAyLCAsIDNdKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuY2xlYW5DYWNoZWRJdGVtcygpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgM107XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMjpcbiAgICAgICAgICAgICAgICAgICAgICAgIGVfOSA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZmFpbGVkIHRvIGNsZWFyIGNhY2hlZCBpdGVtcycpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgM107XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMzpcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmICghdGhpcy51c2VyUG9vbCkgcmV0dXJuIFszIC8qYnJlYWsqLywgN107XG4gICAgICAgICAgICAgICAgICAgICAgICB1c2VyID0gdGhpcy51c2VyUG9vbC5nZXRDdXJyZW50VXNlcigpO1xuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCF1c2VyKSByZXR1cm4gWzMgLypicmVhayovLCA1XTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuY29nbml0b0lkZW50aXR5U2lnbk91dChvcHRzLCB1c2VyKV07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNDpcbiAgICAgICAgICAgICAgICAgICAgICAgIF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMyAvKmJyZWFrKi8sIDZdO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDU6XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ25vIGN1cnJlbnQgQ29nbml0byB1c2VyJyk7XG4gICAgICAgICAgICAgICAgICAgICAgICBfYS5sYWJlbCA9IDY7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNjogcmV0dXJuIFszIC8qYnJlYWsqLywgOF07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNzpcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnbm8gQ29uZ2l0byBVc2VyIHBvb2wnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIF9hLmxhYmVsID0gODtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA4OlxuICAgICAgICAgICAgICAgICAgICAgICAgLyoqXG4gICAgICAgICAgICAgICAgICAgICAgICAgKiBOb3RlIGZvciBmdXR1cmUgcmVmYWN0b3IgLSBubyByZWxpYWJsZSB3YXkgdG8gZ2V0IHVzZXJuYW1lIHdpdGhcbiAgICAgICAgICAgICAgICAgICAgICAgICAqIENvZ25pdG8gVXNlciBQb29scyB2cyBJZGVudGl0eSB3aGVuIGZlZGVyYXRpbmcgd2l0aCBTb2NpYWwgUHJvdmlkZXJzXG4gICAgICAgICAgICAgICAgICAgICAgICAgKiBUaGlzIGlzIHdoeSB3ZSBuZWVkIGEgd2VsbCBzdHJ1Y3R1cmVkIHNlc3Npb24gb2JqZWN0IHRoYXQgY2FuIGJlIGluc3BlY3RlZFxuICAgICAgICAgICAgICAgICAgICAgICAgICogYW5kIGluZm9ybWF0aW9uIHBhc3NlZCBiYWNrIGluIHRoZSBtZXNzYWdlIGJlbG93IGZvciBIdWIgZGlzcGF0Y2hcbiAgICAgICAgICAgICAgICAgICAgICAgICovXG4gICAgICAgICAgICAgICAgICAgICAgICBkaXNwYXRjaEF1dGhFdmVudCgnc2lnbk91dCcsIHRoaXMudXNlciwgXCJBIHVzZXIgaGFzIGJlZW4gc2lnbmVkIG91dFwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMudXNlciA9IG51bGw7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzIgLypyZXR1cm4qL107XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5jbGVhbkNhY2hlZEl0ZW1zID0gZnVuY3Rpb24gKCkge1xuICAgICAgICByZXR1cm4gX19hd2FpdGVyKHRoaXMsIHZvaWQgMCwgdm9pZCAwLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICByZXR1cm4gX19nZW5lcmF0b3IodGhpcywgZnVuY3Rpb24gKF9hKSB7XG4gICAgICAgICAgICAgICAgc3dpdGNoIChfYS5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDA6IFxuICAgICAgICAgICAgICAgICAgICAvLyBjbGVhciBjb2duaXRvIGNhY2hlZCBpdGVtXG4gICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIGNvcmVfMS5DcmVkZW50aWFscy5jbGVhcigpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgLy8gY2xlYXIgY29nbml0byBjYWNoZWQgaXRlbVxuICAgICAgICAgICAgICAgICAgICAgICAgX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi9dO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIENoYW5nZSBhIHBhc3N3b3JkIGZvciBhbiBhdXRoZW50aWNhdGVkIHVzZXJcbiAgICAgKiBAcGFyYW0ge09iamVjdH0gdXNlciAtIFRoZSBDb2duaXRvVXNlciBvYmplY3RcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gb2xkUGFzc3dvcmQgLSB0aGUgY3VycmVudCBwYXNzd29yZFxuICAgICAqIEBwYXJhbSB7U3RyaW5nfSBuZXdQYXNzd29yZCAtIHRoZSByZXF1ZXN0ZWQgbmV3IHBhc3N3b3JkXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSByZXNvbHZlcyBpZiBzdWNjZXNzXG4gICAgICovXG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5jaGFuZ2VQYXNzd29yZCA9IGZ1bmN0aW9uICh1c2VyLCBvbGRQYXNzd29yZCwgbmV3UGFzc3dvcmQpIHtcbiAgICAgICAgdmFyIF90aGlzID0gdGhpcztcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIF90aGlzLnVzZXJTZXNzaW9uKHVzZXIpLnRoZW4oZnVuY3Rpb24gKHNlc3Npb24pIHtcbiAgICAgICAgICAgICAgICB1c2VyLmNoYW5nZVBhc3N3b3JkKG9sZFBhc3N3b3JkLCBuZXdQYXNzd29yZCwgZnVuY3Rpb24gKGVyciwgZGF0YSkge1xuICAgICAgICAgICAgICAgICAgICBpZiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2NoYW5nZSBwYXNzd29yZCBmYWlsdXJlJywgZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiByZXNvbHZlKGRhdGEpO1xuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICAvKipcbiAgICAgKiBJbml0aWF0ZSBhIGZvcmdvdCBwYXNzd29yZCByZXF1ZXN0XG4gICAgICogQHBhcmFtIHtTdHJpbmd9IHVzZXJuYW1lIC0gdGhlIHVzZXJuYW1lIHRvIGNoYW5nZSBwYXNzd29yZFxuICAgICAqIEByZXR1cm4gLSBBIHByb21pc2UgcmVzb2x2ZXMgaWYgc3VjY2Vzc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuZm9yZ290UGFzc3dvcmQgPSBmdW5jdGlvbiAodXNlcm5hbWUpIHtcbiAgICAgICAgaWYgKCF0aGlzLnVzZXJQb29sKSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ05vIHVzZXJQb29sJyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYgKCF1c2VybmFtZSkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdVc2VybmFtZSBjYW5ub3QgYmUgZW1wdHknKTtcbiAgICAgICAgfVxuICAgICAgICB2YXIgdXNlciA9IHRoaXMuY3JlYXRlQ29nbml0b1VzZXIodXNlcm5hbWUpO1xuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlc29sdmUsIHJlamVjdCkge1xuICAgICAgICAgICAgdXNlci5mb3Jnb3RQYXNzd29yZCh7XG4gICAgICAgICAgICAgICAgb25TdWNjZXNzOiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUoKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgb25GYWlsdXJlOiBmdW5jdGlvbiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZm9yZ290IHBhc3N3b3JkIGZhaWx1cmUnLCBlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZWplY3QoZXJyKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgaW5wdXRWZXJpZmljYXRpb25Db2RlOiBmdW5jdGlvbiAoZGF0YSkge1xuICAgICAgICAgICAgICAgICAgICByZXNvbHZlKGRhdGEpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogQ29uZmlybSBhIG5ldyBwYXNzd29yZCB1c2luZyBhIGNvbmZpcm1hdGlvbiBDb2RlXG4gICAgICogQHBhcmFtIHtTdHJpbmd9IHVzZXJuYW1lIC0gVGhlIHVzZXJuYW1lXG4gICAgICogQHBhcmFtIHtTdHJpbmd9IGNvZGUgLSBUaGUgY29uZmlybWF0aW9uIGNvZGVcbiAgICAgKiBAcGFyYW0ge1N0cmluZ30gcGFzc3dvcmQgLSBUaGUgbmV3IHBhc3N3b3JkXG4gICAgICogQHJldHVybiAtIEEgcHJvbWlzZSB0aGF0IHJlc29sdmVzIGlmIHN1Y2Nlc3NcbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmZvcmdvdFBhc3N3b3JkU3VibWl0ID0gZnVuY3Rpb24gKHVzZXJuYW1lLCBjb2RlLCBwYXNzd29yZCkge1xuICAgICAgICBpZiAoIXRoaXMudXNlclBvb2wpIHtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnTm8gdXNlclBvb2wnKTtcbiAgICAgICAgfVxuICAgICAgICBpZiAoIXVzZXJuYW1lKSB7XG4gICAgICAgICAgICByZXR1cm4gUHJvbWlzZS5yZWplY3QoJ1VzZXJuYW1lIGNhbm5vdCBiZSBlbXB0eScpO1xuICAgICAgICB9XG4gICAgICAgIGlmICghY29kZSkge1xuICAgICAgICAgICAgcmV0dXJuIFByb21pc2UucmVqZWN0KCdDb2RlIGNhbm5vdCBiZSBlbXB0eScpO1xuICAgICAgICB9XG4gICAgICAgIGlmICghcGFzc3dvcmQpIHtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnUGFzc3dvcmQgY2Fubm90IGJlIGVtcHR5Jyk7XG4gICAgICAgIH1cbiAgICAgICAgdmFyIHVzZXIgPSB0aGlzLmNyZWF0ZUNvZ25pdG9Vc2VyKHVzZXJuYW1lKTtcbiAgICAgICAgcmV0dXJuIG5ldyBQcm9taXNlKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcbiAgICAgICAgICAgIHVzZXIuY29uZmlybVBhc3N3b3JkKGNvZGUsIHBhc3N3b3JkLCB7XG4gICAgICAgICAgICAgICAgb25TdWNjZXNzOiBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICAgICAgICAgIHJlc29sdmUoKTtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgb25GYWlsdXJlOiBmdW5jdGlvbiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgICAgIHJlamVjdChlcnIpO1xuICAgICAgICAgICAgICAgICAgICByZXR1cm47XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogR2V0IHVzZXIgaW5mb3JtYXRpb25cbiAgICAgKiBAYXN5bmNcbiAgICAgKiBAcmV0dXJuIHtPYmplY3QgfS0gY3VycmVudCBVc2VyJ3MgaW5mb3JtYXRpb25cbiAgICAgKi9cbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmN1cnJlbnRVc2VySW5mbyA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgcmV0dXJuIF9fYXdhaXRlcih0aGlzLCB2b2lkIDAsIHZvaWQgMCwgZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgdmFyIHNvdXJjZSwgdXNlciwgYXR0cmlidXRlcywgdXNlckF0dHJzLCBjcmVkZW50aWFscywgZV8xMCwgaW5mbywgZXJyXzEsIHVzZXI7XG4gICAgICAgICAgICByZXR1cm4gX19nZW5lcmF0b3IodGhpcywgZnVuY3Rpb24gKF9hKSB7XG4gICAgICAgICAgICAgICAgc3dpdGNoIChfYS5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDA6XG4gICAgICAgICAgICAgICAgICAgICAgICBzb3VyY2UgPSBjb3JlXzEuQ3JlZGVudGlhbHMuZ2V0Q3JlZFNvdXJjZSgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCEoIXNvdXJjZSB8fCBzb3VyY2UgPT09ICdhd3MnIHx8IHNvdXJjZSA9PT0gJ3VzZXJQb29sJykpIHJldHVybiBbMyAvKmJyZWFrKi8sIDldO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgdGhpcy5jdXJyZW50VXNlclBvb2xVc2VyKClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgLmNhdGNoKGZ1bmN0aW9uIChlcnIpIHsgcmV0dXJuIGxvZ2dlci5kZWJ1ZyhlcnIpOyB9KV07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMTpcbiAgICAgICAgICAgICAgICAgICAgICAgIHVzZXIgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoIXVzZXIpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzIgLypyZXR1cm4qLywgbnVsbF07XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICBfYS5sYWJlbCA9IDI7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMjpcbiAgICAgICAgICAgICAgICAgICAgICAgIF9hLnRyeXMucHVzaChbMiwgOCwgLCA5XSk7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzQgLyp5aWVsZCovLCB0aGlzLnVzZXJBdHRyaWJ1dGVzKHVzZXIpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAzOlxuICAgICAgICAgICAgICAgICAgICAgICAgYXR0cmlidXRlcyA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHVzZXJBdHRycyA9IHRoaXMuYXR0cmlidXRlc1RvT2JqZWN0KGF0dHJpYnV0ZXMpO1xuICAgICAgICAgICAgICAgICAgICAgICAgY3JlZGVudGlhbHMgPSBudWxsO1xuICAgICAgICAgICAgICAgICAgICAgICAgX2EubGFiZWwgPSA0O1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDQ6XG4gICAgICAgICAgICAgICAgICAgICAgICBfYS50cnlzLnB1c2goWzQsIDYsICwgN10pO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgdGhpcy5jdXJyZW50Q3JlZGVudGlhbHMoKV07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNTpcbiAgICAgICAgICAgICAgICAgICAgICAgIGNyZWRlbnRpYWxzID0gX2Euc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgN107XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNjpcbiAgICAgICAgICAgICAgICAgICAgICAgIGVfMTAgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ0ZhaWxlZCB0byByZXRyaWV2ZSBjcmVkZW50aWFscyB3aGlsZSBnZXR0aW5nIGN1cnJlbnQgdXNlciBpbmZvJywgZV8xMCk7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzMgLypicmVhayovLCA3XTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA3OlxuICAgICAgICAgICAgICAgICAgICAgICAgaW5mbyA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAnaWQnOiBjcmVkZW50aWFscyA/IGNyZWRlbnRpYWxzLmlkZW50aXR5SWQgOiB1bmRlZmluZWQsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgJ3VzZXJuYW1lJzogdXNlci5nZXRVc2VybmFtZSgpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICdhdHRyaWJ1dGVzJzogdXNlckF0dHJzXG4gICAgICAgICAgICAgICAgICAgICAgICB9O1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi8sIGluZm9dO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDg6XG4gICAgICAgICAgICAgICAgICAgICAgICBlcnJfMSA9IF9hLnNlbnQoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnY3VycmVudFVzZXJJbmZvIGVycm9yJywgZXJyXzEpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi8sIHt9XTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA5OlxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKHNvdXJjZSA9PT0gJ2ZlZGVyYXRlZCcpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB1c2VyID0gdGhpcy51c2VyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMiAvKnJldHVybiovLCB1c2VyID8gdXNlciA6IHt9XTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMiAvKnJldHVybiovXTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICBBdXRoQ2xhc3MucHJvdG90eXBlLmZlZGVyYXRlZFNpZ25JbiA9IGZ1bmN0aW9uIChwcm92aWRlck9yT3B0aW9ucywgcmVzcG9uc2UsIHVzZXIpIHtcbiAgICAgICAgcmV0dXJuIF9fYXdhaXRlcih0aGlzLCB2b2lkIDAsIHZvaWQgMCwgZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgdmFyIG9wdGlvbnMsIHByb3ZpZGVyLCBjbGllbnRfaWQsIHJlZGlyZWN0X3VyaSwgcHJvdmlkZXIsIGxvZ2dlZEluVXNlciwgZV8xMSwgdG9rZW4sIGlkZW50aXR5X2lkLCBleHBpcmVzX2F0LCBjcmVkZW50aWFscywgY3VycmVudFVzZXI7XG4gICAgICAgICAgICByZXR1cm4gX19nZW5lcmF0b3IodGhpcywgZnVuY3Rpb24gKF9hKSB7XG4gICAgICAgICAgICAgICAgc3dpdGNoIChfYS5sYWJlbCkge1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDA6XG4gICAgICAgICAgICAgICAgICAgICAgICBpZiAoIXRoaXMuX2NvbmZpZy5pZGVudGl0eVBvb2xJZCAmJiAhdGhpcy5fY29uZmlnLnVzZXJQb29sSWQpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXCJGZWRlcmF0aW9uIHJlcXVpcmVzIGVpdGhlciBhIFVzZXIgUG9vbCBvciBJZGVudGl0eSBQb29sIGluIGNvbmZpZ1wiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIC8vIEVuc3VyZSBiYWNrd2FyZHMgY29tcGF0YWJpbGl0eVxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKHR5cGVvZiBwcm92aWRlck9yT3B0aW9ucyA9PT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpZiAodGhpcy5fY29uZmlnLmlkZW50aXR5UG9vbElkICYmICF0aGlzLl9jb25maWcudXNlclBvb2xJZCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXCJGZWRlcmF0aW9uIHdpdGggSWRlbnRpdHkgUG9vbHMgcmVxdWlyZXMgdG9rZW5zIHBhc3NlZCBhcyBhcmd1bWVudHNcIik7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCEodHlwZXNfMS5pc0ZlZGVyYXRlZFNpZ25Jbk9wdGlvbnMocHJvdmlkZXJPck9wdGlvbnMpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfHwgdHlwZXNfMS5pc0ZlZGVyYXRlZFNpZ25Jbk9wdGlvbnNDdXN0b20ocHJvdmlkZXJPck9wdGlvbnMpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgfHwgdHlwZW9mIHByb3ZpZGVyT3JPcHRpb25zID09PSAndW5kZWZpbmVkJykpIHJldHVybiBbMyAvKmJyZWFrKi8sIDFdO1xuICAgICAgICAgICAgICAgICAgICAgICAgb3B0aW9ucyA9IHByb3ZpZGVyT3JPcHRpb25zIHx8IHsgcHJvdmlkZXI6IENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXIuQ29nbml0byB9O1xuICAgICAgICAgICAgICAgICAgICAgICAgcHJvdmlkZXIgPSB0eXBlc18xLmlzRmVkZXJhdGVkU2lnbkluT3B0aW9ucyhvcHRpb25zKVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgID8gb3B0aW9ucy5wcm92aWRlclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIDogb3B0aW9ucy5jdXN0b21Qcm92aWRlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmICh0aGlzLl9jb25maWcudXNlclBvb2xJZCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGNsaWVudF9pZCA9IHR5cGVzXzEuaXNDb2duaXRvSG9zdGVkT3B0cyh0aGlzLl9jb25maWcub2F1dGgpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgID8gdGhpcy5fY29uZmlnLnVzZXJQb29sV2ViQ2xpZW50SWRcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgOiB0aGlzLl9jb25maWcub2F1dGguY2xpZW50SUQ7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgcmVkaXJlY3RfdXJpID0gdHlwZXNfMS5pc0NvZ25pdG9Ib3N0ZWRPcHRzKHRoaXMuX2NvbmZpZy5vYXV0aClcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPyB0aGlzLl9jb25maWcub2F1dGgucmVkaXJlY3RTaWduSW5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgOiB0aGlzLl9jb25maWcub2F1dGgucmVkaXJlY3RVcmk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5fb0F1dGhIYW5kbGVyLm9hdXRoU2lnbkluKHRoaXMuX2NvbmZpZy5vYXV0aC5yZXNwb25zZVR5cGUsIHRoaXMuX2NvbmZpZy5vYXV0aC5kb21haW4sIHJlZGlyZWN0X3VyaSwgY2xpZW50X2lkLCBwcm92aWRlcik7XG4gICAgICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzMgLypicmVhayovLCA4XTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAxOlxuICAgICAgICAgICAgICAgICAgICAgICAgcHJvdmlkZXIgPSBwcm92aWRlck9yT3B0aW9ucztcbiAgICAgICAgICAgICAgICAgICAgICAgIF9hLmxhYmVsID0gMjtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAyOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2EudHJ5cy5wdXNoKFsyLCA0LCAsIDVdKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIHRoaXMuY3VycmVudEF1dGhlbnRpY2F0ZWRVc2VyKCldO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDM6XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZWRJblVzZXIgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIud2FybihcIlRoZXJlIGlzIGFscmVhZHkgYSBzaWduZWQgaW4gdXNlcjogXCIgKyBsb2dnZWRJblVzZXIgKyBcIiBpbiB5b3VyIGFwcC5cXG4gICAgICAgICAgICAgICAgWW91IHNob3VsZCBub3QgY2FsbCBBdXRoLmZlZGVyYXRlZFNpZ25JbiBtZXRob2QgYWdhaW4gYXMgaXQgbWF5IGNhdXNlIHVuZXhwZWN0ZWQgYmVoYXZpb3IuXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFszIC8qYnJlYWsqLywgNV07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNDpcbiAgICAgICAgICAgICAgICAgICAgICAgIGVfMTEgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzMgLypicmVhayovLCA1XTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA1OlxuICAgICAgICAgICAgICAgICAgICAgICAgdG9rZW4gPSByZXNwb25zZS50b2tlbiwgaWRlbnRpdHlfaWQgPSByZXNwb25zZS5pZGVudGl0eV9pZCwgZXhwaXJlc19hdCA9IHJlc3BvbnNlLmV4cGlyZXNfYXQ7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzQgLyp5aWVsZCovLCBjb3JlXzEuQ3JlZGVudGlhbHMuc2V0KHsgcHJvdmlkZXI6IHByb3ZpZGVyLCB0b2tlbjogdG9rZW4sIGlkZW50aXR5X2lkOiBpZGVudGl0eV9pZCwgdXNlcjogdXNlciwgZXhwaXJlc19hdDogZXhwaXJlc19hdCB9LCAnZmVkZXJhdGlvbicpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA2OlxuICAgICAgICAgICAgICAgICAgICAgICAgY3JlZGVudGlhbHMgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzQgLyp5aWVsZCovLCB0aGlzLmN1cnJlbnRBdXRoZW50aWNhdGVkVXNlcigpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA3OlxuICAgICAgICAgICAgICAgICAgICAgICAgY3VycmVudFVzZXIgPSBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBkaXNwYXRjaEF1dGhFdmVudCgnc2lnbkluJywgY3VycmVudFVzZXIsIFwiQSB1c2VyIFwiICsgY3VycmVudFVzZXIudXNlcm5hbWUgKyBcIiBoYXMgYmVlbiBzaWduZWQgaW5cIik7XG4gICAgICAgICAgICAgICAgICAgICAgICBsb2dnZXIuZGVidWcoJ2ZlZGVyYXRlZCBzaWduIGluIGNyZWRlbnRpYWxzJywgY3JlZGVudGlhbHMpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFsyIC8qcmV0dXJuKi8sIGNyZWRlbnRpYWxzXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSA4OiByZXR1cm4gWzIgLypyZXR1cm4qL107XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSk7XG4gICAgICAgIH0pO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogVXNlZCB0byBjb21wbGV0ZSB0aGUgT0F1dGggZmxvdyB3aXRoIG9yIHdpdGhvdXQgdGhlIENvZ25pdG8gSG9zdGVkIFVJXG4gICAgICogQHBhcmFtIHtTdHJpbmd9IFVSTCAtIG9wdGlvbmFsIHBhcmFtZXRlciBmb3IgY3VzdG9tZXJzIHRvIHBhc3MgaW4gdGhlIHJlc3BvbnNlIFVSTFxuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuX2hhbmRsZUF1dGhSZXNwb25zZSA9IGZ1bmN0aW9uIChVUkwpIHtcbiAgICAgICAgcmV0dXJuIF9fYXdhaXRlcih0aGlzLCB2b2lkIDAsIHZvaWQgMCwgZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgdmFyIGN1cnJlbnRVcmwsIGhhc0NvZGVPckVycm9yLCBoYXNUb2tlbk9yRXJyb3IsIF9hLCBhY2Nlc3NUb2tlbiwgaWRUb2tlbiwgcmVmcmVzaFRva2VuLCBzZXNzaW9uLCBjcmVkZW50aWFscywgY3VycmVudFVzZXIsIGVycl8yO1xuICAgICAgICAgICAgcmV0dXJuIF9fZ2VuZXJhdG9yKHRoaXMsIGZ1bmN0aW9uIChfYikge1xuICAgICAgICAgICAgICAgIHN3aXRjaCAoX2IubGFiZWwpIHtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAwOlxuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCF0aGlzLl9jb25maWcudXNlclBvb2xJZCkge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcihcIk9BdXRoIHJlc3BvbnNlcyByZXF1aXJlIGEgVXNlciBQb29sIGRlZmluZWQgaW4gY29uZmlnXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgY3VycmVudFVybCA9IFVSTCB8fCB3aW5kb3cubG9jYXRpb24uaHJlZjtcbiAgICAgICAgICAgICAgICAgICAgICAgIGhhc0NvZGVPckVycm9yID0gISEodXJsXzEucGFyc2UoY3VycmVudFVybCkucXVlcnkgfHwgJycpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLnNwbGl0KCcmJylcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAubWFwKGZ1bmN0aW9uIChlbnRyeSkgeyByZXR1cm4gZW50cnkuc3BsaXQoJz0nKTsgfSlcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAuZmluZChmdW5jdGlvbiAoX2EpIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICB2YXIgayA9IF9hWzBdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBrID09PSAnY29kZScgfHwgayA9PT0gJ2Vycm9yJztcbiAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgaGFzVG9rZW5PckVycm9yID0gISEodXJsXzEucGFyc2UoY3VycmVudFVybCkuaGFzaCB8fCAnIycpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLnN1YnN0cigxKVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIC5zcGxpdCgnJicpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLm1hcChmdW5jdGlvbiAoZW50cnkpIHsgcmV0dXJuIGVudHJ5LnNwbGl0KCc9Jyk7IH0pXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgLmZpbmQoZnVuY3Rpb24gKF9hKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFyIGsgPSBfYVswXTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gayA9PT0gJ2FjY2Vzc190b2tlbicgfHwgayA9PT0gJ2Vycm9yJztcbiAgICAgICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgICAgICAgICAgaWYgKCEoaGFzQ29kZU9yRXJyb3IgfHwgaGFzVG9rZW5PckVycm9yKSkgcmV0dXJuIFszIC8qYnJlYWsqLywgNl07XG4gICAgICAgICAgICAgICAgICAgICAgICBfYi5sYWJlbCA9IDE7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMTpcbiAgICAgICAgICAgICAgICAgICAgICAgIF9iLnRyeXMucHVzaChbMSwgNSwgLCA2XSk7XG4gICAgICAgICAgICAgICAgICAgICAgICByZXR1cm4gWzQgLyp5aWVsZCovLCB0aGlzLl9vQXV0aEhhbmRsZXIuaGFuZGxlQXV0aFJlc3BvbnNlKGN1cnJlbnRVcmwpXTtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAyOlxuICAgICAgICAgICAgICAgICAgICAgICAgX2EgPSBfYi5zZW50KCksIGFjY2Vzc1Rva2VuID0gX2EuYWNjZXNzVG9rZW4sIGlkVG9rZW4gPSBfYS5pZFRva2VuLCByZWZyZXNoVG9rZW4gPSBfYS5yZWZyZXNoVG9rZW47XG4gICAgICAgICAgICAgICAgICAgICAgICBzZXNzaW9uID0gbmV3IGFtYXpvbl9jb2duaXRvX2lkZW50aXR5X2pzXzEuQ29nbml0b1VzZXJTZXNzaW9uKHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBJZFRva2VuOiBuZXcgYW1hem9uX2NvZ25pdG9faWRlbnRpdHlfanNfMS5Db2duaXRvSWRUb2tlbih7IElkVG9rZW46IGlkVG9rZW4gfSksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgUmVmcmVzaFRva2VuOiBuZXcgYW1hem9uX2NvZ25pdG9faWRlbnRpdHlfanNfMS5Db2duaXRvUmVmcmVzaFRva2VuKHsgUmVmcmVzaFRva2VuOiByZWZyZXNoVG9rZW4gfSksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgQWNjZXNzVG9rZW46IG5ldyBhbWF6b25fY29nbml0b19pZGVudGl0eV9qc18xLkNvZ25pdG9BY2Nlc3NUb2tlbih7IEFjY2Vzc1Rva2VuOiBhY2Nlc3NUb2tlbiB9KVxuICAgICAgICAgICAgICAgICAgICAgICAgfSk7XG4gICAgICAgICAgICAgICAgICAgICAgICBjcmVkZW50aWFscyA9IHZvaWQgMDtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmICghdGhpcy5fY29uZmlnLmlkZW50aXR5UG9vbElkKSByZXR1cm4gWzMgLypicmVhayovLCA0XTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbNCAvKnlpZWxkKi8sIGNvcmVfMS5DcmVkZW50aWFscy5zZXQoc2Vzc2lvbiwgJ3Nlc3Npb24nKV07XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMzpcbiAgICAgICAgICAgICAgICAgICAgICAgIGNyZWRlbnRpYWxzID0gX2Iuc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdBV1MgY3JlZGVudGlhbHMnLCBjcmVkZW50aWFscyk7XG4gICAgICAgICAgICAgICAgICAgICAgICBfYi5sYWJlbCA9IDQ7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNDpcbiAgICAgICAgICAgICAgICAgICAgICAgIGN1cnJlbnRVc2VyID0gdGhpcy5jcmVhdGVDb2duaXRvVXNlcihzZXNzaW9uLmdldElkVG9rZW4oKS5kZWNvZGVQYXlsb2FkKClbJ2NvZ25pdG86dXNlcm5hbWUnXSk7XG4gICAgICAgICAgICAgICAgICAgICAgICBkaXNwYXRjaEF1dGhFdmVudCgnc2lnbkluJywgY3VycmVudFVzZXIsIFwiQSB1c2VyIFwiICsgY3VycmVudFVzZXIuZ2V0VXNlcm5hbWUoKSArIFwiIGhhcyBiZWVuIHNpZ25lZCBpblwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGRpc3BhdGNoQXV0aEV2ZW50KCdjb2duaXRvSG9zdGVkVUknLCBjdXJyZW50VXNlciwgXCJBIHVzZXIgXCIgKyBjdXJyZW50VXNlci5nZXRVc2VybmFtZSgpICsgXCIgaGFzIGJlZW4gc2lnbmVkIGluIHZpYSBDb2duaXRvIEhvc3RlZCBVSVwiKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIC8vIFRoaXMgY2FsbHMgY2FjaGVUb2tlbnMoKSBpbiBDb2duaXRvIFNES1xuICAgICAgICAgICAgICAgICAgICAgICAgY3VycmVudFVzZXIuc2V0U2lnbkluVXNlclNlc3Npb24oc2Vzc2lvbik7XG4gICAgICAgICAgICAgICAgICAgICAgICAvLyNlbmRyZWdpb25cbiAgICAgICAgICAgICAgICAgICAgICAgIGlmICh3aW5kb3cgJiYgdHlwZW9mIHdpbmRvdy5oaXN0b3J5ICE9PSAndW5kZWZpbmVkJykge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIHdpbmRvdy5oaXN0b3J5LnJlcGxhY2VTdGF0ZSh7fSwgbnVsbCwgdGhpcy5fY29uZmlnLm9hdXRoLnJlZGlyZWN0U2lnbkluKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiBbMiAvKnJldHVybiovLCBjcmVkZW50aWFsc107XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNTpcbiAgICAgICAgICAgICAgICAgICAgICAgIGVycl8yID0gX2Iuc2VudCgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKFwiRXJyb3IgaW4gY29nbml0byBob3N0ZWQgYXV0aCByZXNwb25zZVwiLCBlcnJfMik7XG4gICAgICAgICAgICAgICAgICAgICAgICBkaXNwYXRjaEF1dGhFdmVudCgnc2lnbkluX2ZhaWx1cmUnLCBlcnJfMiwgXCJUaGUgT0F1dGggcmVzcG9uc2UgZmxvdyBmYWlsZWRcIik7XG4gICAgICAgICAgICAgICAgICAgICAgICBkaXNwYXRjaEF1dGhFdmVudCgnY29nbml0b0hvc3RlZFVJX2ZhaWx1cmUnLCBlcnJfMiwgXCJBIGZhaWx1cmUgb2NjdXJyZWQgd2hlbiByZXR1cm5pbmcgdG8gdGhlIENvZ25pdG8gSG9zdGVkIFVJXCIpO1xuICAgICAgICAgICAgICAgICAgICAgICAgdGhyb3cgZXJyXzI7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgNjogcmV0dXJuIFsyIC8qcmV0dXJuKi9dO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIENvbXBhY3QgdmVyc2lvbiBvZiBjcmVkZW50aWFsc1xuICAgICAqIEBwYXJhbSB7T2JqZWN0fSBjcmVkZW50aWFsc1xuICAgICAqIEByZXR1cm4ge09iamVjdH0gLSBDcmVkZW50aWFsc1xuICAgICAqL1xuICAgIEF1dGhDbGFzcy5wcm90b3R5cGUuZXNzZW50aWFsQ3JlZGVudGlhbHMgPSBmdW5jdGlvbiAoY3JlZGVudGlhbHMpIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFjY2Vzc0tleUlkOiBjcmVkZW50aWFscy5hY2Nlc3NLZXlJZCxcbiAgICAgICAgICAgIHNlc3Npb25Ub2tlbjogY3JlZGVudGlhbHMuc2Vzc2lvblRva2VuLFxuICAgICAgICAgICAgc2VjcmV0QWNjZXNzS2V5OiBjcmVkZW50aWFscy5zZWNyZXRBY2Nlc3NLZXksXG4gICAgICAgICAgICBpZGVudGl0eUlkOiBjcmVkZW50aWFscy5pZGVudGl0eUlkLFxuICAgICAgICAgICAgYXV0aGVudGljYXRlZDogY3JlZGVudGlhbHMuYXV0aGVudGljYXRlZFxuICAgICAgICB9O1xuICAgIH07XG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5hdHRyaWJ1dGVzVG9PYmplY3QgPSBmdW5jdGlvbiAoYXR0cmlidXRlcykge1xuICAgICAgICB2YXIgb2JqID0ge307XG4gICAgICAgIGlmIChhdHRyaWJ1dGVzKSB7XG4gICAgICAgICAgICBhdHRyaWJ1dGVzLm1hcChmdW5jdGlvbiAoYXR0cmlidXRlKSB7XG4gICAgICAgICAgICAgICAgaWYgKGF0dHJpYnV0ZS5WYWx1ZSA9PT0gJ3RydWUnKSB7XG4gICAgICAgICAgICAgICAgICAgIG9ialthdHRyaWJ1dGUuTmFtZV0gPSB0cnVlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIGlmIChhdHRyaWJ1dGUuVmFsdWUgPT09ICdmYWxzZScpIHtcbiAgICAgICAgICAgICAgICAgICAgb2JqW2F0dHJpYnV0ZS5OYW1lXSA9IGZhbHNlO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgb2JqW2F0dHJpYnV0ZS5OYW1lXSA9IGF0dHJpYnV0ZS5WYWx1ZTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gb2JqO1xuICAgIH07XG4gICAgQXV0aENsYXNzLnByb3RvdHlwZS5jcmVhdGVDb2duaXRvVXNlciA9IGZ1bmN0aW9uICh1c2VybmFtZSkge1xuICAgICAgICB2YXIgdXNlckRhdGEgPSB7XG4gICAgICAgICAgICBVc2VybmFtZTogdXNlcm5hbWUsXG4gICAgICAgICAgICBQb29sOiB0aGlzLnVzZXJQb29sLFxuICAgICAgICB9O1xuICAgICAgICB1c2VyRGF0YS5TdG9yYWdlID0gdGhpcy5fc3RvcmFnZTtcbiAgICAgICAgdmFyIGF1dGhlbnRpY2F0aW9uRmxvd1R5cGUgPSB0aGlzLl9jb25maWcuYXV0aGVudGljYXRpb25GbG93VHlwZTtcbiAgICAgICAgdmFyIHVzZXIgPSBuZXcgYW1hem9uX2NvZ25pdG9faWRlbnRpdHlfanNfMS5Db2duaXRvVXNlcih1c2VyRGF0YSk7XG4gICAgICAgIGlmIChhdXRoZW50aWNhdGlvbkZsb3dUeXBlKSB7XG4gICAgICAgICAgICB1c2VyLnNldEF1dGhlbnRpY2F0aW9uRmxvd1R5cGUoYXV0aGVudGljYXRpb25GbG93VHlwZSk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHVzZXI7XG4gICAgfTtcbiAgICByZXR1cm4gQXV0aENsYXNzO1xufSgpKTtcbmV4cG9ydHMuZGVmYXVsdCA9IEF1dGhDbGFzcztcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPUF1dGguanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/Auth.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/auth/lib/OAuth/OAuth.js":
/*!***********************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/OAuth/OAuth.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar __assign = (this && this.__assign) || Object.assign || function(t) {\n    for (var s, i = 1, n = arguments.length; i < n; i++) {\n        s = arguments[i];\n        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))\n            t[p] = s[p];\n    }\n    return t;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), \"throw\": verb(1), \"return\": verb(2) }, typeof Symbol === \"function\" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError(\"Generator is already executing.\");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y[\"return\"] : op[0] ? y[\"throw\"] || ((t = y[\"return\"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar url_1 = __webpack_require__(/*! url */ \"./node_modules/url/url.js\"); // Used for OAuth parsing of Cognito Hosted UI\nvar urlOpener_1 = __webpack_require__(/*! ./urlOpener */ \"./node_modules/@aws-amplify/auth/lib/OAuth/urlOpener.js\");\nvar oAuthStorage = __webpack_require__(/*! ./oauthStorage */ \"./node_modules/@aws-amplify/auth/lib/OAuth/oauthStorage.js\");\nvar Auth_1 = __webpack_require__(/*! ../types/Auth */ \"./node_modules/@aws-amplify/auth/lib/types/Auth.js\");\nvar core_1 = __webpack_require__(/*! @aws-amplify/core */ \"./node_modules/@aws-amplify/core/lib/index.js\");\nvar SHA256 = __webpack_require__(/*! crypto-js/sha256 */ \"./node_modules/crypto-js/sha256.js\");\nvar Base64 = __webpack_require__(/*! crypto-js/enc-base64 */ \"./node_modules/crypto-js/enc-base64.js\");\nvar AMPLIFY_SYMBOL = ((typeof Symbol !== 'undefined' && typeof Symbol.for === 'function') ?\n    Symbol.for('amplify_default') : '@@amplify_default');\nvar dispatchAuthEvent = function (event, data, message) {\n    core_1.Hub.dispatch('auth', { event: event, data: data, message: message }, 'Auth', AMPLIFY_SYMBOL);\n};\nvar logger = new core_1.ConsoleLogger('OAuth');\nvar OAuth = /** @class */ (function () {\n    function OAuth(_a) {\n        var config = _a.config, cognitoClientId = _a.cognitoClientId, _b = _a.scopes, scopes = _b === void 0 ? [] : _b;\n        this._urlOpener = config.urlOpener || urlOpener_1.launchUri;\n        this._config = config;\n        this._cognitoClientId = cognitoClientId;\n        this._scopes = scopes;\n    }\n    OAuth.prototype.oauthSignIn = function (responseType, domain, redirectSignIn, clientId, provider) {\n        if (responseType === void 0) { responseType = 'code'; }\n        if (provider === void 0) { provider = Auth_1.CognitoHostedUIIdentityProvider.Cognito; }\n        var state = this._generateState(32);\n        oAuthStorage.setState(state);\n        var pkce_key = this._generateRandom(128);\n        oAuthStorage.setPKCE(pkce_key);\n        var code_challenge = this._generateChallenge(pkce_key);\n        var code_challenge_method = 'S256';\n        var queryString = Object.entries(__assign({ redirect_uri: redirectSignIn, response_type: responseType, client_id: clientId, identity_provider: provider, scopes: this._scopes, state: state }, (responseType === 'code' ? { code_challenge: code_challenge } : {}), (responseType === 'code' ? { code_challenge_method: code_challenge_method } : {}))).map(function (_a) {\n            var k = _a[0], v = _a[1];\n            return encodeURIComponent(k) + \"=\" + encodeURIComponent(v);\n        }).join('&');\n        var URL = \"https://\" + domain + \"/oauth2/authorize?\" + queryString;\n        logger.debug(\"Redirecting to \" + URL);\n        this._urlOpener(URL, redirectSignIn);\n    };\n    OAuth.prototype._handleCodeFlow = function (currentUrl) {\n        return __awaiter(this, void 0, void 0, function () {\n            var code, oAuthTokenEndpoint, client_id, redirect_uri, code_verifier, oAuthTokenBody, body, _a, access_token, refresh_token, id_token, error;\n            return __generator(this, function (_b) {\n                switch (_b.label) {\n                    case 0:\n                        code = (url_1.parse(currentUrl).query || '')\n                            .split('&')\n                            .map(function (pairings) { return pairings.split('='); })\n                            .reduce(function (accum, _a) {\n                            var k = _a[0], v = _a[1];\n                            var _b;\n                            return (__assign({}, accum, (_b = {}, _b[k] = v, _b)));\n                        }, { code: undefined }).code;\n                        if (!code) {\n                            return [2 /*return*/];\n                        }\n                        oAuthTokenEndpoint = 'https://' + this._config.domain + '/oauth2/token';\n                        dispatchAuthEvent('codeFlow', {}, \"Retrieving tokens from \" + oAuthTokenEndpoint);\n                        client_id = Auth_1.isCognitoHostedOpts(this._config)\n                            ? this._cognitoClientId\n                            : this._config.clientID;\n                        redirect_uri = Auth_1.isCognitoHostedOpts(this._config)\n                            ? this._config.redirectSignIn\n                            : this._config.redirectUri;\n                        code_verifier = oAuthStorage.getPKCE();\n                        oAuthTokenBody = __assign({ grant_type: 'authorization_code', code: code,\n                            client_id: client_id,\n                            redirect_uri: redirect_uri }, (code_verifier ? { code_verifier: code_verifier } : {}));\n                        logger.debug(\"Calling token endpoint: \" + oAuthTokenEndpoint + \" with\", oAuthTokenBody);\n                        body = Object.entries(oAuthTokenBody)\n                            .map(function (_a) {\n                            var k = _a[0], v = _a[1];\n                            return encodeURIComponent(k) + \"=\" + encodeURIComponent(v);\n                        })\n                            .join('&');\n                        return [4 /*yield*/, fetch(oAuthTokenEndpoint, {\n                                method: 'POST',\n                                headers: {\n                                    'Content-Type': 'application/x-www-form-urlencoded'\n                                },\n                                body: typeof URLSearchParams !== 'undefined' ? new URLSearchParams(body) : body\n                            })];\n                    case 1: return [4 /*yield*/, (_b.sent()).json()];\n                    case 2:\n                        _a = _b.sent(), access_token = _a.access_token, refresh_token = _a.refresh_token, id_token = _a.id_token, error = _a.error;\n                        if (error) {\n                            throw new Error(error);\n                        }\n                        return [2 /*return*/, {\n                                accessToken: access_token,\n                                refreshToken: refresh_token,\n                                idToken: id_token\n                            }];\n                }\n            });\n        });\n    };\n    OAuth.prototype._handleImplicitFlow = function (currentUrl) {\n        return __awaiter(this, void 0, void 0, function () {\n            var _a, id_token, access_token;\n            return __generator(this, function (_b) {\n                _a = url_1.parse(currentUrl).hash\n                    .substr(1) // Remove # from returned code\n                    .split('&')\n                    .map(function (pairings) { return pairings.split('='); })\n                    .reduce(function (accum, _a) {\n                    var k = _a[0], v = _a[1];\n                    var _b;\n                    return (__assign({}, accum, (_b = {}, _b[k] = v, _b)));\n                }, {\n                    id_token: undefined, access_token: undefined\n                }), id_token = _a.id_token, access_token = _a.access_token;\n                dispatchAuthEvent('implicitFlow', {}, \"Got tokens from \" + currentUrl);\n                logger.debug(\"Retrieving implicit tokens from \" + currentUrl + \" with\");\n                return [2 /*return*/, {\n                        accessToken: access_token,\n                        idToken: id_token,\n                        refreshToken: null\n                    }];\n            });\n        });\n    };\n    OAuth.prototype.handleAuthResponse = function (currentUrl) {\n        return __awaiter(this, void 0, void 0, function () {\n            var urlParams, error, error_description;\n            return __generator(this, function (_a) {\n                urlParams = currentUrl ? __assign({}, (url_1.parse(currentUrl).hash || '#').substr(1)\n                    .split('&')\n                    .map(function (entry) { return entry.split('='); })\n                    .reduce(function (acc, _a) {\n                    var k = _a[0], v = _a[1];\n                    return (acc[k] = v, acc);\n                }, {}), (url_1.parse(currentUrl).query || '')\n                    .split('&')\n                    .map(function (entry) { return entry.split('='); })\n                    .reduce(function (acc, _a) {\n                    var k = _a[0], v = _a[1];\n                    return (acc[k] = v, acc);\n                }, {})) : {};\n                error = urlParams.error, error_description = urlParams.error_description;\n                if (error) {\n                    throw new Error(error_description);\n                }\n                this._validateState(urlParams);\n                logger.debug(\"Starting \" + this._config.responseType + \" flow with \" + currentUrl);\n                if (this._config.responseType === 'code') {\n                    return [2 /*return*/, this._handleCodeFlow(currentUrl)];\n                }\n                else {\n                    return [2 /*return*/, this._handleImplicitFlow(currentUrl)];\n                }\n                return [2 /*return*/];\n            });\n        });\n    };\n    OAuth.prototype._validateState = function (urlParams) {\n        if (!urlParams) {\n            return;\n        }\n        var savedState = oAuthStorage.getState();\n        var returnedState = urlParams.state;\n        // This is because savedState only exists if the flow was initiated by Amplify\n        if (savedState && savedState !== returnedState) {\n            throw new Error('Invalid state in OAuth flow');\n        }\n    };\n    OAuth.prototype.signOut = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            var oAuthLogoutEndpoint, client_id, signout_uri;\n            return __generator(this, function (_a) {\n                oAuthLogoutEndpoint = 'https://' + this._config.domain + '/logout?';\n                client_id = Auth_1.isCognitoHostedOpts(this._config)\n                    ? this._cognitoClientId\n                    : this._config.oauth.clientID;\n                signout_uri = Auth_1.isCognitoHostedOpts(this._config)\n                    ? this._config.redirectSignOut\n                    : this._config.returnTo;\n                oAuthLogoutEndpoint += Object.entries({\n                    client_id: client_id,\n                    logout_uri: encodeURIComponent(signout_uri)\n                }).map(function (_a) {\n                    var k = _a[0], v = _a[1];\n                    return k + \"=\" + v;\n                }).join('&');\n                dispatchAuthEvent('oAuthSignOut', { oAuth: 'signOut' }, \"Signing out from \" + oAuthLogoutEndpoint);\n                logger.debug(\"Signing out from \" + oAuthLogoutEndpoint);\n                this._urlOpener(oAuthLogoutEndpoint);\n                return [2 /*return*/];\n            });\n        });\n    };\n    OAuth.prototype._generateState = function (length) {\n        var result = '';\n        var i = length;\n        var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';\n        for (; i > 0; --i)\n            result += chars[Math.round(Math.random() * (chars.length - 1))];\n        return result;\n    };\n    OAuth.prototype._generateChallenge = function (code) {\n        return this._base64URL(SHA256(code));\n    };\n    OAuth.prototype._base64URL = function (string) {\n        return string.toString(Base64).replace(/=/g, '').replace(/\\+/g, '-').replace(/\\//g, '_');\n    };\n    OAuth.prototype._generateRandom = function (size) {\n        var CHARSET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~';\n        var buffer = new Uint8Array(size);\n        if (typeof window !== 'undefined' && !!(window.crypto)) {\n            window.crypto.getRandomValues(buffer);\n        }\n        else {\n            for (var i = 0; i < size; i += 1) {\n                buffer[i] = (Math.random() * CHARSET.length) | 0;\n            }\n        }\n        return this._bufferToString(buffer);\n    };\n    OAuth.prototype._bufferToString = function (buffer) {\n        var CHARSET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';\n        var state = [];\n        for (var i = 0; i < buffer.byteLength; i += 1) {\n            var index = buffer[i] % CHARSET.length;\n            state.push(CHARSET[index]);\n        }\n        return state.join('');\n    };\n    return OAuth;\n}());\nexports.default = OAuth;\n//# sourceMappingURL=OAuth.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/OAuth/OAuth.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/auth/lib/OAuth/oauthStorage.js":
/*!******************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/OAuth/oauthStorage.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nexports.setState = function (state) {\n    window.sessionStorage.setItem('oauth_state', state);\n};\nexports.getState = function () {\n    var oauth_state = window.sessionStorage.getItem('oauth_state');\n    window.sessionStorage.removeItem('oauth_state');\n    return oauth_state;\n};\nexports.setPKCE = function (private_key) {\n    window.sessionStorage.setItem('ouath_pkce_key', private_key);\n};\nexports.getPKCE = function () {\n    var ouath_pkce_key = window.sessionStorage.getItem('ouath_pkce_key');\n    window.sessionStorage.removeItem('ouath_pkce_key');\n    return ouath_pkce_key;\n};\nexports.clearAll = function () {\n    window.sessionStorage.removeItem('ouath_pkce_key');\n    window.sessionStorage.removeItem('oauth_state');\n};\n//# sourceMappingURL=oauthStorage.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/OAuth/oauthStorage.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/auth/lib/OAuth/urlOpener.js":
/*!***************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/OAuth/urlOpener.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar SELF = '_self';\nexports.launchUri = function (url) { return window.open(url, SELF); };\n//# sourceMappingURL=urlOpener.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2F1dGgvbGliL09BdXRoL3VybE9wZW5lci5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AYXdzLWFtcGxpZnkvYXV0aC9saWIvT0F1dGgvdXJsT3BlbmVyLmpzP2U1YmUiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG4vKlxuICogQ29weXJpZ2h0IDIwMTctMjAxNyBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aFxuICogdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgIGh0dHA6Ly9hd3MuYW1hem9uLmNvbS9hcGFjaGUyLjAvXG4gKlxuICogb3IgaW4gdGhlIFwibGljZW5zZVwiIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTIE9SXG4gKiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xudmFyIFNFTEYgPSAnX3NlbGYnO1xuZXhwb3J0cy5sYXVuY2hVcmkgPSBmdW5jdGlvbiAodXJsKSB7IHJldHVybiB3aW5kb3cub3Blbih1cmwsIFNFTEYpOyB9O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9dXJsT3BlbmVyLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/OAuth/urlOpener.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/auth/lib/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/index.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Auth_1 = __webpack_require__(/*! ./Auth */ \"./node_modules/@aws-amplify/auth/lib/Auth.js\");\nexports.AuthClass = Auth_1.default;\nexports.CognitoHostedUIIdentityProvider = Auth_1.CognitoHostedUIIdentityProvider;\nvar amazon_cognito_identity_js_1 = __webpack_require__(/*! amazon-cognito-identity-js */ \"./node_modules/amazon-cognito-identity-js/es/index.js\");\nexports.CognitoUser = amazon_cognito_identity_js_1.CognitoUser;\nexports.CookieStorage = amazon_cognito_identity_js_1.CookieStorage;\nvar core_1 = __webpack_require__(/*! @aws-amplify/core */ \"./node_modules/@aws-amplify/core/lib/index.js\");\nvar logger = new core_1.ConsoleLogger('Auth');\nvar _instance = null;\nif (!_instance) {\n    logger.debug('Create Auth Instance');\n    _instance = new Auth_1.default(null);\n}\nvar Auth = _instance;\ncore_1.default.register(Auth);\nexports.default = Auth;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/auth/lib/types/Auth.js":
/*!**********************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/types/Auth.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar CognitoHostedUIIdentityProvider;\n(function (CognitoHostedUIIdentityProvider) {\n    CognitoHostedUIIdentityProvider[\"Cognito\"] = \"COGNITO\";\n    CognitoHostedUIIdentityProvider[\"Google\"] = \"Google\";\n    CognitoHostedUIIdentityProvider[\"Facebook\"] = \"Facebook\";\n    CognitoHostedUIIdentityProvider[\"Amazon\"] = \"LoginWithAmazon\";\n})(CognitoHostedUIIdentityProvider = exports.CognitoHostedUIIdentityProvider || (exports.CognitoHostedUIIdentityProvider = {}));\nfunction isFederatedSignInOptions(obj) {\n    var key = 'provider';\n    return obj && obj.hasOwnProperty(key);\n}\nexports.isFederatedSignInOptions = isFederatedSignInOptions;\nfunction isFederatedSignInOptionsCustom(obj) {\n    var key = 'customProvider';\n    return obj && obj.hasOwnProperty(key);\n}\nexports.isFederatedSignInOptionsCustom = isFederatedSignInOptionsCustom;\nfunction isCognitoHostedOpts(oauth) {\n    return oauth.redirectSignIn !== undefined;\n}\nexports.isCognitoHostedOpts = isCognitoHostedOpts;\nfunction isUsernamePasswordOpts(obj) {\n    return !!obj.username;\n}\nexports.isUsernamePasswordOpts = isUsernamePasswordOpts;\n//# sourceMappingURL=Auth.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2F1dGgvbGliL3R5cGVzL0F1dGguanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2F1dGgvbGliL3R5cGVzL0F1dGguanM/ZGY0MiJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbi8qXG4gKiBDb3B5cmlnaHQgMjAxNy0yMDE3IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoXG4gKiB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgaHR0cDovL2F3cy5hbWF6b24uY29tL2FwYWNoZTIuMC9cbiAqXG4gKiBvciBpbiB0aGUgXCJsaWNlbnNlXCIgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVMgT1JcbiAqIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG52YXIgQ29nbml0b0hvc3RlZFVJSWRlbnRpdHlQcm92aWRlcjtcbihmdW5jdGlvbiAoQ29nbml0b0hvc3RlZFVJSWRlbnRpdHlQcm92aWRlcikge1xuICAgIENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXJbXCJDb2duaXRvXCJdID0gXCJDT0dOSVRPXCI7XG4gICAgQ29nbml0b0hvc3RlZFVJSWRlbnRpdHlQcm92aWRlcltcIkdvb2dsZVwiXSA9IFwiR29vZ2xlXCI7XG4gICAgQ29nbml0b0hvc3RlZFVJSWRlbnRpdHlQcm92aWRlcltcIkZhY2Vib29rXCJdID0gXCJGYWNlYm9va1wiO1xuICAgIENvZ25pdG9Ib3N0ZWRVSUlkZW50aXR5UHJvdmlkZXJbXCJBbWF6b25cIl0gPSBcIkxvZ2luV2l0aEFtYXpvblwiO1xufSkoQ29nbml0b0hvc3RlZFVJSWRlbnRpdHlQcm92aWRlciA9IGV4cG9ydHMuQ29nbml0b0hvc3RlZFVJSWRlbnRpdHlQcm92aWRlciB8fCAoZXhwb3J0cy5Db2duaXRvSG9zdGVkVUlJZGVudGl0eVByb3ZpZGVyID0ge30pKTtcbmZ1bmN0aW9uIGlzRmVkZXJhdGVkU2lnbkluT3B0aW9ucyhvYmopIHtcbiAgICB2YXIga2V5ID0gJ3Byb3ZpZGVyJztcbiAgICByZXR1cm4gb2JqICYmIG9iai5oYXNPd25Qcm9wZXJ0eShrZXkpO1xufVxuZXhwb3J0cy5pc0ZlZGVyYXRlZFNpZ25Jbk9wdGlvbnMgPSBpc0ZlZGVyYXRlZFNpZ25Jbk9wdGlvbnM7XG5mdW5jdGlvbiBpc0ZlZGVyYXRlZFNpZ25Jbk9wdGlvbnNDdXN0b20ob2JqKSB7XG4gICAgdmFyIGtleSA9ICdjdXN0b21Qcm92aWRlcic7XG4gICAgcmV0dXJuIG9iaiAmJiBvYmouaGFzT3duUHJvcGVydHkoa2V5KTtcbn1cbmV4cG9ydHMuaXNGZWRlcmF0ZWRTaWduSW5PcHRpb25zQ3VzdG9tID0gaXNGZWRlcmF0ZWRTaWduSW5PcHRpb25zQ3VzdG9tO1xuZnVuY3Rpb24gaXNDb2duaXRvSG9zdGVkT3B0cyhvYXV0aCkge1xuICAgIHJldHVybiBvYXV0aC5yZWRpcmVjdFNpZ25JbiAhPT0gdW5kZWZpbmVkO1xufVxuZXhwb3J0cy5pc0NvZ25pdG9Ib3N0ZWRPcHRzID0gaXNDb2duaXRvSG9zdGVkT3B0cztcbmZ1bmN0aW9uIGlzVXNlcm5hbWVQYXNzd29yZE9wdHMob2JqKSB7XG4gICAgcmV0dXJuICEhb2JqLnVzZXJuYW1lO1xufVxuZXhwb3J0cy5pc1VzZXJuYW1lUGFzc3dvcmRPcHRzID0gaXNVc2VybmFtZVBhc3N3b3JkT3B0cztcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPUF1dGguanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/types/Auth.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/auth/lib/types/index.js":
/*!***********************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/types/index.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nfunction __export(m) {\n    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];\n}\nObject.defineProperty(exports, \"__esModule\", { value: true });\n__export(__webpack_require__(/*! ./Auth */ \"./node_modules/@aws-amplify/auth/lib/types/Auth.js\"));\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2F1dGgvbGliL3R5cGVzL2luZGV4LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bhd3MtYW1wbGlmeS9hdXRoL2xpYi90eXBlcy9pbmRleC5qcz80NDVkIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuLypcbiAqIENvcHlyaWdodCAyMDE3LTIwMTcgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGhcbiAqIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICBodHRwOi8vYXdzLmFtYXpvbi5jb20vYXBhY2hlMi4wL1xuICpcbiAqIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUlxuICogQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cbmZ1bmN0aW9uIF9fZXhwb3J0KG0pIHtcbiAgICBmb3IgKHZhciBwIGluIG0pIGlmICghZXhwb3J0cy5oYXNPd25Qcm9wZXJ0eShwKSkgZXhwb3J0c1twXSA9IG1bcF07XG59XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5fX2V4cG9ydChyZXF1aXJlKFwiLi9BdXRoXCIpKTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPWluZGV4LmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/types/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/auth/lib/urlListener.js":
/*!***********************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/lib/urlListener.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", { value: true });\n/*\n * Copyright 2017-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar core_1 = __webpack_require__(/*! @aws-amplify/core */ \"./node_modules/@aws-amplify/core/lib/index.js\");\nexports.default = (function (callback) {\n    if (core_1.JS.browserOrNode().isBrowser && window.location) {\n        var url = window.location.href;\n        callback({ url: url });\n    }\n    else {\n        throw new Error('Not supported');\n    }\n});\n//# sourceMappingURL=urlListener.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2F1dGgvbGliL3VybExpc3RlbmVyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bhd3MtYW1wbGlmeS9hdXRoL2xpYi91cmxMaXN0ZW5lci5qcz84Yzc0Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuLypcbiAqIENvcHlyaWdodCAyMDE3LTIwMTkgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGhcbiAqIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICBodHRwOi8vYXdzLmFtYXpvbi5jb20vYXBhY2hlMi4wL1xuICpcbiAqIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUlxuICogQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cbnZhciBjb3JlXzEgPSByZXF1aXJlKFwiQGF3cy1hbXBsaWZ5L2NvcmVcIik7XG5leHBvcnRzLmRlZmF1bHQgPSAoZnVuY3Rpb24gKGNhbGxiYWNrKSB7XG4gICAgaWYgKGNvcmVfMS5KUy5icm93c2VyT3JOb2RlKCkuaXNCcm93c2VyICYmIHdpbmRvdy5sb2NhdGlvbikge1xuICAgICAgICB2YXIgdXJsID0gd2luZG93LmxvY2F0aW9uLmhyZWY7XG4gICAgICAgIGNhbGxiYWNrKHsgdXJsOiB1cmwgfSk7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ05vdCBzdXBwb3J0ZWQnKTtcbiAgICB9XG59KTtcbi8vIyBzb3VyY2VNYXBwaW5nVVJMPXVybExpc3RlbmVyLmpzLm1hcCJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/auth/lib/urlListener.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Amplify.js":
/*!*******************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Amplify.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Logger_1 = __webpack_require__(/*! ./Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar logger = new Logger_1.ConsoleLogger('Amplify');\nvar Amplify = /** @class */ (function () {\n    function Amplify() {\n    }\n    Amplify.register = function (comp) {\n        logger.debug('component registered in amplify', comp);\n        this._components.push(comp);\n        if (typeof comp.getModuleName === 'function') {\n            Amplify[comp.getModuleName()] = comp;\n        }\n        else {\n            logger.debug('no getModuleName method for component', comp);\n        }\n    };\n    Amplify.configure = function (config) {\n        var _this = this;\n        if (!config)\n            return this._config;\n        this._config = Object.assign(this._config, config);\n        logger.debug('amplify config', this._config);\n        this._components.map(function (comp) {\n            comp.configure(_this._config);\n        });\n        return this._config;\n    };\n    Amplify.addPluggable = function (pluggable) {\n        if (pluggable && pluggable['getCategory'] && typeof pluggable['getCategory'] === 'function') {\n            this._components.map(function (comp) {\n                if (comp['addPluggable'] && typeof comp['addPluggable'] === 'function') {\n                    comp.addPluggable(pluggable);\n                }\n            });\n        }\n    };\n    Amplify._components = [];\n    Amplify._config = {};\n    // for backward compatibility to avoid breaking change\n    // if someone is using like Amplify.Auth\n    Amplify.Auth = null;\n    Amplify.Analytics = null;\n    Amplify.API = null;\n    Amplify.Storage = null;\n    Amplify.I18n = null;\n    Amplify.Cache = null;\n    Amplify.PubSub = null;\n    Amplify.Interactions = null;\n    Amplify.Pushnotification = null;\n    Amplify.UI = null;\n    Amplify.XR = null;\n    Amplify.Logger = Logger_1.ConsoleLogger;\n    Amplify.ServiceWorker = null;\n    return Amplify;\n}());\nexports.default = Amplify;\n//# sourceMappingURL=Amplify.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Amplify.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/ClientDevice/browser.js":
/*!********************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/ClientDevice/browser.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Logger_1 = __webpack_require__(/*! ../Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar logger = new Logger_1.ConsoleLogger('ClientDevice_Browser');\nfunction clientInfo() {\n    if (typeof window === 'undefined') {\n        return {};\n    }\n    return browserClientInfo();\n}\nexports.clientInfo = clientInfo;\nfunction browserClientInfo() {\n    if (typeof window === 'undefined') {\n        logger.warn('No window object available to get browser client info');\n        return {};\n    }\n    var nav = window.navigator;\n    if (!nav) {\n        logger.warn('No navigator object available to get browser client info');\n        return {};\n    }\n    var platform = nav.platform, product = nav.product, vendor = nav.vendor, userAgent = nav.userAgent, language = nav.language;\n    var type = browserType(userAgent);\n    var timezone = browserTimezone();\n    return {\n        'platform': platform,\n        'make': product || vendor,\n        'model': type.type,\n        'version': type.version,\n        'appVersion': [type.type, type.version].join('/'),\n        'language': language,\n        'timezone': timezone\n    };\n}\nfunction dimension() {\n    if (typeof window === 'undefined') {\n        logger.warn('No window object available to get browser client info');\n        return { width: 320, height: 320 };\n    }\n    return {\n        'width': window.innerWidth,\n        'height': window.innerHeight\n    };\n}\nexports.dimension = dimension;\nfunction browserTimezone() {\n    var tzMatch = /\\(([A-Za-z\\s].*)\\)/.exec(new Date().toString());\n    return tzMatch ? tzMatch[1] || \"\" : \"\";\n}\nfunction browserType(userAgent) {\n    var operaMatch = /.+(Opera[\\s[A-Z]*|OPR[\\sA-Z]*)\\/([0-9\\.]+).*/i.exec(userAgent);\n    if (operaMatch) {\n        return { type: operaMatch[1], version: operaMatch[2] };\n    }\n    var cfMatch = /.+(Chrome|Firefox|FxiOS)\\/([0-9\\.]+).*/i.exec(userAgent);\n    if (cfMatch) {\n        return { type: cfMatch[1], version: cfMatch[2] };\n    }\n    var ieMatch = /.+(Trident|Edge)\\/([0-9\\.]+).*/i.exec(userAgent);\n    if (ieMatch) {\n        return { type: ieMatch[1], version: ieMatch[2] };\n    }\n    var sMatch = /.+(Safari)\\/([0-9\\.]+).*/i.exec(userAgent);\n    if (sMatch) {\n        return { type: sMatch[1], version: sMatch[2] };\n    }\n    var awkMatch = /.+(AppleWebKit)\\/([0-9\\.]+).*/i.exec(userAgent);\n    if (awkMatch) {\n        return { type: awkMatch[1], version: awkMatch[2] };\n    }\n    var anyMatch = /.*([A-Z]+)\\/([0-9\\.]+).*/i.exec(userAgent);\n    if (anyMatch) {\n        return { type: anyMatch[1], version: anyMatch[2] };\n    }\n    return { type: '', version: '' };\n}\n//# sourceMappingURL=browser.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/ClientDevice/browser.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/ClientDevice/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/ClientDevice/index.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Browser = __webpack_require__(/*! ./browser */ \"./node_modules/@aws-amplify/core/lib/ClientDevice/browser.js\");\nvar ClientDevice = /** @class */ (function () {\n    function ClientDevice() {\n    }\n    ClientDevice.clientInfo = function () {\n        return Browser.clientInfo();\n    };\n    ClientDevice.dimension = function () {\n        return Browser.dimension();\n    };\n    return ClientDevice;\n}());\nexports.default = ClientDevice;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL0NsaWVudERldmljZS9pbmRleC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AYXdzLWFtcGxpZnkvY29yZS9saWIvQ2xpZW50RGV2aWNlL2luZGV4LmpzPzNhMzYiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG4vKlxuICogQ29weXJpZ2h0IDIwMTctMjAxNyBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aFxuICogdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgIGh0dHA6Ly9hd3MuYW1hem9uLmNvbS9hcGFjaGUyLjAvXG4gKlxuICogb3IgaW4gdGhlIFwibGljZW5zZVwiIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTIE9SXG4gKiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xudmFyIEJyb3dzZXIgPSByZXF1aXJlKFwiLi9icm93c2VyXCIpO1xudmFyIENsaWVudERldmljZSA9IC8qKiBAY2xhc3MgKi8gKGZ1bmN0aW9uICgpIHtcbiAgICBmdW5jdGlvbiBDbGllbnREZXZpY2UoKSB7XG4gICAgfVxuICAgIENsaWVudERldmljZS5jbGllbnRJbmZvID0gZnVuY3Rpb24gKCkge1xuICAgICAgICByZXR1cm4gQnJvd3Nlci5jbGllbnRJbmZvKCk7XG4gICAgfTtcbiAgICBDbGllbnREZXZpY2UuZGltZW5zaW9uID0gZnVuY3Rpb24gKCkge1xuICAgICAgICByZXR1cm4gQnJvd3Nlci5kaW1lbnNpb24oKTtcbiAgICB9O1xuICAgIHJldHVybiBDbGllbnREZXZpY2U7XG59KCkpO1xuZXhwb3J0cy5kZWZhdWx0ID0gQ2xpZW50RGV2aWNlO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9aW5kZXguanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/ClientDevice/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Credentials.js":
/*!***********************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Credentials.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nvar __assign = (this && this.__assign) || Object.assign || function(t) {\n    for (var s, i = 1, n = arguments.length; i < n; i++) {\n        s = arguments[i];\n        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))\n            t[p] = s[p];\n    }\n    return t;\n};\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), \"throw\": verb(1), \"return\": verb(2) }, typeof Symbol === \"function\" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError(\"Generator is already executing.\");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y[\"return\"] : op[0] ? y[\"throw\"] || ((t = y[\"return\"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Logger_1 = __webpack_require__(/*! ./Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar StorageHelper_1 = __webpack_require__(/*! ./StorageHelper */ \"./node_modules/@aws-amplify/core/lib/StorageHelper/index.js\");\nvar Facet_1 = __webpack_require__(/*! ./Facet */ \"./node_modules/@aws-amplify/core/lib/Facet.js\");\nvar JS_1 = __webpack_require__(/*! ./JS */ \"./node_modules/@aws-amplify/core/lib/JS.js\");\nvar OAuthHelper_1 = __webpack_require__(/*! ./OAuthHelper */ \"./node_modules/@aws-amplify/core/lib/OAuthHelper/index.js\");\nvar Amplify_1 = __webpack_require__(/*! ./Amplify */ \"./node_modules/@aws-amplify/core/lib/Amplify.js\");\nvar logger = new Logger_1.ConsoleLogger('Credentials');\nvar Credentials = /** @class */ (function () {\n    function Credentials(config) {\n        this._gettingCredPromise = null;\n        this._refreshHandlers = {};\n        this.configure(config);\n        this._refreshHandlers['google'] = OAuthHelper_1.GoogleOAuth.refreshGoogleToken;\n        this._refreshHandlers['facebook'] = OAuthHelper_1.FacebookOAuth.refreshFacebookToken;\n    }\n    Credentials.prototype.getCredSource = function () {\n        return this._credentials_source;\n    };\n    Credentials.prototype.configure = function (config) {\n        if (!config)\n            return this._config || {};\n        this._config = Object.assign({}, this._config, config);\n        var refreshHandlers = this._config.refreshHandlers;\n        // If the developer has provided an object of refresh handlers,\n        // then we can merge the provided handlers with the current handlers.\n        if (refreshHandlers) {\n            this._refreshHandlers = __assign({}, this._refreshHandlers, refreshHandlers);\n        }\n        this._storage = this._config.storage;\n        if (!this._storage) {\n            this._storage = new StorageHelper_1.default().getStorage();\n        }\n        this._storageSync = Promise.resolve();\n        if (typeof this._storage['sync'] === 'function') {\n            this._storageSync = this._storage['sync']();\n        }\n        return this._config;\n    };\n    Credentials.prototype.get = function () {\n        logger.debug('getting credentials');\n        return this._pickupCredentials();\n    };\n    Credentials.prototype._pickupCredentials = function () {\n        logger.debug('picking up credentials');\n        if (!this._gettingCredPromise || !this._gettingCredPromise.isPending()) {\n            logger.debug('getting new cred promise');\n            if (Facet_1.AWS.config && Facet_1.AWS.config.credentials && Facet_1.AWS.config.credentials instanceof Facet_1.AWS.Credentials) {\n                this._gettingCredPromise = JS_1.default.makeQuerablePromise(this._setCredentialsFromAWS());\n            }\n            else {\n                this._gettingCredPromise = JS_1.default.makeQuerablePromise(this._keepAlive());\n            }\n        }\n        else {\n            logger.debug('getting old cred promise');\n        }\n        return this._gettingCredPromise;\n    };\n    Credentials.prototype._keepAlive = function () {\n        logger.debug('checking if credentials exists and not expired');\n        var cred = this._credentials;\n        if (cred && !this._isExpired(cred)) {\n            logger.debug('credentials not changed and not expired, directly return');\n            return Promise.resolve(cred);\n        }\n        logger.debug('need to get a new credential or refresh the existing one');\n        if (Amplify_1.default.Auth && typeof Amplify_1.default.Auth.currentUserCredentials === 'function') {\n            return Amplify_1.default.Auth.currentUserCredentials();\n        }\n        else {\n            return Promise.reject('No Auth module registered in Amplify');\n        }\n    };\n    Credentials.prototype.refreshFederatedToken = function (federatedInfo) {\n        var _this = this;\n        logger.debug('Getting federated credentials');\n        var provider = federatedInfo.provider, user = federatedInfo.user;\n        var token = federatedInfo.token;\n        var expires_at = federatedInfo.expires_at;\n        var identity_id = federatedInfo.identity_id;\n        var that = this;\n        logger.debug('checking if federated jwt token expired');\n        if (expires_at > new Date().getTime()) {\n            // if not expired\n            logger.debug('token not expired');\n            return this._setCredentialsFromFederation({ provider: provider, token: token, user: user, identity_id: identity_id, expires_at: expires_at });\n        }\n        else {\n            // if refresh handler exists\n            if (that._refreshHandlers[provider] && typeof that._refreshHandlers[provider] === 'function') {\n                logger.debug('getting refreshed jwt token from federation provider');\n                return that._refreshHandlers[provider]().then(function (data) {\n                    logger.debug('refresh federated token sucessfully', data);\n                    token = data.token;\n                    identity_id = data.identity_id;\n                    expires_at = data.expires_at;\n                    return that._setCredentialsFromFederation({ provider: provider, token: token, user: user, identity_id: identity_id, expires_at: expires_at });\n                }).catch(function (e) {\n                    logger.debug('refresh federated token failed', e);\n                    _this.clear();\n                    return Promise.reject('refreshing federation token failed: ' + e);\n                });\n            }\n            else {\n                logger.debug('no refresh handler for provider:', provider);\n                this.clear();\n                return Promise.reject('no refresh handler for provider');\n            }\n        }\n    };\n    Credentials.prototype._isExpired = function (credentials) {\n        if (!credentials) {\n            logger.debug('no credentials for expiration check');\n            return true;\n        }\n        logger.debug('is this credentials expired?', credentials);\n        var ts = new Date().getTime();\n        var delta = 10 * 60 * 1000; // 10 minutes\n        var expired = credentials.expired, expireTime = credentials.expireTime;\n        if (!expired && expireTime > ts + delta) {\n            return false;\n        }\n        return true;\n    };\n    Credentials.prototype._setCredentialsForGuest = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            var attempted, _a, identityPoolId, region, mandatorySignIn, identityId, e_1, credentials, that;\n            var _this = this;\n            return __generator(this, function (_b) {\n                switch (_b.label) {\n                    case 0:\n                        attempted = false;\n                        logger.debug('setting credentials for guest');\n                        _a = this._config, identityPoolId = _a.identityPoolId, region = _a.region, mandatorySignIn = _a.mandatorySignIn;\n                        if (mandatorySignIn) {\n                            return [2 /*return*/, Promise.reject('cannot get guest credentials when mandatory signin enabled')];\n                        }\n                        if (!identityPoolId) {\n                            logger.debug('No Cognito Federated Identity pool provided');\n                            return [2 /*return*/, Promise.reject('No Cognito Federated Identity pool provided')];\n                        }\n                        identityId = undefined;\n                        _b.label = 1;\n                    case 1:\n                        _b.trys.push([1, 3, , 4]);\n                        return [4 /*yield*/, this._storageSync];\n                    case 2:\n                        _b.sent();\n                        identityId = this._storage.getItem('CognitoIdentityId-' + identityPoolId);\n                        return [3 /*break*/, 4];\n                    case 3:\n                        e_1 = _b.sent();\n                        logger.debug('Failed to get the cached identityId', e_1);\n                        return [3 /*break*/, 4];\n                    case 4:\n                        credentials = new Facet_1.AWS.CognitoIdentityCredentials({\n                            IdentityPoolId: identityPoolId,\n                            IdentityId: identityId ? identityId : undefined\n                        }, {\n                            region: region\n                        });\n                        that = this;\n                        return [2 /*return*/, this._loadCredentials(credentials, 'guest', false, null)\n                                .then(function (res) {\n                                return res;\n                            })\n                                .catch(function (e) { return __awaiter(_this, void 0, void 0, function () {\n                                var newCredentials;\n                                return __generator(this, function (_a) {\n                                    // If identity id is deleted in the console, we make one attempt to recreate it\n                                    // and remove existing id from cache. \n                                    if (e.code === 'ResourceNotFoundException' &&\n                                        e.message === \"Identity '\" + identityId + \"' not found.\"\n                                        && !attempted) {\n                                        attempted = true;\n                                        logger.debug('Failed to load guest credentials');\n                                        this._storage.removeItem('CognitoIdentityId-' + identityPoolId);\n                                        credentials.clearCachedId();\n                                        newCredentials = new Facet_1.AWS.CognitoIdentityCredentials({\n                                            IdentityPoolId: identityPoolId,\n                                            IdentityId: undefined\n                                        }, {\n                                            region: region\n                                        });\n                                        return [2 /*return*/, this._loadCredentials(newCredentials, 'guest', false, null)];\n                                    }\n                                    else {\n                                        return [2 /*return*/, e];\n                                    }\n                                    return [2 /*return*/];\n                                });\n                            }); })];\n                }\n            });\n        });\n    };\n    Credentials.prototype._setCredentialsFromAWS = function () {\n        var credentials = Facet_1.AWS.config.credentials;\n        logger.debug('setting credentials from aws');\n        var that = this;\n        if (credentials instanceof Facet_1.AWS.Credentials) {\n            return Promise.resolve(credentials);\n        }\n        else {\n            logger.debug('AWS.config.credentials is not an instance of AWS Credentials');\n            return Promise.reject('AWS.config.credentials is not an instance of AWS Credentials');\n        }\n    };\n    Credentials.prototype._setCredentialsFromFederation = function (params) {\n        var provider = params.provider, token = params.token, identity_id = params.identity_id, user = params.user, expires_at = params.expires_at;\n        var domains = {\n            'google': 'accounts.google.com',\n            'facebook': 'graph.facebook.com',\n            'amazon': 'www.amazon.com',\n            'developer': 'cognito-identity.amazonaws.com'\n        };\n        // Use custom provider url instead of the predefined ones\n        var domain = domains[provider] || provider;\n        if (!domain) {\n            return Promise.reject('You must specify a federated provider');\n        }\n        var logins = {};\n        logins[domain] = token;\n        var _a = this._config, identityPoolId = _a.identityPoolId, region = _a.region;\n        if (!identityPoolId) {\n            logger.debug('No Cognito Federated Identity pool provided');\n            return Promise.reject('No Cognito Federated Identity pool provided');\n        }\n        var credentials = new Facet_1.AWS.CognitoIdentityCredentials({\n            IdentityPoolId: identityPoolId,\n            IdentityId: identity_id,\n            Logins: logins\n        }, {\n            region: region\n        });\n        return this._loadCredentials(credentials, 'federated', true, params);\n    };\n    Credentials.prototype._setCredentialsFromSession = function (session) {\n        logger.debug('set credentials from session');\n        var idToken = session.getIdToken().getJwtToken();\n        var _a = this._config, region = _a.region, userPoolId = _a.userPoolId, identityPoolId = _a.identityPoolId;\n        if (!identityPoolId) {\n            logger.debug('No Cognito Federated Identity pool provided');\n            return Promise.reject('No Cognito Federated Identity pool provided');\n        }\n        var key = 'cognito-idp.' + region + '.amazonaws.com/' + userPoolId;\n        var logins = {};\n        logins[key] = idToken;\n        var credentials = new Facet_1.AWS.CognitoIdentityCredentials({\n            IdentityPoolId: identityPoolId,\n            Logins: logins\n        }, {\n            region: region\n        });\n        var that = this;\n        return this._loadCredentials(credentials, 'userPool', true, null);\n    };\n    Credentials.prototype._loadCredentials = function (credentials, source, authenticated, info) {\n        var _this = this;\n        var that = this;\n        var identityPoolId = this._config.identityPoolId;\n        return new Promise(function (res, rej) {\n            credentials.get(function (err) { return __awaiter(_this, void 0, void 0, function () {\n                var user, provider, token, expires_at, identity_id, e_2;\n                return __generator(this, function (_a) {\n                    switch (_a.label) {\n                        case 0:\n                            if (err) {\n                                logger.debug('Failed to load credentials', credentials);\n                                rej(err);\n                                return [2 /*return*/];\n                            }\n                            logger.debug('Load credentials successfully', credentials);\n                            that._credentials = credentials;\n                            that._credentials.authenticated = authenticated;\n                            that._credentials_source = source;\n                            if (source === 'federated') {\n                                user = Object.assign({ id: this._credentials.identityId }, info.user);\n                                provider = info.provider, token = info.token, expires_at = info.expires_at, identity_id = info.identity_id;\n                                try {\n                                    this._storage.setItem('aws-amplify-federatedInfo', JSON.stringify({\n                                        provider: provider,\n                                        token: token,\n                                        user: user,\n                                        expires_at: expires_at,\n                                        identity_id: identity_id\n                                    }));\n                                }\n                                catch (e) {\n                                    logger.debug('Failed to put federated info into auth storage', e);\n                                }\n                                // the Cache module no longer stores federated info\n                                // this is just for backward compatibility\n                                if (Amplify_1.default.Cache && typeof Amplify_1.default.Cache.setItem === 'function') {\n                                    Amplify_1.default.Cache.setItem('federatedInfo', {\n                                        provider: provider,\n                                        token: token,\n                                        user: user,\n                                        expires_at: expires_at,\n                                        identity_id: identity_id\n                                    }, { priority: 1 });\n                                }\n                                else {\n                                    logger.debug('No Cache module registered in Amplify');\n                                }\n                            }\n                            if (!(source === 'guest')) return [3 /*break*/, 4];\n                            _a.label = 1;\n                        case 1:\n                            _a.trys.push([1, 3, , 4]);\n                            return [4 /*yield*/, this._storageSync];\n                        case 2:\n                            _a.sent();\n                            this._storage.setItem('CognitoIdentityId-' + identityPoolId, credentials.identityId);\n                            return [3 /*break*/, 4];\n                        case 3:\n                            e_2 = _a.sent();\n                            logger.debug('Failed to cache identityId', e_2);\n                            return [3 /*break*/, 4];\n                        case 4:\n                            res(that._credentials);\n                            return [2 /*return*/];\n                    }\n                });\n            }); });\n        });\n    };\n    Credentials.prototype.set = function (params, source) {\n        if (source === 'session') {\n            return this._setCredentialsFromSession(params);\n        }\n        else if (source === 'federation') {\n            return this._setCredentialsFromFederation(params);\n        }\n        else if (source === 'guest') {\n            return this._setCredentialsForGuest();\n        }\n        else {\n            logger.debug('no source specified for setting credentials');\n            return Promise.reject('invalid source');\n        }\n    };\n    Credentials.prototype.clear = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            var _a, identityPoolId, region, credentials;\n            return __generator(this, function (_b) {\n                switch (_b.label) {\n                    case 0:\n                        _a = this._config, identityPoolId = _a.identityPoolId, region = _a.region;\n                        if (identityPoolId) {\n                            credentials = new Facet_1.AWS.CognitoIdentityCredentials({\n                                IdentityPoolId: identityPoolId\n                            }, {\n                                region: region\n                            });\n                            credentials.clearCachedId();\n                        }\n                        this._credentials = null;\n                        this._credentials_source = null;\n                        this._storage.removeItem('aws-amplify-federatedInfo');\n                        if (!(Amplify_1.default.Cache && typeof Amplify_1.default.Cache.setItem === 'function')) return [3 /*break*/, 2];\n                        return [4 /*yield*/, Amplify_1.default.Cache.removeItem('federatedInfo')];\n                    case 1:\n                        _b.sent();\n                        return [3 /*break*/, 3];\n                    case 2:\n                        logger.debug('No Cache module registered in Amplify');\n                        _b.label = 3;\n                    case 3: return [2 /*return*/];\n                }\n            });\n        });\n    };\n    /**\n     * Compact version of credentials\n     * @param {Object} credentials\n     * @return {Object} - Credentials\n     */\n    Credentials.prototype.shear = function (credentials) {\n        return {\n            accessKeyId: credentials.accessKeyId,\n            sessionToken: credentials.sessionToken,\n            secretAccessKey: credentials.secretAccessKey,\n            identityId: credentials.identityId,\n            authenticated: credentials.authenticated\n        };\n    };\n    return Credentials;\n}());\nexports.Credentials = Credentials;\nvar instance = new Credentials(null);\nexports.default = instance;\n//# sourceMappingURL=Credentials.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Credentials.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Errors.js":
/*!******************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Errors.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nfunction missingConfig(name) { return new Error('Missing config value of ' + name); }\nexports.missingConfig = missingConfig;\nfunction invalidParameter(name) { return new Error('Invalid parameter value of ' + name); }\nexports.invalidParameter = invalidParameter;\n//# sourceMappingURL=Errors.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL0Vycm9ycy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AYXdzLWFtcGxpZnkvY29yZS9saWIvRXJyb3JzLmpzPzQwNmUiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG4vKlxuICogQ29weXJpZ2h0IDIwMTctMjAxNyBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aFxuICogdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgIGh0dHA6Ly9hd3MuYW1hem9uLmNvbS9hcGFjaGUyLjAvXG4gKlxuICogb3IgaW4gdGhlIFwibGljZW5zZVwiIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTIE9SXG4gKiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZnVuY3Rpb24gbWlzc2luZ0NvbmZpZyhuYW1lKSB7IHJldHVybiBuZXcgRXJyb3IoJ01pc3NpbmcgY29uZmlnIHZhbHVlIG9mICcgKyBuYW1lKTsgfVxuZXhwb3J0cy5taXNzaW5nQ29uZmlnID0gbWlzc2luZ0NvbmZpZztcbmZ1bmN0aW9uIGludmFsaWRQYXJhbWV0ZXIobmFtZSkgeyByZXR1cm4gbmV3IEVycm9yKCdJbnZhbGlkIHBhcmFtZXRlciB2YWx1ZSBvZiAnICsgbmFtZSk7IH1cbmV4cG9ydHMuaW52YWxpZFBhcmFtZXRlciA9IGludmFsaWRQYXJhbWV0ZXI7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1FcnJvcnMuanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Errors.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Facet.js":
/*!*****************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Facet.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\n// import * as S3 from 'aws-sdk/clients/s3';\nvar AWS = __webpack_require__(/*! aws-sdk/global */ \"./node_modules/aws-sdk/browser.js\");\nexports.AWS = AWS;\n//# sourceMappingURL=Facet.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL0ZhY2V0LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bhd3MtYW1wbGlmeS9jb3JlL2xpYi9GYWNldC5qcz8yMWU1Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuLypcbiAqIENvcHlyaWdodCAyMDE3LTIwMTcgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGhcbiAqIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICBodHRwOi8vYXdzLmFtYXpvbi5jb20vYXBhY2hlMi4wL1xuICpcbiAqIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUlxuICogQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbi8vIGltcG9ydCAqIGFzIFMzIGZyb20gJ2F3cy1zZGsvY2xpZW50cy9zMyc7XG52YXIgQVdTID0gcmVxdWlyZShcImF3cy1zZGsvZ2xvYmFsXCIpO1xuZXhwb3J0cy5BV1MgPSBBV1M7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1GYWNldC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Facet.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Hub.js":
/*!***************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Hub.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar __assign = (this && this.__assign) || Object.assign || function(t) {\n    for (var s, i = 1, n = arguments.length; i < n; i++) {\n        s = arguments[i];\n        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))\n            t[p] = s[p];\n    }\n    return t;\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Logger_1 = __webpack_require__(/*! ./Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar logger = new Logger_1.ConsoleLogger('Hub');\nvar AMPLIFY_SYMBOL = ((typeof Symbol !== 'undefined' && typeof Symbol.for === 'function') ?\n    Symbol.for('amplify_default') : '@@amplify_default');\nfunction isLegacyCallback(callback) {\n    return callback.onHubCapsule !== undefined;\n}\nvar HubClass = /** @class */ (function () {\n    function HubClass(name) {\n        this.listeners = [];\n        this.patterns = [];\n        this.protectedChannels = ['core', 'auth', 'api', 'analytics', 'interactions', 'pubsub', 'storage', 'xr'];\n        this.name = name;\n    }\n    // Note - Need to pass channel as a reference for removal to work and not anonymous function\n    HubClass.prototype.remove = function (channel, listener) {\n        if (channel instanceof RegExp) {\n            var pattern_1 = this.patterns.find(function (_a) {\n                var pattern = _a.pattern;\n                return pattern.source === channel.source;\n            });\n            if (!pattern_1) {\n                logger.warn(\"No listeners for \" + channel);\n                return;\n            }\n            this.patterns = this.patterns.filter(function (x) { return x !== pattern_1; }).slice();\n        }\n        else {\n            var holder = this.listeners[channel];\n            if (!holder) {\n                logger.warn(\"No listeners for \" + channel);\n                return;\n            }\n            this.listeners[channel] = holder.filter(function (_a) {\n                var callback = _a.callback;\n                return callback !== listener;\n            }).slice();\n        }\n    };\n    HubClass.prototype.dispatch = function (channel, payload, source, ampSymbol) {\n        if (source === void 0) { source = ''; }\n        if (this.protectedChannels.indexOf(channel) > -1) {\n            var hasAccess = ampSymbol === AMPLIFY_SYMBOL;\n            if (!hasAccess) {\n                logger.warn(\"WARNING: \" + channel + \" is protected and dispatching on it can have unintended consequences\");\n            }\n        }\n        var capsule = {\n            channel: channel,\n            payload: __assign({}, payload),\n            source: source,\n            patternInfo: []\n        };\n        try {\n            this._toListeners(capsule);\n        }\n        catch (e) {\n            logger.error(e);\n        }\n    };\n    HubClass.prototype.listen = function (channel, callback, listenerName) {\n        if (listenerName === void 0) { listenerName = 'noname'; }\n        var cb;\n        // Check for legacy onHubCapsule callback for backwards compatability\n        if (isLegacyCallback(callback)) {\n            logger.warn(\"WARNING onHubCapsule is Deprecated. Please pass in a callback.\");\n            cb = callback.onHubCapsule.bind(callback);\n        }\n        else if (typeof callback !== 'function') {\n            throw new Error('No callback supplied to Hub');\n        }\n        else {\n            cb = callback;\n        }\n        if (channel instanceof RegExp) {\n            this.patterns.push({\n                pattern: channel,\n                callback: cb\n            });\n        }\n        else {\n            var holder = this.listeners[channel];\n            if (!holder) {\n                holder = [];\n                this.listeners[channel] = holder;\n            }\n            holder.push({\n                name: listenerName,\n                callback: cb\n            });\n        }\n    };\n    HubClass.prototype._toListeners = function (capsule) {\n        var channel = capsule.channel, payload = capsule.payload;\n        var holder = this.listeners[channel];\n        if (holder) {\n            holder.forEach(function (listener) {\n                logger.debug(\"Dispatching to \" + channel + \" with \", payload);\n                try {\n                    listener.callback(capsule);\n                }\n                catch (e) {\n                    logger.error(e);\n                }\n            });\n        }\n        if (this.patterns.length > 0) {\n            if (!payload.message) {\n                logger.warn(\"Cannot perform pattern matching without a message key\");\n                return;\n            }\n            var payloadStr_1 = payload.message;\n            this.patterns.forEach(function (pattern) {\n                var match = payloadStr_1.match(pattern.pattern);\n                if (match) {\n                    var groups = match.slice(1);\n                    var dispatchingCapsule = __assign({}, capsule, { patternInfo: groups });\n                    try {\n                        pattern.callback(dispatchingCapsule);\n                    }\n                    catch (e) {\n                        logger.error(e);\n                    }\n                }\n            });\n        }\n    };\n    return HubClass;\n}());\nexports.HubClass = HubClass;\n/*We export a __default__ instance of HubClass to use it as a\npsuedo Singleton for the main messaging bus, however you can still create\nyour own instance of HubClass() for a separate \"private bus\" of events.*/\nvar Hub = new HubClass('__default__');\nexports.default = Hub;\n//# sourceMappingURL=Hub.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Hub.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/I18n/I18n.js":
/*!*********************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/I18n/I18n.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Logger_1 = __webpack_require__(/*! ../Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar logger = new Logger_1.ConsoleLogger('I18n');\n/**\n * Language transition class\n */\nvar I18n = /** @class */ (function () {\n    /**\n     * @constructor\n     * Initialize with configurations\n     * @param {Object} options\n     */\n    function I18n(options) {\n        /**\n         * @private\n         */\n        this._options = null;\n        /**\n         * @private\n         */\n        this._lang = null;\n        /**\n         * @private\n         */\n        this._dict = {};\n        this._options = Object.assign({}, options);\n        this._lang = this._options.language;\n        if (!this._lang && typeof window !== 'undefined' && window && window.navigator) {\n            this._lang = window.navigator.language;\n        }\n        logger.debug(this._lang);\n    }\n    /**\n     * @method\n     * Explicitly setting language\n     * @param {String} lang\n     */\n    I18n.prototype.setLanguage = function (lang) {\n        this._lang = lang;\n    };\n    /**\n     * @method\n     * Get value\n     * @param {String} key\n     * @param {String} defVal - Default value\n     */\n    I18n.prototype.get = function (key, defVal) {\n        if (defVal === void 0) { defVal = undefined; }\n        if (!this._lang) {\n            return (typeof defVal !== 'undefined') ? defVal : key;\n        }\n        var lang = this._lang;\n        var val = this.getByLanguage(key, lang);\n        if (val) {\n            return val;\n        }\n        if (lang.indexOf('-') > 0) {\n            val = this.getByLanguage(key, lang.split('-')[0]);\n        }\n        if (val) {\n            return val;\n        }\n        return (typeof defVal !== 'undefined') ? defVal : key;\n    };\n    /**\n     * @method\n     * Get value according to specified language\n     * @param {String} key\n     * @param {String} language - Specified langurage to be used\n     * @param {String} defVal - Default value\n     */\n    I18n.prototype.getByLanguage = function (key, language, defVal) {\n        if (defVal === void 0) { defVal = null; }\n        if (!language) {\n            return defVal;\n        }\n        var lang_dict = this._dict[language];\n        if (!lang_dict) {\n            return defVal;\n        }\n        return lang_dict[key];\n    };\n    /**\n     * @method\n     * Add vocabularies for one language\n     * @param {String} langurage - Language of the dictionary\n     * @param {Object} vocabularies - Object that has key-value as dictionary entry\n     */\n    I18n.prototype.putVocabulariesForLanguage = function (language, vocabularies) {\n        var lang_dict = this._dict[language];\n        if (!lang_dict) {\n            lang_dict = this._dict[language] = {};\n        }\n        Object.assign(lang_dict, vocabularies);\n    };\n    /**\n     * @method\n     * Add vocabularies for one language\n     * @param {Object} vocabularies - Object that has language as key,\n     *                                vocabularies of each language as value\n     */\n    I18n.prototype.putVocabularies = function (vocabularies) {\n        var _this = this;\n        Object.keys(vocabularies).map(function (key) {\n            _this.putVocabulariesForLanguage(key, vocabularies[key]);\n        });\n    };\n    return I18n;\n}());\nexports.I18n = I18n;\n//# sourceMappingURL=I18n.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/I18n/I18n.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/I18n/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/I18n/index.js ***!
  \**********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar I18n_1 = __webpack_require__(/*! ./I18n */ \"./node_modules/@aws-amplify/core/lib/I18n/I18n.js\");\nvar Logger_1 = __webpack_require__(/*! ../Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar Amplify_1 = __webpack_require__(/*! ../Amplify */ \"./node_modules/@aws-amplify/core/lib/Amplify.js\");\nvar logger = new Logger_1.ConsoleLogger('I18n');\nvar _config = null;\nvar _i18n = null;\n/**\n * Export I18n APIs\n */\nvar I18n = /** @class */ (function () {\n    function I18n() {\n    }\n    /**\n     * @static\n     * @method\n     * Configure I18n part\n     * @param {Object} config - Configuration of the I18n\n     */\n    I18n.configure = function (config) {\n        logger.debug('configure I18n');\n        if (!config) {\n            return _config;\n        }\n        _config = Object.assign({}, _config, config.I18n || config);\n        I18n.createInstance();\n        return _config;\n    };\n    I18n.getModuleName = function () {\n        return 'I18n';\n    };\n    /**\n     * @static\n     * @method\n     * Create an instance of I18n for the library\n     */\n    I18n.createInstance = function () {\n        logger.debug('create I18n instance');\n        if (_i18n) {\n            return;\n        }\n        _i18n = new I18n_1.I18n(_config);\n    };\n    /**\n     * @static @method\n     * Explicitly setting language\n     * @param {String} lang\n     */\n    I18n.setLanguage = function (lang) {\n        I18n.checkConfig();\n        return _i18n.setLanguage(lang);\n    };\n    /**\n     * @static @method\n     * Get value\n     * @param {String} key\n     * @param {String} defVal - Default value\n     */\n    I18n.get = function (key, defVal) {\n        if (!I18n.checkConfig()) {\n            return (typeof defVal === 'undefined') ? key : defVal;\n        }\n        return _i18n.get(key, defVal);\n    };\n    /**\n     * @static\n     * @method\n     * Add vocabularies for one language\n     * @param {String} langurage - Language of the dictionary\n     * @param {Object} vocabularies - Object that has key-value as dictionary entry\n     */\n    I18n.putVocabulariesForLanguage = function (language, vocabularies) {\n        I18n.checkConfig();\n        return _i18n.putVocabulariesForLanguage(language, vocabularies);\n    };\n    /**\n     * @static\n     * @method\n     * Add vocabularies for one language\n     * @param {Object} vocabularies - Object that has language as key,\n     *                                vocabularies of each language as value\n     */\n    I18n.putVocabularies = function (vocabularies) {\n        I18n.checkConfig();\n        return _i18n.putVocabularies(vocabularies);\n    };\n    I18n.checkConfig = function () {\n        if (!_i18n) {\n            _i18n = new I18n_1.I18n(_config);\n        }\n        return true;\n    };\n    return I18n;\n}());\nAmplify_1.default.register(I18n);\nexports.default = I18n;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/I18n/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/JS.js":
/*!**************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/JS.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/* WEBPACK VAR INJECTION */(function(process) {\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar MIME_MAP = [\n    { type: 'text/plain', ext: 'txt' },\n    { type: 'text/html', ext: 'html' },\n    { type: 'text/javascript', ext: 'js' },\n    { type: 'text/css', ext: 'css' },\n    { type: 'text/csv', ext: 'csv' },\n    { type: 'text/yaml', ext: 'yml' },\n    { type: 'text/yaml', ext: 'yaml' },\n    { type: 'text/calendar', ext: 'ics' },\n    { type: 'text/calendar', ext: 'ical' },\n    { type: 'image/png', ext: 'png' },\n    { type: 'image/gif', ext: 'gif' },\n    { type: 'image/jpeg', ext: 'jpg' },\n    { type: 'image/jpeg', ext: 'jpeg' },\n    { type: 'image/bmp', ext: 'bmp' },\n    { type: 'image/x-icon', ext: 'ico' },\n    { type: 'image/tiff', ext: 'tif' },\n    { type: 'image/tiff', ext: 'tiff' },\n    { type: 'image/svg+xml', ext: 'svg' },\n    { type: 'application/json', ext: 'json' },\n    { type: 'application/xml', ext: 'xml' },\n    { type: 'application/x-sh', ext: 'sh' },\n    { type: 'application/zip', ext: 'zip' },\n    { type: 'application/x-rar-compressed', ext: 'rar' },\n    { type: 'application/x-tar', ext: 'tar' },\n    { type: 'application/x-bzip', ext: 'bz' },\n    { type: 'application/x-bzip2', ext: 'bz2' },\n    { type: 'application/pdf', ext: 'pdf' },\n    { type: 'application/java-archive', ext: 'jar' },\n    { type: 'application/msword', ext: 'doc' },\n    { type: 'application/vnd.ms-excel', ext: 'xls' },\n    { type: 'application/vnd.ms-excel', ext: 'xlsx' },\n    { type: 'message/rfc822', ext: 'eml' }\n];\nvar JS = /** @class */ (function () {\n    function JS() {\n    }\n    JS.isEmpty = function (obj) {\n        return Object.keys(obj).length === 0;\n    };\n    JS.sortByField = function (list, field, dir) {\n        if (!list || !list.sort) {\n            return false;\n        }\n        var dirX = (dir && dir === 'desc') ? -1 : 1;\n        list.sort(function (a, b) {\n            var a_val = a[field];\n            var b_val = b[field];\n            if (typeof b_val === 'undefined') {\n                return (typeof a_val === 'undefined') ? 0 : 1 * dirX;\n            }\n            if (typeof a_val === 'undefined') {\n                return -1 * dirX;\n            }\n            if (a_val < b_val) {\n                return -1 * dirX;\n            }\n            if (a_val > b_val) {\n                return 1 * dirX;\n            }\n            return 0;\n        });\n        return true;\n    };\n    JS.objectLessAttributes = function (obj, less) {\n        var ret = Object.assign({}, obj);\n        if (less) {\n            if (typeof less === 'string') {\n                delete ret[less];\n            }\n            else {\n                less.forEach(function (attr) {\n                    delete ret[attr];\n                });\n            }\n        }\n        return ret;\n    };\n    JS.filenameToContentType = function (filename, defVal) {\n        if (defVal === void 0) { defVal = 'application/octet-stream'; }\n        var name = filename.toLowerCase();\n        var filtered = MIME_MAP.filter(function (mime) { return name.endsWith('.' + mime.ext); });\n        return filtered.length > 0 ? filtered[0].type : defVal;\n    };\n    JS.isTextFile = function (contentType) {\n        var type = contentType.toLowerCase();\n        if (type.startsWith('text/')) {\n            return true;\n        }\n        return ('application/json' === type ||\n            'application/xml' === type ||\n            'application/sh' === type);\n    };\n    /**\n     * generate random string\n     */\n    JS.generateRandomString = function () {\n        var result = '';\n        var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';\n        for (var i = 32; i > 0; i -= 1) {\n            result += chars[Math.floor(Math.random() * chars.length)];\n        }\n        return result;\n    };\n    JS.makeQuerablePromise = function (promise) {\n        if (promise.isResolved)\n            return promise;\n        var isPending = true;\n        var isRejected = false;\n        var isFullfilled = false;\n        var result = promise.then(function (data) {\n            isFullfilled = true;\n            isPending = false;\n            return data;\n        }, function (e) {\n            isRejected = true;\n            isPending = false;\n            throw e;\n        });\n        result.isFullfilled = function () { return isFullfilled; };\n        result.isPending = function () { return isPending; };\n        result.isRejected = function () { return isRejected; };\n        return result;\n    };\n    JS.browserOrNode = function () {\n        var isBrowser = typeof window !== 'undefined' && typeof window.document !== 'undefined';\n        var isNode = typeof process !== 'undefined' &&\n            process.versions != null &&\n            process.versions.node != null;\n        return {\n            isBrowser: isBrowser,\n            isNode: isNode\n        };\n    };\n    /**\n     * transfer the first letter of the keys to lowercase\n     * @param {Object} obj - the object need to be transferred\n     * @param {Array} whiteListForItself - whitelist itself from being transferred\n     * @param {Array} whiteListForChildren - whitelist its children keys from being transferred\n     */\n    JS.transferKeyToLowerCase = function (obj, whiteListForItself, whiteListForChildren) {\n        if (whiteListForItself === void 0) { whiteListForItself = []; }\n        if (whiteListForChildren === void 0) { whiteListForChildren = []; }\n        if (typeof obj !== 'object' || Array.isArray(obj))\n            return obj;\n        var ret = {};\n        for (var key in obj) {\n            if (obj.hasOwnProperty(key)) {\n                var transferedKey = whiteListForItself.includes(key) ?\n                    key : key[0].toLowerCase() + key.slice(1);\n                ret[transferedKey] = whiteListForChildren.includes(key) ?\n                    obj[key]\n                    :\n                        JS.transferKeyToLowerCase(obj[key], whiteListForItself, whiteListForChildren);\n            }\n        }\n        return ret;\n    };\n    /**\n     * transfer the first letter of the keys to lowercase\n     * @param {Object} obj - the object need to be transferred\n     * @param {Array} whiteListForItself - whitelist itself from being transferred\n     * @param {Array} whiteListForChildren - whitelist its children keys from being transferred\n     */\n    JS.transferKeyToUpperCase = function (obj, whiteListForItself, whiteListForChildren) {\n        if (whiteListForItself === void 0) { whiteListForItself = []; }\n        if (whiteListForChildren === void 0) { whiteListForChildren = []; }\n        if (typeof obj !== 'object' || Array.isArray(obj))\n            return obj;\n        var ret = {};\n        for (var key in obj) {\n            if (obj.hasOwnProperty(key)) {\n                var transferedKey = whiteListForItself.includes(key) ?\n                    key : key[0].toUpperCase() + key.slice(1);\n                ret[transferedKey] = whiteListForChildren.includes(key) ?\n                    obj[key]\n                    :\n                        JS.transferKeyToUpperCase(obj[key], whiteListForItself, whiteListForChildren);\n            }\n        }\n        return ret;\n    };\n    return JS;\n}());\nexports.default = JS;\n//# sourceMappingURL=JS.js.map\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../process/browser.js */ \"./node_modules/process/browser.js\")))//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL0pTLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bhd3MtYW1wbGlmeS9jb3JlL2xpYi9KUy5qcz83ODg5Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuLypcbiAqIENvcHlyaWdodCAyMDE3LTIwMTcgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGhcbiAqIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICBodHRwOi8vYXdzLmFtYXpvbi5jb20vYXBhY2hlMi4wL1xuICpcbiAqIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUlxuICogQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbnZhciBNSU1FX01BUCA9IFtcbiAgICB7IHR5cGU6ICd0ZXh0L3BsYWluJywgZXh0OiAndHh0JyB9LFxuICAgIHsgdHlwZTogJ3RleHQvaHRtbCcsIGV4dDogJ2h0bWwnIH0sXG4gICAgeyB0eXBlOiAndGV4dC9qYXZhc2NyaXB0JywgZXh0OiAnanMnIH0sXG4gICAgeyB0eXBlOiAndGV4dC9jc3MnLCBleHQ6ICdjc3MnIH0sXG4gICAgeyB0eXBlOiAndGV4dC9jc3YnLCBleHQ6ICdjc3YnIH0sXG4gICAgeyB0eXBlOiAndGV4dC95YW1sJywgZXh0OiAneW1sJyB9LFxuICAgIHsgdHlwZTogJ3RleHQveWFtbCcsIGV4dDogJ3lhbWwnIH0sXG4gICAgeyB0eXBlOiAndGV4dC9jYWxlbmRhcicsIGV4dDogJ2ljcycgfSxcbiAgICB7IHR5cGU6ICd0ZXh0L2NhbGVuZGFyJywgZXh0OiAnaWNhbCcgfSxcbiAgICB7IHR5cGU6ICdpbWFnZS9wbmcnLCBleHQ6ICdwbmcnIH0sXG4gICAgeyB0eXBlOiAnaW1hZ2UvZ2lmJywgZXh0OiAnZ2lmJyB9LFxuICAgIHsgdHlwZTogJ2ltYWdlL2pwZWcnLCBleHQ6ICdqcGcnIH0sXG4gICAgeyB0eXBlOiAnaW1hZ2UvanBlZycsIGV4dDogJ2pwZWcnIH0sXG4gICAgeyB0eXBlOiAnaW1hZ2UvYm1wJywgZXh0OiAnYm1wJyB9LFxuICAgIHsgdHlwZTogJ2ltYWdlL3gtaWNvbicsIGV4dDogJ2ljbycgfSxcbiAgICB7IHR5cGU6ICdpbWFnZS90aWZmJywgZXh0OiAndGlmJyB9LFxuICAgIHsgdHlwZTogJ2ltYWdlL3RpZmYnLCBleHQ6ICd0aWZmJyB9LFxuICAgIHsgdHlwZTogJ2ltYWdlL3N2Zyt4bWwnLCBleHQ6ICdzdmcnIH0sXG4gICAgeyB0eXBlOiAnYXBwbGljYXRpb24vanNvbicsIGV4dDogJ2pzb24nIH0sXG4gICAgeyB0eXBlOiAnYXBwbGljYXRpb24veG1sJywgZXh0OiAneG1sJyB9LFxuICAgIHsgdHlwZTogJ2FwcGxpY2F0aW9uL3gtc2gnLCBleHQ6ICdzaCcgfSxcbiAgICB7IHR5cGU6ICdhcHBsaWNhdGlvbi96aXAnLCBleHQ6ICd6aXAnIH0sXG4gICAgeyB0eXBlOiAnYXBwbGljYXRpb24veC1yYXItY29tcHJlc3NlZCcsIGV4dDogJ3JhcicgfSxcbiAgICB7IHR5cGU6ICdhcHBsaWNhdGlvbi94LXRhcicsIGV4dDogJ3RhcicgfSxcbiAgICB7IHR5cGU6ICdhcHBsaWNhdGlvbi94LWJ6aXAnLCBleHQ6ICdieicgfSxcbiAgICB7IHR5cGU6ICdhcHBsaWNhdGlvbi94LWJ6aXAyJywgZXh0OiAnYnoyJyB9LFxuICAgIHsgdHlwZTogJ2FwcGxpY2F0aW9uL3BkZicsIGV4dDogJ3BkZicgfSxcbiAgICB7IHR5cGU6ICdhcHBsaWNhdGlvbi9qYXZhLWFyY2hpdmUnLCBleHQ6ICdqYXInIH0sXG4gICAgeyB0eXBlOiAnYXBwbGljYXRpb24vbXN3b3JkJywgZXh0OiAnZG9jJyB9LFxuICAgIHsgdHlwZTogJ2FwcGxpY2F0aW9uL3ZuZC5tcy1leGNlbCcsIGV4dDogJ3hscycgfSxcbiAgICB7IHR5cGU6ICdhcHBsaWNhdGlvbi92bmQubXMtZXhjZWwnLCBleHQ6ICd4bHN4JyB9LFxuICAgIHsgdHlwZTogJ21lc3NhZ2UvcmZjODIyJywgZXh0OiAnZW1sJyB9XG5dO1xudmFyIEpTID0gLyoqIEBjbGFzcyAqLyAoZnVuY3Rpb24gKCkge1xuICAgIGZ1bmN0aW9uIEpTKCkge1xuICAgIH1cbiAgICBKUy5pc0VtcHR5ID0gZnVuY3Rpb24gKG9iaikge1xuICAgICAgICByZXR1cm4gT2JqZWN0LmtleXMob2JqKS5sZW5ndGggPT09IDA7XG4gICAgfTtcbiAgICBKUy5zb3J0QnlGaWVsZCA9IGZ1bmN0aW9uIChsaXN0LCBmaWVsZCwgZGlyKSB7XG4gICAgICAgIGlmICghbGlzdCB8fCAhbGlzdC5zb3J0KSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cbiAgICAgICAgdmFyIGRpclggPSAoZGlyICYmIGRpciA9PT0gJ2Rlc2MnKSA/IC0xIDogMTtcbiAgICAgICAgbGlzdC5zb3J0KGZ1bmN0aW9uIChhLCBiKSB7XG4gICAgICAgICAgICB2YXIgYV92YWwgPSBhW2ZpZWxkXTtcbiAgICAgICAgICAgIHZhciBiX3ZhbCA9IGJbZmllbGRdO1xuICAgICAgICAgICAgaWYgKHR5cGVvZiBiX3ZhbCA9PT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gKHR5cGVvZiBhX3ZhbCA9PT0gJ3VuZGVmaW5lZCcpID8gMCA6IDEgKiBkaXJYO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKHR5cGVvZiBhX3ZhbCA9PT0gJ3VuZGVmaW5lZCcpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gLTEgKiBkaXJYO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKGFfdmFsIDwgYl92YWwpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gLTEgKiBkaXJYO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgaWYgKGFfdmFsID4gYl92YWwpIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gMSAqIGRpclg7XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICByZXR1cm4gMDtcbiAgICAgICAgfSk7XG4gICAgICAgIHJldHVybiB0cnVlO1xuICAgIH07XG4gICAgSlMub2JqZWN0TGVzc0F0dHJpYnV0ZXMgPSBmdW5jdGlvbiAob2JqLCBsZXNzKSB7XG4gICAgICAgIHZhciByZXQgPSBPYmplY3QuYXNzaWduKHt9LCBvYmopO1xuICAgICAgICBpZiAobGVzcykge1xuICAgICAgICAgICAgaWYgKHR5cGVvZiBsZXNzID09PSAnc3RyaW5nJykge1xuICAgICAgICAgICAgICAgIGRlbGV0ZSByZXRbbGVzc107XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICBsZXNzLmZvckVhY2goZnVuY3Rpb24gKGF0dHIpIHtcbiAgICAgICAgICAgICAgICAgICAgZGVsZXRlIHJldFthdHRyXTtcbiAgICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH07XG4gICAgSlMuZmlsZW5hbWVUb0NvbnRlbnRUeXBlID0gZnVuY3Rpb24gKGZpbGVuYW1lLCBkZWZWYWwpIHtcbiAgICAgICAgaWYgKGRlZlZhbCA9PT0gdm9pZCAwKSB7IGRlZlZhbCA9ICdhcHBsaWNhdGlvbi9vY3RldC1zdHJlYW0nOyB9XG4gICAgICAgIHZhciBuYW1lID0gZmlsZW5hbWUudG9Mb3dlckNhc2UoKTtcbiAgICAgICAgdmFyIGZpbHRlcmVkID0gTUlNRV9NQVAuZmlsdGVyKGZ1bmN0aW9uIChtaW1lKSB7IHJldHVybiBuYW1lLmVuZHNXaXRoKCcuJyArIG1pbWUuZXh0KTsgfSk7XG4gICAgICAgIHJldHVybiBmaWx0ZXJlZC5sZW5ndGggPiAwID8gZmlsdGVyZWRbMF0udHlwZSA6IGRlZlZhbDtcbiAgICB9O1xuICAgIEpTLmlzVGV4dEZpbGUgPSBmdW5jdGlvbiAoY29udGVudFR5cGUpIHtcbiAgICAgICAgdmFyIHR5cGUgPSBjb250ZW50VHlwZS50b0xvd2VyQ2FzZSgpO1xuICAgICAgICBpZiAodHlwZS5zdGFydHNXaXRoKCd0ZXh0LycpKSB7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gKCdhcHBsaWNhdGlvbi9qc29uJyA9PT0gdHlwZSB8fFxuICAgICAgICAgICAgJ2FwcGxpY2F0aW9uL3htbCcgPT09IHR5cGUgfHxcbiAgICAgICAgICAgICdhcHBsaWNhdGlvbi9zaCcgPT09IHR5cGUpO1xuICAgIH07XG4gICAgLyoqXG4gICAgICogZ2VuZXJhdGUgcmFuZG9tIHN0cmluZ1xuICAgICAqL1xuICAgIEpTLmdlbmVyYXRlUmFuZG9tU3RyaW5nID0gZnVuY3Rpb24gKCkge1xuICAgICAgICB2YXIgcmVzdWx0ID0gJyc7XG4gICAgICAgIHZhciBjaGFycyA9ICcwMTIzNDU2Nzg5YWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXpBQkNERUZHSElKS0xNTk9QUVJTVFVWV1hZWic7XG4gICAgICAgIGZvciAodmFyIGkgPSAzMjsgaSA+IDA7IGkgLT0gMSkge1xuICAgICAgICAgICAgcmVzdWx0ICs9IGNoYXJzW01hdGguZmxvb3IoTWF0aC5yYW5kb20oKSAqIGNoYXJzLmxlbmd0aCldO1xuICAgICAgICB9XG4gICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgfTtcbiAgICBKUy5tYWtlUXVlcmFibGVQcm9taXNlID0gZnVuY3Rpb24gKHByb21pc2UpIHtcbiAgICAgICAgaWYgKHByb21pc2UuaXNSZXNvbHZlZClcbiAgICAgICAgICAgIHJldHVybiBwcm9taXNlO1xuICAgICAgICB2YXIgaXNQZW5kaW5nID0gdHJ1ZTtcbiAgICAgICAgdmFyIGlzUmVqZWN0ZWQgPSBmYWxzZTtcbiAgICAgICAgdmFyIGlzRnVsbGZpbGxlZCA9IGZhbHNlO1xuICAgICAgICB2YXIgcmVzdWx0ID0gcHJvbWlzZS50aGVuKGZ1bmN0aW9uIChkYXRhKSB7XG4gICAgICAgICAgICBpc0Z1bGxmaWxsZWQgPSB0cnVlO1xuICAgICAgICAgICAgaXNQZW5kaW5nID0gZmFsc2U7XG4gICAgICAgICAgICByZXR1cm4gZGF0YTtcbiAgICAgICAgfSwgZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgICAgIGlzUmVqZWN0ZWQgPSB0cnVlO1xuICAgICAgICAgICAgaXNQZW5kaW5nID0gZmFsc2U7XG4gICAgICAgICAgICB0aHJvdyBlO1xuICAgICAgICB9KTtcbiAgICAgICAgcmVzdWx0LmlzRnVsbGZpbGxlZCA9IGZ1bmN0aW9uICgpIHsgcmV0dXJuIGlzRnVsbGZpbGxlZDsgfTtcbiAgICAgICAgcmVzdWx0LmlzUGVuZGluZyA9IGZ1bmN0aW9uICgpIHsgcmV0dXJuIGlzUGVuZGluZzsgfTtcbiAgICAgICAgcmVzdWx0LmlzUmVqZWN0ZWQgPSBmdW5jdGlvbiAoKSB7IHJldHVybiBpc1JlamVjdGVkOyB9O1xuICAgICAgICByZXR1cm4gcmVzdWx0O1xuICAgIH07XG4gICAgSlMuYnJvd3Nlck9yTm9kZSA9IGZ1bmN0aW9uICgpIHtcbiAgICAgICAgdmFyIGlzQnJvd3NlciA9IHR5cGVvZiB3aW5kb3cgIT09ICd1bmRlZmluZWQnICYmIHR5cGVvZiB3aW5kb3cuZG9jdW1lbnQgIT09ICd1bmRlZmluZWQnO1xuICAgICAgICB2YXIgaXNOb2RlID0gdHlwZW9mIHByb2Nlc3MgIT09ICd1bmRlZmluZWQnICYmXG4gICAgICAgICAgICBwcm9jZXNzLnZlcnNpb25zICE9IG51bGwgJiZcbiAgICAgICAgICAgIHByb2Nlc3MudmVyc2lvbnMubm9kZSAhPSBudWxsO1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgaXNCcm93c2VyOiBpc0Jyb3dzZXIsXG4gICAgICAgICAgICBpc05vZGU6IGlzTm9kZVxuICAgICAgICB9O1xuICAgIH07XG4gICAgLyoqXG4gICAgICogdHJhbnNmZXIgdGhlIGZpcnN0IGxldHRlciBvZiB0aGUga2V5cyB0byBsb3dlcmNhc2VcbiAgICAgKiBAcGFyYW0ge09iamVjdH0gb2JqIC0gdGhlIG9iamVjdCBuZWVkIHRvIGJlIHRyYW5zZmVycmVkXG4gICAgICogQHBhcmFtIHtBcnJheX0gd2hpdGVMaXN0Rm9ySXRzZWxmIC0gd2hpdGVsaXN0IGl0c2VsZiBmcm9tIGJlaW5nIHRyYW5zZmVycmVkXG4gICAgICogQHBhcmFtIHtBcnJheX0gd2hpdGVMaXN0Rm9yQ2hpbGRyZW4gLSB3aGl0ZWxpc3QgaXRzIGNoaWxkcmVuIGtleXMgZnJvbSBiZWluZyB0cmFuc2ZlcnJlZFxuICAgICAqL1xuICAgIEpTLnRyYW5zZmVyS2V5VG9Mb3dlckNhc2UgPSBmdW5jdGlvbiAob2JqLCB3aGl0ZUxpc3RGb3JJdHNlbGYsIHdoaXRlTGlzdEZvckNoaWxkcmVuKSB7XG4gICAgICAgIGlmICh3aGl0ZUxpc3RGb3JJdHNlbGYgPT09IHZvaWQgMCkgeyB3aGl0ZUxpc3RGb3JJdHNlbGYgPSBbXTsgfVxuICAgICAgICBpZiAod2hpdGVMaXN0Rm9yQ2hpbGRyZW4gPT09IHZvaWQgMCkgeyB3aGl0ZUxpc3RGb3JDaGlsZHJlbiA9IFtdOyB9XG4gICAgICAgIGlmICh0eXBlb2Ygb2JqICE9PSAnb2JqZWN0JyB8fCBBcnJheS5pc0FycmF5KG9iaikpXG4gICAgICAgICAgICByZXR1cm4gb2JqO1xuICAgICAgICB2YXIgcmV0ID0ge307XG4gICAgICAgIGZvciAodmFyIGtleSBpbiBvYmopIHtcbiAgICAgICAgICAgIGlmIChvYmouaGFzT3duUHJvcGVydHkoa2V5KSkge1xuICAgICAgICAgICAgICAgIHZhciB0cmFuc2ZlcmVkS2V5ID0gd2hpdGVMaXN0Rm9ySXRzZWxmLmluY2x1ZGVzKGtleSkgP1xuICAgICAgICAgICAgICAgICAgICBrZXkgOiBrZXlbMF0udG9Mb3dlckNhc2UoKSArIGtleS5zbGljZSgxKTtcbiAgICAgICAgICAgICAgICByZXRbdHJhbnNmZXJlZEtleV0gPSB3aGl0ZUxpc3RGb3JDaGlsZHJlbi5pbmNsdWRlcyhrZXkpID9cbiAgICAgICAgICAgICAgICAgICAgb2JqW2tleV1cbiAgICAgICAgICAgICAgICAgICAgOlxuICAgICAgICAgICAgICAgICAgICAgICAgSlMudHJhbnNmZXJLZXlUb0xvd2VyQ2FzZShvYmpba2V5XSwgd2hpdGVMaXN0Rm9ySXRzZWxmLCB3aGl0ZUxpc3RGb3JDaGlsZHJlbik7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9O1xuICAgIC8qKlxuICAgICAqIHRyYW5zZmVyIHRoZSBmaXJzdCBsZXR0ZXIgb2YgdGhlIGtleXMgdG8gbG93ZXJjYXNlXG4gICAgICogQHBhcmFtIHtPYmplY3R9IG9iaiAtIHRoZSBvYmplY3QgbmVlZCB0byBiZSB0cmFuc2ZlcnJlZFxuICAgICAqIEBwYXJhbSB7QXJyYXl9IHdoaXRlTGlzdEZvckl0c2VsZiAtIHdoaXRlbGlzdCBpdHNlbGYgZnJvbSBiZWluZyB0cmFuc2ZlcnJlZFxuICAgICAqIEBwYXJhbSB7QXJyYXl9IHdoaXRlTGlzdEZvckNoaWxkcmVuIC0gd2hpdGVsaXN0IGl0cyBjaGlsZHJlbiBrZXlzIGZyb20gYmVpbmcgdHJhbnNmZXJyZWRcbiAgICAgKi9cbiAgICBKUy50cmFuc2ZlcktleVRvVXBwZXJDYXNlID0gZnVuY3Rpb24gKG9iaiwgd2hpdGVMaXN0Rm9ySXRzZWxmLCB3aGl0ZUxpc3RGb3JDaGlsZHJlbikge1xuICAgICAgICBpZiAod2hpdGVMaXN0Rm9ySXRzZWxmID09PSB2b2lkIDApIHsgd2hpdGVMaXN0Rm9ySXRzZWxmID0gW107IH1cbiAgICAgICAgaWYgKHdoaXRlTGlzdEZvckNoaWxkcmVuID09PSB2b2lkIDApIHsgd2hpdGVMaXN0Rm9yQ2hpbGRyZW4gPSBbXTsgfVxuICAgICAgICBpZiAodHlwZW9mIG9iaiAhPT0gJ29iamVjdCcgfHwgQXJyYXkuaXNBcnJheShvYmopKVxuICAgICAgICAgICAgcmV0dXJuIG9iajtcbiAgICAgICAgdmFyIHJldCA9IHt9O1xuICAgICAgICBmb3IgKHZhciBrZXkgaW4gb2JqKSB7XG4gICAgICAgICAgICBpZiAob2JqLmhhc093blByb3BlcnR5KGtleSkpIHtcbiAgICAgICAgICAgICAgICB2YXIgdHJhbnNmZXJlZEtleSA9IHdoaXRlTGlzdEZvckl0c2VsZi5pbmNsdWRlcyhrZXkpID9cbiAgICAgICAgICAgICAgICAgICAga2V5IDoga2V5WzBdLnRvVXBwZXJDYXNlKCkgKyBrZXkuc2xpY2UoMSk7XG4gICAgICAgICAgICAgICAgcmV0W3RyYW5zZmVyZWRLZXldID0gd2hpdGVMaXN0Rm9yQ2hpbGRyZW4uaW5jbHVkZXMoa2V5KSA/XG4gICAgICAgICAgICAgICAgICAgIG9ialtrZXldXG4gICAgICAgICAgICAgICAgICAgIDpcbiAgICAgICAgICAgICAgICAgICAgICAgIEpTLnRyYW5zZmVyS2V5VG9VcHBlckNhc2Uob2JqW2tleV0sIHdoaXRlTGlzdEZvckl0c2VsZiwgd2hpdGVMaXN0Rm9yQ2hpbGRyZW4pO1xuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHJldHVybiByZXQ7XG4gICAgfTtcbiAgICByZXR1cm4gSlM7XG59KCkpO1xuZXhwb3J0cy5kZWZhdWx0ID0gSlM7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1KUy5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/JS.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Logger/ConsoleLogger.js":
/*!********************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Logger/ConsoleLogger.js ***!
  \********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar LOG_LEVELS = {\n    VERBOSE: 1,\n    DEBUG: 2,\n    INFO: 3,\n    WARN: 4,\n    ERROR: 5\n};\n/**\n* Write logs\n* @class Logger\n*/\nvar ConsoleLogger = /** @class */ (function () {\n    /**\n    * @constructor\n    * @param {string} name - Name of the logger\n    */\n    function ConsoleLogger(name, level) {\n        if (level === void 0) { level = 'WARN'; }\n        this.name = name;\n        this.level = level;\n    }\n    ConsoleLogger.prototype._padding = function (n) {\n        return n < 10 ? '0' + n : '' + n;\n    };\n    ConsoleLogger.prototype._ts = function () {\n        var dt = new Date();\n        return [\n            this._padding(dt.getMinutes()),\n            this._padding(dt.getSeconds())\n        ].join(':') + '.' + dt.getMilliseconds();\n    };\n    /**\n    * Write log\n    * @method\n    * @memeberof Logger\n    * @param {string} type - log type, default INFO\n    * @param {string|object} msg - Logging message or object\n    */\n    ConsoleLogger.prototype._log = function (type) {\n        var msg = [];\n        for (var _i = 1; _i < arguments.length; _i++) {\n            msg[_i - 1] = arguments[_i];\n        }\n        var logger_level_name = this.level;\n        if (ConsoleLogger.LOG_LEVEL) {\n            logger_level_name = ConsoleLogger.LOG_LEVEL;\n        }\n        if ((typeof window !== 'undefined') && window.LOG_LEVEL) {\n            logger_level_name = window.LOG_LEVEL;\n        }\n        var logger_level = LOG_LEVELS[logger_level_name];\n        var type_level = LOG_LEVELS[type];\n        if (!(type_level >= logger_level)) {\n            // Do nothing if type is not greater than or equal to logger level (handle undefined)\n            return;\n        }\n        var log = console.log.bind(console);\n        // if (type === 'ERROR' && console.error) { log = console.error.bind(console); }\n        if (type === 'WARN' && console.warn) {\n            log = console.warn.bind(console);\n        }\n        var prefix = \"[\" + type + \"] \" + this._ts() + \" \" + this.name;\n        if (msg.length === 1 && typeof msg[0] === 'string') {\n            log(prefix + \" - \" + msg[0]);\n        }\n        else if (msg.length === 1) {\n            log(prefix, msg[0]);\n        }\n        else if (typeof msg[0] === 'string') {\n            var obj = msg.slice(1);\n            if (obj.length === 1) {\n                obj = obj[0];\n            }\n            log(prefix + \" - \" + msg[0], obj);\n        }\n        else {\n            log(prefix, msg);\n        }\n    };\n    /**\n    * Write General log. Default to INFO\n    * @method\n    * @memeberof Logger\n    * @param {string|object} msg - Logging message or object\n    */\n    ConsoleLogger.prototype.log = function () {\n        var msg = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            msg[_i] = arguments[_i];\n        }\n        this._log.apply(this, ['INFO'].concat(msg));\n    };\n    /**\n    * Write INFO log\n    * @method\n    * @memeberof Logger\n    * @param {string|object} msg - Logging message or object\n    */\n    ConsoleLogger.prototype.info = function () {\n        var msg = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            msg[_i] = arguments[_i];\n        }\n        this._log.apply(this, ['INFO'].concat(msg));\n    };\n    /**\n    * Write WARN log\n    * @method\n    * @memeberof Logger\n    * @param {string|object} msg - Logging message or object\n    */\n    ConsoleLogger.prototype.warn = function () {\n        var msg = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            msg[_i] = arguments[_i];\n        }\n        this._log.apply(this, ['WARN'].concat(msg));\n    };\n    /**\n    * Write ERROR log\n    * @method\n    * @memeberof Logger\n    * @param {string|object} msg - Logging message or object\n    */\n    ConsoleLogger.prototype.error = function () {\n        var msg = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            msg[_i] = arguments[_i];\n        }\n        this._log.apply(this, ['ERROR'].concat(msg));\n    };\n    /**\n    * Write DEBUG log\n    * @method\n    * @memeberof Logger\n    * @param {string|object} msg - Logging message or object\n    */\n    ConsoleLogger.prototype.debug = function () {\n        var msg = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            msg[_i] = arguments[_i];\n        }\n        this._log.apply(this, ['DEBUG'].concat(msg));\n    };\n    /**\n    * Write VERBOSE log\n    * @method\n    * @memeberof Logger\n    * @param {string|object} msg - Logging message or object\n    */\n    ConsoleLogger.prototype.verbose = function () {\n        var msg = [];\n        for (var _i = 0; _i < arguments.length; _i++) {\n            msg[_i] = arguments[_i];\n        }\n        this._log.apply(this, ['VERBOSE'].concat(msg));\n    };\n    ConsoleLogger.LOG_LEVEL = null;\n    return ConsoleLogger;\n}());\nexports.ConsoleLogger = ConsoleLogger;\n//# sourceMappingURL=ConsoleLogger.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Logger/ConsoleLogger.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Logger/index.js":
/*!************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Logger/index.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nfunction __export(m) {\n    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];\n}\nObject.defineProperty(exports, \"__esModule\", { value: true });\n__export(__webpack_require__(/*! ./ConsoleLogger */ \"./node_modules/@aws-amplify/core/lib/Logger/ConsoleLogger.js\"));\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL0xvZ2dlci9pbmRleC5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9AYXdzLWFtcGxpZnkvY29yZS9saWIvTG9nZ2VyL2luZGV4LmpzP2I3OTAiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG4vKlxuICogQ29weXJpZ2h0IDIwMTctMjAxNyBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aFxuICogdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgIGh0dHA6Ly9hd3MuYW1hem9uLmNvbS9hcGFjaGUyLjAvXG4gKlxuICogb3IgaW4gdGhlIFwibGljZW5zZVwiIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTIE9SXG4gKiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuZnVuY3Rpb24gX19leHBvcnQobSkge1xuICAgIGZvciAodmFyIHAgaW4gbSkgaWYgKCFleHBvcnRzLmhhc093blByb3BlcnR5KHApKSBleHBvcnRzW3BdID0gbVtwXTtcbn1cbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbl9fZXhwb3J0KHJlcXVpcmUoXCIuL0NvbnNvbGVMb2dnZXJcIikpO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9aW5kZXguanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Logger/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/OAuthHelper/FacebookOAuth.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/OAuthHelper/FacebookOAuth.js ***!
  \*************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), \"throw\": verb(1), \"return\": verb(2) }, typeof Symbol === \"function\" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError(\"Generator is already executing.\");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y[\"return\"] : op[0] ? y[\"throw\"] || ((t = y[\"return\"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar Logger_1 = __webpack_require__(/*! ../Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar JS_1 = __webpack_require__(/*! ../JS */ \"./node_modules/@aws-amplify/core/lib/JS.js\");\nvar logger = new Logger_1.ConsoleLogger('CognitoCredentials');\nvar waitForInit = new Promise(function (res, rej) {\n    if (!JS_1.default.browserOrNode().isBrowser) {\n        logger.debug('not in the browser, directly resolved');\n        return res();\n    }\n    var fb = window['FB'];\n    if (fb) {\n        logger.debug('FB SDK already loaded');\n        return res();\n    }\n    else {\n        setTimeout(function () {\n            return res();\n        }, 2000);\n    }\n});\nvar FacebookOAuth = /** @class */ (function () {\n    function FacebookOAuth() {\n        this.initialized = false;\n        this.refreshFacebookToken = this.refreshFacebookToken.bind(this);\n        this._refreshFacebookTokenImpl = this._refreshFacebookTokenImpl.bind(this);\n    }\n    FacebookOAuth.prototype.refreshFacebookToken = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        if (!!this.initialized) return [3 /*break*/, 2];\n                        logger.debug('need to wait for the Facebook SDK loaded');\n                        return [4 /*yield*/, waitForInit];\n                    case 1:\n                        _a.sent();\n                        this.initialized = true;\n                        logger.debug('finish waiting');\n                        _a.label = 2;\n                    case 2: return [2 /*return*/, this._refreshFacebookTokenImpl()];\n                }\n            });\n        });\n    };\n    FacebookOAuth.prototype._refreshFacebookTokenImpl = function () {\n        var fb = null;\n        if (JS_1.default.browserOrNode().isBrowser)\n            fb = window['FB'];\n        if (!fb) {\n            logger.debug('no fb sdk available');\n            return Promise.reject('no fb sdk available');\n        }\n        return new Promise(function (res, rej) {\n            fb.getLoginStatus(function (fbResponse) {\n                if (!fbResponse || !fbResponse.authResponse) {\n                    logger.debug('no response from facebook when refreshing the jwt token');\n                    rej('no response from facebook when refreshing the jwt token');\n                }\n                var response = fbResponse.authResponse;\n                var accessToken = response.accessToken, expiresIn = response.expiresIn;\n                var date = new Date();\n                var expires_at = expiresIn * 1000 + date.getTime();\n                if (!accessToken) {\n                    logger.debug('the jwtToken is undefined');\n                    rej('the jwtToken is undefined');\n                }\n                res({ token: accessToken, expires_at: expires_at });\n            }, { scope: 'public_profile,email' });\n        });\n    };\n    return FacebookOAuth;\n}());\nexports.default = FacebookOAuth;\n//# sourceMappingURL=FacebookOAuth.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/OAuthHelper/FacebookOAuth.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/OAuthHelper/GoogleOAuth.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/OAuthHelper/GoogleOAuth.js ***!
  \***********************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nvar __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {\n    return new (P || (P = Promise))(function (resolve, reject) {\n        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }\n        function rejected(value) { try { step(generator[\"throw\"](value)); } catch (e) { reject(e); } }\n        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }\n        step((generator = generator.apply(thisArg, _arguments || [])).next());\n    });\n};\nvar __generator = (this && this.__generator) || function (thisArg, body) {\n    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;\n    return g = { next: verb(0), \"throw\": verb(1), \"return\": verb(2) }, typeof Symbol === \"function\" && (g[Symbol.iterator] = function() { return this; }), g;\n    function verb(n) { return function (v) { return step([n, v]); }; }\n    function step(op) {\n        if (f) throw new TypeError(\"Generator is already executing.\");\n        while (_) try {\n            if (f = 1, y && (t = op[0] & 2 ? y[\"return\"] : op[0] ? y[\"throw\"] || ((t = y[\"return\"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;\n            if (y = 0, t) op = [op[0] & 2, t.value];\n            switch (op[0]) {\n                case 0: case 1: t = op; break;\n                case 4: _.label++; return { value: op[1], done: false };\n                case 5: _.label++; y = op[1]; op = [0]; continue;\n                case 7: op = _.ops.pop(); _.trys.pop(); continue;\n                default:\n                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }\n                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }\n                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }\n                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }\n                    if (t[2]) _.ops.pop();\n                    _.trys.pop(); continue;\n            }\n            op = body.call(thisArg, _);\n        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }\n        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };\n    }\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar Logger_1 = __webpack_require__(/*! ../Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar JS_1 = __webpack_require__(/*! ../JS */ \"./node_modules/@aws-amplify/core/lib/JS.js\");\nvar logger = new Logger_1.ConsoleLogger('CognitoCredentials');\nvar waitForInit = new Promise(function (res, rej) {\n    if (!JS_1.default.browserOrNode().isBrowser) {\n        logger.debug('not in the browser, directly resolved');\n        return res();\n    }\n    var ga = window['gapi'] && window['gapi'].auth2 ? window['gapi'].auth2 : null;\n    if (ga) {\n        logger.debug('google api already loaded');\n        return res();\n    }\n    else {\n        setTimeout(function () {\n            return res();\n        }, 2000);\n    }\n});\nvar GoogleOAuth = /** @class */ (function () {\n    function GoogleOAuth() {\n        this.initialized = false;\n        this.refreshGoogleToken = this.refreshGoogleToken.bind(this);\n        this._refreshGoogleTokenImpl = this._refreshGoogleTokenImpl.bind(this);\n    }\n    GoogleOAuth.prototype.refreshGoogleToken = function () {\n        return __awaiter(this, void 0, void 0, function () {\n            return __generator(this, function (_a) {\n                switch (_a.label) {\n                    case 0:\n                        if (!!this.initialized) return [3 /*break*/, 2];\n                        logger.debug('need to wait for the Google SDK loaded');\n                        return [4 /*yield*/, waitForInit];\n                    case 1:\n                        _a.sent();\n                        this.initialized = true;\n                        logger.debug('finish waiting');\n                        _a.label = 2;\n                    case 2: return [2 /*return*/, this._refreshGoogleTokenImpl()];\n                }\n            });\n        });\n    };\n    GoogleOAuth.prototype._refreshGoogleTokenImpl = function () {\n        var ga = null;\n        if (JS_1.default.browserOrNode().isBrowser)\n            ga = window['gapi'] && window['gapi'].auth2 ? window['gapi'].auth2 : null;\n        if (!ga) {\n            logger.debug('no gapi auth2 available');\n            return Promise.reject('no gapi auth2 available');\n        }\n        return new Promise(function (res, rej) {\n            ga.getAuthInstance().then(function (googleAuth) {\n                if (!googleAuth) {\n                    console.log('google Auth undefiend');\n                    rej('google Auth undefiend');\n                }\n                var googleUser = googleAuth.currentUser.get();\n                // refresh the token\n                if (googleUser.isSignedIn()) {\n                    logger.debug('refreshing the google access token');\n                    googleUser.reloadAuthResponse()\n                        .then(function (authResponse) {\n                        var id_token = authResponse.id_token, expires_at = authResponse.expires_at;\n                        var profile = googleUser.getBasicProfile();\n                        var user = {\n                            email: profile.getEmail(),\n                            name: profile.getName()\n                        };\n                        res({ token: id_token, expires_at: expires_at });\n                    });\n                }\n                else {\n                    rej('User is not signed in with Google');\n                }\n            }).catch(function (err) {\n                logger.debug('Failed to refresh google token', err);\n                rej('Failed to refresh google token');\n            });\n        });\n    };\n    return GoogleOAuth;\n}());\nexports.default = GoogleOAuth;\n//# sourceMappingURL=GoogleOAuth.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL09BdXRoSGVscGVyL0dvb2dsZU9BdXRoLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bhd3MtYW1wbGlmeS9jb3JlL2xpYi9PQXV0aEhlbHBlci9Hb29nbGVPQXV0aC5qcz9kZGEwIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xudmFyIF9fYXdhaXRlciA9ICh0aGlzICYmIHRoaXMuX19hd2FpdGVyKSB8fCBmdW5jdGlvbiAodGhpc0FyZywgX2FyZ3VtZW50cywgUCwgZ2VuZXJhdG9yKSB7XG4gICAgcmV0dXJuIG5ldyAoUCB8fCAoUCA9IFByb21pc2UpKShmdW5jdGlvbiAocmVzb2x2ZSwgcmVqZWN0KSB7XG4gICAgICAgIGZ1bmN0aW9uIGZ1bGZpbGxlZCh2YWx1ZSkgeyB0cnkgeyBzdGVwKGdlbmVyYXRvci5uZXh0KHZhbHVlKSk7IH0gY2F0Y2ggKGUpIHsgcmVqZWN0KGUpOyB9IH1cbiAgICAgICAgZnVuY3Rpb24gcmVqZWN0ZWQodmFsdWUpIHsgdHJ5IHsgc3RlcChnZW5lcmF0b3JbXCJ0aHJvd1wiXSh2YWx1ZSkpOyB9IGNhdGNoIChlKSB7IHJlamVjdChlKTsgfSB9XG4gICAgICAgIGZ1bmN0aW9uIHN0ZXAocmVzdWx0KSB7IHJlc3VsdC5kb25lID8gcmVzb2x2ZShyZXN1bHQudmFsdWUpIDogbmV3IFAoZnVuY3Rpb24gKHJlc29sdmUpIHsgcmVzb2x2ZShyZXN1bHQudmFsdWUpOyB9KS50aGVuKGZ1bGZpbGxlZCwgcmVqZWN0ZWQpOyB9XG4gICAgICAgIHN0ZXAoKGdlbmVyYXRvciA9IGdlbmVyYXRvci5hcHBseSh0aGlzQXJnLCBfYXJndW1lbnRzIHx8IFtdKSkubmV4dCgpKTtcbiAgICB9KTtcbn07XG52YXIgX19nZW5lcmF0b3IgPSAodGhpcyAmJiB0aGlzLl9fZ2VuZXJhdG9yKSB8fCBmdW5jdGlvbiAodGhpc0FyZywgYm9keSkge1xuICAgIHZhciBfID0geyBsYWJlbDogMCwgc2VudDogZnVuY3Rpb24oKSB7IGlmICh0WzBdICYgMSkgdGhyb3cgdFsxXTsgcmV0dXJuIHRbMV07IH0sIHRyeXM6IFtdLCBvcHM6IFtdIH0sIGYsIHksIHQsIGc7XG4gICAgcmV0dXJuIGcgPSB7IG5leHQ6IHZlcmIoMCksIFwidGhyb3dcIjogdmVyYigxKSwgXCJyZXR1cm5cIjogdmVyYigyKSB9LCB0eXBlb2YgU3ltYm9sID09PSBcImZ1bmN0aW9uXCIgJiYgKGdbU3ltYm9sLml0ZXJhdG9yXSA9IGZ1bmN0aW9uKCkgeyByZXR1cm4gdGhpczsgfSksIGc7XG4gICAgZnVuY3Rpb24gdmVyYihuKSB7IHJldHVybiBmdW5jdGlvbiAodikgeyByZXR1cm4gc3RlcChbbiwgdl0pOyB9OyB9XG4gICAgZnVuY3Rpb24gc3RlcChvcCkge1xuICAgICAgICBpZiAoZikgdGhyb3cgbmV3IFR5cGVFcnJvcihcIkdlbmVyYXRvciBpcyBhbHJlYWR5IGV4ZWN1dGluZy5cIik7XG4gICAgICAgIHdoaWxlIChfKSB0cnkge1xuICAgICAgICAgICAgaWYgKGYgPSAxLCB5ICYmICh0ID0gb3BbMF0gJiAyID8geVtcInJldHVyblwiXSA6IG9wWzBdID8geVtcInRocm93XCJdIHx8ICgodCA9IHlbXCJyZXR1cm5cIl0pICYmIHQuY2FsbCh5KSwgMCkgOiB5Lm5leHQpICYmICEodCA9IHQuY2FsbCh5LCBvcFsxXSkpLmRvbmUpIHJldHVybiB0O1xuICAgICAgICAgICAgaWYgKHkgPSAwLCB0KSBvcCA9IFtvcFswXSAmIDIsIHQudmFsdWVdO1xuICAgICAgICAgICAgc3dpdGNoIChvcFswXSkge1xuICAgICAgICAgICAgICAgIGNhc2UgMDogY2FzZSAxOiB0ID0gb3A7IGJyZWFrO1xuICAgICAgICAgICAgICAgIGNhc2UgNDogXy5sYWJlbCsrOyByZXR1cm4geyB2YWx1ZTogb3BbMV0sIGRvbmU6IGZhbHNlIH07XG4gICAgICAgICAgICAgICAgY2FzZSA1OiBfLmxhYmVsKys7IHkgPSBvcFsxXTsgb3AgPSBbMF07IGNvbnRpbnVlO1xuICAgICAgICAgICAgICAgIGNhc2UgNzogb3AgPSBfLm9wcy5wb3AoKTsgXy50cnlzLnBvcCgpOyBjb250aW51ZTtcbiAgICAgICAgICAgICAgICBkZWZhdWx0OlxuICAgICAgICAgICAgICAgICAgICBpZiAoISh0ID0gXy50cnlzLCB0ID0gdC5sZW5ndGggPiAwICYmIHRbdC5sZW5ndGggLSAxXSkgJiYgKG9wWzBdID09PSA2IHx8IG9wWzBdID09PSAyKSkgeyBfID0gMDsgY29udGludWU7IH1cbiAgICAgICAgICAgICAgICAgICAgaWYgKG9wWzBdID09PSAzICYmICghdCB8fCAob3BbMV0gPiB0WzBdICYmIG9wWzFdIDwgdFszXSkpKSB7IF8ubGFiZWwgPSBvcFsxXTsgYnJlYWs7IH1cbiAgICAgICAgICAgICAgICAgICAgaWYgKG9wWzBdID09PSA2ICYmIF8ubGFiZWwgPCB0WzFdKSB7IF8ubGFiZWwgPSB0WzFdOyB0ID0gb3A7IGJyZWFrOyB9XG4gICAgICAgICAgICAgICAgICAgIGlmICh0ICYmIF8ubGFiZWwgPCB0WzJdKSB7IF8ubGFiZWwgPSB0WzJdOyBfLm9wcy5wdXNoKG9wKTsgYnJlYWs7IH1cbiAgICAgICAgICAgICAgICAgICAgaWYgKHRbMl0pIF8ub3BzLnBvcCgpO1xuICAgICAgICAgICAgICAgICAgICBfLnRyeXMucG9wKCk7IGNvbnRpbnVlO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgb3AgPSBib2R5LmNhbGwodGhpc0FyZywgXyk7XG4gICAgICAgIH0gY2F0Y2ggKGUpIHsgb3AgPSBbNiwgZV07IHkgPSAwOyB9IGZpbmFsbHkgeyBmID0gdCA9IDA7IH1cbiAgICAgICAgaWYgKG9wWzBdICYgNSkgdGhyb3cgb3BbMV07IHJldHVybiB7IHZhbHVlOiBvcFswXSA/IG9wWzFdIDogdm9pZCAwLCBkb25lOiB0cnVlIH07XG4gICAgfVxufTtcbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbi8qXG4gKiBDb3B5cmlnaHQgMjAxNy0yMDE3IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoXG4gKiB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgaHR0cDovL2F3cy5hbWF6b24uY29tL2FwYWNoZTIuMC9cbiAqXG4gKiBvciBpbiB0aGUgXCJsaWNlbnNlXCIgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVMgT1JcbiAqIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG52YXIgTG9nZ2VyXzEgPSByZXF1aXJlKFwiLi4vTG9nZ2VyXCIpO1xudmFyIEpTXzEgPSByZXF1aXJlKFwiLi4vSlNcIik7XG52YXIgbG9nZ2VyID0gbmV3IExvZ2dlcl8xLkNvbnNvbGVMb2dnZXIoJ0NvZ25pdG9DcmVkZW50aWFscycpO1xudmFyIHdhaXRGb3JJbml0ID0gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlcywgcmVqKSB7XG4gICAgaWYgKCFKU18xLmRlZmF1bHQuYnJvd3Nlck9yTm9kZSgpLmlzQnJvd3Nlcikge1xuICAgICAgICBsb2dnZXIuZGVidWcoJ25vdCBpbiB0aGUgYnJvd3NlciwgZGlyZWN0bHkgcmVzb2x2ZWQnKTtcbiAgICAgICAgcmV0dXJuIHJlcygpO1xuICAgIH1cbiAgICB2YXIgZ2EgPSB3aW5kb3dbJ2dhcGknXSAmJiB3aW5kb3dbJ2dhcGknXS5hdXRoMiA/IHdpbmRvd1snZ2FwaSddLmF1dGgyIDogbnVsbDtcbiAgICBpZiAoZ2EpIHtcbiAgICAgICAgbG9nZ2VyLmRlYnVnKCdnb29nbGUgYXBpIGFscmVhZHkgbG9hZGVkJyk7XG4gICAgICAgIHJldHVybiByZXMoKTtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICAgIHNldFRpbWVvdXQoZnVuY3Rpb24gKCkge1xuICAgICAgICAgICAgcmV0dXJuIHJlcygpO1xuICAgICAgICB9LCAyMDAwKTtcbiAgICB9XG59KTtcbnZhciBHb29nbGVPQXV0aCA9IC8qKiBAY2xhc3MgKi8gKGZ1bmN0aW9uICgpIHtcbiAgICBmdW5jdGlvbiBHb29nbGVPQXV0aCgpIHtcbiAgICAgICAgdGhpcy5pbml0aWFsaXplZCA9IGZhbHNlO1xuICAgICAgICB0aGlzLnJlZnJlc2hHb29nbGVUb2tlbiA9IHRoaXMucmVmcmVzaEdvb2dsZVRva2VuLmJpbmQodGhpcyk7XG4gICAgICAgIHRoaXMuX3JlZnJlc2hHb29nbGVUb2tlbkltcGwgPSB0aGlzLl9yZWZyZXNoR29vZ2xlVG9rZW5JbXBsLmJpbmQodGhpcyk7XG4gICAgfVxuICAgIEdvb2dsZU9BdXRoLnByb3RvdHlwZS5yZWZyZXNoR29vZ2xlVG9rZW4gPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgIHJldHVybiBfX2F3YWl0ZXIodGhpcywgdm9pZCAwLCB2b2lkIDAsIGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgIHJldHVybiBfX2dlbmVyYXRvcih0aGlzLCBmdW5jdGlvbiAoX2EpIHtcbiAgICAgICAgICAgICAgICBzd2l0Y2ggKF9hLmxhYmVsKSB7XG4gICAgICAgICAgICAgICAgICAgIGNhc2UgMDpcbiAgICAgICAgICAgICAgICAgICAgICAgIGlmICghIXRoaXMuaW5pdGlhbGl6ZWQpIHJldHVybiBbMyAvKmJyZWFrKi8sIDJdO1xuICAgICAgICAgICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCduZWVkIHRvIHdhaXQgZm9yIHRoZSBHb29nbGUgU0RLIGxvYWRlZCcpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIFs0IC8qeWllbGQqLywgd2FpdEZvckluaXRdO1xuICAgICAgICAgICAgICAgICAgICBjYXNlIDE6XG4gICAgICAgICAgICAgICAgICAgICAgICBfYS5zZW50KCk7XG4gICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmluaXRpYWxpemVkID0gdHJ1ZTtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygnZmluaXNoIHdhaXRpbmcnKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIF9hLmxhYmVsID0gMjtcbiAgICAgICAgICAgICAgICAgICAgY2FzZSAyOiByZXR1cm4gWzIgLypyZXR1cm4qLywgdGhpcy5fcmVmcmVzaEdvb2dsZVRva2VuSW1wbCgpXTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICBHb29nbGVPQXV0aC5wcm90b3R5cGUuX3JlZnJlc2hHb29nbGVUb2tlbkltcGwgPSBmdW5jdGlvbiAoKSB7XG4gICAgICAgIHZhciBnYSA9IG51bGw7XG4gICAgICAgIGlmIChKU18xLmRlZmF1bHQuYnJvd3Nlck9yTm9kZSgpLmlzQnJvd3NlcilcbiAgICAgICAgICAgIGdhID0gd2luZG93WydnYXBpJ10gJiYgd2luZG93WydnYXBpJ10uYXV0aDIgPyB3aW5kb3dbJ2dhcGknXS5hdXRoMiA6IG51bGw7XG4gICAgICAgIGlmICghZ2EpIHtcbiAgICAgICAgICAgIGxvZ2dlci5kZWJ1Zygnbm8gZ2FwaSBhdXRoMiBhdmFpbGFibGUnKTtcbiAgICAgICAgICAgIHJldHVybiBQcm9taXNlLnJlamVjdCgnbm8gZ2FwaSBhdXRoMiBhdmFpbGFibGUnKTtcbiAgICAgICAgfVxuICAgICAgICByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKHJlcywgcmVqKSB7XG4gICAgICAgICAgICBnYS5nZXRBdXRoSW5zdGFuY2UoKS50aGVuKGZ1bmN0aW9uIChnb29nbGVBdXRoKSB7XG4gICAgICAgICAgICAgICAgaWYgKCFnb29nbGVBdXRoKSB7XG4gICAgICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKCdnb29nbGUgQXV0aCB1bmRlZmllbmQnKTtcbiAgICAgICAgICAgICAgICAgICAgcmVqKCdnb29nbGUgQXV0aCB1bmRlZmllbmQnKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgdmFyIGdvb2dsZVVzZXIgPSBnb29nbGVBdXRoLmN1cnJlbnRVc2VyLmdldCgpO1xuICAgICAgICAgICAgICAgIC8vIHJlZnJlc2ggdGhlIHRva2VuXG4gICAgICAgICAgICAgICAgaWYgKGdvb2dsZVVzZXIuaXNTaWduZWRJbigpKSB7XG4gICAgICAgICAgICAgICAgICAgIGxvZ2dlci5kZWJ1ZygncmVmcmVzaGluZyB0aGUgZ29vZ2xlIGFjY2VzcyB0b2tlbicpO1xuICAgICAgICAgICAgICAgICAgICBnb29nbGVVc2VyLnJlbG9hZEF1dGhSZXNwb25zZSgpXG4gICAgICAgICAgICAgICAgICAgICAgICAudGhlbihmdW5jdGlvbiAoYXV0aFJlc3BvbnNlKSB7XG4gICAgICAgICAgICAgICAgICAgICAgICB2YXIgaWRfdG9rZW4gPSBhdXRoUmVzcG9uc2UuaWRfdG9rZW4sIGV4cGlyZXNfYXQgPSBhdXRoUmVzcG9uc2UuZXhwaXJlc19hdDtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciBwcm9maWxlID0gZ29vZ2xlVXNlci5nZXRCYXNpY1Byb2ZpbGUoKTtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhciB1c2VyID0ge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVtYWlsOiBwcm9maWxlLmdldEVtYWlsKCksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgbmFtZTogcHJvZmlsZS5nZXROYW1lKClcbiAgICAgICAgICAgICAgICAgICAgICAgIH07XG4gICAgICAgICAgICAgICAgICAgICAgICByZXMoeyB0b2tlbjogaWRfdG9rZW4sIGV4cGlyZXNfYXQ6IGV4cGlyZXNfYXQgfSk7XG4gICAgICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIHtcbiAgICAgICAgICAgICAgICAgICAgcmVqKCdVc2VyIGlzIG5vdCBzaWduZWQgaW4gd2l0aCBHb29nbGUnKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9KS5jYXRjaChmdW5jdGlvbiAoZXJyKSB7XG4gICAgICAgICAgICAgICAgbG9nZ2VyLmRlYnVnKCdGYWlsZWQgdG8gcmVmcmVzaCBnb29nbGUgdG9rZW4nLCBlcnIpO1xuICAgICAgICAgICAgICAgIHJlaignRmFpbGVkIHRvIHJlZnJlc2ggZ29vZ2xlIHRva2VuJyk7XG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfSk7XG4gICAgfTtcbiAgICByZXR1cm4gR29vZ2xlT0F1dGg7XG59KCkpO1xuZXhwb3J0cy5kZWZhdWx0ID0gR29vZ2xlT0F1dGg7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1Hb29nbGVPQXV0aC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/OAuthHelper/GoogleOAuth.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/OAuthHelper/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/OAuthHelper/index.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", { value: true });\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar GoogleOAuth_1 = __webpack_require__(/*! ./GoogleOAuth */ \"./node_modules/@aws-amplify/core/lib/OAuthHelper/GoogleOAuth.js\");\nvar FacebookOAuth_1 = __webpack_require__(/*! ./FacebookOAuth */ \"./node_modules/@aws-amplify/core/lib/OAuthHelper/FacebookOAuth.js\");\nvar GoogleOAuth = new GoogleOAuth_1.default();\nexports.GoogleOAuth = GoogleOAuth;\nvar FacebookOAuth = new FacebookOAuth_1.default();\nexports.FacebookOAuth = FacebookOAuth;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL09BdXRoSGVscGVyL2luZGV4LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL0Bhd3MtYW1wbGlmeS9jb3JlL2xpYi9PQXV0aEhlbHBlci9pbmRleC5qcz9mZjExIl0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuLypcbiAqIENvcHlyaWdodCAyMDE3LTIwMTcgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGhcbiAqIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICBodHRwOi8vYXdzLmFtYXpvbi5jb20vYXBhY2hlMi4wL1xuICpcbiAqIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUlxuICogQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cbnZhciBHb29nbGVPQXV0aF8xID0gcmVxdWlyZShcIi4vR29vZ2xlT0F1dGhcIik7XG52YXIgRmFjZWJvb2tPQXV0aF8xID0gcmVxdWlyZShcIi4vRmFjZWJvb2tPQXV0aFwiKTtcbnZhciBHb29nbGVPQXV0aCA9IG5ldyBHb29nbGVPQXV0aF8xLmRlZmF1bHQoKTtcbmV4cG9ydHMuR29vZ2xlT0F1dGggPSBHb29nbGVPQXV0aDtcbnZhciBGYWNlYm9va09BdXRoID0gbmV3IEZhY2Vib29rT0F1dGhfMS5kZWZhdWx0KCk7XG5leHBvcnRzLkZhY2Vib29rT0F1dGggPSBGYWNlYm9va09BdXRoO1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9aW5kZXguanMubWFwIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/OAuthHelper/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Parser.js":
/*!******************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Parser.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Logger_1 = __webpack_require__(/*! ./Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar logger = new Logger_1.ConsoleLogger('Parser');\nvar Parser = /** @class */ (function () {\n    function Parser() {\n    }\n    Parser.parseMobilehubConfig = function (config) {\n        var amplifyConfig = {};\n        // Analytics\n        if (config['aws_mobile_analytics_app_id']) {\n            var Analytics = {\n                AWSPinpoint: {\n                    appId: config['aws_mobile_analytics_app_id'],\n                    region: config['aws_mobile_analytics_app_region']\n                }\n            };\n            amplifyConfig.Analytics = Analytics;\n        }\n        // Auth\n        if (config['aws_cognito_identity_pool_id'] || config['aws_user_pools_id']) {\n            var Auth = {\n                userPoolId: config['aws_user_pools_id'],\n                userPoolWebClientId: config['aws_user_pools_web_client_id'],\n                region: config['aws_cognito_region'],\n                identityPoolId: config['aws_cognito_identity_pool_id'],\n                mandatorySignIn: config['aws_mandatory_sign_in'] === 'enable' ? true : false\n            };\n            amplifyConfig.Auth = Auth;\n        }\n        // Storage\n        var storageConfig;\n        if (config['aws_user_files_s3_bucket']) {\n            storageConfig = {\n                AWSS3: {\n                    bucket: config['aws_user_files_s3_bucket'],\n                    region: config['aws_user_files_s3_bucket_region']\n                }\n            };\n        }\n        else {\n            storageConfig = config ? config.Storage || config : {};\n        }\n        amplifyConfig.Analytics = Object.assign({}, amplifyConfig.Analytics, config.Analytics);\n        amplifyConfig.Auth = Object.assign({}, amplifyConfig.Auth, config.Auth);\n        amplifyConfig.Storage = Object.assign({}, storageConfig);\n        logger.debug('parse config', config, 'to amplifyconfig', amplifyConfig);\n        return amplifyConfig;\n    };\n    return Parser;\n}());\nexports.default = Parser;\n//# sourceMappingURL=Parser.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Parser.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Platform/index.js":
/*!**************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Platform/index.js ***!
  \**************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", { value: true });\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar packageInfo = __webpack_require__(/*! ../../package.json */ \"./node_modules/@aws-amplify/core/package.json\");\nvar Platform = {\n    'userAgent': \"aws-amplify/\" + packageInfo.version + \" js\",\n    'product': '',\n    'navigator': null,\n    'isReactNative': false\n};\nif (typeof navigator !== 'undefined' && navigator.product) {\n    Platform.product = navigator.product || '';\n    Platform.navigator = navigator || null;\n    switch (navigator.product) {\n        case 'ReactNative':\n            Platform.userAgent = \"aws-amplify/\" + packageInfo.version + \" react-native\";\n            Platform.isReactNative = true;\n            break;\n        default:\n            Platform.userAgent = \"aws-amplify/\" + packageInfo.version + \" js\";\n            Platform.isReactNative = false;\n            break;\n    }\n}\nexports.default = Platform;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Platform/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/RNComponents/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/RNComponents/index.js ***!
  \******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar JS_1 = __webpack_require__(/*! ../JS */ \"./node_modules/@aws-amplify/core/lib/JS.js\");\nvar StorageHelper_1 = __webpack_require__(/*! ../StorageHelper */ \"./node_modules/@aws-amplify/core/lib/StorageHelper/index.js\");\nvar Linking = {};\nexports.Linking = Linking;\nvar AppState = {\n    addEventListener: function (action, handler) {\n        return;\n    }\n};\nexports.AppState = AppState;\n// if not in react native, just use local storage\nvar AsyncStorage = JS_1.default.browserOrNode().isBrowser ? new StorageHelper_1.default().getStorage() : undefined;\nexports.AsyncStorage = AsyncStorage;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/RNComponents/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/ServiceWorker/ServiceWorker.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/ServiceWorker/ServiceWorker.js ***!
  \***************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", { value: true });\n/**\n * Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar Logger_1 = __webpack_require__(/*! ../Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar JS_1 = __webpack_require__(/*! ../JS */ \"./node_modules/@aws-amplify/core/lib/JS.js\");\nvar Amplify_1 = __webpack_require__(/*! ../Amplify */ \"./node_modules/@aws-amplify/core/lib/Amplify.js\");\n/**\n * Provides a means to registering a service worker in the browser\n * and communicating with it via postMessage events.\n * https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API/\n *\n * postMessage events are currently not supported in all browsers. See:\n * https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API\n *\n * At the minmum this class will register the service worker and listen\n * and attempt to dispatch messages on state change and record analytics\n * events based on the service worker lifecycle.\n */\nvar ServiceWorkerClass = /** @class */ (function () {\n    function ServiceWorkerClass() {\n        // The AWS Amplify logger\n        this._logger = new Logger_1.ConsoleLogger('ServiceWorker');\n    }\n    Object.defineProperty(ServiceWorkerClass.prototype, \"serviceWorker\", {\n        /**\n         * Get the currently active service worker\n         */\n        get: function () {\n            return this._serviceWorker;\n        },\n        enumerable: true,\n        configurable: true\n    });\n    /**\n     * Register the service-worker.js file in the browser\n     * Make sure the service-worker.js is part of the build\n     * for example with Angular, modify the angular-cli.json file\n     * and add to \"assets\" array \"service-worker.js\"\n     * @param {string} - (optional) Service worker file. Defaults to \"/service-worker.js\"\n     * @param {string} - (optional) The service worker scope. Defaults to \"/\"\n     *  - API Doc: https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorkerContainer/register\n     * @returns {Promise}\n     *\t- resolve(ServiceWorkerRegistration)\n     *\t- reject(Error)\n     **/\n    ServiceWorkerClass.prototype.register = function (filePath, scope) {\n        var _this = this;\n        if (filePath === void 0) { filePath = '/service-worker.js'; }\n        if (scope === void 0) { scope = '/'; }\n        this._logger.debug(\"registering \" + filePath);\n        this._logger.debug(\"registering service worker with scope \" + scope);\n        return new Promise(function (resolve, reject) {\n            if (navigator && 'serviceWorker' in navigator) {\n                navigator.serviceWorker.register(filePath, {\n                    'scope': scope\n                }).then(function (registration) {\n                    if (registration.installing) {\n                        _this._serviceWorker = registration.installing;\n                    }\n                    else if (registration.waiting) {\n                        _this._serviceWorker = registration.waiting;\n                    }\n                    else if (registration.active) {\n                        _this._serviceWorker = registration.active;\n                    }\n                    _this._registration = registration;\n                    _this._setupListeners();\n                    _this._logger.debug(\"Service Worker Registration Success: \" + registration);\n                    return resolve(registration);\n                }).catch(function (error) {\n                    _this._logger.debug(\"Service Worker Registration Failed \" + error);\n                    return reject(error);\n                });\n            }\n            else {\n                return reject(new Error('Service Worker not available'));\n            }\n        });\n    };\n    /**\n     * Enable web push notifications. If not subscribed, a new subscription will\n     * be created and registered.\n     * \tTest Push Server: https://web-push-codelab.glitch.me/\n     * \tPush Server Libraries: https://github.com/web-push-libs/\n     * \tAPI Doc: https://developers.google.com/web/fundamentals/codelabs/push-notifications/\n     * @param publicKey\n     * @returns {Promise}\n     * \t- resolve(PushSubscription)\n     *  - reject(Error)\n     */\n    ServiceWorkerClass.prototype.enablePush = function (publicKey) {\n        var _this = this;\n        if (!this._registration)\n            throw new Error('Service Worker not registered');\n        this._publicKey = publicKey;\n        return new Promise(function (resolve, reject) {\n            if (JS_1.default.browserOrNode().isBrowser) {\n                _this._registration.pushManager.getSubscription()\n                    .then(function (subscription) {\n                    if (subscription) {\n                        _this._subscription = subscription;\n                        _this._logger.debug(\"User is subscribed to push: \" + JSON.stringify(subscription));\n                        resolve(subscription);\n                    }\n                    else {\n                        _this._logger.debug(\"User is NOT subscribed to push\");\n                        return _this._registration.pushManager.subscribe({\n                            'userVisibleOnly': true,\n                            'applicationServerKey': _this._urlB64ToUint8Array(publicKey)\n                        }).then(function (subscription) {\n                            _this._subscription = subscription;\n                            _this._logger.debug(\"User subscribed: \" + JSON.stringify(subscription));\n                            resolve(subscription);\n                        }).catch(function (error) {\n                            _this._logger.error(error);\n                        });\n                    }\n                });\n            }\n            else {\n                return reject(new Error('Service Worker not available'));\n            }\n        });\n    };\n    /**\n     * Convert a base64 encoded string to a Uint8 array for the push server key\n     * @param base64String\n     */\n    ServiceWorkerClass.prototype._urlB64ToUint8Array = function (base64String) {\n        var padding = '='.repeat((4 - base64String.length % 4) % 4);\n        var base64 = (base64String + padding)\n            .replace(/\\-/g, '+')\n            .replace(/_/g, '/');\n        var rawData = window.atob(base64);\n        var outputArray = new Uint8Array(rawData.length);\n        for (var i = 0; i < rawData.length; ++i) {\n            outputArray[i] = rawData.charCodeAt(i);\n        }\n        return outputArray;\n    };\n    /**\n     * Send a message to the service worker. The service worker needs\n     * to implement `self.addEventListener('message') to handle the\n     * message. This ***currently*** does not work in Safari or IE.\n     * @param {object | string} - An arbitrary JSON object or string message to send to the service worker\n      *\t- see: https://developer.mozilla.org/en-US/docs/Web/API/Transferable\n     * @returns {Promise}\n     **/\n    ServiceWorkerClass.prototype.send = function (message) {\n        if (this._serviceWorker) {\n            this._serviceWorker.postMessage(typeof message === 'object' ? JSON.stringify(message) : message);\n        }\n    };\n    /**\n     * Listen for service worker state change and message events\n     * https://developer.mozilla.org/en-US/docs/Web/API/ServiceWorker/state\n     **/\n    ServiceWorkerClass.prototype._setupListeners = function () {\n        var _this = this;\n        this._serviceWorker.addEventListener('statechange', function (event) {\n            var currentState = _this._serviceWorker.state;\n            _this._logger.debug(\"ServiceWorker statechange: \" + currentState);\n            if (Amplify_1.default.Analytics && typeof Amplify_1.default.Analytics.record === 'function') {\n                Amplify_1.default.Analytics.record({\n                    name: 'ServiceWorker',\n                    attributes: {\n                        'state': currentState\n                    }\n                });\n            }\n        });\n        this._serviceWorker.addEventListener('message', function (event) {\n            _this._logger.debug(\"ServiceWorker message event: \" + event);\n        });\n    };\n    return ServiceWorkerClass;\n}());\nexports.default = ServiceWorkerClass;\n//# sourceMappingURL=ServiceWorker.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/ServiceWorker/ServiceWorker.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/ServiceWorker/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/ServiceWorker/index.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/**\n * Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar ServiceWorker_1 = __webpack_require__(/*! ./ServiceWorker */ \"./node_modules/@aws-amplify/core/lib/ServiceWorker/ServiceWorker.js\");\nexports.default = ServiceWorker_1.default;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL1NlcnZpY2VXb3JrZXIvaW5kZXguanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvbGliL1NlcnZpY2VXb3JrZXIvaW5kZXguanM/ODU3MyJdLCJzb3VyY2VzQ29udGVudCI6WyJcInVzZSBzdHJpY3RcIjtcbi8qKlxuICogQ29weXJpZ2h0IDIwMTggQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGhcbiAqIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICBodHRwOi8vYXdzLmFtYXpvbi5jb20vYXBhY2hlMi4wL1xuICpcbiAqIG9yIGluIHRoZSBcImxpY2Vuc2VcIiBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUlxuICogQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZWl0aGVyIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cbk9iamVjdC5kZWZpbmVQcm9wZXJ0eShleHBvcnRzLCBcIl9fZXNNb2R1bGVcIiwgeyB2YWx1ZTogdHJ1ZSB9KTtcbnZhciBTZXJ2aWNlV29ya2VyXzEgPSByZXF1aXJlKFwiLi9TZXJ2aWNlV29ya2VyXCIpO1xuZXhwb3J0cy5kZWZhdWx0ID0gU2VydmljZVdvcmtlcl8xLmRlZmF1bHQ7XG4vLyMgc291cmNlTWFwcGluZ1VSTD1pbmRleC5qcy5tYXAiXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/ServiceWorker/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/Signer.js":
/*!******************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/Signer.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nvar __assign = (this && this.__assign) || Object.assign || function(t) {\n    for (var s, i = 1, n = arguments.length; i < n; i++) {\n        s = arguments[i];\n        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))\n            t[p] = s[p];\n    }\n    return t;\n};\nvar __rest = (this && this.__rest) || function (s, e) {\n    var t = {};\n    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)\n        t[p] = s[p];\n    if (s != null && typeof Object.getOwnPropertySymbols === \"function\")\n        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)\n            t[p[i]] = s[p[i]];\n    return t;\n};\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Logger_1 = __webpack_require__(/*! ./Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar Facet_1 = __webpack_require__(/*! ./Facet */ \"./node_modules/@aws-amplify/core/lib/Facet.js\");\nvar logger = new Logger_1.ConsoleLogger('Signer'), url = __webpack_require__(/*! url */ \"./node_modules/url/url.js\"), crypto = Facet_1.AWS['util'].crypto;\nvar DEFAULT_ALGORITHM = 'AWS4-HMAC-SHA256';\nvar IOT_SERVICE_NAME = 'iotdevicegateway';\nvar encrypt = function (key, src, encoding) {\n    return crypto.lib.createHmac('sha256', key).update(src, 'utf8').digest(encoding);\n};\nvar hash = function (src) {\n    var arg = src || '';\n    return crypto.createHash('sha256').update(arg, 'utf8').digest('hex');\n};\n/**\n * @private\n * RFC 3986 compliant version of encodeURIComponent\n */\nvar escape_RFC3986 = function (component) {\n    return component.replace(/[!'()*]/g, function (c) {\n        return '%' + c.charCodeAt(0).toString(16).toUpperCase();\n    });\n};\n/**\n * @private\n * Create canonical query string\n *\n*/\nvar canonical_query = function (query) {\n    if (!query || query.length === 0) {\n        return '';\n    }\n    return query.split('&')\n        .map(function (e) {\n        var key_val = e.split('=');\n        if (key_val.length === 1) {\n            return e;\n        }\n        else {\n            var reencoded_val = escape_RFC3986(key_val[1]);\n            return key_val[0] + '=' + reencoded_val;\n        }\n    }).sort(function (a, b) { return a < b ? -1 : 1; }).join('&');\n};\n/**\n* @private\n* Create canonical headers\n*\n<pre>\nCanonicalHeaders =\n    CanonicalHeadersEntry0 + CanonicalHeadersEntry1 + ... + CanonicalHeadersEntryN\nCanonicalHeadersEntry =\n    Lowercase(HeaderName) + ':' + Trimall(HeaderValue) + '\\n'\n</pre>\n*/\nvar canonical_headers = function (headers) {\n    if (!headers || Object.keys(headers).length === 0) {\n        return '';\n    }\n    return Object.keys(headers)\n        .map(function (key) {\n        return {\n            key: key.toLowerCase(),\n            value: headers[key] ? headers[key].trim().replace(/\\s+/g, ' ') : ''\n        };\n    })\n        .sort(function (a, b) {\n        return a.key < b.key ? -1 : 1;\n    })\n        .map(function (item) {\n        return item.key + ':' + item.value;\n    })\n        .join('\\n') + '\\n';\n};\n/**\n* List of header keys included in the canonical headers.\n* @access private\n*/\nvar signed_headers = function (headers) {\n    return Object.keys(headers)\n        .map(function (key) { return key.toLowerCase(); })\n        .sort()\n        .join(';');\n};\n/**\n* @private\n* Create canonical request\n* Refer to\n* {@link http://docs.aws.amazon.com/general/latest/gr/sigv4-create-canonical-request.html|Create a Canonical Request}\n*\n<pre>\nCanonicalRequest =\n    HTTPRequestMethod + '\\n' +\n    CanonicalURI + '\\n' +\n    CanonicalQueryString + '\\n' +\n    CanonicalHeaders + '\\n' +\n    SignedHeaders + '\\n' +\n    HexEncode(Hash(RequestPayload))\n</pre>\n*/\nvar canonical_request = function (request) {\n    var url_info = url.parse(request.url);\n    return [\n        request.method || '/',\n        encodeURIComponent(url_info.pathname).replace(/%2F/ig, '/'),\n        canonical_query(url_info.query),\n        canonical_headers(request.headers),\n        signed_headers(request.headers),\n        hash(request.data)\n    ].join('\\n');\n};\nvar parse_service_info = function (request) {\n    var url_info = url.parse(request.url), host = url_info.host;\n    var matched = host.match(/([^\\.]+)\\.(?:([^\\.]*)\\.)?amazonaws\\.com$/);\n    var parsed = (matched || []).slice(1, 3);\n    if (parsed[1] === 'es') { // Elastic Search\n        parsed = parsed.reverse();\n    }\n    return {\n        service: request.service || parsed[0],\n        region: request.region || parsed[1]\n    };\n};\nvar credential_scope = function (d_str, region, service) {\n    return [\n        d_str,\n        region,\n        service,\n        'aws4_request',\n    ].join('/');\n};\n/**\n* @private\n* Create a string to sign\n* Refer to\n* {@link http://docs.aws.amazon.com/general/latest/gr/sigv4-create-string-to-sign.html|Create String to Sign}\n*\n<pre>\nStringToSign =\n    Algorithm + \\n +\n    RequestDateTime + \\n +\n    CredentialScope + \\n +\n    HashedCanonicalRequest\n</pre>\n*/\nvar string_to_sign = function (algorithm, canonical_request, dt_str, scope) {\n    return [\n        algorithm,\n        dt_str,\n        scope,\n        hash(canonical_request)\n    ].join('\\n');\n};\n/**\n* @private\n* Create signing key\n* Refer to\n* {@link http://docs.aws.amazon.com/general/latest/gr/sigv4-calculate-signature.html|Calculate Signature}\n*\n<pre>\nkSecret = your secret access key\nkDate = HMAC(\"AWS4\" + kSecret, Date)\nkRegion = HMAC(kDate, Region)\nkService = HMAC(kRegion, Service)\nkSigning = HMAC(kService, \"aws4_request\")\n</pre>\n*/\nvar get_signing_key = function (secret_key, d_str, service_info) {\n    logger.debug(service_info);\n    var k = ('AWS4' + secret_key), k_date = encrypt(k, d_str), k_region = encrypt(k_date, service_info.region), k_service = encrypt(k_region, service_info.service), k_signing = encrypt(k_service, 'aws4_request');\n    return k_signing;\n};\nvar get_signature = function (signing_key, str_to_sign) {\n    return encrypt(signing_key, str_to_sign, 'hex');\n};\n/**\n* @private\n* Create authorization header\n* Refer to\n* {@link http://docs.aws.amazon.com/general/latest/gr/sigv4-add-signature-to-request.html|Add the Signing Information}\n*/\nvar get_authorization_header = function (algorithm, access_key, scope, signed_headers, signature) {\n    return [\n        algorithm + ' ' + 'Credential=' + access_key + '/' + scope,\n        'SignedHeaders=' + signed_headers,\n        'Signature=' + signature\n    ].join(', ');\n};\n/**\n* Sign a HTTP request, add 'Authorization' header to request param\n* @method sign\n* @memberof Signer\n* @static\n*\n* @param {object} request - HTTP request object\n<pre>\nrequest: {\n    method: GET | POST | PUT ...\n    url: ...,\n    headers: {\n        header1: ...\n    },\n    data: data\n}\n</pre>\n* @param {object} access_info - AWS access credential info\n<pre>\naccess_info: {\n    access_key: ...,\n    secret_key: ...,\n    session_token: ...\n}\n</pre>\n* @param {object} [service_info] - AWS service type and region, optional,\n*                                  if not provided then parse out from url\n<pre>\nservice_info: {\n    service: ...,\n    region: ...\n}\n</pre>\n*\n* @returns {object} Signed HTTP request\n*/\nvar sign = function (request, access_info, service_info) {\n    if (service_info === void 0) { service_info = null; }\n    request.headers = request.headers || {};\n    // datetime string and date string\n    var dt = new Date(), dt_str = dt.toISOString().replace(/[:\\-]|\\.\\d{3}/g, ''), d_str = dt_str.substr(0, 8);\n    var url_info = url.parse(request.url);\n    request.headers['host'] = url_info.host;\n    request.headers['x-amz-date'] = dt_str;\n    if (access_info.session_token) {\n        request.headers['X-Amz-Security-Token'] = access_info.session_token;\n    }\n    // Task 1: Create a Canonical Request\n    var request_str = canonical_request(request);\n    logger.debug(request_str);\n    // Task 2: Create a String to Sign\n    var serviceInfo = service_info || parse_service_info(request), scope = credential_scope(d_str, serviceInfo.region, serviceInfo.service), str_to_sign = string_to_sign(DEFAULT_ALGORITHM, request_str, dt_str, scope);\n    // Task 3: Calculate the Signature\n    var signing_key = get_signing_key(access_info.secret_key, d_str, serviceInfo), signature = get_signature(signing_key, str_to_sign);\n    // Task 4: Adding the Signing information to the Request\n    var authorization_header = get_authorization_header(DEFAULT_ALGORITHM, access_info.access_key, scope, signed_headers(request.headers), signature);\n    request.headers['Authorization'] = authorization_header;\n    return request;\n};\nvar signUrl = function (urlToSign, accessInfo, serviceInfo, expiration) {\n    var now = new Date().toISOString().replace(/[:\\-]|\\.\\d{3}/g, '');\n    var today = now.substr(0, 8);\n    // Intentionally discarding search\n    var _a = url.parse(urlToSign, true, true), search = _a.search, parsedUrl = __rest(_a, [\"search\"]);\n    var host = parsedUrl.host;\n    var signedHeaders = { host: host };\n    var _b = serviceInfo || parse_service_info({ url: url.format(parsedUrl) }), region = _b.region, service = _b.service;\n    var credentialScope = credential_scope(today, region, service);\n    // IoT service does not allow the session token in the canonical request\n    // https://docs.aws.amazon.com/general/latest/gr/sigv4-add-signature-to-request.html\n    var sessionTokenRequired = accessInfo.session_token && service !== IOT_SERVICE_NAME;\n    var queryParams = __assign({ 'X-Amz-Algorithm': DEFAULT_ALGORITHM, 'X-Amz-Credential': [accessInfo.access_key, credentialScope].join('/'), 'X-Amz-Date': now.substr(0, 16) }, (sessionTokenRequired ? { 'X-Amz-Security-Token': \"\" + accessInfo.session_token } : {}), (expiration ? { 'X-Amz-Expires': \"\" + expiration } : {}), { 'X-Amz-SignedHeaders': Object.keys(signedHeaders).join(',') });\n    var canonicalRequest = canonical_request({\n        method: 'GET',\n        url: url.format(__assign({}, parsedUrl, { query: __assign({}, parsedUrl.query, queryParams) })),\n        headers: signedHeaders,\n    });\n    var stringToSign = string_to_sign(DEFAULT_ALGORITHM, canonicalRequest, now, credentialScope);\n    var signing_key = get_signing_key(accessInfo.secret_key, today, { region: region, service: service });\n    var signature = get_signature(signing_key, stringToSign);\n    var additionalQueryParams = __assign({ 'X-Amz-Signature': signature }, (accessInfo.session_token && { 'X-Amz-Security-Token': accessInfo.session_token }));\n    var result = url.format({\n        protocol: parsedUrl.protocol,\n        slashes: true,\n        hostname: parsedUrl.hostname,\n        pathname: parsedUrl.pathname,\n        query: __assign({}, parsedUrl.query, queryParams, additionalQueryParams)\n    });\n    return result;\n};\n/**\n* AWS request signer.\n* Refer to {@link http://docs.aws.amazon.com/general/latest/gr/sigv4_signing.html|Signature Version 4}\n*\n* @class Signer\n*/\nvar Signer = /** @class */ (function () {\n    function Signer() {\n    }\n    Signer.sign = sign;\n    Signer.signUrl = signUrl;\n    return Signer;\n}());\nexports.default = Signer;\n//# sourceMappingURL=Signer.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/Signer.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/StorageHelper/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/StorageHelper/index.js ***!
  \*******************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar dataMemory = {};\n/** @class */\nvar MemoryStorage = /** @class */ (function () {\n    function MemoryStorage() {\n    }\n    /**\n     * This is used to set a specific item in storage\n     * @param {string} key - the key for the item\n     * @param {object} value - the value\n     * @returns {string} value that was set\n     */\n    MemoryStorage.setItem = function (key, value) {\n        dataMemory[key] = value;\n        return dataMemory[key];\n    };\n    /**\n     * This is used to get a specific key from storage\n     * @param {string} key - the key for the item\n     * This is used to clear the storage\n     * @returns {string} the data item\n     */\n    MemoryStorage.getItem = function (key) {\n        return Object.prototype.hasOwnProperty.call(dataMemory, key) ? dataMemory[key] : undefined;\n    };\n    /**\n     * This is used to remove an item from storage\n     * @param {string} key - the key being set\n     * @returns {string} value - value that was deleted\n     */\n    MemoryStorage.removeItem = function (key) {\n        return delete dataMemory[key];\n    };\n    /**\n     * This is used to clear the storage\n     * @returns {string} nothing\n     */\n    MemoryStorage.clear = function () {\n        dataMemory = {};\n        return dataMemory;\n    };\n    return MemoryStorage;\n}());\nexports.MemoryStorage = MemoryStorage;\nvar StorageHelper = /** @class */ (function () {\n    /**\n     * This is used to get a storage object\n     * @returns {object} the storage\n     */\n    function StorageHelper() {\n        try {\n            this.storageWindow = window.localStorage;\n            this.storageWindow.setItem('aws.amplify.test-ls', 1);\n            this.storageWindow.removeItem('aws.amplify.test-ls');\n        }\n        catch (exception) {\n            this.storageWindow = MemoryStorage;\n        }\n    }\n    /**\n     * This is used to return the storage\n     * @returns {object} the storage\n     */\n    StorageHelper.prototype.getStorage = function () {\n        return this.storageWindow;\n    };\n    return StorageHelper;\n}());\nexports.default = StorageHelper;\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/StorageHelper/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/lib/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/@aws-amplify/core/lib/index.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n/*\n * Copyright 2017-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\"). You may not use this file except in compliance with\n * the License. A copy of the License is located at\n *\n *     http://aws.amazon.com/apache2.0/\n *\n * or in the \"license\" file accompanying this file. This file is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions\n * and limitations under the License.\n */\nfunction __export(m) {\n    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];\n}\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar Facet_1 = __webpack_require__(/*! ./Facet */ \"./node_modules/@aws-amplify/core/lib/Facet.js\");\nvar Logger_1 = __webpack_require__(/*! ./Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nvar Amplify_1 = __webpack_require__(/*! ./Amplify */ \"./node_modules/@aws-amplify/core/lib/Amplify.js\");\n__export(__webpack_require__(/*! ./Facet */ \"./node_modules/@aws-amplify/core/lib/Facet.js\"));\nvar ClientDevice_1 = __webpack_require__(/*! ./ClientDevice */ \"./node_modules/@aws-amplify/core/lib/ClientDevice/index.js\");\nexports.ClientDevice = ClientDevice_1.default;\nvar Logger_2 = __webpack_require__(/*! ./Logger */ \"./node_modules/@aws-amplify/core/lib/Logger/index.js\");\nexports.ConsoleLogger = Logger_2.ConsoleLogger;\nexports.Logger = Logger_2.ConsoleLogger;\n__export(__webpack_require__(/*! ./Errors */ \"./node_modules/@aws-amplify/core/lib/Errors.js\"));\nvar Hub_1 = __webpack_require__(/*! ./Hub */ \"./node_modules/@aws-amplify/core/lib/Hub.js\");\nexports.Hub = Hub_1.default;\nvar I18n_1 = __webpack_require__(/*! ./I18n */ \"./node_modules/@aws-amplify/core/lib/I18n/index.js\");\nexports.I18n = I18n_1.default;\nvar JS_1 = __webpack_require__(/*! ./JS */ \"./node_modules/@aws-amplify/core/lib/JS.js\");\nexports.JS = JS_1.default;\nvar Signer_1 = __webpack_require__(/*! ./Signer */ \"./node_modules/@aws-amplify/core/lib/Signer.js\");\nexports.Signer = Signer_1.default;\nvar Parser_1 = __webpack_require__(/*! ./Parser */ \"./node_modules/@aws-amplify/core/lib/Parser.js\");\nexports.Parser = Parser_1.default;\nvar OAuthHelper_1 = __webpack_require__(/*! ./OAuthHelper */ \"./node_modules/@aws-amplify/core/lib/OAuthHelper/index.js\");\nexports.FacebookOAuth = OAuthHelper_1.FacebookOAuth;\nexports.GoogleOAuth = OAuthHelper_1.GoogleOAuth;\n__export(__webpack_require__(/*! ./RNComponents */ \"./node_modules/@aws-amplify/core/lib/RNComponents/index.js\"));\nvar Credentials_1 = __webpack_require__(/*! ./Credentials */ \"./node_modules/@aws-amplify/core/lib/Credentials.js\");\nexports.Credentials = Credentials_1.default;\nvar ServiceWorker_1 = __webpack_require__(/*! ./ServiceWorker */ \"./node_modules/@aws-amplify/core/lib/ServiceWorker/index.js\");\nexports.ServiceWorker = ServiceWorker_1.default;\nvar StorageHelper_1 = __webpack_require__(/*! ./StorageHelper */ \"./node_modules/@aws-amplify/core/lib/StorageHelper/index.js\");\nexports.StorageHelper = StorageHelper_1.default;\nexports.MemoryStorage = StorageHelper_1.MemoryStorage;\nvar Platform_1 = __webpack_require__(/*! ./Platform */ \"./node_modules/@aws-amplify/core/lib/Platform/index.js\");\nexports.Platform = Platform_1.default;\nvar Platform_2 = __webpack_require__(/*! ./Platform */ \"./node_modules/@aws-amplify/core/lib/Platform/index.js\");\nexports.Constants = {\n    'userAgent': Platform_2.default.userAgent\n};\nexports.default = Amplify_1.default;\nvar logger = new Logger_1.ConsoleLogger('Core');\nif (Facet_1.AWS['util']) {\n    Facet_1.AWS['util'].userAgent = function () {\n        return exports.Constants.userAgent;\n    };\n}\nelse if (Facet_1.AWS.config) {\n    Facet_1.AWS.config.update({ 'customUserAgent': exports.Constants.userAgent });\n}\nelse {\n    logger.warn('No AWS.config');\n}\n//# sourceMappingURL=index.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/lib/index.js\n");

/***/ }),

/***/ "./node_modules/@aws-amplify/core/package.json":
/*!*****************************************************!*\
  !*** ./node_modules/@aws-amplify/core/package.json ***!
  \*****************************************************/
/*! exports provided: _from, _id, _inBundle, _integrity, _location, _phantomChildren, _requested, _requiredBy, _resolved, _shasum, _spec, _where, author, bugs, bundleDependencies, dependencies, deprecated, description, devDependencies, homepage, jest, license, main, module, name, publishConfig, react-native, repository, scripts, typings, version, default */
/***/ (function(module) {

eval("module.exports = {\"_from\":\"@aws-amplify/core@^1.0.25\",\"_id\":\"@aws-amplify/core@1.0.25\",\"_inBundle\":false,\"_integrity\":\"sha512-h0QJoqiGmYm4T4EEI3ZQgE7IBgnEz+vXQlXSsnMDhjtbaxPEO+tAXNSHdnxcoAQCoDK/KMAdHYbu2vY7Hor/SQ==\",\"_location\":\"/@aws-amplify/core\",\"_phantomChildren\":{},\"_requested\":{\"type\":\"range\",\"registry\":true,\"raw\":\"@aws-amplify/core@^1.0.25\",\"name\":\"@aws-amplify/core\",\"escapedName\":\"@aws-amplify%2fcore\",\"scope\":\"@aws-amplify\",\"rawSpec\":\"^1.0.25\",\"saveSpec\":null,\"fetchSpec\":\"^1.0.25\"},\"_requiredBy\":[\"/@aws-amplify/auth\",\"/@aws-amplify/cache\"],\"_resolved\":\"https://registry.npmjs.org/@aws-amplify/core/-/core-1.0.25.tgz\",\"_shasum\":\"d330fefe7119fc6e0254a7c39e0d1525fa039e4b\",\"_spec\":\"@aws-amplify/core@^1.0.25\",\"_where\":\"/Users/j/Projects/chrome-extension-webpack-boilerplate/node_modules/@aws-amplify/auth\",\"author\":{\"name\":\"Amazon Web Services\"},\"bugs\":{\"url\":\"https://github.com/aws/aws-amplify/issues\"},\"bundleDependencies\":false,\"dependencies\":{\"aws-sdk\":\"2.329.0\",\"url\":\"^0.11.0\"},\"deprecated\":false,\"description\":\"Core category of aws-amplify\",\"devDependencies\":{\"@types/jest\":\"^20.0.8\",\"@types/node\":\"^8.10.15\",\"awesome-typescript-loader\":\"^3.2.2\",\"babel-loader\":\"^7.1.2\",\"babel-preset-es2015\":\"^6.24.1\",\"babel-preset-react\":\"^6.24.1\",\"babel-preset-stage-2\":\"^6.24.1\",\"compression-webpack-plugin\":\"^1.1.3\",\"find\":\"^0.2.7\",\"jest\":\"^22.4.3\",\"json-loader\":\"^0.5.7\",\"prepend-file\":\"^1.3.1\",\"prettier\":\"^1.7.4\",\"rimraf\":\"^2.6.2\",\"source-map-loader\":\"^0.2.1\",\"ts-jest\":\"^22.0.0\",\"tslint\":\"^5.7.0\",\"tslint-config-airbnb\":\"^5.8.0\",\"typescript-formatter\":\"^6.0.0\",\"uglifyjs-webpack-plugin\":\"^0.4.6\",\"webpack\":\"^3.5.5\"},\"homepage\":\"https://github.com/aws/aws-amplify#readme\",\"jest\":{\"transform\":{\"^.+\\\\.(js|jsx|ts|tsx)$\":\"<rootDir>../../node_modules/ts-jest/preprocessor.js\"},\"testRegex\":\"(/__tests__/.*|\\\\.(test|spec))\\\\.(tsx?|jsx?)$\",\"moduleFileExtensions\":[\"ts\",\"tsx\",\"js\",\"json\",\"jsx\"],\"testEnvironment\":\"jsdom\",\"mapCoverage\":true,\"coverageThreshold\":{\"global\":{\"branches\":0,\"functions\":0,\"lines\":0,\"statements\":0}},\"testURL\":\"http://localhost/\",\"coveragePathIgnorePatterns\":[\"/node_modules/\"]},\"license\":\"Apache-2.0\",\"main\":\"./lib/index.js\",\"module\":\"./lib/index.js\",\"name\":\"@aws-amplify/core\",\"publishConfig\":{\"access\":\"public\"},\"react-native\":{\"./lib/ClientDevice\":\"./lib/ClientDevice/reactnative.js\",\"./lib/RNComponents\":\"./lib/RNComponents/reactnative.js\",\"./lib/StorageHelper\":\"./lib/StorageHelper/reactnative.js\"},\"repository\":{\"type\":\"git\",\"url\":\"git+https://github.com/aws/aws-amplify.git\"},\"scripts\":{\"build\":\"npm run clean && tsc && webpack\",\"build-with-test\":\"npm run clean && npm test && tsc && webpack\",\"clean\":\"rimraf lib lib-esm dist\",\"format\":\"tsfmt --useTsfmt tsfmt.json -r src/**/*.ts\",\"lint\":\"tslint 'src/**/*.ts'\",\"test\":\"tslint 'src/**/*.ts' && jest --coverage\"},\"typings\":\"./lib/index.d.ts\",\"version\":\"1.0.25\"};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvQGF3cy1hbXBsaWZ5L2NvcmUvcGFja2FnZS5qc29uLmpzIiwic291cmNlcyI6W10sIm1hcHBpbmdzIjoiIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/@aws-amplify/core/package.json\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/AuthenticationDetails.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/AuthenticationDetails.js ***!
  \*****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n/** @class */\nvar AuthenticationDetails = function () {\n  /**\n   * Constructs a new AuthenticationDetails object\n   * @param {object=} data Creation options.\n   * @param {string} data.Username User being authenticated.\n   * @param {string} data.Password Plain-text password to authenticate with.\n   * @param {(AttributeArg[])?} data.ValidationData Application extra metadata.\n   * @param {(AttributeArg[])?} data.AuthParamaters Authentication paramaters for custom auth.\n   */\n  function AuthenticationDetails(data) {\n    _classCallCheck(this, AuthenticationDetails);\n\n    var _ref = data || {},\n        ValidationData = _ref.ValidationData,\n        Username = _ref.Username,\n        Password = _ref.Password,\n        AuthParameters = _ref.AuthParameters;\n\n    this.validationData = ValidationData || {};\n    this.authParameters = AuthParameters || {};\n    this.username = Username;\n    this.password = Password;\n  }\n\n  /**\n   * @returns {string} the record's username\n   */\n\n\n  AuthenticationDetails.prototype.getUsername = function getUsername() {\n    return this.username;\n  };\n\n  /**\n   * @returns {string} the record's password\n   */\n\n\n  AuthenticationDetails.prototype.getPassword = function getPassword() {\n    return this.password;\n  };\n\n  /**\n   * @returns {Array} the record's validationData\n   */\n\n\n  AuthenticationDetails.prototype.getValidationData = function getValidationData() {\n    return this.validationData;\n  };\n\n  /**\n   * @returns {Array} the record's authParameters\n   */\n\n\n  AuthenticationDetails.prototype.getAuthParameters = function getAuthParameters() {\n    return this.authParameters;\n  };\n\n  return AuthenticationDetails;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (AuthenticationDetails);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/AuthenticationDetails.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/AuthenticationHelper.js":
/*!****************************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/AuthenticationHelper.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var buffer___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! buffer/ */ \"./node_modules/buffer/index.js\");\n/* harmony import */ var buffer___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(buffer___WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var crypto_js_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! crypto-js/core */ \"./node_modules/crypto-js/core.js\");\n/* harmony import */ var crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(crypto_js_core__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var crypto_js_lib_typedarrays__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! crypto-js/lib-typedarrays */ \"./node_modules/crypto-js/lib-typedarrays.js\");\n/* harmony import */ var crypto_js_lib_typedarrays__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(crypto_js_lib_typedarrays__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var crypto_js_sha256__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! crypto-js/sha256 */ \"./node_modules/crypto-js/sha256.js\");\n/* harmony import */ var crypto_js_sha256__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(crypto_js_sha256__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! crypto-js/hmac-sha256 */ \"./node_modules/crypto-js/hmac-sha256.js\");\n/* harmony import */ var crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _BigInteger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./BigInteger */ \"./node_modules/amazon-cognito-identity-js/es/BigInteger.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n // necessary for crypto js\n\n\n\nvar randomBytes = function randomBytes(nBytes) {\n  return buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.random(nBytes).toString(), 'hex');\n};\n\n\n\nvar initN = 'FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD1' + '29024E088A67CC74020BBEA63B139B22514A08798E3404DD' + 'EF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245' + 'E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7ED' + 'EE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3D' + 'C2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F' + '83655D23DCA3AD961C62F356208552BB9ED529077096966D' + '670C354E4ABC9804F1746C08CA18217C32905E462E36CE3B' + 'E39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9' + 'DE2BCBF6955817183995497CEA956AE515D2261898FA0510' + '15728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64' + 'ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7' + 'ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6B' + 'F12FFA06D98A0864D87602733EC86A64521F2B18177B200C' + 'BBE117577A615D6C770988C0BAD946E208E24FA074E5AB31' + '43DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF';\n\nvar newPasswordRequiredChallengeUserAttributePrefix = 'userAttributes.';\n\n/** @class */\n\nvar AuthenticationHelper = function () {\n  /**\n   * Constructs a new AuthenticationHelper object\n   * @param {string} PoolName Cognito user pool name.\n   */\n  function AuthenticationHelper(PoolName) {\n    _classCallCheck(this, AuthenticationHelper);\n\n    this.N = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](initN, 16);\n    this.g = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"]('2', 16);\n    this.k = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](this.hexHash('00' + this.N.toString(16) + '0' + this.g.toString(16)), 16);\n\n    this.smallAValue = this.generateRandomSmallA();\n    this.getLargeAValue(function () {});\n\n    this.infoBits = buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from('Caldera Derived Key', 'utf8');\n\n    this.poolName = PoolName;\n  }\n\n  /**\n   * @returns {BigInteger} small A, a random number\n   */\n\n\n  AuthenticationHelper.prototype.getSmallAValue = function getSmallAValue() {\n    return this.smallAValue;\n  };\n\n  /**\n   * @param {nodeCallback<BigInteger>} callback Called with (err, largeAValue)\n   * @returns {void}\n   */\n\n\n  AuthenticationHelper.prototype.getLargeAValue = function getLargeAValue(callback) {\n    var _this = this;\n\n    if (this.largeAValue) {\n      callback(null, this.largeAValue);\n    } else {\n      this.calculateA(this.smallAValue, function (err, largeAValue) {\n        if (err) {\n          callback(err, null);\n        }\n\n        _this.largeAValue = largeAValue;\n        callback(null, _this.largeAValue);\n      });\n    }\n  };\n\n  /**\n   * helper function to generate a random big integer\n   * @returns {BigInteger} a random value.\n   * @private\n   */\n\n\n  AuthenticationHelper.prototype.generateRandomSmallA = function generateRandomSmallA() {\n    var hexRandom = randomBytes(128).toString('hex');\n\n    var randomBigInt = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](hexRandom, 16);\n    var smallABigInt = randomBigInt.mod(this.N);\n\n    return smallABigInt;\n  };\n\n  /**\n   * helper function to generate a random string\n   * @returns {string} a random value.\n   * @private\n   */\n\n\n  AuthenticationHelper.prototype.generateRandomString = function generateRandomString() {\n    return randomBytes(40).toString('base64');\n  };\n\n  /**\n   * @returns {string} Generated random value included in password hash.\n   */\n\n\n  AuthenticationHelper.prototype.getRandomPassword = function getRandomPassword() {\n    return this.randomPassword;\n  };\n\n  /**\n   * @returns {string} Generated random value included in devices hash.\n   */\n\n\n  AuthenticationHelper.prototype.getSaltDevices = function getSaltDevices() {\n    return this.SaltToHashDevices;\n  };\n\n  /**\n   * @returns {string} Value used to verify devices.\n   */\n\n\n  AuthenticationHelper.prototype.getVerifierDevices = function getVerifierDevices() {\n    return this.verifierDevices;\n  };\n\n  /**\n   * Generate salts and compute verifier.\n   * @param {string} deviceGroupKey Devices to generate verifier for.\n   * @param {string} username User to generate verifier for.\n   * @param {nodeCallback<null>} callback Called with (err, null)\n   * @returns {void}\n   */\n\n\n  AuthenticationHelper.prototype.generateHashDevice = function generateHashDevice(deviceGroupKey, username, callback) {\n    var _this2 = this;\n\n    this.randomPassword = this.generateRandomString();\n    var combinedString = '' + deviceGroupKey + username + ':' + this.randomPassword;\n    var hashedString = this.hash(combinedString);\n\n    var hexRandom = randomBytes(16).toString('hex');\n    this.SaltToHashDevices = this.padHex(new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](hexRandom, 16));\n\n    this.g.modPow(new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](this.hexHash(this.SaltToHashDevices + hashedString), 16), this.N, function (err, verifierDevicesNotPadded) {\n      if (err) {\n        callback(err, null);\n      }\n\n      _this2.verifierDevices = _this2.padHex(verifierDevicesNotPadded);\n      callback(null, null);\n    });\n  };\n\n  /**\n   * Calculate the client's public value A = g^a%N\n   * with the generated random number a\n   * @param {BigInteger} a Randomly generated small A.\n   * @param {nodeCallback<BigInteger>} callback Called with (err, largeAValue)\n   * @returns {void}\n   * @private\n   */\n\n\n  AuthenticationHelper.prototype.calculateA = function calculateA(a, callback) {\n    var _this3 = this;\n\n    this.g.modPow(a, this.N, function (err, A) {\n      if (err) {\n        callback(err, null);\n      }\n\n      if (A.mod(_this3.N).equals(_BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"].ZERO)) {\n        callback(new Error('Illegal paramater. A mod N cannot be 0.'), null);\n      }\n\n      callback(null, A);\n    });\n  };\n\n  /**\n   * Calculate the client's value U which is the hash of A and B\n   * @param {BigInteger} A Large A value.\n   * @param {BigInteger} B Server B value.\n   * @returns {BigInteger} Computed U value.\n   * @private\n   */\n\n\n  AuthenticationHelper.prototype.calculateU = function calculateU(A, B) {\n    this.UHexHash = this.hexHash(this.padHex(A) + this.padHex(B));\n    var finalU = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](this.UHexHash, 16);\n\n    return finalU;\n  };\n\n  /**\n   * Calculate a hash from a bitArray\n   * @param {Buffer} buf Value to hash.\n   * @returns {String} Hex-encoded hash.\n   * @private\n   */\n\n\n  AuthenticationHelper.prototype.hash = function hash(buf) {\n    var str = buf instanceof buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"] ? crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(buf) : buf;\n    var hashHex = crypto_js_sha256__WEBPACK_IMPORTED_MODULE_3___default()(str).toString();\n\n    return new Array(64 - hashHex.length).join('0') + hashHex;\n  };\n\n  /**\n   * Calculate a hash from a hex string\n   * @param {String} hexStr Value to hash.\n   * @returns {String} Hex-encoded hash.\n   * @private\n   */\n\n\n  AuthenticationHelper.prototype.hexHash = function hexHash(hexStr) {\n    return this.hash(buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(hexStr, 'hex'));\n  };\n\n  /**\n   * Standard hkdf algorithm\n   * @param {Buffer} ikm Input key material.\n   * @param {Buffer} salt Salt value.\n   * @returns {Buffer} Strong key material.\n   * @private\n   */\n\n\n  AuthenticationHelper.prototype.computehkdf = function computehkdf(ikm, salt) {\n    var infoBitsWordArray = crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].concat([this.infoBits, buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(String.fromCharCode(1), 'utf8')]));\n    var ikmWordArray = ikm instanceof buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"] ? crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(ikm) : ikm;\n    var saltWordArray = salt instanceof buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"] ? crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(salt) : salt;\n\n    var prk = crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4___default()(ikmWordArray, saltWordArray);\n    var hmac = crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4___default()(infoBitsWordArray, prk);\n    return buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(hmac.toString(), 'hex').slice(0, 16);\n  };\n\n  /**\n   * Calculates the final hkdf based on computed S value, and computed U value and the key\n   * @param {String} username Username.\n   * @param {String} password Password.\n   * @param {BigInteger} serverBValue Server B value.\n   * @param {BigInteger} salt Generated salt.\n   * @param {nodeCallback<Buffer>} callback Called with (err, hkdfValue)\n   * @returns {void}\n   */\n\n\n  AuthenticationHelper.prototype.getPasswordAuthenticationKey = function getPasswordAuthenticationKey(username, password, serverBValue, salt, callback) {\n    var _this4 = this;\n\n    if (serverBValue.mod(this.N).equals(_BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"].ZERO)) {\n      throw new Error('B cannot be zero.');\n    }\n\n    this.UValue = this.calculateU(this.largeAValue, serverBValue);\n\n    if (this.UValue.equals(_BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"].ZERO)) {\n      throw new Error('U cannot be zero.');\n    }\n\n    var usernamePassword = '' + this.poolName + username + ':' + password;\n    var usernamePasswordHash = this.hash(usernamePassword);\n\n    var xValue = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](this.hexHash(this.padHex(salt) + usernamePasswordHash), 16);\n    this.calculateS(xValue, serverBValue, function (err, sValue) {\n      if (err) {\n        callback(err, null);\n      }\n\n      var hkdf = _this4.computehkdf(buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(_this4.padHex(sValue), 'hex'), buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(_this4.padHex(_this4.UValue.toString(16)), 'hex'));\n\n      callback(null, hkdf);\n    });\n  };\n\n  /**\n   * Calculates the S value used in getPasswordAuthenticationKey\n   * @param {BigInteger} xValue Salted password hash value.\n   * @param {BigInteger} serverBValue Server B value.\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  AuthenticationHelper.prototype.calculateS = function calculateS(xValue, serverBValue, callback) {\n    var _this5 = this;\n\n    this.g.modPow(xValue, this.N, function (err, gModPowXN) {\n      if (err) {\n        callback(err, null);\n      }\n\n      var intValue2 = serverBValue.subtract(_this5.k.multiply(gModPowXN));\n      intValue2.modPow(_this5.smallAValue.add(_this5.UValue.multiply(xValue)), _this5.N, function (err2, result) {\n        if (err2) {\n          callback(err2, null);\n        }\n\n        callback(null, result.mod(_this5.N));\n      });\n    });\n  };\n\n  /**\n  * Return constant newPasswordRequiredChallengeUserAttributePrefix\n  * @return {newPasswordRequiredChallengeUserAttributePrefix} constant prefix value\n  */\n\n\n  AuthenticationHelper.prototype.getNewPasswordRequiredChallengeUserAttributePrefix = function getNewPasswordRequiredChallengeUserAttributePrefix() {\n    return newPasswordRequiredChallengeUserAttributePrefix;\n  };\n\n  /**\n   * Converts a BigInteger (or hex string) to hex format padded with zeroes for hashing\n   * @param {BigInteger|String} bigInt Number or string to pad.\n   * @returns {String} Padded hex string.\n   */\n\n\n  AuthenticationHelper.prototype.padHex = function padHex(bigInt) {\n    var hashStr = bigInt.toString(16);\n    if (hashStr.length % 2 === 1) {\n      hashStr = '0' + hashStr;\n    } else if ('89ABCDEFabcdef'.indexOf(hashStr[0]) !== -1) {\n      hashStr = '00' + hashStr;\n    }\n    return hashStr;\n  };\n\n  return AuthenticationHelper;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (AuthenticationHelper);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/AuthenticationHelper.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/BigInteger.js":
/*!******************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/BigInteger.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n// A small implementation of BigInteger based on http://www-cs-students.stanford.edu/~tjw/jsbn/\n//\n// All public methods have been removed except the following:\n//   new BigInteger(a, b) (only radix 2, 4, 8, 16 and 32 supported)\n//   toString (only radix 2, 4, 8, 16 and 32 supported)\n//   negate\n//   abs\n//   compareTo\n//   bitLength\n//   mod\n//   equals\n//   add\n//   subtract\n//   multiply\n//   divide\n//   modPow\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (BigInteger);\n\n/*\n * Copyright (c) 2003-2005  Tom Wu\n * All Rights Reserved.\n *\n * Permission is hereby granted, free of charge, to any person obtaining\n * a copy of this software and associated documentation files (the\n * \"Software\"), to deal in the Software without restriction, including\n * without limitation the rights to use, copy, modify, merge, publish,\n * distribute, sublicense, and/or sell copies of the Software, and to\n * permit persons to whom the Software is furnished to do so, subject to\n * the following conditions:\n *\n * The above copyright notice and this permission notice shall be\n * included in all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS-IS\" AND WITHOUT WARRANTY OF ANY KIND,\n * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY\n * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.\n *\n * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,\n * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER\n * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF\n * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT\n * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.\n *\n * In addition, the following condition applies:\n *\n * All redistributions must retain an intact copy of this copyright notice\n * and disclaimer.\n */\n\n// (public) Constructor\nfunction BigInteger(a, b) {\n  if (a != null) this.fromString(a, b);\n}\n\n// return new, unset BigInteger\nfunction nbi() {\n  return new BigInteger(null);\n}\n\n// Bits per digit\nvar dbits;\n\n// JavaScript engine analysis\nvar canary = 0xdeadbeefcafe;\nvar j_lm = (canary & 0xffffff) == 0xefcafe;\n\n// am: Compute w_j += (x*this_i), propagate carries,\n// c is initial carry, returns final carry.\n// c < 3*dvalue, x < 2*dvalue, this_i < dvalue\n// We need to select the fastest one that works in this environment.\n\n// am1: use a single mult and divide to get the high bits,\n// max digit bits should be 26 because\n// max internal value = 2*dvalue^2-2*dvalue (< 2^53)\nfunction am1(i, x, w, j, c, n) {\n  while (--n >= 0) {\n    var v = x * this[i++] + w[j] + c;\n    c = Math.floor(v / 0x4000000);\n    w[j++] = v & 0x3ffffff;\n  }\n  return c;\n}\n// am2 avoids a big mult-and-extract completely.\n// Max digit bits should be <= 30 because we do bitwise ops\n// on values up to 2*hdvalue^2-hdvalue-1 (< 2^31)\nfunction am2(i, x, w, j, c, n) {\n  var xl = x & 0x7fff,\n      xh = x >> 15;\n  while (--n >= 0) {\n    var l = this[i] & 0x7fff;\n    var h = this[i++] >> 15;\n    var m = xh * l + h * xl;\n    l = xl * l + ((m & 0x7fff) << 15) + w[j] + (c & 0x3fffffff);\n    c = (l >>> 30) + (m >>> 15) + xh * h + (c >>> 30);\n    w[j++] = l & 0x3fffffff;\n  }\n  return c;\n}\n// Alternately, set max digit bits to 28 since some\n// browsers slow down when dealing with 32-bit numbers.\nfunction am3(i, x, w, j, c, n) {\n  var xl = x & 0x3fff,\n      xh = x >> 14;\n  while (--n >= 0) {\n    var l = this[i] & 0x3fff;\n    var h = this[i++] >> 14;\n    var m = xh * l + h * xl;\n    l = xl * l + ((m & 0x3fff) << 14) + w[j] + c;\n    c = (l >> 28) + (m >> 14) + xh * h;\n    w[j++] = l & 0xfffffff;\n  }\n  return c;\n}\nvar inBrowser = typeof navigator !== \"undefined\";\nif (inBrowser && j_lm && navigator.appName == \"Microsoft Internet Explorer\") {\n  BigInteger.prototype.am = am2;\n  dbits = 30;\n} else if (inBrowser && j_lm && navigator.appName != \"Netscape\") {\n  BigInteger.prototype.am = am1;\n  dbits = 26;\n} else {\n  // Mozilla/Netscape seems to prefer am3\n  BigInteger.prototype.am = am3;\n  dbits = 28;\n}\n\nBigInteger.prototype.DB = dbits;\nBigInteger.prototype.DM = (1 << dbits) - 1;\nBigInteger.prototype.DV = 1 << dbits;\n\nvar BI_FP = 52;\nBigInteger.prototype.FV = Math.pow(2, BI_FP);\nBigInteger.prototype.F1 = BI_FP - dbits;\nBigInteger.prototype.F2 = 2 * dbits - BI_FP;\n\n// Digit conversions\nvar BI_RM = \"0123456789abcdefghijklmnopqrstuvwxyz\";\nvar BI_RC = new Array();\nvar rr, vv;\nrr = \"0\".charCodeAt(0);\nfor (vv = 0; vv <= 9; ++vv) {\n  BI_RC[rr++] = vv;\n}rr = \"a\".charCodeAt(0);\nfor (vv = 10; vv < 36; ++vv) {\n  BI_RC[rr++] = vv;\n}rr = \"A\".charCodeAt(0);\nfor (vv = 10; vv < 36; ++vv) {\n  BI_RC[rr++] = vv;\n}function int2char(n) {\n  return BI_RM.charAt(n);\n}\nfunction intAt(s, i) {\n  var c = BI_RC[s.charCodeAt(i)];\n  return c == null ? -1 : c;\n}\n\n// (protected) copy this to r\nfunction bnpCopyTo(r) {\n  for (var i = this.t - 1; i >= 0; --i) {\n    r[i] = this[i];\n  }r.t = this.t;\n  r.s = this.s;\n}\n\n// (protected) set from integer value x, -DV <= x < DV\nfunction bnpFromInt(x) {\n  this.t = 1;\n  this.s = x < 0 ? -1 : 0;\n  if (x > 0) this[0] = x;else if (x < -1) this[0] = x + this.DV;else this.t = 0;\n}\n\n// return bigint initialized to value\nfunction nbv(i) {\n  var r = nbi();\n\n  r.fromInt(i);\n\n  return r;\n}\n\n// (protected) set from string and radix\nfunction bnpFromString(s, b) {\n  var k;\n  if (b == 16) k = 4;else if (b == 8) k = 3;else if (b == 2) k = 1;else if (b == 32) k = 5;else if (b == 4) k = 2;else throw new Error(\"Only radix 2, 4, 8, 16, 32 are supported\");\n  this.t = 0;\n  this.s = 0;\n  var i = s.length,\n      mi = false,\n      sh = 0;\n  while (--i >= 0) {\n    var x = intAt(s, i);\n    if (x < 0) {\n      if (s.charAt(i) == \"-\") mi = true;\n      continue;\n    }\n    mi = false;\n    if (sh == 0) this[this.t++] = x;else if (sh + k > this.DB) {\n      this[this.t - 1] |= (x & (1 << this.DB - sh) - 1) << sh;\n      this[this.t++] = x >> this.DB - sh;\n    } else this[this.t - 1] |= x << sh;\n    sh += k;\n    if (sh >= this.DB) sh -= this.DB;\n  }\n  this.clamp();\n  if (mi) BigInteger.ZERO.subTo(this, this);\n}\n\n// (protected) clamp off excess high words\nfunction bnpClamp() {\n  var c = this.s & this.DM;\n  while (this.t > 0 && this[this.t - 1] == c) {\n    --this.t;\n  }\n}\n\n// (public) return string representation in given radix\nfunction bnToString(b) {\n  if (this.s < 0) return \"-\" + this.negate().toString();\n  var k;\n  if (b == 16) k = 4;else if (b == 8) k = 3;else if (b == 2) k = 1;else if (b == 32) k = 5;else if (b == 4) k = 2;else throw new Error(\"Only radix 2, 4, 8, 16, 32 are supported\");\n  var km = (1 << k) - 1,\n      d,\n      m = false,\n      r = \"\",\n      i = this.t;\n  var p = this.DB - i * this.DB % k;\n  if (i-- > 0) {\n    if (p < this.DB && (d = this[i] >> p) > 0) {\n      m = true;\n      r = int2char(d);\n    }\n    while (i >= 0) {\n      if (p < k) {\n        d = (this[i] & (1 << p) - 1) << k - p;\n        d |= this[--i] >> (p += this.DB - k);\n      } else {\n        d = this[i] >> (p -= k) & km;\n        if (p <= 0) {\n          p += this.DB;\n          --i;\n        }\n      }\n      if (d > 0) m = true;\n      if (m) r += int2char(d);\n    }\n  }\n  return m ? r : \"0\";\n}\n\n// (public) -this\nfunction bnNegate() {\n  var r = nbi();\n\n  BigInteger.ZERO.subTo(this, r);\n\n  return r;\n}\n\n// (public) |this|\nfunction bnAbs() {\n  return this.s < 0 ? this.negate() : this;\n}\n\n// (public) return + if this > a, - if this < a, 0 if equal\nfunction bnCompareTo(a) {\n  var r = this.s - a.s;\n  if (r != 0) return r;\n  var i = this.t;\n  r = i - a.t;\n  if (r != 0) return this.s < 0 ? -r : r;\n  while (--i >= 0) {\n    if ((r = this[i] - a[i]) != 0) return r;\n  }return 0;\n}\n\n// returns bit length of the integer x\nfunction nbits(x) {\n  var r = 1,\n      t;\n  if ((t = x >>> 16) != 0) {\n    x = t;\n    r += 16;\n  }\n  if ((t = x >> 8) != 0) {\n    x = t;\n    r += 8;\n  }\n  if ((t = x >> 4) != 0) {\n    x = t;\n    r += 4;\n  }\n  if ((t = x >> 2) != 0) {\n    x = t;\n    r += 2;\n  }\n  if ((t = x >> 1) != 0) {\n    x = t;\n    r += 1;\n  }\n  return r;\n}\n\n// (public) return the number of bits in \"this\"\nfunction bnBitLength() {\n  if (this.t <= 0) return 0;\n  return this.DB * (this.t - 1) + nbits(this[this.t - 1] ^ this.s & this.DM);\n}\n\n// (protected) r = this << n*DB\nfunction bnpDLShiftTo(n, r) {\n  var i;\n  for (i = this.t - 1; i >= 0; --i) {\n    r[i + n] = this[i];\n  }for (i = n - 1; i >= 0; --i) {\n    r[i] = 0;\n  }r.t = this.t + n;\n  r.s = this.s;\n}\n\n// (protected) r = this >> n*DB\nfunction bnpDRShiftTo(n, r) {\n  for (var i = n; i < this.t; ++i) {\n    r[i - n] = this[i];\n  }r.t = Math.max(this.t - n, 0);\n  r.s = this.s;\n}\n\n// (protected) r = this << n\nfunction bnpLShiftTo(n, r) {\n  var bs = n % this.DB;\n  var cbs = this.DB - bs;\n  var bm = (1 << cbs) - 1;\n  var ds = Math.floor(n / this.DB),\n      c = this.s << bs & this.DM,\n      i;\n  for (i = this.t - 1; i >= 0; --i) {\n    r[i + ds + 1] = this[i] >> cbs | c;\n    c = (this[i] & bm) << bs;\n  }\n  for (i = ds - 1; i >= 0; --i) {\n    r[i] = 0;\n  }r[ds] = c;\n  r.t = this.t + ds + 1;\n  r.s = this.s;\n  r.clamp();\n}\n\n// (protected) r = this >> n\nfunction bnpRShiftTo(n, r) {\n  r.s = this.s;\n  var ds = Math.floor(n / this.DB);\n  if (ds >= this.t) {\n    r.t = 0;\n    return;\n  }\n  var bs = n % this.DB;\n  var cbs = this.DB - bs;\n  var bm = (1 << bs) - 1;\n  r[0] = this[ds] >> bs;\n  for (var i = ds + 1; i < this.t; ++i) {\n    r[i - ds - 1] |= (this[i] & bm) << cbs;\n    r[i - ds] = this[i] >> bs;\n  }\n  if (bs > 0) r[this.t - ds - 1] |= (this.s & bm) << cbs;\n  r.t = this.t - ds;\n  r.clamp();\n}\n\n// (protected) r = this - a\nfunction bnpSubTo(a, r) {\n  var i = 0,\n      c = 0,\n      m = Math.min(a.t, this.t);\n  while (i < m) {\n    c += this[i] - a[i];\n    r[i++] = c & this.DM;\n    c >>= this.DB;\n  }\n  if (a.t < this.t) {\n    c -= a.s;\n    while (i < this.t) {\n      c += this[i];\n      r[i++] = c & this.DM;\n      c >>= this.DB;\n    }\n    c += this.s;\n  } else {\n    c += this.s;\n    while (i < a.t) {\n      c -= a[i];\n      r[i++] = c & this.DM;\n      c >>= this.DB;\n    }\n    c -= a.s;\n  }\n  r.s = c < 0 ? -1 : 0;\n  if (c < -1) r[i++] = this.DV + c;else if (c > 0) r[i++] = c;\n  r.t = i;\n  r.clamp();\n}\n\n// (protected) r = this * a, r != this,a (HAC 14.12)\n// \"this\" should be the larger one if appropriate.\nfunction bnpMultiplyTo(a, r) {\n  var x = this.abs(),\n      y = a.abs();\n  var i = x.t;\n  r.t = i + y.t;\n  while (--i >= 0) {\n    r[i] = 0;\n  }for (i = 0; i < y.t; ++i) {\n    r[i + x.t] = x.am(0, y[i], r, i, 0, x.t);\n  }r.s = 0;\n  r.clamp();\n  if (this.s != a.s) BigInteger.ZERO.subTo(r, r);\n}\n\n// (protected) r = this^2, r != this (HAC 14.16)\nfunction bnpSquareTo(r) {\n  var x = this.abs();\n  var i = r.t = 2 * x.t;\n  while (--i >= 0) {\n    r[i] = 0;\n  }for (i = 0; i < x.t - 1; ++i) {\n    var c = x.am(i, x[i], r, 2 * i, 0, 1);\n    if ((r[i + x.t] += x.am(i + 1, 2 * x[i], r, 2 * i + 1, c, x.t - i - 1)) >= x.DV) {\n      r[i + x.t] -= x.DV;\n      r[i + x.t + 1] = 1;\n    }\n  }\n  if (r.t > 0) r[r.t - 1] += x.am(i, x[i], r, 2 * i, 0, 1);\n  r.s = 0;\n  r.clamp();\n}\n\n// (protected) divide this by m, quotient and remainder to q, r (HAC 14.20)\n// r != q, this != m.  q or r may be null.\nfunction bnpDivRemTo(m, q, r) {\n  var pm = m.abs();\n  if (pm.t <= 0) return;\n  var pt = this.abs();\n  if (pt.t < pm.t) {\n    if (q != null) q.fromInt(0);\n    if (r != null) this.copyTo(r);\n    return;\n  }\n  if (r == null) r = nbi();\n  var y = nbi(),\n      ts = this.s,\n      ms = m.s;\n  var nsh = this.DB - nbits(pm[pm.t - 1]);\n  // normalize modulus\n  if (nsh > 0) {\n    pm.lShiftTo(nsh, y);\n    pt.lShiftTo(nsh, r);\n  } else {\n    pm.copyTo(y);\n    pt.copyTo(r);\n  }\n  var ys = y.t;\n  var y0 = y[ys - 1];\n  if (y0 == 0) return;\n  var yt = y0 * (1 << this.F1) + (ys > 1 ? y[ys - 2] >> this.F2 : 0);\n  var d1 = this.FV / yt,\n      d2 = (1 << this.F1) / yt,\n      e = 1 << this.F2;\n  var i = r.t,\n      j = i - ys,\n      t = q == null ? nbi() : q;\n  y.dlShiftTo(j, t);\n  if (r.compareTo(t) >= 0) {\n    r[r.t++] = 1;\n    r.subTo(t, r);\n  }\n  BigInteger.ONE.dlShiftTo(ys, t);\n  t.subTo(y, y);\n  // \"negative\" y so we can replace sub with am later\n  while (y.t < ys) {\n    y[y.t++] = 0;\n  }while (--j >= 0) {\n    // Estimate quotient digit\n    var qd = r[--i] == y0 ? this.DM : Math.floor(r[i] * d1 + (r[i - 1] + e) * d2);\n    if ((r[i] += y.am(0, qd, r, j, 0, ys)) < qd) {\n      // Try it out\n      y.dlShiftTo(j, t);\n      r.subTo(t, r);\n      while (r[i] < --qd) {\n        r.subTo(t, r);\n      }\n    }\n  }\n  if (q != null) {\n    r.drShiftTo(ys, q);\n    if (ts != ms) BigInteger.ZERO.subTo(q, q);\n  }\n  r.t = ys;\n  r.clamp();\n  if (nsh > 0) r.rShiftTo(nsh, r);\n  // Denormalize remainder\n  if (ts < 0) BigInteger.ZERO.subTo(r, r);\n}\n\n// (public) this mod a\nfunction bnMod(a) {\n  var r = nbi();\n  this.abs().divRemTo(a, null, r);\n  if (this.s < 0 && r.compareTo(BigInteger.ZERO) > 0) a.subTo(r, r);\n  return r;\n}\n\n// (protected) return \"-1/this % 2^DB\"; useful for Mont. reduction\n// justification:\n//         xy == 1 (mod m)\n//         xy =  1+km\n//   xy(2-xy) = (1+km)(1-km)\n// x[y(2-xy)] = 1-k^2m^2\n// x[y(2-xy)] == 1 (mod m^2)\n// if y is 1/x mod m, then y(2-xy) is 1/x mod m^2\n// should reduce x and y(2-xy) by m^2 at each step to keep size bounded.\n// JS multiply \"overflows\" differently from C/C++, so care is needed here.\nfunction bnpInvDigit() {\n  if (this.t < 1) return 0;\n  var x = this[0];\n  if ((x & 1) == 0) return 0;\n  var y = x & 3;\n  // y == 1/x mod 2^2\n  y = y * (2 - (x & 0xf) * y) & 0xf;\n  // y == 1/x mod 2^4\n  y = y * (2 - (x & 0xff) * y) & 0xff;\n  // y == 1/x mod 2^8\n  y = y * (2 - ((x & 0xffff) * y & 0xffff)) & 0xffff;\n  // y == 1/x mod 2^16\n  // last step - calculate inverse mod DV directly;\n  // assumes 16 < DB <= 32 and assumes ability to handle 48-bit ints\n  y = y * (2 - x * y % this.DV) % this.DV;\n  // y == 1/x mod 2^dbits\n  // we really want the negative inverse, and -DV < y < DV\n  return y > 0 ? this.DV - y : -y;\n}\n\nfunction bnEquals(a) {\n  return this.compareTo(a) == 0;\n}\n\n// (protected) r = this + a\nfunction bnpAddTo(a, r) {\n  var i = 0,\n      c = 0,\n      m = Math.min(a.t, this.t);\n  while (i < m) {\n    c += this[i] + a[i];\n    r[i++] = c & this.DM;\n    c >>= this.DB;\n  }\n  if (a.t < this.t) {\n    c += a.s;\n    while (i < this.t) {\n      c += this[i];\n      r[i++] = c & this.DM;\n      c >>= this.DB;\n    }\n    c += this.s;\n  } else {\n    c += this.s;\n    while (i < a.t) {\n      c += a[i];\n      r[i++] = c & this.DM;\n      c >>= this.DB;\n    }\n    c += a.s;\n  }\n  r.s = c < 0 ? -1 : 0;\n  if (c > 0) r[i++] = c;else if (c < -1) r[i++] = this.DV + c;\n  r.t = i;\n  r.clamp();\n}\n\n// (public) this + a\nfunction bnAdd(a) {\n  var r = nbi();\n\n  this.addTo(a, r);\n\n  return r;\n}\n\n// (public) this - a\nfunction bnSubtract(a) {\n  var r = nbi();\n\n  this.subTo(a, r);\n\n  return r;\n}\n\n// (public) this * a\nfunction bnMultiply(a) {\n  var r = nbi();\n\n  this.multiplyTo(a, r);\n\n  return r;\n}\n\n// (public) this / a\nfunction bnDivide(a) {\n  var r = nbi();\n\n  this.divRemTo(a, r, null);\n\n  return r;\n}\n\n// Montgomery reduction\nfunction Montgomery(m) {\n  this.m = m;\n  this.mp = m.invDigit();\n  this.mpl = this.mp & 0x7fff;\n  this.mph = this.mp >> 15;\n  this.um = (1 << m.DB - 15) - 1;\n  this.mt2 = 2 * m.t;\n}\n\n// xR mod m\nfunction montConvert(x) {\n  var r = nbi();\n  x.abs().dlShiftTo(this.m.t, r);\n  r.divRemTo(this.m, null, r);\n  if (x.s < 0 && r.compareTo(BigInteger.ZERO) > 0) this.m.subTo(r, r);\n  return r;\n}\n\n// x/R mod m\nfunction montRevert(x) {\n  var r = nbi();\n  x.copyTo(r);\n  this.reduce(r);\n  return r;\n}\n\n// x = x/R mod m (HAC 14.32)\nfunction montReduce(x) {\n  while (x.t <= this.mt2) {\n    // pad x so am has enough room later\n    x[x.t++] = 0;\n  }for (var i = 0; i < this.m.t; ++i) {\n    // faster way of calculating u0 = x[i]*mp mod DV\n    var j = x[i] & 0x7fff;\n    var u0 = j * this.mpl + ((j * this.mph + (x[i] >> 15) * this.mpl & this.um) << 15) & x.DM;\n    // use am to combine the multiply-shift-add into one call\n    j = i + this.m.t;\n    x[j] += this.m.am(0, u0, x, i, 0, this.m.t);\n    // propagate carry\n    while (x[j] >= x.DV) {\n      x[j] -= x.DV;\n      x[++j]++;\n    }\n  }\n  x.clamp();\n  x.drShiftTo(this.m.t, x);\n  if (x.compareTo(this.m) >= 0) x.subTo(this.m, x);\n}\n\n// r = \"x^2/R mod m\"; x != r\nfunction montSqrTo(x, r) {\n  x.squareTo(r);\n\n  this.reduce(r);\n}\n\n// r = \"xy/R mod m\"; x,y != r\nfunction montMulTo(x, y, r) {\n  x.multiplyTo(y, r);\n\n  this.reduce(r);\n}\n\nMontgomery.prototype.convert = montConvert;\nMontgomery.prototype.revert = montRevert;\nMontgomery.prototype.reduce = montReduce;\nMontgomery.prototype.mulTo = montMulTo;\nMontgomery.prototype.sqrTo = montSqrTo;\n\n// (public) this^e % m (HAC 14.85)\nfunction bnModPow(e, m, callback) {\n  var i = e.bitLength(),\n      k,\n      r = nbv(1),\n      z = new Montgomery(m);\n  if (i <= 0) return r;else if (i < 18) k = 1;else if (i < 48) k = 3;else if (i < 144) k = 4;else if (i < 768) k = 5;else k = 6;\n\n  // precomputation\n  var g = new Array(),\n      n = 3,\n      k1 = k - 1,\n      km = (1 << k) - 1;\n  g[1] = z.convert(this);\n  if (k > 1) {\n    var g2 = nbi();\n    z.sqrTo(g[1], g2);\n    while (n <= km) {\n      g[n] = nbi();\n      z.mulTo(g2, g[n - 2], g[n]);\n      n += 2;\n    }\n  }\n\n  var j = e.t - 1,\n      w,\n      is1 = true,\n      r2 = nbi(),\n      t;\n  i = nbits(e[j]) - 1;\n  while (j >= 0) {\n    if (i >= k1) w = e[j] >> i - k1 & km;else {\n      w = (e[j] & (1 << i + 1) - 1) << k1 - i;\n      if (j > 0) w |= e[j - 1] >> this.DB + i - k1;\n    }\n\n    n = k;\n    while ((w & 1) == 0) {\n      w >>= 1;\n      --n;\n    }\n    if ((i -= n) < 0) {\n      i += this.DB;\n      --j;\n    }\n    if (is1) {\n      // ret == 1, don't bother squaring or multiplying it\n      g[w].copyTo(r);\n      is1 = false;\n    } else {\n      while (n > 1) {\n        z.sqrTo(r, r2);\n        z.sqrTo(r2, r);\n        n -= 2;\n      }\n      if (n > 0) z.sqrTo(r, r2);else {\n        t = r;\n        r = r2;\n        r2 = t;\n      }\n      z.mulTo(r2, g[w], r);\n    }\n\n    while (j >= 0 && (e[j] & 1 << i) == 0) {\n      z.sqrTo(r, r2);\n      t = r;\n      r = r2;\n      r2 = t;\n      if (--i < 0) {\n        i = this.DB - 1;\n        --j;\n      }\n    }\n  }\n  var result = z.revert(r);\n  callback(null, result);\n  return result;\n}\n\n// protected\nBigInteger.prototype.copyTo = bnpCopyTo;\nBigInteger.prototype.fromInt = bnpFromInt;\nBigInteger.prototype.fromString = bnpFromString;\nBigInteger.prototype.clamp = bnpClamp;\nBigInteger.prototype.dlShiftTo = bnpDLShiftTo;\nBigInteger.prototype.drShiftTo = bnpDRShiftTo;\nBigInteger.prototype.lShiftTo = bnpLShiftTo;\nBigInteger.prototype.rShiftTo = bnpRShiftTo;\nBigInteger.prototype.subTo = bnpSubTo;\nBigInteger.prototype.multiplyTo = bnpMultiplyTo;\nBigInteger.prototype.squareTo = bnpSquareTo;\nBigInteger.prototype.divRemTo = bnpDivRemTo;\nBigInteger.prototype.invDigit = bnpInvDigit;\nBigInteger.prototype.addTo = bnpAddTo;\n\n// public\nBigInteger.prototype.toString = bnToString;\nBigInteger.prototype.negate = bnNegate;\nBigInteger.prototype.abs = bnAbs;\nBigInteger.prototype.compareTo = bnCompareTo;\nBigInteger.prototype.bitLength = bnBitLength;\nBigInteger.prototype.mod = bnMod;\nBigInteger.prototype.equals = bnEquals;\nBigInteger.prototype.add = bnAdd;\nBigInteger.prototype.subtract = bnSubtract;\nBigInteger.prototype.multiply = bnMultiply;\nBigInteger.prototype.divide = bnDivide;\nBigInteger.prototype.modPow = bnModPow;\n\n// \"constants\"\nBigInteger.ZERO = nbv(0);\nBigInteger.ONE = nbv(1);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/BigInteger.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/Client.js":
/*!**************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/Client.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _UserAgent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UserAgent */ \"./node_modules/amazon-cognito-identity-js/es/UserAgent.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n\n/** @class */\n\nvar Client = function () {\n  /**\n   * Constructs a new AWS Cognito Identity Provider client object\n   * @param {string} region AWS region\n   * @param {string} endpoint endpoint\n   */\n  function Client(region, endpoint) {\n    _classCallCheck(this, Client);\n\n    this.endpoint = endpoint || 'https://cognito-idp.' + region + '.amazonaws.com/';\n    this.userAgent = _UserAgent__WEBPACK_IMPORTED_MODULE_0__[\"default\"].prototype.userAgent || 'aws-amplify/0.1.x js';\n  }\n\n  /**\n   * Makes an unauthenticated request on AWS Cognito Identity Provider API\n   * using fetch\n   * @param {string} operation API operation\n   * @param {object} params Input parameters\n   * @param {function} callback Callback called when a response is returned\n   * @returns {void}\n  */\n\n\n  Client.prototype.request = function request(operation, params, callback) {\n    var headers = {\n      'Content-Type': 'application/x-amz-json-1.1',\n      'X-Amz-Target': 'AWSCognitoIdentityProviderService.' + operation,\n      'X-Amz-User-Agent': this.userAgent\n    };\n\n    var options = {\n      headers: headers,\n      method: 'POST',\n      mode: 'cors',\n      cache: 'no-cache',\n      body: JSON.stringify(params)\n    };\n\n    var response = void 0;\n    var responseJsonData = void 0;\n\n    fetch(this.endpoint, options).then(function (resp) {\n      response = resp;\n      return resp;\n    }, function (err) {\n      // If error happens here, the request failed\n      // if it is TypeError throw network error\n      if (err instanceof TypeError) {\n        throw new Error('Network error');\n      }\n      throw err;\n    }).then(function (resp) {\n      return resp.json().catch(function () {\n        return {};\n      });\n    }).then(function (data) {\n      // return parsed body stream\n      if (response.ok) return callback(null, data);\n      responseJsonData = data;\n\n      // Taken from aws-sdk-js/lib/protocol/json.js\n      // eslint-disable-next-line no-underscore-dangle\n      var code = (data.__type || data.code).split('#').pop();\n      var error = {\n        code: code,\n        name: code,\n        message: data.message || data.Message || null\n      };\n      return callback(error);\n    }).catch(function (err) {\n      // first check if we have a service error\n      if (response && response.headers && response.headers.get('x-amzn-errortype')) {\n        try {\n          var code = response.headers.get('x-amzn-errortype').split(':')[0];\n          var error = {\n            code: code,\n            name: code,\n            statusCode: response.status,\n            message: response.status ? response.status.toString() : null\n          };\n          return callback(error);\n        } catch (ex) {\n          return callback(err);\n        }\n        // otherwise check if error is Network error\n      } else if (err instanceof Error && err.message === 'Network error') {\n        var _error = {\n          code: 'NetworkError',\n          name: err.name,\n          message: err.message\n        };\n        return callback(_error);\n      } else {\n        return callback(err);\n      }\n    });\n  };\n\n  return Client;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Client);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYW1hem9uLWNvZ25pdG8taWRlbnRpdHktanMvZXMvQ2xpZW50LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2FtYXpvbi1jb2duaXRvLWlkZW50aXR5LWpzL2VzL0NsaWVudC5qcz8xNjEwIl0sInNvdXJjZXNDb250ZW50IjpbImZ1bmN0aW9uIF9jbGFzc0NhbGxDaGVjayhpbnN0YW5jZSwgQ29uc3RydWN0b3IpIHsgaWYgKCEoaW5zdGFuY2UgaW5zdGFuY2VvZiBDb25zdHJ1Y3RvcikpIHsgdGhyb3cgbmV3IFR5cGVFcnJvcihcIkNhbm5vdCBjYWxsIGEgY2xhc3MgYXMgYSBmdW5jdGlvblwiKTsgfSB9XG5cbmltcG9ydCBVc2VyQWdlbnQgZnJvbSAnLi9Vc2VyQWdlbnQnO1xuLyoqIEBjbGFzcyAqL1xuXG52YXIgQ2xpZW50ID0gZnVuY3Rpb24gKCkge1xuICAvKipcbiAgICogQ29uc3RydWN0cyBhIG5ldyBBV1MgQ29nbml0byBJZGVudGl0eSBQcm92aWRlciBjbGllbnQgb2JqZWN0XG4gICAqIEBwYXJhbSB7c3RyaW5nfSByZWdpb24gQVdTIHJlZ2lvblxuICAgKiBAcGFyYW0ge3N0cmluZ30gZW5kcG9pbnQgZW5kcG9pbnRcbiAgICovXG4gIGZ1bmN0aW9uIENsaWVudChyZWdpb24sIGVuZHBvaW50KSB7XG4gICAgX2NsYXNzQ2FsbENoZWNrKHRoaXMsIENsaWVudCk7XG5cbiAgICB0aGlzLmVuZHBvaW50ID0gZW5kcG9pbnQgfHwgJ2h0dHBzOi8vY29nbml0by1pZHAuJyArIHJlZ2lvbiArICcuYW1hem9uYXdzLmNvbS8nO1xuICAgIHRoaXMudXNlckFnZW50ID0gVXNlckFnZW50LnByb3RvdHlwZS51c2VyQWdlbnQgfHwgJ2F3cy1hbXBsaWZ5LzAuMS54IGpzJztcbiAgfVxuXG4gIC8qKlxuICAgKiBNYWtlcyBhbiB1bmF1dGhlbnRpY2F0ZWQgcmVxdWVzdCBvbiBBV1MgQ29nbml0byBJZGVudGl0eSBQcm92aWRlciBBUElcbiAgICogdXNpbmcgZmV0Y2hcbiAgICogQHBhcmFtIHtzdHJpbmd9IG9wZXJhdGlvbiBBUEkgb3BlcmF0aW9uXG4gICAqIEBwYXJhbSB7b2JqZWN0fSBwYXJhbXMgSW5wdXQgcGFyYW1ldGVyc1xuICAgKiBAcGFyYW0ge2Z1bmN0aW9ufSBjYWxsYmFjayBDYWxsYmFjayBjYWxsZWQgd2hlbiBhIHJlc3BvbnNlIGlzIHJldHVybmVkXG4gICAqIEByZXR1cm5zIHt2b2lkfVxuICAqL1xuXG5cbiAgQ2xpZW50LnByb3RvdHlwZS5yZXF1ZXN0ID0gZnVuY3Rpb24gcmVxdWVzdChvcGVyYXRpb24sIHBhcmFtcywgY2FsbGJhY2spIHtcbiAgICB2YXIgaGVhZGVycyA9IHtcbiAgICAgICdDb250ZW50LVR5cGUnOiAnYXBwbGljYXRpb24veC1hbXotanNvbi0xLjEnLFxuICAgICAgJ1gtQW16LVRhcmdldCc6ICdBV1NDb2duaXRvSWRlbnRpdHlQcm92aWRlclNlcnZpY2UuJyArIG9wZXJhdGlvbixcbiAgICAgICdYLUFtei1Vc2VyLUFnZW50JzogdGhpcy51c2VyQWdlbnRcbiAgICB9O1xuXG4gICAgdmFyIG9wdGlvbnMgPSB7XG4gICAgICBoZWFkZXJzOiBoZWFkZXJzLFxuICAgICAgbWV0aG9kOiAnUE9TVCcsXG4gICAgICBtb2RlOiAnY29ycycsXG4gICAgICBjYWNoZTogJ25vLWNhY2hlJyxcbiAgICAgIGJvZHk6IEpTT04uc3RyaW5naWZ5KHBhcmFtcylcbiAgICB9O1xuXG4gICAgdmFyIHJlc3BvbnNlID0gdm9pZCAwO1xuICAgIHZhciByZXNwb25zZUpzb25EYXRhID0gdm9pZCAwO1xuXG4gICAgZmV0Y2godGhpcy5lbmRwb2ludCwgb3B0aW9ucykudGhlbihmdW5jdGlvbiAocmVzcCkge1xuICAgICAgcmVzcG9uc2UgPSByZXNwO1xuICAgICAgcmV0dXJuIHJlc3A7XG4gICAgfSwgZnVuY3Rpb24gKGVycikge1xuICAgICAgLy8gSWYgZXJyb3IgaGFwcGVucyBoZXJlLCB0aGUgcmVxdWVzdCBmYWlsZWRcbiAgICAgIC8vIGlmIGl0IGlzIFR5cGVFcnJvciB0aHJvdyBuZXR3b3JrIGVycm9yXG4gICAgICBpZiAoZXJyIGluc3RhbmNlb2YgVHlwZUVycm9yKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcignTmV0d29yayBlcnJvcicpO1xuICAgICAgfVxuICAgICAgdGhyb3cgZXJyO1xuICAgIH0pLnRoZW4oZnVuY3Rpb24gKHJlc3ApIHtcbiAgICAgIHJldHVybiByZXNwLmpzb24oKS5jYXRjaChmdW5jdGlvbiAoKSB7XG4gICAgICAgIHJldHVybiB7fTtcbiAgICAgIH0pO1xuICAgIH0pLnRoZW4oZnVuY3Rpb24gKGRhdGEpIHtcbiAgICAgIC8vIHJldHVybiBwYXJzZWQgYm9keSBzdHJlYW1cbiAgICAgIGlmIChyZXNwb25zZS5vaykgcmV0dXJuIGNhbGxiYWNrKG51bGwsIGRhdGEpO1xuICAgICAgcmVzcG9uc2VKc29uRGF0YSA9IGRhdGE7XG5cbiAgICAgIC8vIFRha2VuIGZyb20gYXdzLXNkay1qcy9saWIvcHJvdG9jb2wvanNvbi5qc1xuICAgICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXVuZGVyc2NvcmUtZGFuZ2xlXG4gICAgICB2YXIgY29kZSA9IChkYXRhLl9fdHlwZSB8fCBkYXRhLmNvZGUpLnNwbGl0KCcjJykucG9wKCk7XG4gICAgICB2YXIgZXJyb3IgPSB7XG4gICAgICAgIGNvZGU6IGNvZGUsXG4gICAgICAgIG5hbWU6IGNvZGUsXG4gICAgICAgIG1lc3NhZ2U6IGRhdGEubWVzc2FnZSB8fCBkYXRhLk1lc3NhZ2UgfHwgbnVsbFxuICAgICAgfTtcbiAgICAgIHJldHVybiBjYWxsYmFjayhlcnJvcik7XG4gICAgfSkuY2F0Y2goZnVuY3Rpb24gKGVycikge1xuICAgICAgLy8gZmlyc3QgY2hlY2sgaWYgd2UgaGF2ZSBhIHNlcnZpY2UgZXJyb3JcbiAgICAgIGlmIChyZXNwb25zZSAmJiByZXNwb25zZS5oZWFkZXJzICYmIHJlc3BvbnNlLmhlYWRlcnMuZ2V0KCd4LWFtem4tZXJyb3J0eXBlJykpIHtcbiAgICAgICAgdHJ5IHtcbiAgICAgICAgICB2YXIgY29kZSA9IHJlc3BvbnNlLmhlYWRlcnMuZ2V0KCd4LWFtem4tZXJyb3J0eXBlJykuc3BsaXQoJzonKVswXTtcbiAgICAgICAgICB2YXIgZXJyb3IgPSB7XG4gICAgICAgICAgICBjb2RlOiBjb2RlLFxuICAgICAgICAgICAgbmFtZTogY29kZSxcbiAgICAgICAgICAgIHN0YXR1c0NvZGU6IHJlc3BvbnNlLnN0YXR1cyxcbiAgICAgICAgICAgIG1lc3NhZ2U6IHJlc3BvbnNlLnN0YXR1cyA/IHJlc3BvbnNlLnN0YXR1cy50b1N0cmluZygpIDogbnVsbFxuICAgICAgICAgIH07XG4gICAgICAgICAgcmV0dXJuIGNhbGxiYWNrKGVycm9yKTtcbiAgICAgICAgfSBjYXRjaCAoZXgpIHtcbiAgICAgICAgICByZXR1cm4gY2FsbGJhY2soZXJyKTtcbiAgICAgICAgfVxuICAgICAgICAvLyBvdGhlcndpc2UgY2hlY2sgaWYgZXJyb3IgaXMgTmV0d29yayBlcnJvclxuICAgICAgfSBlbHNlIGlmIChlcnIgaW5zdGFuY2VvZiBFcnJvciAmJiBlcnIubWVzc2FnZSA9PT0gJ05ldHdvcmsgZXJyb3InKSB7XG4gICAgICAgIHZhciBfZXJyb3IgPSB7XG4gICAgICAgICAgY29kZTogJ05ldHdvcmtFcnJvcicsXG4gICAgICAgICAgbmFtZTogZXJyLm5hbWUsXG4gICAgICAgICAgbWVzc2FnZTogZXJyLm1lc3NhZ2VcbiAgICAgICAgfTtcbiAgICAgICAgcmV0dXJuIGNhbGxiYWNrKF9lcnJvcik7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICByZXR1cm4gY2FsbGJhY2soZXJyKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgfTtcblxuICByZXR1cm4gQ2xpZW50O1xufSgpO1xuXG5leHBvcnQgZGVmYXVsdCBDbGllbnQ7Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/Client.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoAccessToken.js":
/*!**************************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoAccessToken.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _CognitoJwtToken__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CognitoJwtToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoJwtToken.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\n/*\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/** @class */\n\nvar CognitoAccessToken = function (_CognitoJwtToken) {\n  _inherits(CognitoAccessToken, _CognitoJwtToken);\n\n  /**\n   * Constructs a new CognitoAccessToken object\n   * @param {string=} AccessToken The JWT access token.\n   */\n  function CognitoAccessToken() {\n    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},\n        AccessToken = _ref.AccessToken;\n\n    _classCallCheck(this, CognitoAccessToken);\n\n    return _possibleConstructorReturn(this, _CognitoJwtToken.call(this, AccessToken || ''));\n  }\n\n  return CognitoAccessToken;\n}(_CognitoJwtToken__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoAccessToken);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoAccessToken.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoIdToken.js":
/*!**********************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoIdToken.js ***!
  \**********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _CognitoJwtToken__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CognitoJwtToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoJwtToken.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self; }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/** @class */\n\nvar CognitoIdToken = function (_CognitoJwtToken) {\n  _inherits(CognitoIdToken, _CognitoJwtToken);\n\n  /**\n   * Constructs a new CognitoIdToken object\n   * @param {string=} IdToken The JWT Id token\n   */\n  function CognitoIdToken() {\n    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},\n        IdToken = _ref.IdToken;\n\n    _classCallCheck(this, CognitoIdToken);\n\n    return _possibleConstructorReturn(this, _CognitoJwtToken.call(this, IdToken || ''));\n  }\n\n  return CognitoIdToken;\n}(_CognitoJwtToken__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoIdToken);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoIdToken.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoJwtToken.js":
/*!***********************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoJwtToken.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var buffer___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! buffer/ */ \"./node_modules/buffer/index.js\");\n/* harmony import */ var buffer___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(buffer___WEBPACK_IMPORTED_MODULE_0__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n/** @class */\n\nvar CognitoJwtToken = function () {\n  /**\n   * Constructs a new CognitoJwtToken object\n   * @param {string=} token The JWT token.\n   */\n  function CognitoJwtToken(token) {\n    _classCallCheck(this, CognitoJwtToken);\n\n    // Assign object\n    this.jwtToken = token || '';\n    this.payload = this.decodePayload();\n  }\n\n  /**\n   * @returns {string} the record's token.\n   */\n\n\n  CognitoJwtToken.prototype.getJwtToken = function getJwtToken() {\n    return this.jwtToken;\n  };\n\n  /**\n   * @returns {int} the token's expiration (exp member).\n   */\n\n\n  CognitoJwtToken.prototype.getExpiration = function getExpiration() {\n    return this.payload.exp;\n  };\n\n  /**\n   * @returns {int} the token's \"issued at\" (iat member).\n   */\n\n\n  CognitoJwtToken.prototype.getIssuedAt = function getIssuedAt() {\n    return this.payload.iat;\n  };\n\n  /**\n   * @returns {object} the token's payload.\n   */\n\n\n  CognitoJwtToken.prototype.decodePayload = function decodePayload() {\n    var payload = this.jwtToken.split('.')[1];\n    try {\n      return JSON.parse(buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(payload, 'base64').toString('utf8'));\n    } catch (err) {\n      return {};\n    }\n  };\n\n  return CognitoJwtToken;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoJwtToken);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoJwtToken.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoRefreshToken.js":
/*!***************************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoRefreshToken.js ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n/** @class */\nvar CognitoRefreshToken = function () {\n  /**\n   * Constructs a new CognitoRefreshToken object\n   * @param {string=} RefreshToken The JWT refresh token.\n   */\n  function CognitoRefreshToken() {\n    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},\n        RefreshToken = _ref.RefreshToken;\n\n    _classCallCheck(this, CognitoRefreshToken);\n\n    // Assign object\n    this.token = RefreshToken || '';\n  }\n\n  /**\n   * @returns {string} the record's token.\n   */\n\n\n  CognitoRefreshToken.prototype.getToken = function getToken() {\n    return this.token;\n  };\n\n  return CognitoRefreshToken;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoRefreshToken);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoRefreshToken.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoUser.js":
/*!*******************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoUser.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var buffer___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! buffer/ */ \"./node_modules/buffer/index.js\");\n/* harmony import */ var buffer___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(buffer___WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var crypto_js_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! crypto-js/core */ \"./node_modules/crypto-js/core.js\");\n/* harmony import */ var crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(crypto_js_core__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var crypto_js_lib_typedarrays__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! crypto-js/lib-typedarrays */ \"./node_modules/crypto-js/lib-typedarrays.js\");\n/* harmony import */ var crypto_js_lib_typedarrays__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(crypto_js_lib_typedarrays__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var crypto_js_enc_base64__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! crypto-js/enc-base64 */ \"./node_modules/crypto-js/enc-base64.js\");\n/* harmony import */ var crypto_js_enc_base64__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(crypto_js_enc_base64__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! crypto-js/hmac-sha256 */ \"./node_modules/crypto-js/hmac-sha256.js\");\n/* harmony import */ var crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4__);\n/* harmony import */ var _BigInteger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./BigInteger */ \"./node_modules/amazon-cognito-identity-js/es/BigInteger.js\");\n/* harmony import */ var _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./AuthenticationHelper */ \"./node_modules/amazon-cognito-identity-js/es/AuthenticationHelper.js\");\n/* harmony import */ var _CognitoAccessToken__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CognitoAccessToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoAccessToken.js\");\n/* harmony import */ var _CognitoIdToken__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CognitoIdToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoIdToken.js\");\n/* harmony import */ var _CognitoRefreshToken__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./CognitoRefreshToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoRefreshToken.js\");\n/* harmony import */ var _CognitoUserSession__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./CognitoUserSession */ \"./node_modules/amazon-cognito-identity-js/es/CognitoUserSession.js\");\n/* harmony import */ var _DateHelper__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./DateHelper */ \"./node_modules/amazon-cognito-identity-js/es/DateHelper.js\");\n/* harmony import */ var _CognitoUserAttribute__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./CognitoUserAttribute */ \"./node_modules/amazon-cognito-identity-js/es/CognitoUserAttribute.js\");\n/* harmony import */ var _StorageHelper__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./StorageHelper */ \"./node_modules/amazon-cognito-identity-js/es/StorageHelper.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n // necessary for crypto js\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * @callback nodeCallback\n * @template T result\n * @param {*} err The operation failure reason, or null.\n * @param {T} result The operation result.\n */\n\n/**\n * @callback onFailure\n * @param {*} err Failure reason.\n */\n\n/**\n * @callback onSuccess\n * @template T result\n * @param {T} result The operation result.\n */\n\n/**\n * @callback mfaRequired\n * @param {*} details MFA challenge details.\n */\n\n/**\n * @callback customChallenge\n * @param {*} details Custom challenge details.\n */\n\n/**\n * @callback inputVerificationCode\n * @param {*} data Server response.\n */\n\n/**\n * @callback authSuccess\n * @param {CognitoUserSession} session The new session.\n * @param {bool=} userConfirmationNecessary User must be confirmed.\n */\n\n/** @class */\n\nvar CognitoUser = function () {\n  /**\n   * Constructs a new CognitoUser object\n   * @param {object} data Creation options\n   * @param {string} data.Username The user's username.\n   * @param {CognitoUserPool} data.Pool Pool containing the user.\n   * @param {object} data.Storage Optional storage object.\n   */\n  function CognitoUser(data) {\n    _classCallCheck(this, CognitoUser);\n\n    if (data == null || data.Username == null || data.Pool == null) {\n      throw new Error('Username and pool information are required.');\n    }\n\n    this.username = data.Username || '';\n    this.pool = data.Pool;\n    this.Session = null;\n\n    this.client = data.Pool.client;\n\n    this.signInUserSession = null;\n    this.authenticationFlowType = 'USER_SRP_AUTH';\n\n    this.storage = data.Storage || new _StorageHelper__WEBPACK_IMPORTED_MODULE_13__[\"default\"]().getStorage();\n\n    this.keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId();\n    this.userDataKey = this.keyPrefix + '.' + this.username + '.userData';\n  }\n\n  /**\n   * Sets the session for this user\n   * @param {CognitoUserSession} signInUserSession the session\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.setSignInUserSession = function setSignInUserSession(signInUserSession) {\n    this.clearCachedUserData();\n    this.signInUserSession = signInUserSession;\n    this.cacheTokens();\n  };\n\n  /**\n   * @returns {CognitoUserSession} the current session for this user\n   */\n\n\n  CognitoUser.prototype.getSignInUserSession = function getSignInUserSession() {\n    return this.signInUserSession;\n  };\n\n  /**\n   * @returns {string} the user's username\n   */\n\n\n  CognitoUser.prototype.getUsername = function getUsername() {\n    return this.username;\n  };\n\n  /**\n   * @returns {String} the authentication flow type\n   */\n\n\n  CognitoUser.prototype.getAuthenticationFlowType = function getAuthenticationFlowType() {\n    return this.authenticationFlowType;\n  };\n\n  /**\n   * sets authentication flow type\n   * @param {string} authenticationFlowType New value.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.setAuthenticationFlowType = function setAuthenticationFlowType(authenticationFlowType) {\n    this.authenticationFlowType = authenticationFlowType;\n  };\n\n  /**\n   * This is used for authenticating the user through the custom authentication flow.\n   * @param {AuthenticationDetails} authDetails Contains the authentication data\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {customChallenge} callback.customChallenge Custom challenge\n   *        response required to continue.\n   * @param {authSuccess} callback.onSuccess Called on success with the new session.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.initiateAuth = function initiateAuth(authDetails, callback) {\n    var _this = this;\n\n    var authParameters = authDetails.getAuthParameters();\n    authParameters.USERNAME = this.username;\n\n    var jsonReq = {\n      AuthFlow: 'CUSTOM_AUTH',\n      ClientId: this.pool.getClientId(),\n      AuthParameters: authParameters,\n      ClientMetadata: authDetails.getValidationData()\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n\n    this.client.request('InitiateAuth', jsonReq, function (err, data) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      var challengeName = data.ChallengeName;\n      var challengeParameters = data.ChallengeParameters;\n\n      if (challengeName === 'CUSTOM_CHALLENGE') {\n        _this.Session = data.Session;\n        return callback.customChallenge(challengeParameters);\n      }\n      _this.signInUserSession = _this.getCognitoUserSession(data.AuthenticationResult);\n      _this.cacheTokens();\n      return callback.onSuccess(_this.signInUserSession);\n    });\n  };\n\n  /**\n   * This is used for authenticating the user.\n   * stuff\n   * @param {AuthenticationDetails} authDetails Contains the authentication data\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {newPasswordRequired} callback.newPasswordRequired new\n   *        password and any required attributes are required to continue\n   * @param {mfaRequired} callback.mfaRequired MFA code\n   *        required to continue.\n   * @param {customChallenge} callback.customChallenge Custom challenge\n   *        response required to continue.\n   * @param {authSuccess} callback.onSuccess Called on success with the new session.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.authenticateUser = function authenticateUser(authDetails, callback) {\n    if (this.authenticationFlowType === 'USER_PASSWORD_AUTH') {\n      return this.authenticateUserPlainUsernamePassword(authDetails, callback);\n    } else if (this.authenticationFlowType === 'USER_SRP_AUTH' || this.authenticationFlowType === 'CUSTOM_AUTH') {\n      return this.authenticateUserDefaultAuth(authDetails, callback);\n    }\n    return callback.onFailure(new Error('Authentication flow type is invalid.'));\n  };\n\n  /**\n   * PRIVATE ONLY: This is an internal only method and should not\n   * be directly called by the consumers.\n   * It calls the AuthenticationHelper for SRP related\n   * stuff\n   * @param {AuthenticationDetails} authDetails Contains the authentication data\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {newPasswordRequired} callback.newPasswordRequired new\n   *        password and any required attributes are required to continue\n   * @param {mfaRequired} callback.mfaRequired MFA code\n   *        required to continue.\n   * @param {customChallenge} callback.customChallenge Custom challenge\n   *        response required to continue.\n   * @param {authSuccess} callback.onSuccess Called on success with the new session.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.authenticateUserDefaultAuth = function authenticateUserDefaultAuth(authDetails, callback) {\n    var _this2 = this;\n\n    var authenticationHelper = new _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_6__[\"default\"](this.pool.getUserPoolId().split('_')[1]);\n    var dateHelper = new _DateHelper__WEBPACK_IMPORTED_MODULE_11__[\"default\"]();\n\n    var serverBValue = void 0;\n    var salt = void 0;\n    var authParameters = {};\n\n    if (this.deviceKey != null) {\n      authParameters.DEVICE_KEY = this.deviceKey;\n    }\n\n    authParameters.USERNAME = this.username;\n    authenticationHelper.getLargeAValue(function (errOnAValue, aValue) {\n      // getLargeAValue callback start\n      if (errOnAValue) {\n        callback.onFailure(errOnAValue);\n      }\n\n      authParameters.SRP_A = aValue.toString(16);\n\n      if (_this2.authenticationFlowType === 'CUSTOM_AUTH') {\n        authParameters.CHALLENGE_NAME = 'SRP_A';\n      }\n\n      var jsonReq = {\n        AuthFlow: _this2.authenticationFlowType,\n        ClientId: _this2.pool.getClientId(),\n        AuthParameters: authParameters,\n        ClientMetadata: authDetails.getValidationData()\n      };\n      if (_this2.getUserContextData(_this2.username)) {\n        jsonReq.UserContextData = _this2.getUserContextData(_this2.username);\n      }\n\n      _this2.client.request('InitiateAuth', jsonReq, function (err, data) {\n        if (err) {\n          return callback.onFailure(err);\n        }\n\n        var challengeParameters = data.ChallengeParameters;\n\n        _this2.username = challengeParameters.USER_ID_FOR_SRP;\n        serverBValue = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](challengeParameters.SRP_B, 16);\n        salt = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](challengeParameters.SALT, 16);\n        _this2.getCachedDeviceKeyAndPassword();\n\n        authenticationHelper.getPasswordAuthenticationKey(_this2.username, authDetails.getPassword(), serverBValue, salt, function (errOnHkdf, hkdf) {\n          // getPasswordAuthenticationKey callback start\n          if (errOnHkdf) {\n            callback.onFailure(errOnHkdf);\n          }\n\n          var dateNow = dateHelper.getNowString();\n\n          var message = crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].concat([buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(_this2.pool.getUserPoolId().split('_')[1], 'utf8'), buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(_this2.username, 'utf8'), buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(challengeParameters.SECRET_BLOCK, 'base64'), buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(dateNow, 'utf8')]));\n          var key = crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(hkdf);\n          var signatureString = crypto_js_enc_base64__WEBPACK_IMPORTED_MODULE_3___default.a.stringify(crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4___default()(message, key));\n\n          var challengeResponses = {};\n\n          challengeResponses.USERNAME = _this2.username;\n          challengeResponses.PASSWORD_CLAIM_SECRET_BLOCK = challengeParameters.SECRET_BLOCK;\n          challengeResponses.TIMESTAMP = dateNow;\n          challengeResponses.PASSWORD_CLAIM_SIGNATURE = signatureString;\n\n          if (_this2.deviceKey != null) {\n            challengeResponses.DEVICE_KEY = _this2.deviceKey;\n          }\n\n          var respondToAuthChallenge = function respondToAuthChallenge(challenge, challengeCallback) {\n            return _this2.client.request('RespondToAuthChallenge', challenge, function (errChallenge, dataChallenge) {\n              if (errChallenge && errChallenge.code === 'ResourceNotFoundException' && errChallenge.message.toLowerCase().indexOf('device') !== -1) {\n                challengeResponses.DEVICE_KEY = null;\n                _this2.deviceKey = null;\n                _this2.randomPassword = null;\n                _this2.deviceGroupKey = null;\n                _this2.clearCachedDeviceKeyAndPassword();\n                return respondToAuthChallenge(challenge, challengeCallback);\n              }\n              return challengeCallback(errChallenge, dataChallenge);\n            });\n          };\n\n          var jsonReqResp = {\n            ChallengeName: 'PASSWORD_VERIFIER',\n            ClientId: _this2.pool.getClientId(),\n            ChallengeResponses: challengeResponses,\n            Session: data.Session\n          };\n          if (_this2.getUserContextData()) {\n            jsonReqResp.UserContextData = _this2.getUserContextData();\n          }\n          respondToAuthChallenge(jsonReqResp, function (errAuthenticate, dataAuthenticate) {\n            if (errAuthenticate) {\n              return callback.onFailure(errAuthenticate);\n            }\n\n            return _this2.authenticateUserInternal(dataAuthenticate, authenticationHelper, callback);\n          });\n          return undefined;\n          // getPasswordAuthenticationKey callback end\n        });\n        return undefined;\n      });\n      // getLargeAValue callback end\n    });\n  };\n\n  /**\n   * PRIVATE ONLY: This is an internal only method and should not\n   * be directly called by the consumers.\n   * @param {AuthenticationDetails} authDetails Contains the authentication data.\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {mfaRequired} callback.mfaRequired MFA code\n   *        required to continue.\n   * @param {authSuccess} callback.onSuccess Called on success with the new session.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.authenticateUserPlainUsernamePassword = function authenticateUserPlainUsernamePassword(authDetails, callback) {\n    var _this3 = this;\n\n    var authParameters = {};\n    authParameters.USERNAME = this.username;\n    authParameters.PASSWORD = authDetails.getPassword();\n    if (!authParameters.PASSWORD) {\n      callback.onFailure(new Error('PASSWORD parameter is required'));\n      return;\n    }\n    var authenticationHelper = new _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_6__[\"default\"](this.pool.getUserPoolId().split('_')[1]);\n    this.getCachedDeviceKeyAndPassword();\n    if (this.deviceKey != null) {\n      authParameters.DEVICE_KEY = this.deviceKey;\n    }\n\n    var jsonReq = {\n      AuthFlow: 'USER_PASSWORD_AUTH',\n      ClientId: this.pool.getClientId(),\n      AuthParameters: authParameters,\n      ClientMetadata: authDetails.getValidationData()\n    };\n    if (this.getUserContextData(this.username)) {\n      jsonReq.UserContextData = this.getUserContextData(this.username);\n    }\n    // USER_PASSWORD_AUTH happens in a single round-trip: client sends userName and password,\n    // Cognito UserPools verifies password and returns tokens.\n    this.client.request('InitiateAuth', jsonReq, function (err, authResult) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return _this3.authenticateUserInternal(authResult, authenticationHelper, callback);\n    });\n  };\n\n  /**\n  * PRIVATE ONLY: This is an internal only method and should not\n  * be directly called by the consumers.\n  * @param {object} dataAuthenticate authentication data\n  * @param {object} authenticationHelper helper created\n  * @param {callback} callback passed on from caller\n  * @returns {void}\n  */\n\n\n  CognitoUser.prototype.authenticateUserInternal = function authenticateUserInternal(dataAuthenticate, authenticationHelper, callback) {\n    var _this4 = this;\n\n    var challengeName = dataAuthenticate.ChallengeName;\n    var challengeParameters = dataAuthenticate.ChallengeParameters;\n\n    if (challengeName === 'SMS_MFA') {\n      this.Session = dataAuthenticate.Session;\n      return callback.mfaRequired(challengeName, challengeParameters);\n    }\n\n    if (challengeName === 'SELECT_MFA_TYPE') {\n      this.Session = dataAuthenticate.Session;\n      return callback.selectMFAType(challengeName, challengeParameters);\n    }\n\n    if (challengeName === 'MFA_SETUP') {\n      this.Session = dataAuthenticate.Session;\n      return callback.mfaSetup(challengeName, challengeParameters);\n    }\n\n    if (challengeName === 'SOFTWARE_TOKEN_MFA') {\n      this.Session = dataAuthenticate.Session;\n      return callback.totpRequired(challengeName, challengeParameters);\n    }\n\n    if (challengeName === 'CUSTOM_CHALLENGE') {\n      this.Session = dataAuthenticate.Session;\n      return callback.customChallenge(challengeParameters);\n    }\n\n    if (challengeName === 'NEW_PASSWORD_REQUIRED') {\n      this.Session = dataAuthenticate.Session;\n\n      var userAttributes = null;\n      var rawRequiredAttributes = null;\n      var requiredAttributes = [];\n      var userAttributesPrefix = authenticationHelper.getNewPasswordRequiredChallengeUserAttributePrefix();\n\n      if (challengeParameters) {\n        userAttributes = JSON.parse(dataAuthenticate.ChallengeParameters.userAttributes);\n        rawRequiredAttributes = JSON.parse(dataAuthenticate.ChallengeParameters.requiredAttributes);\n      }\n\n      if (rawRequiredAttributes) {\n        for (var i = 0; i < rawRequiredAttributes.length; i++) {\n          requiredAttributes[i] = rawRequiredAttributes[i].substr(userAttributesPrefix.length);\n        }\n      }\n      return callback.newPasswordRequired(userAttributes, requiredAttributes);\n    }\n\n    if (challengeName === 'DEVICE_SRP_AUTH') {\n      this.getDeviceResponse(callback);\n      return undefined;\n    }\n\n    this.signInUserSession = this.getCognitoUserSession(dataAuthenticate.AuthenticationResult);\n    this.challengeName = challengeName;\n    this.cacheTokens();\n\n    var newDeviceMetadata = dataAuthenticate.AuthenticationResult.NewDeviceMetadata;\n    if (newDeviceMetadata == null) {\n      return callback.onSuccess(this.signInUserSession);\n    }\n\n    authenticationHelper.generateHashDevice(dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceGroupKey, dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceKey, function (errGenHash) {\n      if (errGenHash) {\n        return callback.onFailure(errGenHash);\n      }\n\n      var deviceSecretVerifierConfig = {\n        Salt: buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(authenticationHelper.getSaltDevices(), 'hex').toString('base64'),\n        PasswordVerifier: buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(authenticationHelper.getVerifierDevices(), 'hex').toString('base64')\n      };\n\n      _this4.verifierDevices = deviceSecretVerifierConfig.PasswordVerifier;\n      _this4.deviceGroupKey = newDeviceMetadata.DeviceGroupKey;\n      _this4.randomPassword = authenticationHelper.getRandomPassword();\n\n      _this4.client.request('ConfirmDevice', {\n        DeviceKey: newDeviceMetadata.DeviceKey,\n        AccessToken: _this4.signInUserSession.getAccessToken().getJwtToken(),\n        DeviceSecretVerifierConfig: deviceSecretVerifierConfig,\n        DeviceName: navigator.userAgent\n      }, function (errConfirm, dataConfirm) {\n        if (errConfirm) {\n          return callback.onFailure(errConfirm);\n        }\n\n        _this4.deviceKey = dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceKey;\n        _this4.cacheDeviceKeyAndPassword();\n        if (dataConfirm.UserConfirmationNecessary === true) {\n          return callback.onSuccess(_this4.signInUserSession, dataConfirm.UserConfirmationNecessary);\n        }\n        return callback.onSuccess(_this4.signInUserSession);\n      });\n      return undefined;\n    });\n    return undefined;\n  };\n\n  /**\n  * This method is user to complete the NEW_PASSWORD_REQUIRED challenge.\n  * Pass the new password with any new user attributes to be updated.\n  * User attribute keys must be of format userAttributes.<attribute_name>.\n  * @param {string} newPassword new password for this user\n  * @param {object} requiredAttributeData map with values for all required attributes\n  * @param {object} callback Result callback map.\n  * @param {onFailure} callback.onFailure Called on any error.\n  * @param {mfaRequired} callback.mfaRequired MFA code required to continue.\n  * @param {customChallenge} callback.customChallenge Custom challenge\n  *         response required to continue.\n  * @param {authSuccess} callback.onSuccess Called on success with the new session.\n  * @returns {void}\n  */\n\n\n  CognitoUser.prototype.completeNewPasswordChallenge = function completeNewPasswordChallenge(newPassword, requiredAttributeData, callback) {\n    var _this5 = this;\n\n    if (!newPassword) {\n      return callback.onFailure(new Error('New password is required.'));\n    }\n    var authenticationHelper = new _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_6__[\"default\"](this.pool.getUserPoolId().split('_')[1]);\n    var userAttributesPrefix = authenticationHelper.getNewPasswordRequiredChallengeUserAttributePrefix();\n\n    var finalUserAttributes = {};\n    if (requiredAttributeData) {\n      Object.keys(requiredAttributeData).forEach(function (key) {\n        finalUserAttributes[userAttributesPrefix + key] = requiredAttributeData[key];\n      });\n    }\n\n    finalUserAttributes.NEW_PASSWORD = newPassword;\n    finalUserAttributes.USERNAME = this.username;\n    var jsonReq = {\n      ChallengeName: 'NEW_PASSWORD_REQUIRED',\n      ClientId: this.pool.getClientId(),\n      ChallengeResponses: finalUserAttributes,\n      Session: this.Session\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n\n    this.client.request('RespondToAuthChallenge', jsonReq, function (errAuthenticate, dataAuthenticate) {\n      if (errAuthenticate) {\n        return callback.onFailure(errAuthenticate);\n      }\n      return _this5.authenticateUserInternal(dataAuthenticate, authenticationHelper, callback);\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to get a session using device authentication. It is called at the end of user\n   * authentication\n   *\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {authSuccess} callback.onSuccess Called on success with the new session.\n   * @returns {void}\n   * @private\n   */\n\n\n  CognitoUser.prototype.getDeviceResponse = function getDeviceResponse(callback) {\n    var _this6 = this;\n\n    var authenticationHelper = new _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_6__[\"default\"](this.deviceGroupKey);\n    var dateHelper = new _DateHelper__WEBPACK_IMPORTED_MODULE_11__[\"default\"]();\n\n    var authParameters = {};\n\n    authParameters.USERNAME = this.username;\n    authParameters.DEVICE_KEY = this.deviceKey;\n    authenticationHelper.getLargeAValue(function (errAValue, aValue) {\n      // getLargeAValue callback start\n      if (errAValue) {\n        callback.onFailure(errAValue);\n      }\n\n      authParameters.SRP_A = aValue.toString(16);\n\n      var jsonReq = {\n        ChallengeName: 'DEVICE_SRP_AUTH',\n        ClientId: _this6.pool.getClientId(),\n        ChallengeResponses: authParameters\n      };\n      if (_this6.getUserContextData()) {\n        jsonReq.UserContextData = _this6.getUserContextData();\n      }\n      _this6.client.request('RespondToAuthChallenge', jsonReq, function (err, data) {\n        if (err) {\n          return callback.onFailure(err);\n        }\n\n        var challengeParameters = data.ChallengeParameters;\n\n        var serverBValue = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](challengeParameters.SRP_B, 16);\n        var salt = new _BigInteger__WEBPACK_IMPORTED_MODULE_5__[\"default\"](challengeParameters.SALT, 16);\n\n        authenticationHelper.getPasswordAuthenticationKey(_this6.deviceKey, _this6.randomPassword, serverBValue, salt, function (errHkdf, hkdf) {\n          // getPasswordAuthenticationKey callback start\n          if (errHkdf) {\n            return callback.onFailure(errHkdf);\n          }\n\n          var dateNow = dateHelper.getNowString();\n\n          var message = crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].concat([buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(_this6.deviceGroupKey, 'utf8'), buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(_this6.deviceKey, 'utf8'), buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(challengeParameters.SECRET_BLOCK, 'base64'), buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(dateNow, 'utf8')]));\n          var key = crypto_js_core__WEBPACK_IMPORTED_MODULE_1___default.a.lib.WordArray.create(hkdf);\n          var signatureString = crypto_js_enc_base64__WEBPACK_IMPORTED_MODULE_3___default.a.stringify(crypto_js_hmac_sha256__WEBPACK_IMPORTED_MODULE_4___default()(message, key));\n\n          var challengeResponses = {};\n\n          challengeResponses.USERNAME = _this6.username;\n          challengeResponses.PASSWORD_CLAIM_SECRET_BLOCK = challengeParameters.SECRET_BLOCK;\n          challengeResponses.TIMESTAMP = dateNow;\n          challengeResponses.PASSWORD_CLAIM_SIGNATURE = signatureString;\n          challengeResponses.DEVICE_KEY = _this6.deviceKey;\n\n          var jsonReqResp = {\n            ChallengeName: 'DEVICE_PASSWORD_VERIFIER',\n            ClientId: _this6.pool.getClientId(),\n            ChallengeResponses: challengeResponses,\n            Session: data.Session\n          };\n          if (_this6.getUserContextData()) {\n            jsonReqResp.UserContextData = _this6.getUserContextData();\n          }\n\n          _this6.client.request('RespondToAuthChallenge', jsonReqResp, function (errAuthenticate, dataAuthenticate) {\n            if (errAuthenticate) {\n              return callback.onFailure(errAuthenticate);\n            }\n\n            _this6.signInUserSession = _this6.getCognitoUserSession(dataAuthenticate.AuthenticationResult);\n            _this6.cacheTokens();\n\n            return callback.onSuccess(_this6.signInUserSession);\n          });\n          return undefined;\n          // getPasswordAuthenticationKey callback end\n        });\n        return undefined;\n      });\n      // getLargeAValue callback end\n    });\n  };\n\n  /**\n   * This is used for a certain user to confirm the registration by using a confirmation code\n   * @param {string} confirmationCode Code entered by user.\n   * @param {bool} forceAliasCreation Allow migrating from an existing email / phone number.\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.confirmRegistration = function confirmRegistration(confirmationCode, forceAliasCreation, callback) {\n    var jsonReq = {\n      ClientId: this.pool.getClientId(),\n      ConfirmationCode: confirmationCode,\n      Username: this.username,\n      ForceAliasCreation: forceAliasCreation\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n    this.client.request('ConfirmSignUp', jsonReq, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, 'SUCCESS');\n    });\n  };\n\n  /**\n   * This is used by the user once he has the responses to a custom challenge\n   * @param {string} answerChallenge The custom challenge answer.\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {customChallenge} callback.customChallenge\n   *    Custom challenge response required to continue.\n   * @param {authSuccess} callback.onSuccess Called on success with the new session.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.sendCustomChallengeAnswer = function sendCustomChallengeAnswer(answerChallenge, callback) {\n    var _this7 = this;\n\n    var challengeResponses = {};\n    challengeResponses.USERNAME = this.username;\n    challengeResponses.ANSWER = answerChallenge;\n\n    var authenticationHelper = new _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_6__[\"default\"](this.pool.getUserPoolId().split('_')[1]);\n    this.getCachedDeviceKeyAndPassword();\n    if (this.deviceKey != null) {\n      challengeResponses.DEVICE_KEY = this.deviceKey;\n    }\n\n    var jsonReq = {\n      ChallengeName: 'CUSTOM_CHALLENGE',\n      ChallengeResponses: challengeResponses,\n      ClientId: this.pool.getClientId(),\n      Session: this.Session\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n    this.client.request('RespondToAuthChallenge', jsonReq, function (err, data) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n\n      return _this7.authenticateUserInternal(data, authenticationHelper, callback);\n    });\n  };\n\n  /**\n   * This is used by the user once he has an MFA code\n   * @param {string} confirmationCode The MFA code entered by the user.\n   * @param {object} callback Result callback map.\n   * @param {string} mfaType The mfa we are replying to.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {authSuccess} callback.onSuccess Called on success with the new session.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.sendMFACode = function sendMFACode(confirmationCode, callback, mfaType) {\n    var _this8 = this;\n\n    var challengeResponses = {};\n    challengeResponses.USERNAME = this.username;\n    challengeResponses.SMS_MFA_CODE = confirmationCode;\n    var mfaTypeSelection = mfaType || 'SMS_MFA';\n    if (mfaTypeSelection === 'SOFTWARE_TOKEN_MFA') {\n      challengeResponses.SOFTWARE_TOKEN_MFA_CODE = confirmationCode;\n    }\n\n    if (this.deviceKey != null) {\n      challengeResponses.DEVICE_KEY = this.deviceKey;\n    }\n\n    var jsonReq = {\n      ChallengeName: mfaTypeSelection,\n      ChallengeResponses: challengeResponses,\n      ClientId: this.pool.getClientId(),\n      Session: this.Session\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n\n    this.client.request('RespondToAuthChallenge', jsonReq, function (err, dataAuthenticate) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n\n      var challengeName = dataAuthenticate.ChallengeName;\n\n      if (challengeName === 'DEVICE_SRP_AUTH') {\n        _this8.getDeviceResponse(callback);\n        return undefined;\n      }\n\n      _this8.signInUserSession = _this8.getCognitoUserSession(dataAuthenticate.AuthenticationResult);\n      _this8.cacheTokens();\n\n      if (dataAuthenticate.AuthenticationResult.NewDeviceMetadata == null) {\n        return callback.onSuccess(_this8.signInUserSession);\n      }\n\n      var authenticationHelper = new _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_6__[\"default\"](_this8.pool.getUserPoolId().split('_')[1]);\n      authenticationHelper.generateHashDevice(dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceGroupKey, dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceKey, function (errGenHash) {\n        if (errGenHash) {\n          return callback.onFailure(errGenHash);\n        }\n\n        var deviceSecretVerifierConfig = {\n          Salt: buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(authenticationHelper.getSaltDevices(), 'hex').toString('base64'),\n          PasswordVerifier: buffer___WEBPACK_IMPORTED_MODULE_0__[\"Buffer\"].from(authenticationHelper.getVerifierDevices(), 'hex').toString('base64')\n        };\n\n        _this8.verifierDevices = deviceSecretVerifierConfig.PasswordVerifier;\n        _this8.deviceGroupKey = dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceGroupKey;\n        _this8.randomPassword = authenticationHelper.getRandomPassword();\n\n        _this8.client.request('ConfirmDevice', {\n          DeviceKey: dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceKey,\n          AccessToken: _this8.signInUserSession.getAccessToken().getJwtToken(),\n          DeviceSecretVerifierConfig: deviceSecretVerifierConfig,\n          DeviceName: navigator.userAgent\n        }, function (errConfirm, dataConfirm) {\n          if (errConfirm) {\n            return callback.onFailure(errConfirm);\n          }\n\n          _this8.deviceKey = dataAuthenticate.AuthenticationResult.NewDeviceMetadata.DeviceKey;\n          _this8.cacheDeviceKeyAndPassword();\n          if (dataConfirm.UserConfirmationNecessary === true) {\n            return callback.onSuccess(_this8.signInUserSession, dataConfirm.UserConfirmationNecessary);\n          }\n          return callback.onSuccess(_this8.signInUserSession);\n        });\n        return undefined;\n      });\n      return undefined;\n    });\n  };\n\n  /**\n   * This is used by an authenticated user to change the current password\n   * @param {string} oldUserPassword The current password.\n   * @param {string} newUserPassword The requested new password.\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.changePassword = function changePassword(oldUserPassword, newUserPassword, callback) {\n    if (!(this.signInUserSession != null && this.signInUserSession.isValid())) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    this.client.request('ChangePassword', {\n      PreviousPassword: oldUserPassword,\n      ProposedPassword: newUserPassword,\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, 'SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated user to enable MFA for itself\n   * @deprecated\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.enableMFA = function enableMFA(callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    var mfaOptions = [];\n    var mfaEnabled = {\n      DeliveryMedium: 'SMS',\n      AttributeName: 'phone_number'\n    };\n    mfaOptions.push(mfaEnabled);\n\n    this.client.request('SetUserSettings', {\n      MFAOptions: mfaOptions,\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, 'SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated user to enable MFA for itself\n   * @param {IMfaSettings} smsMfaSettings the sms mfa settings\n   * @param {IMFASettings} softwareTokenMfaSettings the software token mfa settings\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.setUserMfaPreference = function setUserMfaPreference(smsMfaSettings, softwareTokenMfaSettings, callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    this.client.request('SetUserMFAPreference', {\n      SMSMfaSettings: smsMfaSettings,\n      SoftwareTokenMfaSettings: softwareTokenMfaSettings,\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, 'SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated user to disable MFA for itself\n   * @deprecated\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.disableMFA = function disableMFA(callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    var mfaOptions = [];\n\n    this.client.request('SetUserSettings', {\n      MFAOptions: mfaOptions,\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, 'SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated user to delete itself\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.deleteUser = function deleteUser(callback) {\n    var _this9 = this;\n\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    this.client.request('DeleteUser', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      _this9.clearCachedUser();\n      return callback(null, 'SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * @typedef {CognitoUserAttribute | { Name:string, Value:string }} AttributeArg\n   */\n  /**\n   * This is used by an authenticated user to change a list of attributes\n   * @param {AttributeArg[]} attributes A list of the new user attributes.\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.updateAttributes = function updateAttributes(attributes, callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    this.client.request('UpdateUserAttributes', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken(),\n      UserAttributes: attributes\n    }, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, 'SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated user to get a list of attributes\n   * @param {nodeCallback<CognitoUserAttribute[]>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getUserAttributes = function getUserAttributes(callback) {\n    if (!(this.signInUserSession != null && this.signInUserSession.isValid())) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    this.client.request('GetUser', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err, userData) {\n      if (err) {\n        return callback(err, null);\n      }\n\n      var attributeList = [];\n\n      for (var i = 0; i < userData.UserAttributes.length; i++) {\n        var attribute = {\n          Name: userData.UserAttributes[i].Name,\n          Value: userData.UserAttributes[i].Value\n        };\n        var userAttribute = new _CognitoUserAttribute__WEBPACK_IMPORTED_MODULE_12__[\"default\"](attribute);\n        attributeList.push(userAttribute);\n      }\n\n      return callback(null, attributeList);\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated user to get the MFAOptions\n   * @param {nodeCallback<MFAOptions>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getMFAOptions = function getMFAOptions(callback) {\n    if (!(this.signInUserSession != null && this.signInUserSession.isValid())) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    this.client.request('GetUser', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err, userData) {\n      if (err) {\n        return callback(err, null);\n      }\n\n      return callback(null, userData.MFAOptions);\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated users to get the userData\n   * @param {nodeCallback<UserData>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getUserData = function getUserData(callback, params) {\n    var _this10 = this;\n\n    if (!(this.signInUserSession != null && this.signInUserSession.isValid())) {\n      this.clearCachedUserData();\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    var bypassCache = params ? params.bypassCache : false;\n\n    var userData = this.storage.getItem(this.userDataKey);\n    // get the cached user data\n\n    if (!userData || bypassCache) {\n      this.client.request('GetUser', {\n        AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n      }, function (err, latestUserData) {\n        if (err) {\n          return callback(err, null);\n        }\n        _this10.cacheUserData(latestUserData);\n        var refresh = _this10.signInUserSession.getRefreshToken();\n        if (refresh && refresh.getToken()) {\n          _this10.refreshSession(refresh, function (refreshError, data) {\n            if (refreshError) {\n              return callback(refreshError, null);\n            }\n            return callback(null, latestUserData);\n          });\n        } else {\n          return callback(null, latestUserData);\n        }\n      });\n    } else {\n      try {\n        return callback(null, JSON.parse(userData));\n      } catch (err) {\n        this.clearCachedUserData();\n        return callback(err, null);\n      }\n    }\n    return undefined;\n  };\n\n  /**\n   * This is used by an authenticated user to delete a list of attributes\n   * @param {string[]} attributeList Names of the attributes to delete.\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.deleteAttributes = function deleteAttributes(attributeList, callback) {\n    if (!(this.signInUserSession != null && this.signInUserSession.isValid())) {\n      return callback(new Error('User is not authenticated'), null);\n    }\n\n    this.client.request('DeleteUserAttributes', {\n      UserAttributeNames: attributeList,\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, 'SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used by a user to resend a confirmation code\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.resendConfirmationCode = function resendConfirmationCode(callback) {\n    var jsonReq = {\n      ClientId: this.pool.getClientId(),\n      Username: this.username\n    };\n\n    this.client.request('ResendConfirmationCode', jsonReq, function (err, result) {\n      if (err) {\n        return callback(err, null);\n      }\n      return callback(null, result);\n    });\n  };\n\n  /**\n   * This is used to get a session, either from the session object\n   * or from  the local storage, or by using a refresh token\n   *\n   * @param {nodeCallback<CognitoUserSession>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getSession = function getSession(callback) {\n    if (this.username == null) {\n      return callback(new Error('Username is null. Cannot retrieve a new session'), null);\n    }\n\n    if (this.signInUserSession != null && this.signInUserSession.isValid()) {\n      return callback(null, this.signInUserSession);\n    }\n\n    var keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId() + '.' + this.username;\n    var idTokenKey = keyPrefix + '.idToken';\n    var accessTokenKey = keyPrefix + '.accessToken';\n    var refreshTokenKey = keyPrefix + '.refreshToken';\n    var clockDriftKey = keyPrefix + '.clockDrift';\n\n    if (this.storage.getItem(idTokenKey)) {\n      var idToken = new _CognitoIdToken__WEBPACK_IMPORTED_MODULE_8__[\"default\"]({\n        IdToken: this.storage.getItem(idTokenKey)\n      });\n      var accessToken = new _CognitoAccessToken__WEBPACK_IMPORTED_MODULE_7__[\"default\"]({\n        AccessToken: this.storage.getItem(accessTokenKey)\n      });\n      var refreshToken = new _CognitoRefreshToken__WEBPACK_IMPORTED_MODULE_9__[\"default\"]({\n        RefreshToken: this.storage.getItem(refreshTokenKey)\n      });\n      var clockDrift = parseInt(this.storage.getItem(clockDriftKey), 0) || 0;\n\n      var sessionData = {\n        IdToken: idToken,\n        AccessToken: accessToken,\n        RefreshToken: refreshToken,\n        ClockDrift: clockDrift\n      };\n      var cachedSession = new _CognitoUserSession__WEBPACK_IMPORTED_MODULE_10__[\"default\"](sessionData);\n      if (cachedSession.isValid()) {\n        this.signInUserSession = cachedSession;\n        return callback(null, this.signInUserSession);\n      }\n\n      if (!refreshToken.getToken()) {\n        return callback(new Error('Cannot retrieve a new session. Please authenticate.'), null);\n      }\n\n      this.refreshSession(refreshToken, callback);\n    } else {\n      callback(new Error('Local storage is missing an ID Token, Please authenticate'), null);\n    }\n\n    return undefined;\n  };\n\n  /**\n   * This uses the refreshToken to retrieve a new session\n   * @param {CognitoRefreshToken} refreshToken A previous session's refresh token.\n   * @param {nodeCallback<CognitoUserSession>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.refreshSession = function refreshSession(refreshToken, callback) {\n    var _this11 = this;\n\n    var authParameters = {};\n    authParameters.REFRESH_TOKEN = refreshToken.getToken();\n    var keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId();\n    var lastUserKey = keyPrefix + '.LastAuthUser';\n\n    if (this.storage.getItem(lastUserKey)) {\n      this.username = this.storage.getItem(lastUserKey);\n      var deviceKeyKey = keyPrefix + '.' + this.username + '.deviceKey';\n      this.deviceKey = this.storage.getItem(deviceKeyKey);\n      authParameters.DEVICE_KEY = this.deviceKey;\n    }\n\n    var jsonReq = {\n      ClientId: this.pool.getClientId(),\n      AuthFlow: 'REFRESH_TOKEN_AUTH',\n      AuthParameters: authParameters\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n    this.client.request('InitiateAuth', jsonReq, function (err, authResult) {\n      if (err) {\n        if (err.code === 'NotAuthorizedException') {\n          _this11.clearCachedUser();\n        }\n        return callback(err, null);\n      }\n      if (authResult) {\n        var authenticationResult = authResult.AuthenticationResult;\n        if (!Object.prototype.hasOwnProperty.call(authenticationResult, 'RefreshToken')) {\n          authenticationResult.RefreshToken = refreshToken.getToken();\n        }\n        _this11.signInUserSession = _this11.getCognitoUserSession(authenticationResult);\n        _this11.cacheTokens();\n        return callback(null, _this11.signInUserSession);\n      }\n      return undefined;\n    });\n  };\n\n  /**\n   * This is used to save the session tokens to local storage\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.cacheTokens = function cacheTokens() {\n    var keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId();\n    var idTokenKey = keyPrefix + '.' + this.username + '.idToken';\n    var accessTokenKey = keyPrefix + '.' + this.username + '.accessToken';\n    var refreshTokenKey = keyPrefix + '.' + this.username + '.refreshToken';\n    var clockDriftKey = keyPrefix + '.' + this.username + '.clockDrift';\n    var lastUserKey = keyPrefix + '.LastAuthUser';\n\n    this.storage.setItem(idTokenKey, this.signInUserSession.getIdToken().getJwtToken());\n    this.storage.setItem(accessTokenKey, this.signInUserSession.getAccessToken().getJwtToken());\n    this.storage.setItem(refreshTokenKey, this.signInUserSession.getRefreshToken().getToken());\n    this.storage.setItem(clockDriftKey, '' + this.signInUserSession.getClockDrift());\n    this.storage.setItem(lastUserKey, this.username);\n  };\n\n  /**\n   * This is to cache user data\n   */\n\n\n  CognitoUser.prototype.cacheUserData = function cacheUserData(userData) {\n    this.storage.setItem(this.userDataKey, JSON.stringify(userData));\n  };\n\n  /**\n   * This is to remove cached user data\n   */\n\n\n  CognitoUser.prototype.clearCachedUserData = function clearCachedUserData() {\n    this.storage.removeItem(this.userDataKey);\n  };\n\n  CognitoUser.prototype.clearCachedUser = function clearCachedUser() {\n    this.clearCachedTokens();\n    this.clearCachedUserData();\n  };\n\n  /**\n   * This is used to cache the device key and device group and device password\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.cacheDeviceKeyAndPassword = function cacheDeviceKeyAndPassword() {\n    var keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId() + '.' + this.username;\n    var deviceKeyKey = keyPrefix + '.deviceKey';\n    var randomPasswordKey = keyPrefix + '.randomPasswordKey';\n    var deviceGroupKeyKey = keyPrefix + '.deviceGroupKey';\n\n    this.storage.setItem(deviceKeyKey, this.deviceKey);\n    this.storage.setItem(randomPasswordKey, this.randomPassword);\n    this.storage.setItem(deviceGroupKeyKey, this.deviceGroupKey);\n  };\n\n  /**\n   * This is used to get current device key and device group and device password\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getCachedDeviceKeyAndPassword = function getCachedDeviceKeyAndPassword() {\n    var keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId() + '.' + this.username;\n    var deviceKeyKey = keyPrefix + '.deviceKey';\n    var randomPasswordKey = keyPrefix + '.randomPasswordKey';\n    var deviceGroupKeyKey = keyPrefix + '.deviceGroupKey';\n\n    if (this.storage.getItem(deviceKeyKey)) {\n      this.deviceKey = this.storage.getItem(deviceKeyKey);\n      this.randomPassword = this.storage.getItem(randomPasswordKey);\n      this.deviceGroupKey = this.storage.getItem(deviceGroupKeyKey);\n    }\n  };\n\n  /**\n   * This is used to clear the device key info from local storage\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.clearCachedDeviceKeyAndPassword = function clearCachedDeviceKeyAndPassword() {\n    var keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId() + '.' + this.username;\n    var deviceKeyKey = keyPrefix + '.deviceKey';\n    var randomPasswordKey = keyPrefix + '.randomPasswordKey';\n    var deviceGroupKeyKey = keyPrefix + '.deviceGroupKey';\n\n    this.storage.removeItem(deviceKeyKey);\n    this.storage.removeItem(randomPasswordKey);\n    this.storage.removeItem(deviceGroupKeyKey);\n  };\n\n  /**\n   * This is used to clear the session tokens from local storage\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.clearCachedTokens = function clearCachedTokens() {\n    var keyPrefix = 'CognitoIdentityServiceProvider.' + this.pool.getClientId();\n    var idTokenKey = keyPrefix + '.' + this.username + '.idToken';\n    var accessTokenKey = keyPrefix + '.' + this.username + '.accessToken';\n    var refreshTokenKey = keyPrefix + '.' + this.username + '.refreshToken';\n    var lastUserKey = keyPrefix + '.LastAuthUser';\n    var clockDriftKey = keyPrefix + '.' + this.username + '.clockDrift';\n\n    this.storage.removeItem(idTokenKey);\n    this.storage.removeItem(accessTokenKey);\n    this.storage.removeItem(refreshTokenKey);\n    this.storage.removeItem(lastUserKey);\n    this.storage.removeItem(clockDriftKey);\n  };\n\n  /**\n   * This is used to build a user session from tokens retrieved in the authentication result\n   * @param {object} authResult Successful auth response from server.\n   * @returns {CognitoUserSession} The new user session.\n   * @private\n   */\n\n\n  CognitoUser.prototype.getCognitoUserSession = function getCognitoUserSession(authResult) {\n    var idToken = new _CognitoIdToken__WEBPACK_IMPORTED_MODULE_8__[\"default\"](authResult);\n    var accessToken = new _CognitoAccessToken__WEBPACK_IMPORTED_MODULE_7__[\"default\"](authResult);\n    var refreshToken = new _CognitoRefreshToken__WEBPACK_IMPORTED_MODULE_9__[\"default\"](authResult);\n\n    var sessionData = {\n      IdToken: idToken,\n      AccessToken: accessToken,\n      RefreshToken: refreshToken\n    };\n\n    return new _CognitoUserSession__WEBPACK_IMPORTED_MODULE_10__[\"default\"](sessionData);\n  };\n\n  /**\n   * This is used to initiate a forgot password request\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {inputVerificationCode?} callback.inputVerificationCode\n   *    Optional callback raised instead of onSuccess with response data.\n   * @param {onSuccess} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.forgotPassword = function forgotPassword(callback) {\n    var jsonReq = {\n      ClientId: this.pool.getClientId(),\n      Username: this.username\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n    this.client.request('ForgotPassword', jsonReq, function (err, data) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      if (typeof callback.inputVerificationCode === 'function') {\n        return callback.inputVerificationCode(data);\n      }\n      return callback.onSuccess(data);\n    });\n  };\n\n  /**\n   * This is used to confirm a new password using a confirmationCode\n   * @param {string} confirmationCode Code entered by user.\n   * @param {string} newPassword Confirm new password.\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<void>} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.confirmPassword = function confirmPassword(confirmationCode, newPassword, callback) {\n    var jsonReq = {\n      ClientId: this.pool.getClientId(),\n      Username: this.username,\n      ConfirmationCode: confirmationCode,\n      Password: newPassword\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n    this.client.request('ConfirmForgotPassword', jsonReq, function (err) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return callback.onSuccess();\n    });\n  };\n\n  /**\n   * This is used to initiate an attribute confirmation request\n   * @param {string} attributeName User attribute that needs confirmation.\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {inputVerificationCode} callback.inputVerificationCode Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getAttributeVerificationCode = function getAttributeVerificationCode(attributeName, callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('GetUserAttributeVerificationCode', {\n      AttributeName: attributeName,\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err, data) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      if (typeof callback.inputVerificationCode === 'function') {\n        return callback.inputVerificationCode(data);\n      }\n      return callback.onSuccess();\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to confirm an attribute using a confirmation code\n   * @param {string} attributeName Attribute being confirmed.\n   * @param {string} confirmationCode Code entered by user.\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<string>} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.verifyAttribute = function verifyAttribute(attributeName, confirmationCode, callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('VerifyUserAttribute', {\n      AttributeName: attributeName,\n      Code: confirmationCode,\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return callback.onSuccess('SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to get the device information using the current device key\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<*>} callback.onSuccess Called on success with device data.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getDevice = function getDevice(callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('GetDevice', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken(),\n      DeviceKey: this.deviceKey\n    }, function (err, data) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return callback.onSuccess(data);\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to forget a specific device\n   * @param {string} deviceKey Device key.\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<string>} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.forgetSpecificDevice = function forgetSpecificDevice(deviceKey, callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('ForgetDevice', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken(),\n      DeviceKey: deviceKey\n    }, function (err) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return callback.onSuccess('SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to forget the current device\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<string>} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.forgetDevice = function forgetDevice(callback) {\n    var _this12 = this;\n\n    this.forgetSpecificDevice(this.deviceKey, {\n      onFailure: callback.onFailure,\n      onSuccess: function onSuccess(result) {\n        _this12.deviceKey = null;\n        _this12.deviceGroupKey = null;\n        _this12.randomPassword = null;\n        _this12.clearCachedDeviceKeyAndPassword();\n        return callback.onSuccess(result);\n      }\n    });\n  };\n\n  /**\n   * This is used to set the device status as remembered\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<string>} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.setDeviceStatusRemembered = function setDeviceStatusRemembered(callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('UpdateDeviceStatus', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken(),\n      DeviceKey: this.deviceKey,\n      DeviceRememberedStatus: 'remembered'\n    }, function (err) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return callback.onSuccess('SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to set the device status as not remembered\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<string>} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.setDeviceStatusNotRemembered = function setDeviceStatusNotRemembered(callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('UpdateDeviceStatus', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken(),\n      DeviceKey: this.deviceKey,\n      DeviceRememberedStatus: 'not_remembered'\n    }, function (err) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return callback.onSuccess('SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to list all devices for a user\n   *\n   * @param {int} limit the number of devices returned in a call\n   * @param {string} paginationToken the pagination token in case any was returned before\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<*>} callback.onSuccess Called on success with device list.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.listDevices = function listDevices(limit, paginationToken, callback) {\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('ListDevices', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken(),\n      Limit: limit,\n      PaginationToken: paginationToken\n    }, function (err, data) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      return callback.onSuccess(data);\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used to globally revoke all tokens issued to a user\n   * @param {object} callback Result callback map.\n   * @param {onFailure} callback.onFailure Called on any error.\n   * @param {onSuccess<string>} callback.onSuccess Called on success.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.globalSignOut = function globalSignOut(callback) {\n    var _this13 = this;\n\n    if (this.signInUserSession == null || !this.signInUserSession.isValid()) {\n      return callback.onFailure(new Error('User is not authenticated'));\n    }\n\n    this.client.request('GlobalSignOut', {\n      AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n    }, function (err) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      _this13.clearCachedUser();\n      return callback.onSuccess('SUCCESS');\n    });\n    return undefined;\n  };\n\n  /**\n   * This is used for the user to signOut of the application and clear the cached tokens.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.signOut = function signOut() {\n    this.signInUserSession = null;\n    this.clearCachedUser();\n  };\n\n  /**\n   * This is used by a user trying to select a given MFA\n   * @param {string} answerChallenge the mfa the user wants\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.sendMFASelectionAnswer = function sendMFASelectionAnswer(answerChallenge, callback) {\n    var _this14 = this;\n\n    var challengeResponses = {};\n    challengeResponses.USERNAME = this.username;\n    challengeResponses.ANSWER = answerChallenge;\n\n    var jsonReq = {\n      ChallengeName: 'SELECT_MFA_TYPE',\n      ChallengeResponses: challengeResponses,\n      ClientId: this.pool.getClientId(),\n      Session: this.Session\n    };\n    if (this.getUserContextData()) {\n      jsonReq.UserContextData = this.getUserContextData();\n    }\n    this.client.request('RespondToAuthChallenge', jsonReq, function (err, data) {\n      if (err) {\n        return callback.onFailure(err);\n      }\n      _this14.Session = data.Session;\n      if (answerChallenge === 'SMS_MFA') {\n        return callback.mfaRequired(data.challengeName, data.challengeParameters);\n      }\n      if (answerChallenge === 'SOFTWARE_TOKEN_MFA') {\n        return callback.totpRequired(data.challengeName, data.challengeParameters);\n      }\n      return undefined;\n    });\n  };\n\n  /**\n   * This returns the user context data for advanced security feature.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.getUserContextData = function getUserContextData() {\n    var pool = this.pool;\n    return pool.getUserContextData(this.username);\n  };\n\n  /**\n   * This is used by an authenticated or a user trying to authenticate to associate a TOTP MFA\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.associateSoftwareToken = function associateSoftwareToken(callback) {\n    var _this15 = this;\n\n    if (!(this.signInUserSession != null && this.signInUserSession.isValid())) {\n      this.client.request('AssociateSoftwareToken', {\n        Session: this.Session\n      }, function (err, data) {\n        if (err) {\n          return callback.onFailure(err);\n        }\n        _this15.Session = data.Session;\n        return callback.associateSecretCode(data.SecretCode);\n      });\n    } else {\n      this.client.request('AssociateSoftwareToken', {\n        AccessToken: this.signInUserSession.getAccessToken().getJwtToken()\n      }, function (err, data) {\n        if (err) {\n          return callback.onFailure(err);\n        }\n        return callback.associateSecretCode(data.SecretCode);\n      });\n    }\n  };\n\n  /**\n   * This is used by an authenticated or a user trying to authenticate to verify a TOTP MFA\n   * @param {string} totpCode The MFA code entered by the user.\n   * @param {string} friendlyDeviceName The device name we are assigning to the device.\n   * @param {nodeCallback<string>} callback Called on success or error.\n   * @returns {void}\n   */\n\n\n  CognitoUser.prototype.verifySoftwareToken = function verifySoftwareToken(totpCode, friendlyDeviceName, callback) {\n    var _this16 = this;\n\n    if (!(this.signInUserSession != null && this.signInUserSession.isValid())) {\n      this.client.request('VerifySoftwareToken', {\n        Session: this.Session,\n        UserCode: totpCode,\n        FriendlyDeviceName: friendlyDeviceName\n      }, function (err, data) {\n        if (err) {\n          return callback.onFailure(err);\n        }\n        _this16.Session = data.Session;\n        var challengeResponses = {};\n        challengeResponses.USERNAME = _this16.username;\n        var jsonReq = {\n          ChallengeName: 'MFA_SETUP',\n          ClientId: _this16.pool.getClientId(),\n          ChallengeResponses: challengeResponses,\n          Session: _this16.Session\n        };\n        if (_this16.getUserContextData()) {\n          jsonReq.UserContextData = _this16.getUserContextData();\n        }\n        _this16.client.request('RespondToAuthChallenge', jsonReq, function (errRespond, dataRespond) {\n          if (errRespond) {\n            return callback.onFailure(errRespond);\n          }\n          _this16.signInUserSession = _this16.getCognitoUserSession(dataRespond.AuthenticationResult);\n          _this16.cacheTokens();\n          return callback.onSuccess(_this16.signInUserSession);\n        });\n        return undefined;\n      });\n    } else {\n      this.client.request('VerifySoftwareToken', {\n        AccessToken: this.signInUserSession.getAccessToken().getJwtToken(),\n        UserCode: totpCode,\n        FriendlyDeviceName: friendlyDeviceName\n      }, function (err, data) {\n        if (err) {\n          return callback.onFailure(err);\n        }\n        return callback.onSuccess(data);\n      });\n    }\n  };\n\n  return CognitoUser;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoUser);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoUser.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoUserAttribute.js":
/*!****************************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoUserAttribute.js ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n/** @class */\nvar CognitoUserAttribute = function () {\n  /**\n   * Constructs a new CognitoUserAttribute object\n   * @param {string=} Name The record's name\n   * @param {string=} Value The record's value\n   */\n  function CognitoUserAttribute() {\n    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},\n        Name = _ref.Name,\n        Value = _ref.Value;\n\n    _classCallCheck(this, CognitoUserAttribute);\n\n    this.Name = Name || '';\n    this.Value = Value || '';\n  }\n\n  /**\n   * @returns {string} the record's value.\n   */\n\n\n  CognitoUserAttribute.prototype.getValue = function getValue() {\n    return this.Value;\n  };\n\n  /**\n   * Sets the record's value.\n   * @param {string} value The new value.\n   * @returns {CognitoUserAttribute} The record for method chaining.\n   */\n\n\n  CognitoUserAttribute.prototype.setValue = function setValue(value) {\n    this.Value = value;\n    return this;\n  };\n\n  /**\n   * @returns {string} the record's name.\n   */\n\n\n  CognitoUserAttribute.prototype.getName = function getName() {\n    return this.Name;\n  };\n\n  /**\n   * Sets the record's name\n   * @param {string} name The new name.\n   * @returns {CognitoUserAttribute} The record for method chaining.\n   */\n\n\n  CognitoUserAttribute.prototype.setName = function setName(name) {\n    this.Name = name;\n    return this;\n  };\n\n  /**\n   * @returns {string} a string representation of the record.\n   */\n\n\n  CognitoUserAttribute.prototype.toString = function toString() {\n    return JSON.stringify(this);\n  };\n\n  /**\n   * @returns {object} a flat object representing the record.\n   */\n\n\n  CognitoUserAttribute.prototype.toJSON = function toJSON() {\n    return {\n      Name: this.Name,\n      Value: this.Value\n    };\n  };\n\n  return CognitoUserAttribute;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoUserAttribute);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYW1hem9uLWNvZ25pdG8taWRlbnRpdHktanMvZXMvQ29nbml0b1VzZXJBdHRyaWJ1dGUuanMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9ub2RlX21vZHVsZXMvYW1hem9uLWNvZ25pdG8taWRlbnRpdHktanMvZXMvQ29nbml0b1VzZXJBdHRyaWJ1dGUuanM/YTMzMCJdLCJzb3VyY2VzQ29udGVudCI6WyJmdW5jdGlvbiBfY2xhc3NDYWxsQ2hlY2soaW5zdGFuY2UsIENvbnN0cnVjdG9yKSB7IGlmICghKGluc3RhbmNlIGluc3RhbmNlb2YgQ29uc3RydWN0b3IpKSB7IHRocm93IG5ldyBUeXBlRXJyb3IoXCJDYW5ub3QgY2FsbCBhIGNsYXNzIGFzIGEgZnVuY3Rpb25cIik7IH0gfVxuXG4vKiFcbiAqIENvcHlyaWdodCAyMDE2IEFtYXpvbi5jb20sXG4gKiBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIExpY2Vuc2VkIHVuZGVyIHRoZSBBbWF6b24gU29mdHdhcmUgTGljZW5zZSAodGhlIFwiTGljZW5zZVwiKS5cbiAqIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGVcbiAqIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgIGh0dHA6Ly9hd3MuYW1hem9uLmNvbS9hc2wvXG4gKlxuICogb3IgaW4gdGhlIFwibGljZW5zZVwiIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzXG4gKiBkaXN0cmlidXRlZCBvbiBhbiBcIkFTIElTXCIgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFUyBPUlxuICogQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2VcbiAqIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuLyoqIEBjbGFzcyAqL1xudmFyIENvZ25pdG9Vc2VyQXR0cmlidXRlID0gZnVuY3Rpb24gKCkge1xuICAvKipcbiAgICogQ29uc3RydWN0cyBhIG5ldyBDb2duaXRvVXNlckF0dHJpYnV0ZSBvYmplY3RcbiAgICogQHBhcmFtIHtzdHJpbmc9fSBOYW1lIFRoZSByZWNvcmQncyBuYW1lXG4gICAqIEBwYXJhbSB7c3RyaW5nPX0gVmFsdWUgVGhlIHJlY29yZCdzIHZhbHVlXG4gICAqL1xuICBmdW5jdGlvbiBDb2duaXRvVXNlckF0dHJpYnV0ZSgpIHtcbiAgICB2YXIgX3JlZiA9IGFyZ3VtZW50cy5sZW5ndGggPiAwICYmIGFyZ3VtZW50c1swXSAhPT0gdW5kZWZpbmVkID8gYXJndW1lbnRzWzBdIDoge30sXG4gICAgICAgIE5hbWUgPSBfcmVmLk5hbWUsXG4gICAgICAgIFZhbHVlID0gX3JlZi5WYWx1ZTtcblxuICAgIF9jbGFzc0NhbGxDaGVjayh0aGlzLCBDb2duaXRvVXNlckF0dHJpYnV0ZSk7XG5cbiAgICB0aGlzLk5hbWUgPSBOYW1lIHx8ICcnO1xuICAgIHRoaXMuVmFsdWUgPSBWYWx1ZSB8fCAnJztcbiAgfVxuXG4gIC8qKlxuICAgKiBAcmV0dXJucyB7c3RyaW5nfSB0aGUgcmVjb3JkJ3MgdmFsdWUuXG4gICAqL1xuXG5cbiAgQ29nbml0b1VzZXJBdHRyaWJ1dGUucHJvdG90eXBlLmdldFZhbHVlID0gZnVuY3Rpb24gZ2V0VmFsdWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuVmFsdWU7XG4gIH07XG5cbiAgLyoqXG4gICAqIFNldHMgdGhlIHJlY29yZCdzIHZhbHVlLlxuICAgKiBAcGFyYW0ge3N0cmluZ30gdmFsdWUgVGhlIG5ldyB2YWx1ZS5cbiAgICogQHJldHVybnMge0NvZ25pdG9Vc2VyQXR0cmlidXRlfSBUaGUgcmVjb3JkIGZvciBtZXRob2QgY2hhaW5pbmcuXG4gICAqL1xuXG5cbiAgQ29nbml0b1VzZXJBdHRyaWJ1dGUucHJvdG90eXBlLnNldFZhbHVlID0gZnVuY3Rpb24gc2V0VmFsdWUodmFsdWUpIHtcbiAgICB0aGlzLlZhbHVlID0gdmFsdWU7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH07XG5cbiAgLyoqXG4gICAqIEByZXR1cm5zIHtzdHJpbmd9IHRoZSByZWNvcmQncyBuYW1lLlxuICAgKi9cblxuXG4gIENvZ25pdG9Vc2VyQXR0cmlidXRlLnByb3RvdHlwZS5nZXROYW1lID0gZnVuY3Rpb24gZ2V0TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5OYW1lO1xuICB9O1xuXG4gIC8qKlxuICAgKiBTZXRzIHRoZSByZWNvcmQncyBuYW1lXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBuYW1lIFRoZSBuZXcgbmFtZS5cbiAgICogQHJldHVybnMge0NvZ25pdG9Vc2VyQXR0cmlidXRlfSBUaGUgcmVjb3JkIGZvciBtZXRob2QgY2hhaW5pbmcuXG4gICAqL1xuXG5cbiAgQ29nbml0b1VzZXJBdHRyaWJ1dGUucHJvdG90eXBlLnNldE5hbWUgPSBmdW5jdGlvbiBzZXROYW1lKG5hbWUpIHtcbiAgICB0aGlzLk5hbWUgPSBuYW1lO1xuICAgIHJldHVybiB0aGlzO1xuICB9O1xuXG4gIC8qKlxuICAgKiBAcmV0dXJucyB7c3RyaW5nfSBhIHN0cmluZyByZXByZXNlbnRhdGlvbiBvZiB0aGUgcmVjb3JkLlxuICAgKi9cblxuXG4gIENvZ25pdG9Vc2VyQXR0cmlidXRlLnByb3RvdHlwZS50b1N0cmluZyA9IGZ1bmN0aW9uIHRvU3RyaW5nKCkge1xuICAgIHJldHVybiBKU09OLnN0cmluZ2lmeSh0aGlzKTtcbiAgfTtcblxuICAvKipcbiAgICogQHJldHVybnMge29iamVjdH0gYSBmbGF0IG9iamVjdCByZXByZXNlbnRpbmcgdGhlIHJlY29yZC5cbiAgICovXG5cblxuICBDb2duaXRvVXNlckF0dHJpYnV0ZS5wcm90b3R5cGUudG9KU09OID0gZnVuY3Rpb24gdG9KU09OKCkge1xuICAgIHJldHVybiB7XG4gICAgICBOYW1lOiB0aGlzLk5hbWUsXG4gICAgICBWYWx1ZTogdGhpcy5WYWx1ZVxuICAgIH07XG4gIH07XG5cbiAgcmV0dXJuIENvZ25pdG9Vc2VyQXR0cmlidXRlO1xufSgpO1xuXG5leHBvcnQgZGVmYXVsdCBDb2duaXRvVXNlckF0dHJpYnV0ZTsiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoUserAttribute.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoUserPool.js":
/*!***********************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoUserPool.js ***!
  \***********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Client__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Client */ \"./node_modules/amazon-cognito-identity-js/es/Client.js\");\n/* harmony import */ var _CognitoUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CognitoUser */ \"./node_modules/amazon-cognito-identity-js/es/CognitoUser.js\");\n/* harmony import */ var _StorageHelper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./StorageHelper */ \"./node_modules/amazon-cognito-identity-js/es/StorageHelper.js\");\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n\n\n/** @class */\n\nvar CognitoUserPool = function () {\n  /**\n   * Constructs a new CognitoUserPool object\n   * @param {object} data Creation options.\n   * @param {string} data.UserPoolId Cognito user pool id.\n   * @param {string} data.ClientId User pool application client id.\n   * @param {object} data.Storage Optional storage object.\n   * @param {boolean} data.AdvancedSecurityDataCollectionFlag Optional:\n   *        boolean flag indicating if the data collection is enabled\n   *        to support cognito advanced security features. By default, this\n   *        flag is set to true.\n   */\n  function CognitoUserPool(data) {\n    _classCallCheck(this, CognitoUserPool);\n\n    var _ref = data || {},\n        UserPoolId = _ref.UserPoolId,\n        ClientId = _ref.ClientId,\n        endpoint = _ref.endpoint,\n        AdvancedSecurityDataCollectionFlag = _ref.AdvancedSecurityDataCollectionFlag;\n\n    if (!UserPoolId || !ClientId) {\n      throw new Error('Both UserPoolId and ClientId are required.');\n    }\n    if (!/^[\\w-]+_.+$/.test(UserPoolId)) {\n      throw new Error('Invalid UserPoolId format.');\n    }\n    var region = UserPoolId.split('_')[0];\n\n    this.userPoolId = UserPoolId;\n    this.clientId = ClientId;\n\n    this.client = new _Client__WEBPACK_IMPORTED_MODULE_0__[\"default\"](region, endpoint);\n\n    /**\n     * By default, AdvancedSecurityDataCollectionFlag is set to true,\n     * if no input value is provided.\n     */\n    this.advancedSecurityDataCollectionFlag = AdvancedSecurityDataCollectionFlag !== false;\n\n    this.storage = data.Storage || new _StorageHelper__WEBPACK_IMPORTED_MODULE_2__[\"default\"]().getStorage();\n  }\n\n  /**\n   * @returns {string} the user pool id\n   */\n\n\n  CognitoUserPool.prototype.getUserPoolId = function getUserPoolId() {\n    return this.userPoolId;\n  };\n\n  /**\n   * @returns {string} the client id\n   */\n\n\n  CognitoUserPool.prototype.getClientId = function getClientId() {\n    return this.clientId;\n  };\n\n  /**\n   * @typedef {object} SignUpResult\n   * @property {CognitoUser} user New user.\n   * @property {bool} userConfirmed If the user is already confirmed.\n   */\n  /**\n   * method for signing up a user\n   * @param {string} username User's username.\n   * @param {string} password Plain-text initial password entered by user.\n   * @param {(AttributeArg[])=} userAttributes New user attributes.\n   * @param {(AttributeArg[])=} validationData Application metadata.\n   * @param {nodeCallback<SignUpResult>} callback Called on error or with the new user.\n   * @returns {void}\n   */\n\n\n  CognitoUserPool.prototype.signUp = function signUp(username, password, userAttributes, validationData, callback) {\n    var _this = this;\n\n    var jsonReq = {\n      ClientId: this.clientId,\n      Username: username,\n      Password: password,\n      UserAttributes: userAttributes,\n      ValidationData: validationData\n    };\n    if (this.getUserContextData(username)) {\n      jsonReq.UserContextData = this.getUserContextData(username);\n    }\n    this.client.request('SignUp', jsonReq, function (err, data) {\n      if (err) {\n        return callback(err, null);\n      }\n\n      var cognitoUser = {\n        Username: username,\n        Pool: _this,\n        Storage: _this.storage\n      };\n\n      var returnData = {\n        user: new _CognitoUser__WEBPACK_IMPORTED_MODULE_1__[\"default\"](cognitoUser),\n        userConfirmed: data.UserConfirmed,\n        userSub: data.UserSub\n      };\n\n      return callback(null, returnData);\n    });\n  };\n\n  /**\n   * method for getting the current user of the application from the local storage\n   *\n   * @returns {CognitoUser} the user retrieved from storage\n   */\n\n\n  CognitoUserPool.prototype.getCurrentUser = function getCurrentUser() {\n    var lastUserKey = 'CognitoIdentityServiceProvider.' + this.clientId + '.LastAuthUser';\n\n    var lastAuthUser = this.storage.getItem(lastUserKey);\n    if (lastAuthUser) {\n      var cognitoUser = {\n        Username: lastAuthUser,\n        Pool: this,\n        Storage: this.storage\n      };\n\n      return new _CognitoUser__WEBPACK_IMPORTED_MODULE_1__[\"default\"](cognitoUser);\n    }\n\n    return null;\n  };\n\n  /**\n   * This method returns the encoded data string used for cognito advanced security feature.\n   * This would be generated only when developer has included the JS used for collecting the\n   * data on their client. Please refer to documentation to know more about using AdvancedSecurity\n   * features\n   * @param {string} username the username for the context data\n   * @returns {string} the user context data\n   **/\n\n\n  CognitoUserPool.prototype.getUserContextData = function getUserContextData(username) {\n    if (typeof AmazonCognitoAdvancedSecurityData === 'undefined') {\n      return undefined;\n    }\n    /* eslint-disable */\n    var amazonCognitoAdvancedSecurityDataConst = AmazonCognitoAdvancedSecurityData;\n    /* eslint-enable */\n\n    if (this.advancedSecurityDataCollectionFlag) {\n      var advancedSecurityData = amazonCognitoAdvancedSecurityDataConst.getData(username, this.userPoolId, this.clientId);\n      if (advancedSecurityData) {\n        var userContextData = {\n          EncodedData: advancedSecurityData\n        };\n        return userContextData;\n      }\n    }\n    return {};\n  };\n\n  return CognitoUserPool;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoUserPool);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoUserPool.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CognitoUserSession.js":
/*!**************************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CognitoUserSession.js ***!
  \**************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n/** @class */\nvar CognitoUserSession = function () {\n  /**\n   * Constructs a new CognitoUserSession object\n   * @param {CognitoIdToken} IdToken The session's Id token.\n   * @param {CognitoRefreshToken=} RefreshToken The session's refresh token.\n   * @param {CognitoAccessToken} AccessToken The session's access token.\n   * @param {int} ClockDrift The saved computer's clock drift or undefined to force calculation.\n   */\n  function CognitoUserSession() {\n    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},\n        IdToken = _ref.IdToken,\n        RefreshToken = _ref.RefreshToken,\n        AccessToken = _ref.AccessToken,\n        ClockDrift = _ref.ClockDrift;\n\n    _classCallCheck(this, CognitoUserSession);\n\n    if (AccessToken == null || IdToken == null) {\n      throw new Error('Id token and Access Token must be present.');\n    }\n\n    this.idToken = IdToken;\n    this.refreshToken = RefreshToken;\n    this.accessToken = AccessToken;\n    this.clockDrift = ClockDrift === undefined ? this.calculateClockDrift() : ClockDrift;\n  }\n\n  /**\n   * @returns {CognitoIdToken} the session's Id token\n   */\n\n\n  CognitoUserSession.prototype.getIdToken = function getIdToken() {\n    return this.idToken;\n  };\n\n  /**\n   * @returns {CognitoRefreshToken} the session's refresh token\n   */\n\n\n  CognitoUserSession.prototype.getRefreshToken = function getRefreshToken() {\n    return this.refreshToken;\n  };\n\n  /**\n   * @returns {CognitoAccessToken} the session's access token\n   */\n\n\n  CognitoUserSession.prototype.getAccessToken = function getAccessToken() {\n    return this.accessToken;\n  };\n\n  /**\n   * @returns {int} the session's clock drift\n   */\n\n\n  CognitoUserSession.prototype.getClockDrift = function getClockDrift() {\n    return this.clockDrift;\n  };\n\n  /**\n   * @returns {int} the computer's clock drift\n   */\n\n\n  CognitoUserSession.prototype.calculateClockDrift = function calculateClockDrift() {\n    var now = Math.floor(new Date() / 1000);\n    var iat = Math.min(this.accessToken.getIssuedAt(), this.idToken.getIssuedAt());\n\n    return now - iat;\n  };\n\n  /**\n   * Checks to see if the session is still valid based on session expiry information found\n   * in tokens and the current time (adjusted with clock drift)\n   * @returns {boolean} if the session is still valid\n   */\n\n\n  CognitoUserSession.prototype.isValid = function isValid() {\n    var now = Math.floor(new Date() / 1000);\n    var adjusted = now - this.clockDrift;\n\n    return adjusted < this.accessToken.getExpiration() && adjusted < this.idToken.getExpiration();\n  };\n\n  return CognitoUserSession;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CognitoUserSession);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CognitoUserSession.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/CookieStorage.js":
/*!*********************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/CookieStorage.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! js-cookie */ \"./node_modules/js-cookie/src/js.cookie.js\");\n/* harmony import */ var js_cookie__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(js_cookie__WEBPACK_IMPORTED_MODULE_0__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n\n\n/** @class */\n\nvar CookieStorage = function () {\n\n  /**\n   * Constructs a new CookieStorage object\n   * @param {object} data Creation options.\n   * @param {string} data.domain Cookies domain (mandatory).\n   * @param {string} data.path Cookies path (default: '/')\n   * @param {integer} data.expires Cookie expiration (in days, default: 365)\n   * @param {boolean} data.secure Cookie secure flag (default: true)\n   */\n  function CookieStorage(data) {\n    _classCallCheck(this, CookieStorage);\n\n    this.domain = data.domain;\n    if (data.path) {\n      this.path = data.path;\n    } else {\n      this.path = '/';\n    }\n    if (Object.prototype.hasOwnProperty.call(data, 'expires')) {\n      this.expires = data.expires;\n    } else {\n      this.expires = 365;\n    }\n    if (Object.prototype.hasOwnProperty.call(data, 'secure')) {\n      this.secure = data.secure;\n    } else {\n      this.secure = true;\n    }\n  }\n\n  /**\n   * This is used to set a specific item in storage\n   * @param {string} key - the key for the item\n   * @param {object} value - the value\n   * @returns {string} value that was set\n   */\n\n\n  CookieStorage.prototype.setItem = function setItem(key, value) {\n    js_cookie__WEBPACK_IMPORTED_MODULE_0__[\"set\"](key, value, {\n      path: this.path,\n      expires: this.expires,\n      domain: this.domain,\n      secure: this.secure\n    });\n    return js_cookie__WEBPACK_IMPORTED_MODULE_0__[\"get\"](key);\n  };\n\n  /**\n   * This is used to get a specific key from storage\n   * @param {string} key - the key for the item\n   * This is used to clear the storage\n   * @returns {string} the data item\n   */\n\n\n  CookieStorage.prototype.getItem = function getItem(key) {\n    return js_cookie__WEBPACK_IMPORTED_MODULE_0__[\"get\"](key);\n  };\n\n  /**\n   * This is used to remove an item from storage\n   * @param {string} key - the key being set\n   * @returns {string} value - value that was deleted\n   */\n\n\n  CookieStorage.prototype.removeItem = function removeItem(key) {\n    return js_cookie__WEBPACK_IMPORTED_MODULE_0__[\"remove\"](key, {\n      path: this.path,\n      domain: this.domain,\n      secure: this.secure\n    });\n  };\n\n  /**\n   * This is used to clear the storage\n   * @returns {string} nothing\n   */\n\n\n  CookieStorage.prototype.clear = function clear() {\n    var cookies = js_cookie__WEBPACK_IMPORTED_MODULE_0__[\"get\"]();\n    var index = void 0;\n    for (index = 0; index < cookies.length; ++index) {\n      js_cookie__WEBPACK_IMPORTED_MODULE_0__[\"remove\"](cookies[index]);\n    }\n    return {};\n  };\n\n  return CookieStorage;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (CookieStorage);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/CookieStorage.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/DateHelper.js":
/*!******************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/DateHelper.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\nvar monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];\nvar weekNames = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];\n\n/** @class */\n\nvar DateHelper = function () {\n  function DateHelper() {\n    _classCallCheck(this, DateHelper);\n  }\n\n  /**\n   * @returns {string} The current time in \"ddd MMM D HH:mm:ss UTC YYYY\" format.\n   */\n  DateHelper.prototype.getNowString = function getNowString() {\n    var now = new Date();\n\n    var weekDay = weekNames[now.getUTCDay()];\n    var month = monthNames[now.getUTCMonth()];\n    var day = now.getUTCDate();\n\n    var hours = now.getUTCHours();\n    if (hours < 10) {\n      hours = '0' + hours;\n    }\n\n    var minutes = now.getUTCMinutes();\n    if (minutes < 10) {\n      minutes = '0' + minutes;\n    }\n\n    var seconds = now.getUTCSeconds();\n    if (seconds < 10) {\n      seconds = '0' + seconds;\n    }\n\n    var year = now.getUTCFullYear();\n\n    // ddd MMM D HH:mm:ss UTC YYYY\n    var dateNow = weekDay + ' ' + month + ' ' + day + ' ' + hours + ':' + minutes + ':' + seconds + ' UTC ' + year;\n\n    return dateNow;\n  };\n\n  return DateHelper;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (DateHelper);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/DateHelper.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/StorageHelper.js":
/*!*********************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/StorageHelper.js ***!
  \*********************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\nvar dataMemory = {};\n\n/** @class */\n\nvar MemoryStorage = function () {\n  function MemoryStorage() {\n    _classCallCheck(this, MemoryStorage);\n  }\n\n  /**\n   * This is used to set a specific item in storage\n   * @param {string} key - the key for the item\n   * @param {object} value - the value\n   * @returns {string} value that was set\n   */\n  MemoryStorage.setItem = function setItem(key, value) {\n    dataMemory[key] = value;\n    return dataMemory[key];\n  };\n\n  /**\n   * This is used to get a specific key from storage\n   * @param {string} key - the key for the item\n   * This is used to clear the storage\n   * @returns {string} the data item\n   */\n\n\n  MemoryStorage.getItem = function getItem(key) {\n    return Object.prototype.hasOwnProperty.call(dataMemory, key) ? dataMemory[key] : undefined;\n  };\n\n  /**\n   * This is used to remove an item from storage\n   * @param {string} key - the key being set\n   * @returns {string} value - value that was deleted\n   */\n\n\n  MemoryStorage.removeItem = function removeItem(key) {\n    return delete dataMemory[key];\n  };\n\n  /**\n   * This is used to clear the storage\n   * @returns {string} nothing\n   */\n\n\n  MemoryStorage.clear = function clear() {\n    dataMemory = {};\n    return dataMemory;\n  };\n\n  return MemoryStorage;\n}();\n\n/** @class */\n\n\nvar StorageHelper = function () {\n\n  /**\n   * This is used to get a storage object\n   * @returns {object} the storage\n   */\n  function StorageHelper() {\n    _classCallCheck(this, StorageHelper);\n\n    try {\n      this.storageWindow = window.localStorage;\n      this.storageWindow.setItem('aws.cognito.test-ls', 1);\n      this.storageWindow.removeItem('aws.cognito.test-ls');\n    } catch (exception) {\n      this.storageWindow = MemoryStorage;\n    }\n  }\n\n  /**\n   * This is used to return the storage\n   * @returns {object} the storage\n   */\n\n\n  StorageHelper.prototype.getStorage = function getStorage() {\n    return this.storageWindow;\n  };\n\n  return StorageHelper;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (StorageHelper);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/StorageHelper.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/UserAgent.js":
/*!*****************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/UserAgent.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n// class for defining the amzn user-agent\n/* harmony default export */ __webpack_exports__[\"default\"] = (UserAgent);\n// constructor\nfunction UserAgent() {}\n// public\nUserAgent.prototype.userAgent = 'aws-amplify/0.1.x js';//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYW1hem9uLWNvZ25pdG8taWRlbnRpdHktanMvZXMvVXNlckFnZW50LmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2FtYXpvbi1jb2duaXRvLWlkZW50aXR5LWpzL2VzL1VzZXJBZ2VudC5qcz82ZjY3Il0sInNvdXJjZXNDb250ZW50IjpbIi8vIGNsYXNzIGZvciBkZWZpbmluZyB0aGUgYW16biB1c2VyLWFnZW50XG5leHBvcnQgZGVmYXVsdCBVc2VyQWdlbnQ7XG4vLyBjb25zdHJ1Y3RvclxuZnVuY3Rpb24gVXNlckFnZW50KCkge31cbi8vIHB1YmxpY1xuVXNlckFnZW50LnByb3RvdHlwZS51c2VyQWdlbnQgPSAnYXdzLWFtcGxpZnkvMC4xLngganMnOyJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/UserAgent.js\n");

/***/ }),

/***/ "./node_modules/amazon-cognito-identity-js/es/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/amazon-cognito-identity-js/es/index.js ***!
  \*************************************************************/
/*! exports provided: AuthenticationDetails, AuthenticationHelper, CognitoAccessToken, CognitoIdToken, CognitoRefreshToken, CognitoUser, CognitoUserAttribute, CognitoUserPool, CognitoUserSession, CookieStorage, DateHelper */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _AuthenticationDetails__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AuthenticationDetails */ \"./node_modules/amazon-cognito-identity-js/es/AuthenticationDetails.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"AuthenticationDetails\", function() { return _AuthenticationDetails__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony import */ var _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AuthenticationHelper */ \"./node_modules/amazon-cognito-identity-js/es/AuthenticationHelper.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"AuthenticationHelper\", function() { return _AuthenticationHelper__WEBPACK_IMPORTED_MODULE_1__[\"default\"]; });\n\n/* harmony import */ var _CognitoAccessToken__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CognitoAccessToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoAccessToken.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CognitoAccessToken\", function() { return _CognitoAccessToken__WEBPACK_IMPORTED_MODULE_2__[\"default\"]; });\n\n/* harmony import */ var _CognitoIdToken__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CognitoIdToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoIdToken.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CognitoIdToken\", function() { return _CognitoIdToken__WEBPACK_IMPORTED_MODULE_3__[\"default\"]; });\n\n/* harmony import */ var _CognitoRefreshToken__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CognitoRefreshToken */ \"./node_modules/amazon-cognito-identity-js/es/CognitoRefreshToken.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CognitoRefreshToken\", function() { return _CognitoRefreshToken__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony import */ var _CognitoUser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CognitoUser */ \"./node_modules/amazon-cognito-identity-js/es/CognitoUser.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CognitoUser\", function() { return _CognitoUser__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony import */ var _CognitoUserAttribute__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CognitoUserAttribute */ \"./node_modules/amazon-cognito-identity-js/es/CognitoUserAttribute.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CognitoUserAttribute\", function() { return _CognitoUserAttribute__WEBPACK_IMPORTED_MODULE_6__[\"default\"]; });\n\n/* harmony import */ var _CognitoUserPool__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CognitoUserPool */ \"./node_modules/amazon-cognito-identity-js/es/CognitoUserPool.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CognitoUserPool\", function() { return _CognitoUserPool__WEBPACK_IMPORTED_MODULE_7__[\"default\"]; });\n\n/* harmony import */ var _CognitoUserSession__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CognitoUserSession */ \"./node_modules/amazon-cognito-identity-js/es/CognitoUserSession.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CognitoUserSession\", function() { return _CognitoUserSession__WEBPACK_IMPORTED_MODULE_8__[\"default\"]; });\n\n/* harmony import */ var _CookieStorage__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./CookieStorage */ \"./node_modules/amazon-cognito-identity-js/es/CookieStorage.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"CookieStorage\", function() { return _CookieStorage__WEBPACK_IMPORTED_MODULE_9__[\"default\"]; });\n\n/* harmony import */ var _DateHelper__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./DateHelper */ \"./node_modules/amazon-cognito-identity-js/es/DateHelper.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"DateHelper\", function() { return _DateHelper__WEBPACK_IMPORTED_MODULE_10__[\"default\"]; });\n\n/*!\n * Copyright 2016 Amazon.com,\n * Inc. or its affiliates. All Rights Reserved.\n *\n * Licensed under the Amazon Software License (the \"License\").\n * You may not use this file except in compliance with the\n * License. A copy of the License is located at\n *\n *     http://aws.amazon.com/asl/\n *\n * or in the \"license\" file accompanying this file. This file is\n * distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR\n * CONDITIONS OF ANY KIND, express or implied. See the License\n * for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/amazon-cognito-identity-js/es/index.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.min.json":
/*!************************************************************************!*\
  !*** ./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.min.json ***!
  \************************************************************************/
/*! exports provided: version, metadata, operations, shapes, default */
/***/ (function(module) {

eval("module.exports = {\"version\":\"2.0\",\"metadata\":{\"apiVersion\":\"2014-06-30\",\"endpointPrefix\":\"cognito-identity\",\"jsonVersion\":\"1.1\",\"protocol\":\"json\",\"serviceFullName\":\"Amazon Cognito Identity\",\"serviceId\":\"Cognito Identity\",\"signatureVersion\":\"v4\",\"targetPrefix\":\"AWSCognitoIdentityService\",\"uid\":\"cognito-identity-2014-06-30\"},\"operations\":{\"CreateIdentityPool\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolName\",\"AllowUnauthenticatedIdentities\"],\"members\":{\"IdentityPoolName\":{},\"AllowUnauthenticatedIdentities\":{\"type\":\"boolean\"},\"SupportedLoginProviders\":{\"shape\":\"S4\"},\"DeveloperProviderName\":{},\"OpenIdConnectProviderARNs\":{\"shape\":\"S8\"},\"CognitoIdentityProviders\":{\"shape\":\"Sa\"},\"SamlProviderARNs\":{\"shape\":\"Sf\"}}},\"output\":{\"shape\":\"Sg\"}},\"DeleteIdentities\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityIdsToDelete\"],\"members\":{\"IdentityIdsToDelete\":{\"type\":\"list\",\"member\":{}}}},\"output\":{\"type\":\"structure\",\"members\":{\"UnprocessedIdentityIds\":{\"type\":\"list\",\"member\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{},\"ErrorCode\":{}}}}}}},\"DeleteIdentityPool\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\"],\"members\":{\"IdentityPoolId\":{}}}},\"DescribeIdentity\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityId\"],\"members\":{\"IdentityId\":{}}},\"output\":{\"shape\":\"Sr\"}},\"DescribeIdentityPool\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\"],\"members\":{\"IdentityPoolId\":{}}},\"output\":{\"shape\":\"Sg\"}},\"GetCredentialsForIdentity\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityId\"],\"members\":{\"IdentityId\":{},\"Logins\":{\"shape\":\"Sw\"},\"CustomRoleArn\":{}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{},\"Credentials\":{\"type\":\"structure\",\"members\":{\"AccessKeyId\":{},\"SecretKey\":{},\"SessionToken\":{},\"Expiration\":{\"type\":\"timestamp\"}}}}}},\"GetId\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\"],\"members\":{\"AccountId\":{},\"IdentityPoolId\":{},\"Logins\":{\"shape\":\"Sw\"}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{}}}},\"GetIdentityPoolRoles\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\"],\"members\":{\"IdentityPoolId\":{}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityPoolId\":{},\"Roles\":{\"shape\":\"S18\"},\"RoleMappings\":{\"shape\":\"S1a\"}}}},\"GetOpenIdToken\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityId\"],\"members\":{\"IdentityId\":{},\"Logins\":{\"shape\":\"Sw\"}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{},\"Token\":{}}}},\"GetOpenIdTokenForDeveloperIdentity\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\",\"Logins\"],\"members\":{\"IdentityPoolId\":{},\"IdentityId\":{},\"Logins\":{\"shape\":\"Sw\"},\"TokenDuration\":{\"type\":\"long\"}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{},\"Token\":{}}}},\"ListIdentities\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\",\"MaxResults\"],\"members\":{\"IdentityPoolId\":{},\"MaxResults\":{\"type\":\"integer\"},\"NextToken\":{},\"HideDisabled\":{\"type\":\"boolean\"}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityPoolId\":{},\"Identities\":{\"type\":\"list\",\"member\":{\"shape\":\"Sr\"}},\"NextToken\":{}}}},\"ListIdentityPools\":{\"input\":{\"type\":\"structure\",\"required\":[\"MaxResults\"],\"members\":{\"MaxResults\":{\"type\":\"integer\"},\"NextToken\":{}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityPools\":{\"type\":\"list\",\"member\":{\"type\":\"structure\",\"members\":{\"IdentityPoolId\":{},\"IdentityPoolName\":{}}}},\"NextToken\":{}}}},\"LookupDeveloperIdentity\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\"],\"members\":{\"IdentityPoolId\":{},\"IdentityId\":{},\"DeveloperUserIdentifier\":{},\"MaxResults\":{\"type\":\"integer\"},\"NextToken\":{}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{},\"DeveloperUserIdentifierList\":{\"type\":\"list\",\"member\":{}},\"NextToken\":{}}}},\"MergeDeveloperIdentities\":{\"input\":{\"type\":\"structure\",\"required\":[\"SourceUserIdentifier\",\"DestinationUserIdentifier\",\"DeveloperProviderName\",\"IdentityPoolId\"],\"members\":{\"SourceUserIdentifier\":{},\"DestinationUserIdentifier\":{},\"DeveloperProviderName\":{},\"IdentityPoolId\":{}}},\"output\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{}}}},\"SetIdentityPoolRoles\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\",\"Roles\"],\"members\":{\"IdentityPoolId\":{},\"Roles\":{\"shape\":\"S18\"},\"RoleMappings\":{\"shape\":\"S1a\"}}}},\"UnlinkDeveloperIdentity\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityId\",\"IdentityPoolId\",\"DeveloperProviderName\",\"DeveloperUserIdentifier\"],\"members\":{\"IdentityId\":{},\"IdentityPoolId\":{},\"DeveloperProviderName\":{},\"DeveloperUserIdentifier\":{}}}},\"UnlinkIdentity\":{\"input\":{\"type\":\"structure\",\"required\":[\"IdentityId\",\"Logins\",\"LoginsToRemove\"],\"members\":{\"IdentityId\":{},\"Logins\":{\"shape\":\"Sw\"},\"LoginsToRemove\":{\"shape\":\"Ss\"}}}},\"UpdateIdentityPool\":{\"input\":{\"shape\":\"Sg\"},\"output\":{\"shape\":\"Sg\"}}},\"shapes\":{\"S4\":{\"type\":\"map\",\"key\":{},\"value\":{}},\"S8\":{\"type\":\"list\",\"member\":{}},\"Sa\":{\"type\":\"list\",\"member\":{\"type\":\"structure\",\"members\":{\"ProviderName\":{},\"ClientId\":{},\"ServerSideTokenCheck\":{\"type\":\"boolean\"}}}},\"Sf\":{\"type\":\"list\",\"member\":{}},\"Sg\":{\"type\":\"structure\",\"required\":[\"IdentityPoolId\",\"IdentityPoolName\",\"AllowUnauthenticatedIdentities\"],\"members\":{\"IdentityPoolId\":{},\"IdentityPoolName\":{},\"AllowUnauthenticatedIdentities\":{\"type\":\"boolean\"},\"SupportedLoginProviders\":{\"shape\":\"S4\"},\"DeveloperProviderName\":{},\"OpenIdConnectProviderARNs\":{\"shape\":\"S8\"},\"CognitoIdentityProviders\":{\"shape\":\"Sa\"},\"SamlProviderARNs\":{\"shape\":\"Sf\"}}},\"Sr\":{\"type\":\"structure\",\"members\":{\"IdentityId\":{},\"Logins\":{\"shape\":\"Ss\"},\"CreationDate\":{\"type\":\"timestamp\"},\"LastModifiedDate\":{\"type\":\"timestamp\"}}},\"Ss\":{\"type\":\"list\",\"member\":{}},\"Sw\":{\"type\":\"map\",\"key\":{},\"value\":{}},\"S18\":{\"type\":\"map\",\"key\":{},\"value\":{}},\"S1a\":{\"type\":\"map\",\"key\":{},\"value\":{\"type\":\"structure\",\"required\":[\"Type\"],\"members\":{\"Type\":{},\"AmbiguousRoleResolution\":{},\"RulesConfiguration\":{\"type\":\"structure\",\"required\":[\"Rules\"],\"members\":{\"Rules\":{\"type\":\"list\",\"member\":{\"type\":\"structure\",\"required\":[\"Claim\",\"MatchType\",\"Value\",\"RoleARN\"],\"members\":{\"Claim\":{},\"MatchType\":{},\"Value\":{},\"RoleARN\":{}}}}}}}}}}};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9hcGlzL2NvZ25pdG8taWRlbnRpdHktMjAxNC0wNi0zMC5taW4uanNvbi5qcyIsInNvdXJjZXMiOltdLCJtYXBwaW5ncyI6IiIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.min.json\n");

/***/ }),

/***/ "./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.paginators.json":
/*!*******************************************************************************!*\
  !*** ./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.paginators.json ***!
  \*******************************************************************************/
/*! exports provided: pagination, default */
/***/ (function(module) {

eval("module.exports = {\"pagination\":{}};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9hcGlzL2NvZ25pdG8taWRlbnRpdHktMjAxNC0wNi0zMC5wYWdpbmF0b3JzLmpzb24uanMiLCJzb3VyY2VzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.paginators.json\n");

/***/ }),

/***/ "./node_modules/aws-sdk/apis/metadata.json":
/*!*************************************************!*\
  !*** ./node_modules/aws-sdk/apis/metadata.json ***!
  \*************************************************/
/*! exports provided: acm, apigateway, applicationautoscaling, appstream, autoscaling, batch, budgets, clouddirectory, cloudformation, cloudfront, cloudhsm, cloudsearch, cloudsearchdomain, cloudtrail, cloudwatch, cloudwatchevents, cloudwatchlogs, codebuild, codecommit, codedeploy, codepipeline, cognitoidentity, cognitoidentityserviceprovider, cognitosync, configservice, cur, datapipeline, devicefarm, directconnect, directoryservice, discovery, dms, dynamodb, dynamodbstreams, ec2, ecr, ecs, efs, elasticache, elasticbeanstalk, elb, elbv2, emr, es, elastictranscoder, firehose, gamelift, glacier, health, iam, importexport, inspector, iot, iotdata, kinesis, kinesisanalytics, kms, lambda, lexruntime, lightsail, machinelearning, marketplacecommerceanalytics, marketplacemetering, mturk, mobileanalytics, opsworks, opsworkscm, organizations, pinpoint, polly, rds, redshift, rekognition, resourcegroupstaggingapi, route53, route53domains, s3, servicecatalog, ses, shield, simpledb, sms, snowball, sns, sqs, ssm, storagegateway, stepfunctions, sts, support, swf, xray, waf, wafregional, workdocs, workspaces, codestar, lexmodelbuildingservice, marketplaceentitlementservice, athena, greengrass, dax, migrationhub, cloudhsmv2, glue, mobile, pricing, costexplorer, mediaconvert, medialive, mediapackage, mediastore, mediastoredata, appsync, guardduty, mq, comprehend, iotjobsdataplane, kinesisvideoarchivedmedia, kinesisvideomedia, kinesisvideo, sagemakerruntime, sagemaker, translate, resourcegroups, alexaforbusiness, cloud9, serverlessapplicationrepository, servicediscovery, workmail, autoscalingplans, transcribeservice, connect, acmpca, fms, secretsmanager, iotanalytics, iot1clickdevicesservice, iot1clickprojects, pi, neptune, mediatailor, eks, macie, dlm, signer, default */
/***/ (function(module) {

eval("module.exports = {\"acm\":{\"name\":\"ACM\",\"cors\":true},\"apigateway\":{\"name\":\"APIGateway\",\"cors\":true},\"applicationautoscaling\":{\"prefix\":\"application-autoscaling\",\"name\":\"ApplicationAutoScaling\",\"cors\":true},\"appstream\":{\"name\":\"AppStream\"},\"autoscaling\":{\"name\":\"AutoScaling\",\"cors\":true},\"batch\":{\"name\":\"Batch\"},\"budgets\":{\"name\":\"Budgets\"},\"clouddirectory\":{\"name\":\"CloudDirectory\",\"versions\":[\"2016-05-10*\"]},\"cloudformation\":{\"name\":\"CloudFormation\",\"cors\":true},\"cloudfront\":{\"name\":\"CloudFront\",\"versions\":[\"2013-05-12*\",\"2013-11-11*\",\"2014-05-31*\",\"2014-10-21*\",\"2014-11-06*\",\"2015-04-17*\",\"2015-07-27*\",\"2015-09-17*\",\"2016-01-13*\",\"2016-01-28*\",\"2016-08-01*\",\"2016-08-20*\",\"2016-09-07*\",\"2016-09-29*\",\"2016-11-25*\",\"2017-03-25*\",\"2017-10-30*\"],\"cors\":true},\"cloudhsm\":{\"name\":\"CloudHSM\",\"cors\":true},\"cloudsearch\":{\"name\":\"CloudSearch\"},\"cloudsearchdomain\":{\"name\":\"CloudSearchDomain\"},\"cloudtrail\":{\"name\":\"CloudTrail\",\"cors\":true},\"cloudwatch\":{\"prefix\":\"monitoring\",\"name\":\"CloudWatch\",\"cors\":true},\"cloudwatchevents\":{\"prefix\":\"events\",\"name\":\"CloudWatchEvents\",\"versions\":[\"2014-02-03*\"],\"cors\":true},\"cloudwatchlogs\":{\"prefix\":\"logs\",\"name\":\"CloudWatchLogs\",\"cors\":true},\"codebuild\":{\"name\":\"CodeBuild\",\"cors\":true},\"codecommit\":{\"name\":\"CodeCommit\",\"cors\":true},\"codedeploy\":{\"name\":\"CodeDeploy\",\"cors\":true},\"codepipeline\":{\"name\":\"CodePipeline\",\"cors\":true},\"cognitoidentity\":{\"prefix\":\"cognito-identity\",\"name\":\"CognitoIdentity\",\"cors\":true},\"cognitoidentityserviceprovider\":{\"prefix\":\"cognito-idp\",\"name\":\"CognitoIdentityServiceProvider\",\"cors\":true},\"cognitosync\":{\"prefix\":\"cognito-sync\",\"name\":\"CognitoSync\",\"cors\":true},\"configservice\":{\"prefix\":\"config\",\"name\":\"ConfigService\",\"cors\":true},\"cur\":{\"name\":\"CUR\",\"cors\":true},\"datapipeline\":{\"name\":\"DataPipeline\"},\"devicefarm\":{\"name\":\"DeviceFarm\",\"cors\":true},\"directconnect\":{\"name\":\"DirectConnect\",\"cors\":true},\"directoryservice\":{\"prefix\":\"ds\",\"name\":\"DirectoryService\"},\"discovery\":{\"name\":\"Discovery\"},\"dms\":{\"name\":\"DMS\"},\"dynamodb\":{\"name\":\"DynamoDB\",\"cors\":true},\"dynamodbstreams\":{\"prefix\":\"streams.dynamodb\",\"name\":\"DynamoDBStreams\",\"cors\":true},\"ec2\":{\"name\":\"EC2\",\"versions\":[\"2013-06-15*\",\"2013-10-15*\",\"2014-02-01*\",\"2014-05-01*\",\"2014-06-15*\",\"2014-09-01*\",\"2014-10-01*\",\"2015-03-01*\",\"2015-04-15*\",\"2015-10-01*\",\"2016-04-01*\",\"2016-09-15*\"],\"cors\":true},\"ecr\":{\"name\":\"ECR\",\"cors\":true},\"ecs\":{\"name\":\"ECS\",\"cors\":true},\"efs\":{\"prefix\":\"elasticfilesystem\",\"name\":\"EFS\",\"cors\":true},\"elasticache\":{\"name\":\"ElastiCache\",\"versions\":[\"2012-11-15*\",\"2014-03-24*\",\"2014-07-15*\",\"2014-09-30*\"],\"cors\":true},\"elasticbeanstalk\":{\"name\":\"ElasticBeanstalk\",\"cors\":true},\"elb\":{\"prefix\":\"elasticloadbalancing\",\"name\":\"ELB\",\"cors\":true},\"elbv2\":{\"prefix\":\"elasticloadbalancingv2\",\"name\":\"ELBv2\",\"cors\":true},\"emr\":{\"prefix\":\"elasticmapreduce\",\"name\":\"EMR\",\"cors\":true},\"es\":{\"name\":\"ES\"},\"elastictranscoder\":{\"name\":\"ElasticTranscoder\",\"cors\":true},\"firehose\":{\"name\":\"Firehose\",\"cors\":true},\"gamelift\":{\"name\":\"GameLift\",\"cors\":true},\"glacier\":{\"name\":\"Glacier\"},\"health\":{\"name\":\"Health\"},\"iam\":{\"name\":\"IAM\"},\"importexport\":{\"name\":\"ImportExport\"},\"inspector\":{\"name\":\"Inspector\",\"versions\":[\"2015-08-18*\"],\"cors\":true},\"iot\":{\"name\":\"Iot\",\"cors\":true},\"iotdata\":{\"prefix\":\"iot-data\",\"name\":\"IotData\",\"cors\":true},\"kinesis\":{\"name\":\"Kinesis\",\"cors\":true},\"kinesisanalytics\":{\"name\":\"KinesisAnalytics\"},\"kms\":{\"name\":\"KMS\",\"cors\":true},\"lambda\":{\"name\":\"Lambda\",\"cors\":true},\"lexruntime\":{\"prefix\":\"runtime.lex\",\"name\":\"LexRuntime\",\"cors\":true},\"lightsail\":{\"name\":\"Lightsail\"},\"machinelearning\":{\"name\":\"MachineLearning\",\"cors\":true},\"marketplacecommerceanalytics\":{\"name\":\"MarketplaceCommerceAnalytics\",\"cors\":true},\"marketplacemetering\":{\"prefix\":\"meteringmarketplace\",\"name\":\"MarketplaceMetering\"},\"mturk\":{\"prefix\":\"mturk-requester\",\"name\":\"MTurk\",\"cors\":true},\"mobileanalytics\":{\"name\":\"MobileAnalytics\",\"cors\":true},\"opsworks\":{\"name\":\"OpsWorks\",\"cors\":true},\"opsworkscm\":{\"name\":\"OpsWorksCM\"},\"organizations\":{\"name\":\"Organizations\"},\"pinpoint\":{\"name\":\"Pinpoint\"},\"polly\":{\"name\":\"Polly\",\"cors\":true},\"rds\":{\"name\":\"RDS\",\"versions\":[\"2014-09-01*\"],\"cors\":true},\"redshift\":{\"name\":\"Redshift\",\"cors\":true},\"rekognition\":{\"name\":\"Rekognition\",\"cors\":true},\"resourcegroupstaggingapi\":{\"name\":\"ResourceGroupsTaggingAPI\"},\"route53\":{\"name\":\"Route53\",\"cors\":true},\"route53domains\":{\"name\":\"Route53Domains\",\"cors\":true},\"s3\":{\"name\":\"S3\",\"dualstackAvailable\":true,\"cors\":true},\"servicecatalog\":{\"name\":\"ServiceCatalog\",\"cors\":true},\"ses\":{\"prefix\":\"email\",\"name\":\"SES\",\"cors\":true},\"shield\":{\"name\":\"Shield\"},\"simpledb\":{\"prefix\":\"sdb\",\"name\":\"SimpleDB\"},\"sms\":{\"name\":\"SMS\"},\"snowball\":{\"name\":\"Snowball\"},\"sns\":{\"name\":\"SNS\",\"cors\":true},\"sqs\":{\"name\":\"SQS\",\"cors\":true},\"ssm\":{\"name\":\"SSM\",\"cors\":true},\"storagegateway\":{\"name\":\"StorageGateway\",\"cors\":true},\"stepfunctions\":{\"prefix\":\"states\",\"name\":\"StepFunctions\"},\"sts\":{\"name\":\"STS\",\"cors\":true},\"support\":{\"name\":\"Support\"},\"swf\":{\"name\":\"SWF\"},\"xray\":{\"name\":\"XRay\"},\"waf\":{\"name\":\"WAF\",\"cors\":true},\"wafregional\":{\"prefix\":\"waf-regional\",\"name\":\"WAFRegional\"},\"workdocs\":{\"name\":\"WorkDocs\",\"cors\":true},\"workspaces\":{\"name\":\"WorkSpaces\"},\"codestar\":{\"name\":\"CodeStar\"},\"lexmodelbuildingservice\":{\"prefix\":\"lex-models\",\"name\":\"LexModelBuildingService\",\"cors\":true},\"marketplaceentitlementservice\":{\"prefix\":\"entitlement.marketplace\",\"name\":\"MarketplaceEntitlementService\"},\"athena\":{\"name\":\"Athena\"},\"greengrass\":{\"name\":\"Greengrass\"},\"dax\":{\"name\":\"DAX\"},\"migrationhub\":{\"prefix\":\"AWSMigrationHub\",\"name\":\"MigrationHub\"},\"cloudhsmv2\":{\"name\":\"CloudHSMV2\"},\"glue\":{\"name\":\"Glue\"},\"mobile\":{\"name\":\"Mobile\"},\"pricing\":{\"name\":\"Pricing\",\"cors\":true},\"costexplorer\":{\"prefix\":\"ce\",\"name\":\"CostExplorer\"},\"mediaconvert\":{\"name\":\"MediaConvert\"},\"medialive\":{\"name\":\"MediaLive\"},\"mediapackage\":{\"name\":\"MediaPackage\"},\"mediastore\":{\"name\":\"MediaStore\"},\"mediastoredata\":{\"prefix\":\"mediastore-data\",\"name\":\"MediaStoreData\"},\"appsync\":{\"name\":\"AppSync\"},\"guardduty\":{\"name\":\"GuardDuty\"},\"mq\":{\"name\":\"MQ\"},\"comprehend\":{\"name\":\"Comprehend\"},\"iotjobsdataplane\":{\"prefix\":\"iot-jobs-data\",\"name\":\"IoTJobsDataPlane\"},\"kinesisvideoarchivedmedia\":{\"prefix\":\"kinesis-video-archived-media\",\"name\":\"KinesisVideoArchivedMedia\",\"cors\":true},\"kinesisvideomedia\":{\"prefix\":\"kinesis-video-media\",\"name\":\"KinesisVideoMedia\"},\"kinesisvideo\":{\"name\":\"KinesisVideo\",\"cors\":true},\"sagemakerruntime\":{\"prefix\":\"runtime.sagemaker\",\"name\":\"SageMakerRuntime\"},\"sagemaker\":{\"name\":\"SageMaker\"},\"translate\":{\"name\":\"Translate\",\"cors\":true},\"resourcegroups\":{\"prefix\":\"resource-groups\",\"name\":\"ResourceGroups\"},\"alexaforbusiness\":{\"name\":\"AlexaForBusiness\"},\"cloud9\":{\"name\":\"Cloud9\"},\"serverlessapplicationrepository\":{\"prefix\":\"serverlessrepo\",\"name\":\"ServerlessApplicationRepository\"},\"servicediscovery\":{\"name\":\"ServiceDiscovery\"},\"workmail\":{\"name\":\"WorkMail\"},\"autoscalingplans\":{\"prefix\":\"autoscaling-plans\",\"name\":\"AutoScalingPlans\"},\"transcribeservice\":{\"prefix\":\"transcribe\",\"name\":\"TranscribeService\"},\"connect\":{\"name\":\"Connect\"},\"acmpca\":{\"prefix\":\"acm-pca\",\"name\":\"ACMPCA\"},\"fms\":{\"name\":\"FMS\"},\"secretsmanager\":{\"name\":\"SecretsManager\",\"cors\":true},\"iotanalytics\":{\"name\":\"IoTAnalytics\"},\"iot1clickdevicesservice\":{\"prefix\":\"iot1click-devices\",\"name\":\"IoT1ClickDevicesService\"},\"iot1clickprojects\":{\"prefix\":\"iot1click-projects\",\"name\":\"IoT1ClickProjects\"},\"pi\":{\"name\":\"PI\"},\"neptune\":{\"name\":\"Neptune\"},\"mediatailor\":{\"name\":\"MediaTailor\"},\"eks\":{\"name\":\"EKS\"},\"macie\":{\"name\":\"Macie\"},\"dlm\":{\"name\":\"DLM\"},\"signer\":{\"name\":\"Signer\"}};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9hcGlzL21ldGFkYXRhLmpzb24uanMiLCJzb3VyY2VzIjpbXSwibWFwcGluZ3MiOiIiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/apis/metadata.json\n");

/***/ }),

/***/ "./node_modules/aws-sdk/apis/sts-2011-06-15.min.json":
/*!***********************************************************!*\
  !*** ./node_modules/aws-sdk/apis/sts-2011-06-15.min.json ***!
  \***********************************************************/
/*! exports provided: version, metadata, operations, shapes, default */
/***/ (function(module) {

eval("module.exports = {\"version\":\"2.0\",\"metadata\":{\"apiVersion\":\"2011-06-15\",\"endpointPrefix\":\"sts\",\"globalEndpoint\":\"sts.amazonaws.com\",\"protocol\":\"query\",\"serviceAbbreviation\":\"AWS STS\",\"serviceFullName\":\"AWS Security Token Service\",\"serviceId\":\"STS\",\"signatureVersion\":\"v4\",\"uid\":\"sts-2011-06-15\",\"xmlNamespace\":\"https://sts.amazonaws.com/doc/2011-06-15/\"},\"operations\":{\"AssumeRole\":{\"input\":{\"type\":\"structure\",\"required\":[\"RoleArn\",\"RoleSessionName\"],\"members\":{\"RoleArn\":{},\"RoleSessionName\":{},\"Policy\":{},\"DurationSeconds\":{\"type\":\"integer\"},\"ExternalId\":{},\"SerialNumber\":{},\"TokenCode\":{}}},\"output\":{\"resultWrapper\":\"AssumeRoleResult\",\"type\":\"structure\",\"members\":{\"Credentials\":{\"shape\":\"Sa\"},\"AssumedRoleUser\":{\"shape\":\"Sf\"},\"PackedPolicySize\":{\"type\":\"integer\"}}}},\"AssumeRoleWithSAML\":{\"input\":{\"type\":\"structure\",\"required\":[\"RoleArn\",\"PrincipalArn\",\"SAMLAssertion\"],\"members\":{\"RoleArn\":{},\"PrincipalArn\":{},\"SAMLAssertion\":{},\"Policy\":{},\"DurationSeconds\":{\"type\":\"integer\"}}},\"output\":{\"resultWrapper\":\"AssumeRoleWithSAMLResult\",\"type\":\"structure\",\"members\":{\"Credentials\":{\"shape\":\"Sa\"},\"AssumedRoleUser\":{\"shape\":\"Sf\"},\"PackedPolicySize\":{\"type\":\"integer\"},\"Subject\":{},\"SubjectType\":{},\"Issuer\":{},\"Audience\":{},\"NameQualifier\":{}}}},\"AssumeRoleWithWebIdentity\":{\"input\":{\"type\":\"structure\",\"required\":[\"RoleArn\",\"RoleSessionName\",\"WebIdentityToken\"],\"members\":{\"RoleArn\":{},\"RoleSessionName\":{},\"WebIdentityToken\":{},\"ProviderId\":{},\"Policy\":{},\"DurationSeconds\":{\"type\":\"integer\"}}},\"output\":{\"resultWrapper\":\"AssumeRoleWithWebIdentityResult\",\"type\":\"structure\",\"members\":{\"Credentials\":{\"shape\":\"Sa\"},\"SubjectFromWebIdentityToken\":{},\"AssumedRoleUser\":{\"shape\":\"Sf\"},\"PackedPolicySize\":{\"type\":\"integer\"},\"Provider\":{},\"Audience\":{}}}},\"DecodeAuthorizationMessage\":{\"input\":{\"type\":\"structure\",\"required\":[\"EncodedMessage\"],\"members\":{\"EncodedMessage\":{}}},\"output\":{\"resultWrapper\":\"DecodeAuthorizationMessageResult\",\"type\":\"structure\",\"members\":{\"DecodedMessage\":{}}}},\"GetCallerIdentity\":{\"input\":{\"type\":\"structure\",\"members\":{}},\"output\":{\"resultWrapper\":\"GetCallerIdentityResult\",\"type\":\"structure\",\"members\":{\"UserId\":{},\"Account\":{},\"Arn\":{}}}},\"GetFederationToken\":{\"input\":{\"type\":\"structure\",\"required\":[\"Name\"],\"members\":{\"Name\":{},\"Policy\":{},\"DurationSeconds\":{\"type\":\"integer\"}}},\"output\":{\"resultWrapper\":\"GetFederationTokenResult\",\"type\":\"structure\",\"members\":{\"Credentials\":{\"shape\":\"Sa\"},\"FederatedUser\":{\"type\":\"structure\",\"required\":[\"FederatedUserId\",\"Arn\"],\"members\":{\"FederatedUserId\":{},\"Arn\":{}}},\"PackedPolicySize\":{\"type\":\"integer\"}}}},\"GetSessionToken\":{\"input\":{\"type\":\"structure\",\"members\":{\"DurationSeconds\":{\"type\":\"integer\"},\"SerialNumber\":{},\"TokenCode\":{}}},\"output\":{\"resultWrapper\":\"GetSessionTokenResult\",\"type\":\"structure\",\"members\":{\"Credentials\":{\"shape\":\"Sa\"}}}}},\"shapes\":{\"Sa\":{\"type\":\"structure\",\"required\":[\"AccessKeyId\",\"SecretAccessKey\",\"SessionToken\",\"Expiration\"],\"members\":{\"AccessKeyId\":{},\"SecretAccessKey\":{},\"SessionToken\":{},\"Expiration\":{\"type\":\"timestamp\"}}},\"Sf\":{\"type\":\"structure\",\"required\":[\"AssumedRoleId\",\"Arn\"],\"members\":{\"AssumedRoleId\":{},\"Arn\":{}}}}};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9hcGlzL3N0cy0yMDExLTA2LTE1Lm1pbi5qc29uLmpzIiwic291cmNlcyI6W10sIm1hcHBpbmdzIjoiIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/apis/sts-2011-06-15.min.json\n");

/***/ }),

/***/ "./node_modules/aws-sdk/apis/sts-2011-06-15.paginators.json":
/*!******************************************************************!*\
  !*** ./node_modules/aws-sdk/apis/sts-2011-06-15.paginators.json ***!
  \******************************************************************/
/*! exports provided: pagination, default */
/***/ (function(module) {

eval("module.exports = {\"pagination\":{}};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9hcGlzL3N0cy0yMDExLTA2LTE1LnBhZ2luYXRvcnMuanNvbi5qcyIsInNvdXJjZXMiOltdLCJtYXBwaW5ncyI6IiIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/apis/sts-2011-06-15.paginators.json\n");

/***/ }),

/***/ "./node_modules/aws-sdk/browser.js":
/*!*****************************************!*\
  !*** ./node_modules/aws-sdk/browser.js ***!
  \*****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("__webpack_require__(/*! ./lib/browser_loader */ \"./node_modules/aws-sdk/lib/browser_loader.js\");\n\nvar AWS = __webpack_require__(/*! ./lib/core */ \"./node_modules/aws-sdk/lib/core.js\");\nif (typeof window !== 'undefined') window.AWS = AWS;\nif (true) module.exports = AWS;\nif (typeof self !== 'undefined') self.AWS = AWS;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9icm93c2VyLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vbm9kZV9tb2R1bGVzL2F3cy1zZGsvYnJvd3Nlci5qcz8zMWNlIl0sInNvdXJjZXNDb250ZW50IjpbInJlcXVpcmUoJy4vbGliL2Jyb3dzZXJfbG9hZGVyJyk7XG5cbnZhciBBV1MgPSByZXF1aXJlKCcuL2xpYi9jb3JlJyk7XG5pZiAodHlwZW9mIHdpbmRvdyAhPT0gJ3VuZGVmaW5lZCcpIHdpbmRvdy5BV1MgPSBBV1M7XG5pZiAodHlwZW9mIG1vZHVsZSAhPT0gJ3VuZGVmaW5lZCcpIG1vZHVsZS5leHBvcnRzID0gQVdTO1xuaWYgKHR5cGVvZiBzZWxmICE9PSAndW5kZWZpbmVkJykgc2VsZi5BV1MgPSBBV1M7Il0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/browser.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/clients/cognitoidentity.js":
/*!*********************************************************!*\
  !*** ./node_modules/aws-sdk/clients/cognitoidentity.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("__webpack_require__(/*! ../lib/node_loader */ \"./node_modules/aws-sdk/lib/browser_loader.js\");\nvar AWS = __webpack_require__(/*! ../lib/core */ \"./node_modules/aws-sdk/lib/core.js\");\nvar Service = AWS.Service;\nvar apiLoader = AWS.apiLoader;\n\napiLoader.services['cognitoidentity'] = {};\nAWS.CognitoIdentity = Service.defineService('cognitoidentity', ['2014-06-30']);\n__webpack_require__(/*! ../lib/services/cognitoidentity */ \"./node_modules/aws-sdk/lib/services/cognitoidentity.js\");\nObject.defineProperty(apiLoader.services['cognitoidentity'], '2014-06-30', {\n  get: function get() {\n    var model = __webpack_require__(/*! ../apis/cognito-identity-2014-06-30.min.json */ \"./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.min.json\");\n    model.paginators = __webpack_require__(/*! ../apis/cognito-identity-2014-06-30.paginators.json */ \"./node_modules/aws-sdk/apis/cognito-identity-2014-06-30.paginators.json\").pagination;\n    return model;\n  },\n  enumerable: true,\n  configurable: true\n});\n\nmodule.exports = AWS.CognitoIdentity;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9jbGllbnRzL2NvZ25pdG9pZGVudGl0eS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9hd3Mtc2RrL2NsaWVudHMvY29nbml0b2lkZW50aXR5LmpzPzk0YTAiXSwic291cmNlc0NvbnRlbnQiOlsicmVxdWlyZSgnLi4vbGliL25vZGVfbG9hZGVyJyk7XG52YXIgQVdTID0gcmVxdWlyZSgnLi4vbGliL2NvcmUnKTtcbnZhciBTZXJ2aWNlID0gQVdTLlNlcnZpY2U7XG52YXIgYXBpTG9hZGVyID0gQVdTLmFwaUxvYWRlcjtcblxuYXBpTG9hZGVyLnNlcnZpY2VzWydjb2duaXRvaWRlbnRpdHknXSA9IHt9O1xuQVdTLkNvZ25pdG9JZGVudGl0eSA9IFNlcnZpY2UuZGVmaW5lU2VydmljZSgnY29nbml0b2lkZW50aXR5JywgWycyMDE0LTA2LTMwJ10pO1xucmVxdWlyZSgnLi4vbGliL3NlcnZpY2VzL2NvZ25pdG9pZGVudGl0eScpO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGFwaUxvYWRlci5zZXJ2aWNlc1snY29nbml0b2lkZW50aXR5J10sICcyMDE0LTA2LTMwJywge1xuICBnZXQ6IGZ1bmN0aW9uIGdldCgpIHtcbiAgICB2YXIgbW9kZWwgPSByZXF1aXJlKCcuLi9hcGlzL2NvZ25pdG8taWRlbnRpdHktMjAxNC0wNi0zMC5taW4uanNvbicpO1xuICAgIG1vZGVsLnBhZ2luYXRvcnMgPSByZXF1aXJlKCcuLi9hcGlzL2NvZ25pdG8taWRlbnRpdHktMjAxNC0wNi0zMC5wYWdpbmF0b3JzLmpzb24nKS5wYWdpbmF0aW9uO1xuICAgIHJldHVybiBtb2RlbDtcbiAgfSxcbiAgZW51bWVyYWJsZTogdHJ1ZSxcbiAgY29uZmlndXJhYmxlOiB0cnVlXG59KTtcblxubW9kdWxlLmV4cG9ydHMgPSBBV1MuQ29nbml0b0lkZW50aXR5O1xuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/clients/cognitoidentity.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/clients/sts.js":
/*!*********************************************!*\
  !*** ./node_modules/aws-sdk/clients/sts.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("__webpack_require__(/*! ../lib/node_loader */ \"./node_modules/aws-sdk/lib/browser_loader.js\");\nvar AWS = __webpack_require__(/*! ../lib/core */ \"./node_modules/aws-sdk/lib/core.js\");\nvar Service = AWS.Service;\nvar apiLoader = AWS.apiLoader;\n\napiLoader.services['sts'] = {};\nAWS.STS = Service.defineService('sts', ['2011-06-15']);\n__webpack_require__(/*! ../lib/services/sts */ \"./node_modules/aws-sdk/lib/services/sts.js\");\nObject.defineProperty(apiLoader.services['sts'], '2011-06-15', {\n  get: function get() {\n    var model = __webpack_require__(/*! ../apis/sts-2011-06-15.min.json */ \"./node_modules/aws-sdk/apis/sts-2011-06-15.min.json\");\n    model.paginators = __webpack_require__(/*! ../apis/sts-2011-06-15.paginators.json */ \"./node_modules/aws-sdk/apis/sts-2011-06-15.paginators.json\").pagination;\n    return model;\n  },\n  enumerable: true,\n  configurable: true\n});\n\nmodule.exports = AWS.STS;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9jbGllbnRzL3N0cy5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9hd3Mtc2RrL2NsaWVudHMvc3RzLmpzP2U5OGEiXSwic291cmNlc0NvbnRlbnQiOlsicmVxdWlyZSgnLi4vbGliL25vZGVfbG9hZGVyJyk7XG52YXIgQVdTID0gcmVxdWlyZSgnLi4vbGliL2NvcmUnKTtcbnZhciBTZXJ2aWNlID0gQVdTLlNlcnZpY2U7XG52YXIgYXBpTG9hZGVyID0gQVdTLmFwaUxvYWRlcjtcblxuYXBpTG9hZGVyLnNlcnZpY2VzWydzdHMnXSA9IHt9O1xuQVdTLlNUUyA9IFNlcnZpY2UuZGVmaW5lU2VydmljZSgnc3RzJywgWycyMDExLTA2LTE1J10pO1xucmVxdWlyZSgnLi4vbGliL3NlcnZpY2VzL3N0cycpO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGFwaUxvYWRlci5zZXJ2aWNlc1snc3RzJ10sICcyMDExLTA2LTE1Jywge1xuICBnZXQ6IGZ1bmN0aW9uIGdldCgpIHtcbiAgICB2YXIgbW9kZWwgPSByZXF1aXJlKCcuLi9hcGlzL3N0cy0yMDExLTA2LTE1Lm1pbi5qc29uJyk7XG4gICAgbW9kZWwucGFnaW5hdG9ycyA9IHJlcXVpcmUoJy4uL2FwaXMvc3RzLTIwMTEtMDYtMTUucGFnaW5hdG9ycy5qc29uJykucGFnaW5hdGlvbjtcbiAgICByZXR1cm4gbW9kZWw7XG4gIH0sXG4gIGVudW1lcmFibGU6IHRydWUsXG4gIGNvbmZpZ3VyYWJsZTogdHJ1ZVxufSk7XG5cbm1vZHVsZS5leHBvcnRzID0gQVdTLlNUUztcbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/clients/sts.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/lib/api_loader.js":
/*!************************************************!*\
  !*** ./node_modules/aws-sdk/lib/api_loader.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("function apiLoader(svc, version) {\n  if (!apiLoader.services.hasOwnProperty(svc)) {\n    throw new Error('InvalidService: Failed to load api for ' + svc);\n  }\n  return apiLoader.services[svc][version];\n}\n\n/**\n * @api private\n *\n * This member of AWS.apiLoader is private, but changing it will necessitate a\n * change to ../scripts/services-table-generator.ts\n */\napiLoader.services = {};\n\n/**\n * @api private\n */\nmodule.exports = apiLoader;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9saWIvYXBpX2xvYWRlci5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9hd3Mtc2RrL2xpYi9hcGlfbG9hZGVyLmpzPzYzN2QiXSwic291cmNlc0NvbnRlbnQiOlsiZnVuY3Rpb24gYXBpTG9hZGVyKHN2YywgdmVyc2lvbikge1xuICBpZiAoIWFwaUxvYWRlci5zZXJ2aWNlcy5oYXNPd25Qcm9wZXJ0eShzdmMpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdJbnZhbGlkU2VydmljZTogRmFpbGVkIHRvIGxvYWQgYXBpIGZvciAnICsgc3ZjKTtcbiAgfVxuICByZXR1cm4gYXBpTG9hZGVyLnNlcnZpY2VzW3N2Y11bdmVyc2lvbl07XG59XG5cbi8qKlxuICogQGFwaSBwcml2YXRlXG4gKlxuICogVGhpcyBtZW1iZXIgb2YgQVdTLmFwaUxvYWRlciBpcyBwcml2YXRlLCBidXQgY2hhbmdpbmcgaXQgd2lsbCBuZWNlc3NpdGF0ZSBhXG4gKiBjaGFuZ2UgdG8gLi4vc2NyaXB0cy9zZXJ2aWNlcy10YWJsZS1nZW5lcmF0b3IudHNcbiAqL1xuYXBpTG9hZGVyLnNlcnZpY2VzID0ge307XG5cbi8qKlxuICogQGFwaSBwcml2YXRlXG4gKi9cbm1vZHVsZS5leHBvcnRzID0gYXBpTG9hZGVyO1xuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/lib/api_loader.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/lib/browserCryptoLib.js":
/*!******************************************************!*\
  !*** ./node_modules/aws-sdk/lib/browserCryptoLib.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var Hmac = __webpack_require__(/*! ./browserHmac */ \"./node_modules/aws-sdk/lib/browserHmac.js\");\nvar Md5 = __webpack_require__(/*! ./browserMd5 */ \"./node_modules/aws-sdk/lib/browserMd5.js\");\nvar Sha1 = __webpack_require__(/*! ./browserSha1 */ \"./node_modules/aws-sdk/lib/browserSha1.js\");\nvar Sha256 = __webpack_require__(/*! ./browserSha256 */ \"./node_modules/aws-sdk/lib/browserSha256.js\");\n\n/**\n * @api private\n */\nmodule.exports = exports = {\n    createHash: function createHash(alg) {\n      alg = alg.toLowerCase();\n      if (alg === 'md5') {\n        return new Md5();\n      } else if (alg === 'sha256') {\n        return new Sha256();\n      } else if (alg === 'sha1') {\n        return new Sha1();\n      }\n\n      throw new Error('Hash algorithm ' + alg + ' is not supported in the browser SDK');\n    },\n    createHmac: function createHmac(alg, key) {\n      alg = alg.toLowerCase();\n      if (alg === 'md5') {\n        return new Hmac(Md5, key);\n      } else if (alg === 'sha256') {\n        return new Hmac(Sha256, key);\n      } else if (alg === 'sha1') {\n        return new Hmac(Sha1, key);\n      }\n\n      throw new Error('HMAC algorithm ' + alg + ' is not supported in the browser SDK');\n    },\n    createSign: function() {\n      throw new Error('createSign is not implemented in the browser');\n    }\n  }\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9saWIvYnJvd3NlckNyeXB0b0xpYi5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9hd3Mtc2RrL2xpYi9icm93c2VyQ3J5cHRvTGliLmpzP2UzMGEiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIEhtYWMgPSByZXF1aXJlKCcuL2Jyb3dzZXJIbWFjJyk7XG52YXIgTWQ1ID0gcmVxdWlyZSgnLi9icm93c2VyTWQ1Jyk7XG52YXIgU2hhMSA9IHJlcXVpcmUoJy4vYnJvd3NlclNoYTEnKTtcbnZhciBTaGEyNTYgPSByZXF1aXJlKCcuL2Jyb3dzZXJTaGEyNTYnKTtcblxuLyoqXG4gKiBAYXBpIHByaXZhdGVcbiAqL1xubW9kdWxlLmV4cG9ydHMgPSBleHBvcnRzID0ge1xuICAgIGNyZWF0ZUhhc2g6IGZ1bmN0aW9uIGNyZWF0ZUhhc2goYWxnKSB7XG4gICAgICBhbGcgPSBhbGcudG9Mb3dlckNhc2UoKTtcbiAgICAgIGlmIChhbGcgPT09ICdtZDUnKSB7XG4gICAgICAgIHJldHVybiBuZXcgTWQ1KCk7XG4gICAgICB9IGVsc2UgaWYgKGFsZyA9PT0gJ3NoYTI1NicpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBTaGEyNTYoKTtcbiAgICAgIH0gZWxzZSBpZiAoYWxnID09PSAnc2hhMScpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBTaGExKCk7XG4gICAgICB9XG5cbiAgICAgIHRocm93IG5ldyBFcnJvcignSGFzaCBhbGdvcml0aG0gJyArIGFsZyArICcgaXMgbm90IHN1cHBvcnRlZCBpbiB0aGUgYnJvd3NlciBTREsnKTtcbiAgICB9LFxuICAgIGNyZWF0ZUhtYWM6IGZ1bmN0aW9uIGNyZWF0ZUhtYWMoYWxnLCBrZXkpIHtcbiAgICAgIGFsZyA9IGFsZy50b0xvd2VyQ2FzZSgpO1xuICAgICAgaWYgKGFsZyA9PT0gJ21kNScpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBIbWFjKE1kNSwga2V5KTtcbiAgICAgIH0gZWxzZSBpZiAoYWxnID09PSAnc2hhMjU2Jykge1xuICAgICAgICByZXR1cm4gbmV3IEhtYWMoU2hhMjU2LCBrZXkpO1xuICAgICAgfSBlbHNlIGlmIChhbGcgPT09ICdzaGExJykge1xuICAgICAgICByZXR1cm4gbmV3IEhtYWMoU2hhMSwga2V5KTtcbiAgICAgIH1cblxuICAgICAgdGhyb3cgbmV3IEVycm9yKCdITUFDIGFsZ29yaXRobSAnICsgYWxnICsgJyBpcyBub3Qgc3VwcG9ydGVkIGluIHRoZSBicm93c2VyIFNESycpO1xuICAgIH0sXG4gICAgY3JlYXRlU2lnbjogZnVuY3Rpb24oKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ2NyZWF0ZVNpZ24gaXMgbm90IGltcGxlbWVudGVkIGluIHRoZSBicm93c2VyJyk7XG4gICAgfVxuICB9XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/lib/browserCryptoLib.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/lib/browserHashUtils.js":
/*!******************************************************!*\
  !*** ./node_modules/aws-sdk/lib/browserHashUtils.js ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var Buffer = __webpack_require__(/*! buffer/ */ \"./node_modules/buffer/index.js\").Buffer;\n\n/**\n * This is a polyfill for the static method `isView` of `ArrayBuffer`, which is\n * e.g. missing in IE 10.\n *\n * @api private\n */\nif (\n    typeof ArrayBuffer !== 'undefined' &&\n    typeof ArrayBuffer.isView === 'undefined'\n) {\n    ArrayBuffer.isView = function(arg) {\n        return viewStrings.indexOf(Object.prototype.toString.call(arg)) > -1;\n    };\n}\n\n/**\n * @api private\n */\nvar viewStrings = [\n    '[object Int8Array]',\n    '[object Uint8Array]',\n    '[object Uint8ClampedArray]',\n    '[object Int16Array]',\n    '[object Uint16Array]',\n    '[object Int32Array]',\n    '[object Uint32Array]',\n    '[object Float32Array]',\n    '[object Float64Array]',\n    '[object DataView]',\n];\n\n/**\n * @api private\n */\nfunction isEmptyData(data) {\n    if (typeof data === 'string') {\n        return data.length === 0;\n    }\n    return data.byteLength === 0;\n}\n\n/**\n * @api private\n */\nfunction convertToBuffer(data) {\n    if (typeof data === 'string') {\n        data = new Buffer(data, 'utf8');\n    }\n\n    if (ArrayBuffer.isView(data)) {\n        return new Uint8Array(data.buffer, data.byteOffset, data.byteLength / Uint8Array.BYTES_PER_ELEMENT);\n    }\n\n    return new Uint8Array(data);\n}\n\n/**\n * @api private\n */\nmodule.exports = exports = {\n    isEmptyData: isEmptyData,\n    convertToBuffer: convertToBuffer,\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/lib/browserHashUtils.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/lib/browserHmac.js":
/*!*************************************************!*\
  !*** ./node_modules/aws-sdk/lib/browserHmac.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var hashUtils = __webpack_require__(/*! ./browserHashUtils */ \"./node_modules/aws-sdk/lib/browserHashUtils.js\");\n\n/**\n * @api private\n */\nfunction Hmac(hashCtor, secret) {\n    this.hash = new hashCtor();\n    this.outer = new hashCtor();\n\n    var inner = bufferFromSecret(hashCtor, secret);\n    var outer = new Uint8Array(hashCtor.BLOCK_SIZE);\n    outer.set(inner);\n\n    for (var i = 0; i < hashCtor.BLOCK_SIZE; i++) {\n        inner[i] ^= 0x36;\n        outer[i] ^= 0x5c;\n    }\n\n    this.hash.update(inner);\n    this.outer.update(outer);\n\n    // Zero out the copied key buffer.\n    for (var i = 0; i < inner.byteLength; i++) {\n        inner[i] = 0;\n    }\n}\n\n/**\n * @api private\n */\nmodule.exports = exports = Hmac;\n\nHmac.prototype.update = function (toHash) {\n    if (hashUtils.isEmptyData(toHash) || this.error) {\n        return this;\n    }\n\n    try {\n        this.hash.update(hashUtils.convertToBuffer(toHash));\n    } catch (e) {\n        this.error = e;\n    }\n\n    return this;\n};\n\nHmac.prototype.digest = function (encoding) {\n    if (!this.outer.finished) {\n        this.outer.update(this.hash.digest());\n    }\n\n    return this.outer.digest(encoding);\n}\n\nfunction bufferFromSecret(hashCtor, secret) {\n    var input = hashUtils.convertToBuffer(secret);\n    if (input.byteLength > hashCtor.BLOCK_SIZE) {\n        var bufferHash = new hashCtor;\n        bufferHash.update(input);\n        input = bufferHash.digest();\n    }\n    var buffer = new Uint8Array(hashCtor.BLOCK_SIZE);\n    buffer.set(input);\n    return buffer;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/lib/browserHmac.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/lib/browserMd5.js":
/*!************************************************!*\
  !*** ./node_modules/aws-sdk/lib/browserMd5.js ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var hashUtils = __webpack_require__(/*! ./browserHashUtils */ \"./node_modules/aws-sdk/lib/browserHashUtils.js\");\nvar Buffer = __webpack_require__(/*! buffer/ */ \"./node_modules/buffer/index.js\").Buffer;\n\nvar BLOCK_SIZE = 64;\n\nvar DIGEST_LENGTH = 16;\n\nvar INIT = [\n    0x67452301,\n    0xefcdab89,\n    0x98badcfe,\n    0x10325476,\n];\n\n/**\n * @api private\n */\nfunction Md5() {\n    this.state = [\n        0x67452301,\n        0xefcdab89,\n        0x98badcfe,\n        0x10325476,\n    ];\n    this.buffer = new DataView(new ArrayBuffer(BLOCK_SIZE));\n    this.bufferLength = 0;\n    this.bytesHashed = 0;\n    this.finished = false;\n}\n\n/**\n * @api private\n */\nmodule.exports = exports = Md5;\n\nMd5.BLOCK_SIZE = BLOCK_SIZE;\n\nMd5.prototype.update = function (sourceData) {\n    if (hashUtils.isEmptyData(sourceData)) {\n        return this;\n    } else if (this.finished) {\n        throw new Error('Attempted to update an already finished hash.');\n    }\n\n    var data = hashUtils.convertToBuffer(sourceData);\n    var position = 0;\n    var byteLength = data.byteLength;\n    this.bytesHashed += byteLength;\n    while (byteLength > 0) {\n        this.buffer.setUint8(this.bufferLength++, data[position++]);\n        byteLength--;\n        if (this.bufferLength === BLOCK_SIZE) {\n            this.hashBuffer();\n            this.bufferLength = 0;\n        }\n    }\n\n    return this;\n};\n\nMd5.prototype.digest = function (encoding) {\n    if (!this.finished) {\n        var _a = this, buffer = _a.buffer, undecoratedLength = _a.bufferLength, bytesHashed = _a.bytesHashed;\n        var bitsHashed = bytesHashed * 8;\n        buffer.setUint8(this.bufferLength++, 128);\n        // Ensure the final block has enough room for the hashed length\n        if (undecoratedLength % BLOCK_SIZE >= BLOCK_SIZE - 8) {\n            for (var i = this.bufferLength; i < BLOCK_SIZE; i++) {\n                buffer.setUint8(i, 0);\n            }\n            this.hashBuffer();\n            this.bufferLength = 0;\n        }\n        for (var i = this.bufferLength; i < BLOCK_SIZE - 8; i++) {\n            buffer.setUint8(i, 0);\n        }\n        buffer.setUint32(BLOCK_SIZE - 8, bitsHashed >>> 0, true);\n        buffer.setUint32(BLOCK_SIZE - 4, Math.floor(bitsHashed / 0x100000000), true);\n        this.hashBuffer();\n        this.finished = true;\n    }\n    var out = new DataView(new ArrayBuffer(DIGEST_LENGTH));\n    for (var i = 0; i < 4; i++) {\n        out.setUint32(i * 4, this.state[i], true);\n    }\n    var buff = new Buffer(out.buffer, out.byteOffset, out.byteLength);\n    return encoding ? buff.toString(encoding) : buff;\n};\n\nMd5.prototype.hashBuffer = function () {\n    var _a = this, buffer = _a.buffer, state = _a.state;\n    var a = state[0], b = state[1], c = state[2], d = state[3];\n    a = ff(a, b, c, d, buffer.getUint32(0, true), 7, 0xd76aa478);\n    d = ff(d, a, b, c, buffer.getUint32(4, true), 12, 0xe8c7b756);\n    c = ff(c, d, a, b, buffer.getUint32(8, true), 17, 0x242070db);\n    b = ff(b, c, d, a, buffer.getUint32(12, true), 22, 0xc1bdceee);\n    a = ff(a, b, c, d, buffer.getUint32(16, true), 7, 0xf57c0faf);\n    d = ff(d, a, b, c, buffer.getUint32(20, true), 12, 0x4787c62a);\n    c = ff(c, d, a, b, buffer.getUint32(24, true), 17, 0xa8304613);\n    b = ff(b, c, d, a, buffer.getUint32(28, true), 22, 0xfd469501);\n    a = ff(a, b, c, d, buffer.getUint32(32, true), 7, 0x698098d8);\n    d = ff(d, a, b, c, buffer.getUint32(36, true), 12, 0x8b44f7af);\n    c = ff(c, d, a, b, buffer.getUint32(40, true), 17, 0xffff5bb1);\n    b = ff(b, c, d, a, buffer.getUint32(44, true), 22, 0x895cd7be);\n    a = ff(a, b, c, d, buffer.getUint32(48, true), 7, 0x6b901122);\n    d = ff(d, a, b, c, buffer.getUint32(52, true), 12, 0xfd987193);\n    c = ff(c, d, a, b, buffer.getUint32(56, true), 17, 0xa679438e);\n    b = ff(b, c, d, a, buffer.getUint32(60, true), 22, 0x49b40821);\n    a = gg(a, b, c, d, buffer.getUint32(4, true), 5, 0xf61e2562);\n    d = gg(d, a, b, c, buffer.getUint32(24, true), 9, 0xc040b340);\n    c = gg(c, d, a, b, buffer.getUint32(44, true), 14, 0x265e5a51);\n    b = gg(b, c, d, a, buffer.getUint32(0, true), 20, 0xe9b6c7aa);\n    a = gg(a, b, c, d, buffer.getUint32(20, true), 5, 0xd62f105d);\n    d = gg(d, a, b, c, buffer.getUint32(40, true), 9, 0x02441453);\n    c = gg(c, d, a, b, buffer.getUint32(60, true), 14, 0xd8a1e681);\n    b = gg(b, c, d, a, buffer.getUint32(16, true), 20, 0xe7d3fbc8);\n    a = gg(a, b, c, d, buffer.getUint32(36, true), 5, 0x21e1cde6);\n    d = gg(d, a, b, c, buffer.getUint32(56, true), 9, 0xc33707d6);\n    c = gg(c, d, a, b, buffer.getUint32(12, true), 14, 0xf4d50d87);\n    b = gg(b, c, d, a, buffer.getUint32(32, true), 20, 0x455a14ed);\n    a = gg(a, b, c, d, buffer.getUint32(52, true), 5, 0xa9e3e905);\n    d = gg(d, a, b, c, buffer.getUint32(8, true), 9, 0xfcefa3f8);\n    c = gg(c, d, a, b, buffer.getUint32(28, true), 14, 0x676f02d9);\n    b = gg(b, c, d, a, buffer.getUint32(48, true), 20, 0x8d2a4c8a);\n    a = hh(a, b, c, d, buffer.getUint32(20, true), 4, 0xfffa3942);\n    d = hh(d, a, b, c, buffer.getUint32(32, true), 11, 0x8771f681);\n    c = hh(c, d, a, b, buffer.getUint32(44, true), 16, 0x6d9d6122);\n    b = hh(b, c, d, a, buffer.getUint32(56, true), 23, 0xfde5380c);\n    a = hh(a, b, c, d, buffer.getUint32(4, true), 4, 0xa4beea44);\n    d = hh(d, a, b, c, buffer.getUint32(16, true), 11, 0x4bdecfa9);\n    c = hh(c, d, a, b, buffer.getUint32(28, true), 16, 0xf6bb4b60);\n    b = hh(b, c, d, a, buffer.getUint32(40, true), 23, 0xbebfbc70);\n    a = hh(a, b, c, d, buffer.getUint32(52, true), 4, 0x289b7ec6);\n    d = hh(d, a, b, c, buffer.getUint32(0, true), 11, 0xeaa127fa);\n    c = hh(c, d, a, b, buffer.getUint32(12, true), 16, 0xd4ef3085);\n    b = hh(b, c, d, a, buffer.getUint32(24, true), 23, 0x04881d05);\n    a = hh(a, b, c, d, buffer.getUint32(36, true), 4, 0xd9d4d039);\n    d = hh(d, a, b, c, buffer.getUint32(48, true), 11, 0xe6db99e5);\n    c = hh(c, d, a, b, buffer.getUint32(60, true), 16, 0x1fa27cf8);\n    b = hh(b, c, d, a, buffer.getUint32(8, true), 23, 0xc4ac5665);\n    a = ii(a, b, c, d, buffer.getUint32(0, true), 6, 0xf4292244);\n    d = ii(d, a, b, c, buffer.getUint32(28, true), 10, 0x432aff97);\n    c = ii(c, d, a, b, buffer.getUint32(56, true), 15, 0xab9423a7);\n    b = ii(b, c, d, a, buffer.getUint32(20, true), 21, 0xfc93a039);\n    a = ii(a, b, c, d, buffer.getUint32(48, true), 6, 0x655b59c3);\n    d = ii(d, a, b, c, buffer.getUint32(12, true), 10, 0x8f0ccc92);\n    c = ii(c, d, a, b, buffer.getUint32(40, true), 15, 0xffeff47d);\n    b = ii(b, c, d, a, buffer.getUint32(4, true), 21, 0x85845dd1);\n    a = ii(a, b, c, d, buffer.getUint32(32, true), 6, 0x6fa87e4f);\n    d = ii(d, a, b, c, buffer.getUint32(60, true), 10, 0xfe2ce6e0);\n    c = ii(c, d, a, b, buffer.getUint32(24, true), 15, 0xa3014314);\n    b = ii(b, c, d, a, buffer.getUint32(52, true), 21, 0x4e0811a1);\n    a = ii(a, b, c, d, buffer.getUint32(16, true), 6, 0xf7537e82);\n    d = ii(d, a, b, c, buffer.getUint32(44, true), 10, 0xbd3af235);\n    c = ii(c, d, a, b, buffer.getUint32(8, true), 15, 0x2ad7d2bb);\n    b = ii(b, c, d, a, buffer.getUint32(36, true), 21, 0xeb86d391);\n    state[0] = (a + state[0]) & 0xFFFFFFFF;\n    state[1] = (b + state[1]) & 0xFFFFFFFF;\n    state[2] = (c + state[2]) & 0xFFFFFFFF;\n    state[3] = (d + state[3]) & 0xFFFFFFFF;\n};\n\nfunction cmn(q, a, b, x, s, t) {\n    a = (((a + q) & 0xFFFFFFFF) + ((x + t) & 0xFFFFFFFF)) & 0xFFFFFFFF;\n    return (((a << s) | (a >>> (32 - s))) + b) & 0xFFFFFFFF;\n}\n\nfunction ff(a, b, c, d, x, s, t) {\n    return cmn((b & c) | ((~b) & d), a, b, x, s, t);\n}\n\nfunction gg(a, b, c, d, x, s, t) {\n    return cmn((b & d) | (c & (~d)), a, b, x, s, t);\n}\n\nfunction hh(a, b, c, d, x, s, t) {\n    return cmn(b ^ c ^ d, a, b, x, s, t);\n}\n\nfunction ii(a, b, c, d, x, s, t) {\n    return cmn(c ^ (b | (~d)), a, b, x, s, t);\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9ub2RlX21vZHVsZXMvYXdzLXNkay9saWIvYnJvd3Nlck1kNS5qcy5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL25vZGVfbW9kdWxlcy9hd3Mtc2RrL2xpYi9icm93c2VyTWQ1LmpzP2M1NmIiXSwic291cmNlc0NvbnRlbnQiOlsidmFyIGhhc2hVdGlscyA9IHJlcXVpcmUoJy4vYnJvd3Nlckhhc2hVdGlscycpO1xudmFyIEJ1ZmZlciA9IHJlcXVpcmUoJ2J1ZmZlci8nKS5CdWZmZXI7XG5cbnZhciBCTE9DS19TSVpFID0gNjQ7XG5cbnZhciBESUdFU1RfTEVOR1RIID0gMTY7XG5cbnZhciBJTklUID0gW1xuICAgIDB4Njc0NTIzMDEsXG4gICAgMHhlZmNkYWI4OSxcbiAgICAweDk4YmFkY2ZlLFxuICAgIDB4MTAzMjU0NzYsXG5dO1xuXG4vKipcbiAqIEBhcGkgcHJpdmF0ZVxuICovXG5mdW5jdGlvbiBNZDUoKSB7XG4gICAgdGhpcy5zdGF0ZSA9IFtcbiAgICAgICAgMHg2NzQ1MjMwMSxcbiAgICAgICAgMHhlZmNkYWI4OSxcbiAgICAgICAgMHg5OGJhZGNmZSxcbiAgICAgICAgMHgxMDMyNTQ3NixcbiAgICBdO1xuICAgIHRoaXMuYnVmZmVyID0gbmV3IERhdGFWaWV3KG5ldyBBcnJheUJ1ZmZlcihCTE9DS19TSVpFKSk7XG4gICAgdGhpcy5idWZmZXJMZW5ndGggPSAwO1xuICAgIHRoaXMuYnl0ZXNIYXNoZWQgPSAwO1xuICAgIHRoaXMuZmluaXNoZWQgPSBmYWxzZTtcbn1cblxuLyoqXG4gKiBAYXBpIHByaXZhdGVcbiAqL1xubW9kdWxlLmV4cG9ydHMgPSBleHBvcnRzID0gTWQ1O1xuXG5NZDUuQkxPQ0tfU0laRSA9IEJMT0NLX1NJWkU7XG5cbk1kNS5wcm90b3R5cGUudXBkYXRlID0gZnVuY3Rpb24gKHNvdXJjZURhdGEpIHtcbiAgICBpZiAoaGFzaFV0aWxzLmlzRW1wdHlEYXRhKHNvdXJjZURhdGEpKSB7XG4gICAgICAgIHJldHVybiB0aGlzO1xuICAgIH0gZWxzZSBpZiAodGhpcy5maW5pc2hlZCkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0F0dGVtcHRlZCB0byB1cGRhdGUgYW4gYWxyZWFkeSBmaW5pc2hlZCBoYXNoLicpO1xuICAgIH1cblxuICAgIHZhciBkYXRhID0gaGFzaFV0aWxzLmNvbnZlcnRUb0J1ZmZlcihzb3VyY2VEYXRhKTtcbiAgICB2YXIgcG9zaXRpb24gPSAwO1xuICAgIHZhciBieXRlTGVuZ3RoID0gZGF0YS5ieXRlTGVuZ3RoO1xuICAgIHRoaXMuYnl0ZXNIYXNoZWQgKz0gYnl0ZUxlbmd0aDtcbiAgICB3aGlsZSAoYnl0ZUxlbmd0aCA+IDApIHtcbiAgICAgICAgdGhpcy5idWZmZXIuc2V0VWludDgodGhpcy5idWZmZXJMZW5ndGgrKywgZGF0YVtwb3NpdGlvbisrXSk7XG4gICAgICAgIGJ5dGVMZW5ndGgtLTtcbiAgICAgICAgaWYgKHRoaXMuYnVmZmVyTGVuZ3RoID09PSBCTE9DS19TSVpFKSB7XG4gICAgICAgICAgICB0aGlzLmhhc2hCdWZmZXIoKTtcbiAgICAgICAgICAgIHRoaXMuYnVmZmVyTGVuZ3RoID0gMDtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiB0aGlzO1xufTtcblxuTWQ1LnByb3RvdHlwZS5kaWdlc3QgPSBmdW5jdGlvbiAoZW5jb2RpbmcpIHtcbiAgICBpZiAoIXRoaXMuZmluaXNoZWQpIHtcbiAgICAgICAgdmFyIF9hID0gdGhpcywgYnVmZmVyID0gX2EuYnVmZmVyLCB1bmRlY29yYXRlZExlbmd0aCA9IF9hLmJ1ZmZlckxlbmd0aCwgYnl0ZXNIYXNoZWQgPSBfYS5ieXRlc0hhc2hlZDtcbiAgICAgICAgdmFyIGJpdHNIYXNoZWQgPSBieXRlc0hhc2hlZCAqIDg7XG4gICAgICAgIGJ1ZmZlci5zZXRVaW50OCh0aGlzLmJ1ZmZlckxlbmd0aCsrLCAxMjgpO1xuICAgICAgICAvLyBFbnN1cmUgdGhlIGZpbmFsIGJsb2NrIGhhcyBlbm91Z2ggcm9vbSBmb3IgdGhlIGhhc2hlZCBsZW5ndGhcbiAgICAgICAgaWYgKHVuZGVjb3JhdGVkTGVuZ3RoICUgQkxPQ0tfU0laRSA+PSBCTE9DS19TSVpFIC0gOCkge1xuICAgICAgICAgICAgZm9yICh2YXIgaSA9IHRoaXMuYnVmZmVyTGVuZ3RoOyBpIDwgQkxPQ0tfU0laRTsgaSsrKSB7XG4gICAgICAgICAgICAgICAgYnVmZmVyLnNldFVpbnQ4KGksIDApO1xuICAgICAgICAgICAgfVxuICAgICAgICAgICAgdGhpcy5oYXNoQnVmZmVyKCk7XG4gICAgICAgICAgICB0aGlzLmJ1ZmZlckxlbmd0aCA9IDA7XG4gICAgICAgIH1cbiAgICAgICAgZm9yICh2YXIgaSA9IHRoaXMuYnVmZmVyTGVuZ3RoOyBpIDwgQkxPQ0tfU0laRSAtIDg7IGkrKykge1xuICAgICAgICAgICAgYnVmZmVyLnNldFVpbnQ4KGksIDApO1xuICAgICAgICB9XG4gICAgICAgIGJ1ZmZlci5zZXRVaW50MzIoQkxPQ0tfU0laRSAtIDgsIGJpdHNIYXNoZWQgPj4+IDAsIHRydWUpO1xuICAgICAgICBidWZmZXIuc2V0VWludDMyKEJMT0NLX1NJWkUgLSA0LCBNYXRoLmZsb29yKGJpdHNIYXNoZWQgLyAweDEwMDAwMDAwMCksIHRydWUpO1xuICAgICAgICB0aGlzLmhhc2hCdWZmZXIoKTtcbiAgICAgICAgdGhpcy5maW5pc2hlZCA9IHRydWU7XG4gICAgfVxuICAgIHZhciBvdXQgPSBuZXcgRGF0YVZpZXcobmV3IEFycmF5QnVmZmVyKERJR0VTVF9MRU5HVEgpKTtcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IDQ7IGkrKykge1xuICAgICAgICBvdXQuc2V0VWludDMyKGkgKiA0LCB0aGlzLnN0YXRlW2ldLCB0cnVlKTtcbiAgICB9XG4gICAgdmFyIGJ1ZmYgPSBuZXcgQnVmZmVyKG91dC5idWZmZXIsIG91dC5ieXRlT2Zmc2V0LCBvdXQuYnl0ZUxlbmd0aCk7XG4gICAgcmV0dXJuIGVuY29kaW5nID8gYnVmZi50b1N0cmluZyhlbmNvZGluZykgOiBidWZmO1xufTtcblxuTWQ1LnByb3RvdHlwZS5oYXNoQnVmZmVyID0gZnVuY3Rpb24gKCkge1xuICAgIHZhciBfYSA9IHRoaXMsIGJ1ZmZlciA9IF9hLmJ1ZmZlciwgc3RhdGUgPSBfYS5zdGF0ZTtcbiAgICB2YXIgYSA9IHN0YXRlWzBdLCBiID0gc3RhdGVbMV0sIGMgPSBzdGF0ZVsyXSwgZCA9IHN0YXRlWzNdO1xuICAgIGEgPSBmZihhLCBiLCBjLCBkLCBidWZmZXIuZ2V0VWludDMyKDAsIHRydWUpLCA3LCAweGQ3NmFhNDc4KTtcbiAgICBkID0gZmYoZCwgYSwgYiwgYywgYnVmZmVyLmdldFVpbnQzMig0LCB0cnVlKSwgMTIsIDB4ZThjN2I3NTYpO1xuICAgIGMgPSBmZihjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDgsIHRydWUpLCAxNywgMHgyNDIwNzBkYik7XG4gICAgYiA9IGZmKGIsIGMsIGQsIGEsIGJ1ZmZlci5nZXRVaW50MzIoMTIsIHRydWUpLCAyMiwgMHhjMWJkY2VlZSk7XG4gICAgYSA9IGZmKGEsIGIsIGMsIGQsIGJ1ZmZlci5nZXRVaW50MzIoMTYsIHRydWUpLCA3LCAweGY1N2MwZmFmKTtcbiAgICBkID0gZmYoZCwgYSwgYiwgYywgYnVmZmVyLmdldFVpbnQzMigyMCwgdHJ1ZSksIDEyLCAweDQ3ODdjNjJhKTtcbiAgICBjID0gZmYoYywgZCwgYSwgYiwgYnVmZmVyLmdldFVpbnQzMigyNCwgdHJ1ZSksIDE3LCAweGE4MzA0NjEzKTtcbiAgICBiID0gZmYoYiwgYywgZCwgYSwgYnVmZmVyLmdldFVpbnQzMigyOCwgdHJ1ZSksIDIyLCAweGZkNDY5NTAxKTtcbiAgICBhID0gZmYoYSwgYiwgYywgZCwgYnVmZmVyLmdldFVpbnQzMigzMiwgdHJ1ZSksIDcsIDB4Njk4MDk4ZDgpO1xuICAgIGQgPSBmZihkLCBhLCBiLCBjLCBidWZmZXIuZ2V0VWludDMyKDM2LCB0cnVlKSwgMTIsIDB4OGI0NGY3YWYpO1xuICAgIGMgPSBmZihjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDQwLCB0cnVlKSwgMTcsIDB4ZmZmZjViYjEpO1xuICAgIGIgPSBmZihiLCBjLCBkLCBhLCBidWZmZXIuZ2V0VWludDMyKDQ0LCB0cnVlKSwgMjIsIDB4ODk1Y2Q3YmUpO1xuICAgIGEgPSBmZihhLCBiLCBjLCBkLCBidWZmZXIuZ2V0VWludDMyKDQ4LCB0cnVlKSwgNywgMHg2YjkwMTEyMik7XG4gICAgZCA9IGZmKGQsIGEsIGIsIGMsIGJ1ZmZlci5nZXRVaW50MzIoNTIsIHRydWUpLCAxMiwgMHhmZDk4NzE5Myk7XG4gICAgYyA9IGZmKGMsIGQsIGEsIGIsIGJ1ZmZlci5nZXRVaW50MzIoNTYsIHRydWUpLCAxNywgMHhhNjc5NDM4ZSk7XG4gICAgYiA9IGZmKGIsIGMsIGQsIGEsIGJ1ZmZlci5nZXRVaW50MzIoNjAsIHRydWUpLCAyMiwgMHg0OWI0MDgyMSk7XG4gICAgYSA9IGdnKGEsIGIsIGMsIGQsIGJ1ZmZlci5nZXRVaW50MzIoNCwgdHJ1ZSksIDUsIDB4ZjYxZTI1NjIpO1xuICAgIGQgPSBnZyhkLCBhLCBiLCBjLCBidWZmZXIuZ2V0VWludDMyKDI0LCB0cnVlKSwgOSwgMHhjMDQwYjM0MCk7XG4gICAgYyA9IGdnKGMsIGQsIGEsIGIsIGJ1ZmZlci5nZXRVaW50MzIoNDQsIHRydWUpLCAxNCwgMHgyNjVlNWE1MSk7XG4gICAgYiA9IGdnKGIsIGMsIGQsIGEsIGJ1ZmZlci5nZXRVaW50MzIoMCwgdHJ1ZSksIDIwLCAweGU5YjZjN2FhKTtcbiAgICBhID0gZ2coYSwgYiwgYywgZCwgYnVmZmVyLmdldFVpbnQzMigyMCwgdHJ1ZSksIDUsIDB4ZDYyZjEwNWQpO1xuICAgIGQgPSBnZyhkLCBhLCBiLCBjLCBidWZmZXIuZ2V0VWludDMyKDQwLCB0cnVlKSwgOSwgMHgwMjQ0MTQ1Myk7XG4gICAgYyA9IGdnKGMsIGQsIGEsIGIsIGJ1ZmZlci5nZXRVaW50MzIoNjAsIHRydWUpLCAxNCwgMHhkOGExZTY4MSk7XG4gICAgYiA9IGdnKGIsIGMsIGQsIGEsIGJ1ZmZlci5nZXRVaW50MzIoMTYsIHRydWUpLCAyMCwgMHhlN2QzZmJjOCk7XG4gICAgYSA9IGdnKGEsIGIsIGMsIGQsIGJ1ZmZlci5nZXRVaW50MzIoMzYsIHRydWUpLCA1LCAweDIxZTFjZGU2KTtcbiAgICBkID0gZ2coZCwgYSwgYiwgYywgYnVmZmVyLmdldFVpbnQzMig1NiwgdHJ1ZSksIDksIDB4YzMzNzA3ZDYpO1xuICAgIGMgPSBnZyhjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDEyLCB0cnVlKSwgMTQsIDB4ZjRkNTBkODcpO1xuICAgIGIgPSBnZyhiLCBjLCBkLCBhLCBidWZmZXIuZ2V0VWludDMyKDMyLCB0cnVlKSwgMjAsIDB4NDU1YTE0ZWQpO1xuICAgIGEgPSBnZyhhLCBiLCBjLCBkLCBidWZmZXIuZ2V0VWludDMyKDUyLCB0cnVlKSwgNSwgMHhhOWUzZTkwNSk7XG4gICAgZCA9IGdnKGQsIGEsIGIsIGMsIGJ1ZmZlci5nZXRVaW50MzIoOCwgdHJ1ZSksIDksIDB4ZmNlZmEzZjgpO1xuICAgIGMgPSBnZyhjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDI4LCB0cnVlKSwgMTQsIDB4Njc2ZjAyZDkpO1xuICAgIGIgPSBnZyhiLCBjLCBkLCBhLCBidWZmZXIuZ2V0VWludDMyKDQ4LCB0cnVlKSwgMjAsIDB4OGQyYTRjOGEpO1xuICAgIGEgPSBoaChhLCBiLCBjLCBkLCBidWZmZXIuZ2V0VWludDMyKDIwLCB0cnVlKSwgNCwgMHhmZmZhMzk0Mik7XG4gICAgZCA9IGhoKGQsIGEsIGIsIGMsIGJ1ZmZlci5nZXRVaW50MzIoMzIsIHRydWUpLCAxMSwgMHg4NzcxZjY4MSk7XG4gICAgYyA9IGhoKGMsIGQsIGEsIGIsIGJ1ZmZlci5nZXRVaW50MzIoNDQsIHRydWUpLCAxNiwgMHg2ZDlkNjEyMik7XG4gICAgYiA9IGhoKGIsIGMsIGQsIGEsIGJ1ZmZlci5nZXRVaW50MzIoNTYsIHRydWUpLCAyMywgMHhmZGU1MzgwYyk7XG4gICAgYSA9IGhoKGEsIGIsIGMsIGQsIGJ1ZmZlci5nZXRVaW50MzIoNCwgdHJ1ZSksIDQsIDB4YTRiZWVhNDQpO1xuICAgIGQgPSBoaChkLCBhLCBiLCBjLCBidWZmZXIuZ2V0VWludDMyKDE2LCB0cnVlKSwgMTEsIDB4NGJkZWNmYTkpO1xuICAgIGMgPSBoaChjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDI4LCB0cnVlKSwgMTYsIDB4ZjZiYjRiNjApO1xuICAgIGIgPSBoaChiLCBjLCBkLCBhLCBidWZmZXIuZ2V0VWludDMyKDQwLCB0cnVlKSwgMjMsIDB4YmViZmJjNzApO1xuICAgIGEgPSBoaChhLCBiLCBjLCBkLCBidWZmZXIuZ2V0VWludDMyKDUyLCB0cnVlKSwgNCwgMHgyODliN2VjNik7XG4gICAgZCA9IGhoKGQsIGEsIGIsIGMsIGJ1ZmZlci5nZXRVaW50MzIoMCwgdHJ1ZSksIDExLCAweGVhYTEyN2ZhKTtcbiAgICBjID0gaGgoYywgZCwgYSwgYiwgYnVmZmVyLmdldFVpbnQzMigxMiwgdHJ1ZSksIDE2LCAweGQ0ZWYzMDg1KTtcbiAgICBiID0gaGgoYiwgYywgZCwgYSwgYnVmZmVyLmdldFVpbnQzMigyNCwgdHJ1ZSksIDIzLCAweDA0ODgxZDA1KTtcbiAgICBhID0gaGgoYSwgYiwgYywgZCwgYnVmZmVyLmdldFVpbnQzMigzNiwgdHJ1ZSksIDQsIDB4ZDlkNGQwMzkpO1xuICAgIGQgPSBoaChkLCBhLCBiLCBjLCBidWZmZXIuZ2V0VWludDMyKDQ4LCB0cnVlKSwgMTEsIDB4ZTZkYjk5ZTUpO1xuICAgIGMgPSBoaChjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDYwLCB0cnVlKSwgMTYsIDB4MWZhMjdjZjgpO1xuICAgIGIgPSBoaChiLCBjLCBkLCBhLCBidWZmZXIuZ2V0VWludDMyKDgsIHRydWUpLCAyMywgMHhjNGFjNTY2NSk7XG4gICAgYSA9IGlpKGEsIGIsIGMsIGQsIGJ1ZmZlci5nZXRVaW50MzIoMCwgdHJ1ZSksIDYsIDB4ZjQyOTIyNDQpO1xuICAgIGQgPSBpaShkLCBhLCBiLCBjLCBidWZmZXIuZ2V0VWludDMyKDI4LCB0cnVlKSwgMTAsIDB4NDMyYWZmOTcpO1xuICAgIGMgPSBpaShjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDU2LCB0cnVlKSwgMTUsIDB4YWI5NDIzYTcpO1xuICAgIGIgPSBpaShiLCBjLCBkLCBhLCBidWZmZXIuZ2V0VWludDMyKDIwLCB0cnVlKSwgMjEsIDB4ZmM5M2EwMzkpO1xuICAgIGEgPSBpaShhLCBiLCBjLCBkLCBidWZmZXIuZ2V0VWludDMyKDQ4LCB0cnVlKSwgNiwgMHg2NTViNTljMyk7XG4gICAgZCA9IGlpKGQsIGEsIGIsIGMsIGJ1ZmZlci5nZXRVaW50MzIoMTIsIHRydWUpLCAxMCwgMHg4ZjBjY2M5Mik7XG4gICAgYyA9IGlpKGMsIGQsIGEsIGIsIGJ1ZmZlci5nZXRVaW50MzIoNDAsIHRydWUpLCAxNSwgMHhmZmVmZjQ3ZCk7XG4gICAgYiA9IGlpKGIsIGMsIGQsIGEsIGJ1ZmZlci5nZXRVaW50MzIoNCwgdHJ1ZSksIDIxLCAweDg1ODQ1ZGQxKTtcbiAgICBhID0gaWkoYSwgYiwgYywgZCwgYnVmZmVyLmdldFVpbnQzMigzMiwgdHJ1ZSksIDYsIDB4NmZhODdlNGYpO1xuICAgIGQgPSBpaShkLCBhLCBiLCBjLCBidWZmZXIuZ2V0VWludDMyKDYwLCB0cnVlKSwgMTAsIDB4ZmUyY2U2ZTApO1xuICAgIGMgPSBpaShjLCBkLCBhLCBiLCBidWZmZXIuZ2V0VWludDMyKDI0LCB0cnVlKSwgMTUsIDB4YTMwMTQzMTQpO1xuICAgIGIgPSBpaShiLCBjLCBkLCBhLCBidWZmZXIuZ2V0VWludDMyKDUyLCB0cnVlKSwgMjEsIDB4NGUwODExYTEpO1xuICAgIGEgPSBpaShhLCBiLCBjLCBkLCBidWZmZXIuZ2V0VWludDMyKDE2LCB0cnVlKSwgNiwgMHhmNzUzN2U4Mik7XG4gICAgZCA9IGlpKGQsIGEsIGIsIGMsIGJ1ZmZlci5nZXRVaW50MzIoNDQsIHRydWUpLCAxMCwgMHhiZDNhZjIzNSk7XG4gICAgYyA9IGlpKGMsIGQsIGEsIGIsIGJ1ZmZlci5nZXRVaW50MzIoOCwgdHJ1ZSksIDE1LCAweDJhZDdkMmJiKTtcbiAgICBiID0gaWkoYiwgYywgZCwgYSwgYnVmZmVyLmdldFVpbnQzMigzNiwgdHJ1ZSksIDIxLCAweGViODZkMzkxKTtcbiAgICBzdGF0ZVswXSA9IChhICsgc3RhdGVbMF0pICYgMHhGRkZGRkZGRjtcbiAgICBzdGF0ZVsxXSA9IChiICsgc3RhdGVbMV0pICYgMHhGRkZGRkZGRjtcbiAgICBzdGF0ZVsyXSA9IChjICsgc3RhdGVbMl0pICYgMHhGRkZGRkZGRjtcbiAgICBzdGF0ZVszXSA9IChkICsgc3RhdGVbM10pICYgMHhGRkZGRkZGRjtcbn07XG5cbmZ1bmN0aW9uIGNtbihxLCBhLCBiLCB4LCBzLCB0KSB7XG4gICAgYSA9ICgoKGEgKyBxKSAmIDB4RkZGRkZGRkYpICsgKCh4ICsgdCkgJiAweEZGRkZGRkZGKSkgJiAweEZGRkZGRkZGO1xuICAgIHJldHVybiAoKChhIDw8IHMpIHwgKGEgPj4+ICgzMiAtIHMpKSkgKyBiKSAmIDB4RkZGRkZGRkY7XG59XG5cbmZ1bmN0aW9uIGZmKGEsIGIsIGMsIGQsIHgsIHMsIHQpIHtcbiAgICByZXR1cm4gY21uKChiICYgYykgfCAoKH5iKSAmIGQpLCBhLCBiLCB4LCBzLCB0KTtcbn1cblxuZnVuY3Rpb24gZ2coYSwgYiwgYywgZCwgeCwgcywgdCkge1xuICAgIHJldHVybiBjbW4oKGIgJiBkKSB8IChjICYgKH5kKSksIGEsIGIsIHgsIHMsIHQpO1xufVxuXG5mdW5jdGlvbiBoaChhLCBiLCBjLCBkLCB4LCBzLCB0KSB7XG4gICAgcmV0dXJuIGNtbihiIF4gYyBeIGQsIGEsIGIsIHgsIHMsIHQpO1xufVxuXG5mdW5jdGlvbiBpaShhLCBiLCBjLCBkLCB4LCBzLCB0KSB7XG4gICAgcmV0dXJuIGNtbihjIF4gKGIgfCAofmQpKSwgYSwgYiwgeCwgcywgdCk7XG59XG4iXSwibWFwcGluZ3MiOiJBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/lib/browserMd5.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/lib/browserSha1.js":
/*!*************************************************!*\
  !*** ./node_modules/aws-sdk/lib/browserSha1.js ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var Buffer = __webpack_require__(/*! buffer/ */ \"./node_modules/buffer/index.js\").Buffer;\nvar hashUtils = __webpack_require__(/*! ./browserHashUtils */ \"./node_modules/aws-sdk/lib/browserHashUtils.js\");\n\nvar BLOCK_SIZE = 64;\n\nvar DIGEST_LENGTH = 20;\n\nvar KEY = new Uint32Array([\n    0x5a827999,\n    0x6ed9eba1,\n    0x8f1bbcdc | 0,\n    0xca62c1d6 | 0\n]);\n\nvar INIT = [\n    0x6a09e667,\n    0xbb67ae85,\n    0x3c6ef372,\n    0xa54ff53a,\n    0x510e527f,\n    0x9b05688c,\n    0x1f83d9ab,\n    0x5be0cd19,\n];\n\nvar MAX_HASHABLE_LENGTH = Math.pow(2, 53) - 1;\n\n/**\n * @api private\n */\nfunction Sha1() {\n    this.h0 = 0x67452301;\n    this.h1 = 0xEFCDAB89;\n    this.h2 = 0x98BADCFE;\n    this.h3 = 0x10325476;\n    this.h4 = 0xC3D2E1F0;\n    // The first 64 bytes (16 words) is the data chunk\n    this.block = new Uint32Array(80);\n    this.offset = 0;\n    this.shift = 24;\n    this.totalLength = 0;\n}\n\n/**\n * @api private\n */\nmodule.exports = exports = Sha1;\n\nSha1.BLOCK_SIZE = BLOCK_SIZE;\n\nSha1.prototype.update = function (data) {\n    if (this.finished) {\n        throw new Error('Attempted to update an already finished hash.');\n    }\n\n    if (hashUtils.isEmptyData(data)) {\n        return this;\n    }\n\n    data = hashUtils.convertToBuffer(data);\n\n    var length = data.length;\n    this.totalLength += length * 8;\n    for (var i = 0; i < length; i++) {\n        this.write(data[i]);\n    }\n\n    return this;\n};\n\nSha1.prototype.write = function write(byte) {\n    this.block[this.offset] |= (byte & 0xff) << this.shift;\n    if (this.shift) {\n        this.shift -= 8;\n    } else {\n        this.offset++;\n        this.shift = 24;\n    }\n\n    if (this.offset === 16) this.processBlock();\n};\n\nSha1.prototype.digest = function (encoding) {\n    // Pad\n    this.write(0x80);\n    if (this.offset > 14 || (this.offset === 14 && this.shift < 24)) {\n      this.processBlock();\n    }\n    this.offset = 14;\n    this.shift = 24;\n\n    // 64-bit length big-endian\n    this.write(0x00); // numbers this big aren't accurate in javascript anyway\n    this.write(0x00); // ..So just hard-code to zero.\n    this.write(this.totalLength > 0xffffffffff ? this.totalLength / 0x10000000000 : 0x00);\n    this.write(this.totalLength > 0xffffffff ? this.totalLength / 0x100000000 : 0x00);\n    for (var s = 24; s >= 0; s -= 8) {\n        this.write(this.totalLength >> s);\n    }\n    // The value in state is little-endian rather than big-endian, so flip\n    // each word into a new Uint8Array\n    var out = new Buffer(DIGEST_LENGTH);\n    var outView = new DataView(out.buffer);\n    outView.setUint32(0, this.h0, false);\n    outView.setUint32(4, this.h1, false);\n    outView.setUint32(8, this.h2, false);\n    outView.setUint32(12, this.h3, false);\n    outView.setUint32(16, this.h4, false);\n\n    return encoding ? out.toString(encoding) : out;\n};\n\nSha1.prototype.processBlock = function processBlock() {\n    // Extend the sixteen 32-bit words into eighty 32-bit words:\n    for (var i = 16; i < 80; i++) {\n      var w = this.block[i - 3] ^ this.block[i - 8] ^ this.block[i - 14] ^ this.block[i - 16];\n      this.block[i] = (w << 1) | (w >>> 31);\n    }\n\n    // Initialize hash value for this chunk:\n    var a = this.h0;\n    var b = this.h1;\n    var c = this.h2;\n    var d = this.h3;\n    var e = this.h4;\n    var f, k;\n\n    // Main loop:\n    for (i = 0; i < 80; i++) {\n      if (i < 20) {\n        f = d ^ (b & (c ^ d));\n        k = 0x5A827999;\n      }\n      else if (i < 40) {\n        f = b ^ c ^ d;\n        k = 0x6ED9EBA1;\n      }\n      else if (i < 60) {\n        f = (b & c) | (d & (b | c));\n        k = 0x8F1BBCDC;\n      }\n      else {\n        f = b ^ c ^ d;\n        k = 0xCA62C1D6;\n      }\n      var temp = (a << 5 | a >>> 27) + f + e + k + (this.block[i]|0);\n      e = d;\n      d = c;\n      c = (b << 30 | b >>> 2);\n      b = a;\n      a = temp;\n    }\n\n    // Add this chunk's hash to result so far:\n    this.h0 = (this.h0 + a) | 0;\n    this.h1 = (this.h1 + b) | 0;\n    this.h2 = (this.h2 + c) | 0;\n    this.h3 = (this.h3 + d) | 0;\n    this.h4 = (this.h4 + e) | 0;\n\n    // The block is now reusable.\n    this.offset = 0;\n    for (i = 0; i < 16; i++) {\n        this.block[i] = 0;\n    }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/aws-sdk/lib/browserSha1.js\n");

/***/ }),

/***/ "./node_modules/aws-sdk/lib/browserSha256.js":
/*!***************************************************!*\
  !*** ./node_modules/aws-sdk/lib/browserSha256.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require